/*
 * Decompiled with CFR 0.152.
 */
package io.fogcloud.sdk.mdns.api;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import io.fogcloud.sdk.mdns.helper.CommonFunc;
import io.fogcloud.sdk.mdns.helper.MDNSErrCode;
import io.fogcloud.sdk.mdns.helper.SearchDeviceCallBack;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MDNS {
    private CommonFunc comfunc = new CommonFunc();
    private boolean isWorking = false;
    private WifiManager wifiManager = null;
    private Map<String, JSONObject> jsonmap = null;
    private final int _ADDDEVICE = 1002;
    private final int _REMOVEDEVICE = 1003;
    private Context mContext;
    private SearchDeviceCallBack msearchdevcb;
    private JSONArray array;
    private String mserviceName;
    private JmDNS jmdns;
    private SampleListener slistener;
    private Handler mdnsHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1002: {
                    MDNS.this.updateMessage();
                    break;
                }
                case 1003: {
                    MDNS.this.updateMessage();
                }
            }
        }
    };

    public MDNS(Context context) {
        this.mContext = context;
    }

    public void startSearchDevices(String serviceName, SearchDeviceCallBack searchdevcb) {
        if (this.comfunc.checkPara(serviceName)) {
            if (null != this.mContext) {
                this.startMdnsService(serviceName, searchdevcb);
            } else {
                this.comfunc.failureCBmDNS(MDNSErrCode.CONTEXT_CODE, MDNSErrCode.CONTEXT, searchdevcb);
            }
        } else {
            this.comfunc.failureCBmDNS(MDNSErrCode.EMPTY_CODE, MDNSErrCode.EMPTY, searchdevcb);
        }
    }

    public void stopSearchDevices(SearchDeviceCallBack searchdevcb) {
        this.stopMdnsService(searchdevcb);
    }

    private void startMdnsService(String serviceName, final SearchDeviceCallBack searchdevcb) {
        this.mserviceName = serviceName;
        this.msearchdevcb = searchdevcb;
        if (!this.isWorking) {
            this.isWorking = true;
            if (this.wifiManager == null) {
                this.wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            }
            new Thread(){

                @Override
                public void run() {
                    MDNS.this.stopMDNS();
                    MDNS.this.startMDNS();
                    while (MDNS.this.isWorking) {
                        try {
                            Thread.sleep(3000L);
                            MDNS.this.sendCallBack();
                        }
                        catch (InterruptedException e) {
                            MDNS.this.comfunc.successCBmDNS(MDNSErrCode.EXCEPTION_CODE, e.getMessage(), searchdevcb);
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
        } else {
            this.comfunc.failureCBmDNS(MDNSErrCode.BUSY_CODE, MDNSErrCode.BUSY, searchdevcb);
        }
    }

    private void stopMdnsService(SearchDeviceCallBack searchdevcb) {
        if (this.isWorking) {
            this.isWorking = false;
            this.comfunc.successCBmDNS(MDNSErrCode.SUCCESS_CODE, MDNSErrCode.SUCCESS, searchdevcb);
        } else {
            this.comfunc.failureCBmDNS(MDNSErrCode.CLOSED_CODE, MDNSErrCode.CLOSED, searchdevcb);
        }
    }

    private void startMDNS() {
        new Thread(){

            @Override
            public void run() {
                MDNS.this.jmdns = null;
                MDNS.this.slistener = null;
                InetAddress intf = null;
                MDNS.this.array = new JSONArray();
                MDNS.this.jsonmap = new HashMap();
                try {
                    boolean jmdnsTag = true;
                    while (jmdnsTag) {
                        if (intf != null && MDNS.this.jmdns != null) {
                            jmdnsTag = false;
                            WifiManager.MulticastLock lock = MDNS.this.wifiManager.createMulticastLock("mylock");
                            lock.setReferenceCounted(true);
                            lock.acquire();
                            MDNS.this.slistener = new SampleListener();
                            MDNS.this.jmdns.addServiceListener(MDNS.this.mserviceName, (ServiceListener)MDNS.this.slistener);
                            continue;
                        }
                        if (intf == null) {
                            intf = MDNS.this.getLocalIpAddress(MDNS.this.mContext);
                        }
                        if (MDNS.this.jmdns != null) continue;
                        MDNS.this.jmdns = JmDNS.create((InetAddress)intf);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void stopMDNS() {
        if (null != this.jmdns) {
            try {
                this.jmdns.removeServiceListener(this.mserviceName, (ServiceListener)this.slistener);
                this.jmdns.unregisterAllServices();
                this.jmdns.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateMessage() {
        JSONArray tmpArray = new JSONArray();
        for (Map.Entry<String, JSONObject> entry : this.jsonmap.entrySet()) {
            tmpArray.put((Object)entry.getValue());
        }
        this.array = tmpArray;
    }

    private void sendCallBack() {
        this.comfunc.onDevsFindmDNS(this.array, this.msearchdevcb);
    }

    public InetAddress getLocalIpAddress(Context context) throws Exception {
        if (this.wifiManager == null) {
            this.wifiManager = (WifiManager)context.getSystemService("wifi");
        }
        WifiInfo wifiinfo = this.wifiManager.getConnectionInfo();
        int intaddr = wifiinfo.getIpAddress();
        byte[] byteaddr = new byte[]{(byte)(intaddr & 0xFF), (byte)(intaddr >> 8 & 0xFF), (byte)(intaddr >> 16 & 0xFF), (byte)(intaddr >> 24 & 0xFF)};
        InetAddress addr = InetAddress.getByAddress(byteaddr);
        return addr;
    }

    class SampleListener
    implements ServiceListener {
        ServiceInfo sName;

        SampleListener() {
        }

        public void serviceAdded(ServiceEvent event) {
            if (!MDNS.this.jsonmap.containsKey(event.getName())) {
                this.sName = MDNS.this.jmdns.getServiceInfo(MDNS.this.mserviceName, event.getName());
                if (null != this.sName) {
                    byte infoLength;
                    ArrayList<String> mDNSList = new ArrayList<String>();
                    byte[] allinfobyte = this.sName.getTextBytes();
                    int allLen = allinfobyte.length;
                    for (int index = 0; index < allLen; index += infoLength) {
                        infoLength = allinfobyte[index++];
                        byte[] temp = new byte[infoLength];
                        System.arraycopy(allinfobyte, index, temp, 0, infoLength);
                        try {
                            String isoString = new String(temp, "UTF-8");
                            mDNSList.add(isoString);
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        int isOtherStr;
                        JSONObject jsonObject = new JSONObject();
                        String dev_ip = "";
                        Inet4Address[] ipv4 = this.sName.getInet4Addresses();
                        if (ipv4.length > 0 && (isOtherStr = (dev_ip = ipv4[0].toString()).indexOf("/")) > -1) {
                            dev_ip = dev_ip.substring(isOtherStr + 1);
                        }
                        jsonObject.put("Name", (Object)this.sName.getName());
                        jsonObject.put("IP", (Object)dev_ip);
                        jsonObject.put("Port", this.sName.getPort());
                        for (String orlValue : mDNSList) {
                            if ("".equals(orlValue)) continue;
                            String[] temp = orlValue.split("=");
                            jsonObject.put(temp[0], (Object)temp[1]);
                        }
                        MDNS.this.jsonmap.put(event.getName(), jsonObject);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    Message msg = new Message();
                    msg.what = 1002;
                    MDNS.this.mdnsHandler.sendMessage(msg);
                }
            }
        }

        public void serviceRemoved(ServiceEvent event) {
            MDNS.this.jsonmap.remove(event.getName());
            Message msg = new Message();
            msg.what = 1003;
            MDNS.this.mdnsHandler.sendMessage(msg);
        }

        public void serviceResolved(ServiceEvent event) {
            Log.d((String)"---mdns---", (String)event.getName());
        }
    }
}

