/*
 * Decompiled with CFR 0.152.
 */
package io.fogcloud.sdk.easylink.jetty;

import io.fogcloud.sdk.easylink.helper.EasyLinkCallBack;
import io.fogcloud.sdk.easylink.jetty.EasyServlet;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class EasyServer {
    private int mPort;
    public Server mServer;

    public EasyServer(int port) {
        this.mPort = port;
    }

    public synchronized void start(EasyLinkCallBack easylinkcb) {
        if (this.mServer != null && this.mServer.isStarted()) {
            return;
        }
        if (this.mServer == null) {
            ServletContextHandler servletHandler = new ServletContextHandler(1);
            servletHandler.addServlet(new ServletHolder((Servlet)new EasyServlet(easylinkcb)), "/auth-setup");
            HandlerList handlerList = new HandlerList();
            handlerList.addHandler((Handler)servletHandler);
            this.mServer = new Server(this.mPort);
            this.mServer.setHandler((Handler)handlerList);
        }
        try {
            this.mServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (this.mServer == null || this.mServer.isStopped()) {
            return;
        }
        try {
            this.mServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean isStarted() {
        if (this.mServer == null) {
            return false;
        }
        return this.mServer.isStarted();
    }
}

