/*
 * Decompiled with CFR 0.152.
 */
package io.fogcloud.sdk.easylink.api;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import io.fogcloud.sdk.easylink.api.EasyLink_plus;
import io.fogcloud.sdk.easylink.helper.ComHelper;
import io.fogcloud.sdk.easylink.helper.EasyLinkCallBack;
import io.fogcloud.sdk.easylink.helper.EasyLinkErrCode;
import io.fogcloud.sdk.easylink.helper.EasyLinkParams;
import io.fogcloud.sdk.easylink.jetty.EasyServer;
import java.net.NetworkInterface;
import java.net.SocketException;

public class EasyLink {
    public static final int mPort = 8000;
    private static EasyServer mEasyServer = null;
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private EasyLink_plus mEasylinkPlus;
    private boolean eltag = false;
    private Thread workThread = null;
    private ComHelper comfunc = new ComHelper();
    private Context mContext;

    public EasyLink(Context context) {
        this.mContext = context;
    }

    public String getSSID() {
        if (this.mContext != null) {
            this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            this.mWifiInfo = this.mWifiManager.getConnectionInfo();
            String ssid_mxchip = this.mWifiInfo.getSSID();
            ssid_mxchip = ssid_mxchip.substring(1, ssid_mxchip.length() - 1);
            return ssid_mxchip;
        }
        return null;
    }

    public boolean isAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (null != cm.getActiveNetworkInfo()) {
            return cm.getActiveNetworkInfo().isAvailable();
        }
        return false;
    }

    public boolean isWifiEnabled() {
        WifiManager wifiMan;
        return this.mContext != null && 3 == (wifiMan = (WifiManager)this.mContext.getSystemService("wifi")).getWifiState();
    }

    public boolean is3rd() {
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkINfo = cm.getActiveNetworkInfo();
        return networkINfo != null && networkINfo.getType() == 0;
    }

    public void startEasyLink(EasyLinkParams easylinkPara, EasyLinkCallBack easylinkcb) {
        if (ComHelper.checkPara(easylinkPara.ssid)) {
            if (null != this.mContext) {
                this.startEasyLink(easylinkPara.ssid, easylinkPara.password, easylinkPara.isSendIP, easylinkPara.runSecond, easylinkPara.sleeptime, easylinkPara.extraData, easylinkPara.rc4key, easylinkPara.isSmallMTU, easylinkcb);
            } else {
                this.comfunc.failureCBEasyLink(EasyLinkErrCode.CONTEXT_CODE, EasyLinkErrCode.CONTEXT, easylinkcb);
            }
        } else {
            this.comfunc.failureCBEasyLink(EasyLinkErrCode.INVALID_CODE, EasyLinkErrCode.INVALID, easylinkcb);
        }
    }

    private void startEasyLink(String ssid, String password, boolean isSendIP, final int runSecond, int sleeptime, String extraData, String rc4key, boolean isSmallMTU, final EasyLinkCallBack easylinkcb) {
        if (!this.eltag) {
            if (null == this.workThread) {
                this.workThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(runSecond);
                            if (EasyLink.this.eltag) {
                                EasyLink.this.stopEasyLink(easylinkcb);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
                this.workThread.start();
            }
            try {
                this.startEasylink(ssid, password, isSendIP, sleeptime, extraData, rc4key, isSmallMTU, easylinkcb);
                this.eltag = true;
                if (isSendIP) {
                    try {
                        mEasyServer = new EasyServer(8000);
                        mEasyServer.start(easylinkcb);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.comfunc.successCBEasyLink(EasyLinkErrCode.START_CODE, EasyLinkErrCode.SUCCESS, easylinkcb);
            }
            catch (Exception e) {
                this.comfunc.failureCBEasyLink(EasyLinkErrCode.EXCEPTION_CODE, e.getMessage(), easylinkcb);
            }
        } else {
            this.comfunc.failureCBEasyLink(EasyLinkErrCode.BUSY_CODE, EasyLinkErrCode.BUSY, easylinkcb);
        }
    }

    public void stopEasyLink(final EasyLinkCallBack easylinkcb) {
        new Thread(){

            @Override
            public void run() {
                super.run();
                if (null != EasyLink.this.mEasylinkPlus && EasyLink.this.eltag) {
                    if (null != EasyLink.this.workThread) {
                        EasyLink.this.workThread = null;
                    }
                    EasyLink.this.mEasylinkPlus.stopTransmitting();
                    if (null != mEasyServer && mEasyServer.isStarted()) {
                        mEasyServer.stop();
                    }
                    EasyLink.this.eltag = false;
                    EasyLink.this.comfunc.successCBEasyLink(EasyLinkErrCode.STOP_CODE, EasyLinkErrCode.SUCCESS, easylinkcb);
                } else {
                    EasyLink.this.comfunc.failureCBEasyLink(EasyLinkErrCode.CLOSED_CODE, EasyLinkErrCode.CLOSED, easylinkcb);
                }
            }
        }.start();
    }

    protected void startEasylink(String ssid, String password, boolean isSendIP, int sleeptime, String extraData, String rc4key, boolean isSmallMTU, EasyLinkCallBack easylinkcb) {
        int ip = 0;
        if (isSendIP) {
            ip = this.getNormalIP(this.mContext);
        } else if (ComHelper.isInteger(extraData)) {
            ip = Integer.parseInt(extraData);
            extraData = "";
        } else {
            ip = 1000;
        }
        this.mEasylinkPlus = EasyLink_plus.getInstence(this.mContext);
        try {
            NetworkInterface intf = NetworkInterface.getByName("wlan0");
            if (intf.getMTU() < 1500 || isSmallMTU) {
                this.mEasylinkPlus.setSmallMtu(true);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.comfunc.failureCBEasyLink(EasyLinkErrCode.EXCEPTION_CODE, e.getMessage(), easylinkcb);
        }
        try {
            this.mEasylinkPlus.transmitSettings(ssid, password, ip, sleeptime, extraData, rc4key);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.comfunc.failureCBEasyLink(EasyLinkErrCode.EXCEPTION_CODE, e.getMessage(), easylinkcb);
        }
    }

    private int getNormalIP(Context context) {
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        return this.mWifiInfo.getIpAddress();
    }
}

