package io.fogcloud.sdk.easylink.helper;

import java.io.UnsupportedEncodingException;

/**
 * 通过设置WiFi P2P的device name来传输easylink配网数据
 *
 * Youxx
 * 2017/10/30
 */
public class P2PData {

//    private String TAG = "---p2p---";

    private char decode_table[] = {
            0x00, 0x55, 0x21, 0x1e, 0x78, 0x09, 0x61, 0x56,
            0x0c, 0x71, 0x67, 0x2f, 0x3d, 0x4b, 0x01, 0x2b,
            0x6c, 0x1c, 0x2d, 0x38, 0x50, 0x58, 0x5a, 0x40,
            0x5f, 0x46, 0x1b, 0x70, 0x62, 0x7d, 0x68, 0x6b,
            0x5e, 0x3f, 0x4f, 0x26, 0x27, 0x0d, 0x28, 0x5d,
            0x0b, 0x5b, 0x06, 0x65, 0x4e, 0x0f, 0x41, 0x3e,
            0x5c, 0x17, 0x54, 0x7c, 0x24, 0x31, 0x18, 0x13,
            0x73, 0x7a, 0x03, 0x49, 0x32, 0x4c, 0x25, 0x63,
            0x77, 0x76, 0x51, 0x1a, 0x05, 0x3a, 0x69, 0x3c,
            0x34, 0x43, 0x37, 0x44, 0x66, 0x08, 0x7f, 0x59,
            0x20, 0x47, 0x72, 0x16, 0x2e, 0x35, 0x6e, 0x33,
            0x14, 0x1f, 0x52, 0x29, 0x45, 0x6a, 0x2c, 0x0e,
            0x15, 0x30, 0x42, 0x36, 0x10, 0x60, 0x74, 0x4d,
            0x64, 0x48, 0x79, 0x0a, 0x02, 0x04, 0x6d, 0x07,
            0x3b, 0x22, 0x1d, 0x2a, 0x7e, 0x39, 0x11, 0x7b,
            0x12, 0x19, 0x6f, 0x57, 0x23, 0x75, 0x4a, 0x53,
            0x9c, 0xaf, 0x91, 0xa4, 0xb6, 0xa8, 0xa7, 0x97,
            0x98, 0x84, 0xbd, 0xb9, 0x82, 0xb1, 0xa3, 0xbe,
            0xa2, 0x89, 0x95, 0x9a, 0x94, 0x8e, 0xae, 0xba,
            0xa9, 0x9f, 0xa6, 0xb7, 0xad, 0xb4, 0x87, 0xa5,
            0xab, 0x88, 0x85, 0x93, 0xaa, 0x90, 0x81, 0xbb,
            0x8f, 0x86, 0x92, 0xa0, 0xac, 0x8b, 0xb5, 0x80,
            0xb0, 0x99, 0xb3, 0xbc, 0xb8, 0x9d, 0xbf, 0x8d,
            0x96, 0x8a, 0x9e, 0xb2, 0x9b, 0x83, 0xa1, 0x8c,
            0xc1, 0xd8, 0xd5, 0xd6, 0xc5, 0xc0, 0xd3, 0xcd,
            0xc2, 0xd7, 0xd9, 0xc9, 0xcc, 0xca, 0xdc, 0xd2,
            0xde, 0xc6, 0xc7, 0xdd, 0xdf, 0xcb, 0xda, 0xc3,
            0xdb, 0xc8, 0xd4, 0xce, 0xd0, 0xd1, 0xc4, 0xcf,
            0xef, 0xea, 0xe3, 0xe6, 0xeb, 0xe1, 0xe4, 0xe9,
            0xe2, 0xe0, 0xec, 0xe5, 0xe7, 0xe8, 0xee, 0xed,
            0xf1, 0xf7, 0xf4, 0xf5, 0xf2, 0xf3, 0xf0, 0xf6,
            0xfb, 0xf9, 0xfa, 0xf8, 0xfc, 0xfd, 0xfe, 0xff,
    };

    /**
     * =============  利用wifi director进行配网  ==============
     * Android使用wifi p2p方式，发送probe request包，利用WPS IE中的device name来发送配网数据，P2P数据，通常在channel 1、6、11。
     * device name的组成方式：IE total len - 4(IE header lenght) = total len
     * 数据组成：total len = ssidlen ssid key crc1
     * 第一个字节是ssid len；最后2个字节是crc16，crc的计算方式同广播配网一样
     * ssid和key使用了encode算法做数据转换
     * 当total大于32以后，就对ssid做裁减，多几个字节，就把ssid前面几个字节去掉；如果ssid全部去掉都放不下，则不用p2p发送，只使用广播。
     **/

    public String bgProtocol(aws_broadcast aws, String ssid, String key) throws UnsupportedEncodingException {
        char[] tmpSsidAndKey = new char[3 + ssid.getBytes("UTF-8").length + key.getBytes("UTF-8").length];
//        aws_broadcast aws = new aws_broadcast();
        char crc16;
        int i = 1;
        int j = 1;
        int total_length = ssid.getBytes("UTF-8").length + key.getBytes("UTF-8").length + 3;
        int overflow_length;
        boolean is_chinese = false;
        int real_length;


        //广播配网一直存在
        aws.aws_send(ssid,key);
        //最大长度只能是32
        if (total_length > 32) {
            overflow_length = total_length - 32;
            if(overflow_length > ssid.getBytes("UTF-8").length) {
//                aws.aws_send(ssid,key);

            } else {
                //先判断是否含有中文
                for (byte b : ssid.getBytes()) {
                    if(b < 0) {
                        is_chinese = true;
                        break;
                    }
                }
                if(!is_chinese) {
                    tmpSsidAndKey[0] = (char) (ssid.getBytes("UTF-8").length - overflow_length);
                    // 添加ssid
                    for (byte b : ssid.getBytes("UTF-8")) {
                        j++;
                        if (j > overflow_length) {
                            tmpSsidAndKey[i++] = decode_table[b];
                        }
                    }
                    //添加pwd
                    for (byte b : key.getBytes("UTF-8")) {
                        tmpSsidAndKey[i++] = decode_table[b];
                    }
                    //crc16
                    crc16 = CRC16.zconfig_checksum_v2(tmpSsidAndKey, tmpSsidAndKey.length);
                    tmpSsidAndKey[i++] = (char) ((crc16 & 0xff00) >> 8);
                    tmpSsidAndKey[i] = (char) (crc16 & 0xff);
                }
                else
                {
                    //WPS
                    tmpSsidAndKey[0] = 0;
                    real_length = 1;
                    //添加pwd
                    for (byte b : key.getBytes("UTF-8")) {
                        tmpSsidAndKey[i++] = decode_table[b];
                        real_length++;
                    }
                    //crc16
                    crc16 = CRC16.zconfig_checksum_v2(tmpSsidAndKey, tmpSsidAndKey.length);
                    tmpSsidAndKey[i++] = (char) ((crc16 & 0xff00) >> 8);
                    tmpSsidAndKey[i] = (char) (crc16 & 0xff);
                    real_length+=2;
                    total_length = real_length;
                }
            }
        } else {
            //先判断是否含有中文
            for (byte b : ssid.getBytes()) {
                if(b < 0) {
                    is_chinese = true;
                    break;
                }
            }
            if(is_chinese)
            {
                //广播
//                aws.aws_send(ssid,key);
                //WPS
                tmpSsidAndKey[0] = 0;
                real_length = 1;
                //添加pwd
                for (byte b : key.getBytes("UTF-8")) {
                    tmpSsidAndKey[i++] = decode_table[b];
                    real_length++;
                }
                //crc16
                crc16 = CRC16.zconfig_checksum_v2(tmpSsidAndKey, tmpSsidAndKey.length);
                tmpSsidAndKey[i++] = (char) ((crc16 & 0xff00) >> 8);
                tmpSsidAndKey[i] = (char) (crc16 & 0xff);
                real_length+=2;
                total_length = real_length;
            }
            else {
                tmpSsidAndKey[0] = (char) ssid.getBytes("UTF-8").length;
                // 添加ssid
                for (byte b : ssid.getBytes()) {
                    tmpSsidAndKey[i++] = decode_table[b];
                }
                //添加pwd
                for (byte b : key.getBytes("UTF-8")) {
                    tmpSsidAndKey[i++] = decode_table[b];
                }
                //crc16
                crc16 = CRC16.zconfig_checksum_v2(tmpSsidAndKey, tmpSsidAndKey.length);
                tmpSsidAndKey[i++] = (char) ((crc16 & 0xff00) >> 8);
                tmpSsidAndKey[i] = (char) (crc16 & 0xff);
            }
        }
        return new String(tmpSsidAndKey, 0, total_length);
    }
}