/*
 * Decompiled with CFR 0.152.
 */
package io.fogcloud.sdk.easylink.plus;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Parcelable;
import io.fogcloud.sdk.easylink.helper.ProbeReqData;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EasyLink_minus {
    private Thread mCallbackThread;
    private Context mContext;
    boolean stopSending = false;
    private IntentFilter mIntentFilter = null;
    private boolean mScanning;
    private int mErrorId = 0;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context paramAnonymousContext, Intent intent) {
            EasyLink_minus.this.mScanning = false;
            EasyLink_minus.this.mContext.unregisterReceiver((BroadcastReceiver)this);
            if (intent.getAction().equals("android.net.wifi.SCAN_RESULTS")) {
                System.out.println("SCAN_RESULTS_AVAILABLE");
                EasyLink_minus.this.mScanning = false;
            }
            if (intent.getAction().equals("android.net.wifi.STATE_CHANGE")) {
                try {
                    Parcelable localParcelable = intent.getParcelableExtra("networkInfo");
                    if (localParcelable != null && !((NetworkInfo)localParcelable).isAvailable()) {
                        EasyLink_minus.this.mErrorId = 102;
                        EasyLink_minus.this.mScanning = false;
                        EasyLink_minus.this.clearNetList();
                        return;
                    }
                }
                catch (Exception localException2) {
                    localException2.printStackTrace();
                    return;
                }
            }
            try {
                switch (intent.getIntExtra("wifi_state", 0)) {
                    case 0: {
                        EasyLink_minus.this.clearNetList();
                        return;
                    }
                }
            }
            catch (Exception localException1) {
                localException1.printStackTrace();
                return;
            }
            EasyLink_minus.this.mErrorId = 101;
            EasyLink_minus.this.mScanning = false;
        }
    };
    private List<Integer> mNetId = new ArrayList<Integer>();

    public boolean isScanning() {
        return this.mScanning;
    }

    public EasyLink_minus(Context ctx, Thread t) {
        this(ctx);
        this.mCallbackThread = t;
    }

    public EasyLink_minus(Context ctx) {
        this.mContext = ctx;
        this.mIntentFilter = new IntentFilter();
        this.mIntentFilter.addAction("android.net.wifi.SCAN_RESULTS");
        this.mIntentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        this.mIntentFilter.addAction("android.net.wifi.STATE_CHANGE");
        this.mContext.registerReceiver(this.mReceiver, this.mIntentFilter);
    }

    public void transmitSettings(final String Ssid, final String Key, final int ipAddress) {
        new Thread(){

            @Override
            public void run() {
                EasyLink_minus.this.startTransmit(Ssid, Key, ipAddress);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startTransmit(String Ssid, String Key, int ipAddress) {
        this.stopSending = false;
        String[] param = null;
        try {
            param = new ProbeReqData().bgProtocol(Ssid, Key, ipAddress);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        WifiManager localWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        WifiConfiguration config = new WifiConfiguration();
        config.BSSID = null;
        config.preSharedKey = null;
        config.wepKeys = new String[4];
        config.wepTxKeyIndex = 0;
        config.priority = 0;
        config.hiddenSSID = true;
        config.allowedKeyManagement.set(0);
        config.allowedGroupCiphers.set(0);
        config.allowedGroupCiphers.set(1);
        config.allowedGroupCiphers.set(2);
        config.allowedGroupCiphers.set(3);
        config.allowedPairwiseCiphers.set(1);
        config.allowedPairwiseCiphers.set(2);
        config.allowedProtocols.set(0);
        config.allowedProtocols.set(1);
        while (!this.stopSending) {
            for (int pi = 1; pi < param.length; ++pi) {
                config.SSID = String.format("\"%s\"", param[pi]);
                localWifiManager.addNetwork(config);
                localWifiManager.saveConfiguration();
                for (WifiConfiguration cfg : localWifiManager.getConfiguredNetworks()) {
                    if (!cfg.SSID.equals(config.SSID)) continue;
                    this.mNetId.add(cfg.networkId);
                }
                try {
                    Iterator<Object> iterator = this.mNetId.iterator();
                    while (iterator.hasNext()) {
                        int netId = (Integer)iterator.next();
                        localWifiManager.disableNetwork(netId);
                        localWifiManager.enableNetwork(netId, false);
                        localWifiManager.startScan();
                        Thread.sleep(50L);
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                finally {
                    this.mNetId = new ArrayList<Integer>();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendProbeRequest(WifiManager localWifiManager, List<Integer> netIds) {
        try {
            while (!this.stopSending) {
                for (int netId : netIds) {
                    localWifiManager.disableNetwork(netId);
                    localWifiManager.enableNetwork(netId, false);
                    localWifiManager.startScan();
                    Thread.sleep(50L);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.mNetId = new ArrayList<Integer>();
        }
    }

    private void clearNetList() {
        WifiManager localWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        if (localWifiManager == null || localWifiManager.getConfiguredNetworks() == null) {
            return;
        }
        for (WifiConfiguration localWifiConfiguration : localWifiManager.getConfiguredNetworks()) {
            String ssid = localWifiConfiguration.SSID.replaceAll("\"", "");
            for (byte bt : ssid.getBytes()) {
                if (bt != 1) continue;
                localWifiManager.removeNetwork(localWifiConfiguration.networkId);
                localWifiManager.saveConfiguration();
            }
        }
    }

    public void stopTransmitting() {
        this.stopSending = true;
        this.clearNetList();
    }
}

