/*
 * Decompiled with CFR 0.152.
 */
package io.fogcloud.sdk.easylink.api;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceRequest;
import android.net.wifi.p2p.nsd.WifiP2pServiceRequest;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import io.fogcloud.sdk.easylink.helper.EasyLinkCallBack;
import io.fogcloud.sdk.easylink.helper.EasyLinkParams;
import io.fogcloud.sdk.easylink.helper.P2PData;
import io.fogcloud.sdk.easylink.helper.UdpSend;
import io.fogcloud.sdk.easylink.helper.aws_broadcast;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Arrays;

public class EasylinkP2P {
    private Context mContext;
    private String TAG = "---P2P---";
    private WifiP2pManager manager;
    private WifiP2pDnsSdServiceRequest serviceRequest;
    private WifiP2pManager.Channel channel;
    private aws_broadcast aws;
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private static boolean threadtag = true;
    private final int d_port = 65123;
    private static boolean close_flag = false;
    private static boolean close_AWS_Listen_flag = false;
    private String chanelname;
    private EasyLinkCallBack elcb;
    private boolean easylink_timeout = false;
    private CountDownTimer cdt;
    Handler LHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                EasylinkP2P.this.listenModulepack((String)msg.obj);
            } else if (msg.what == 3) {
                EasylinkP2P.this.sendTargetPack();
            }
        }
    };

    public EasylinkP2P(Context mContext_e) {
        this.mContext = mContext_e;
        this.manager = (WifiP2pManager)this.mContext.getSystemService("wifip2p");
        this.channel = this.manager.initialize(this.mContext, this.mContext.getMainLooper(), new WifiP2pManager.ChannelListener(){

            public void onChannelDisconnected() {
            }
        });
        this.send2handler(3, "");
        this.aws = new aws_broadcast();
    }

    private void sendTargetPack() {
        new Thread(){
            final int d_port = 50000;

            @Override
            public void run() {
                UdpSend tt = new UdpSend();
                while (threadtag) {
                    try {
                        tt.sendConfigData(1248, 50000);
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void listenModulepack(final String ExtraData) {
        new Thread(){

            @Override
            public void run() {
                boolean send_cb = true;
                byte[] buf = new byte[1024];
                byte[] default_str = new byte[1024];
                byte[] one_byte_str = new byte[1024];
                DatagramPacket recvdata = new DatagramPacket(buf, 1024);
                one_byte_str[0] = -18;
                try {
                    DatagramSocket listen_socket = new DatagramSocket(null);
                    listen_socket.setReuseAddress(true);
                    listen_socket.bind(new InetSocketAddress(65123));
                    while (!close_AWS_Listen_flag) {
                        try {
                            listen_socket.setSoTimeout(3000);
                            listen_socket.receive(recvdata);
                            if (recvdata.getLength() != 0) {
                                byte[] recv_bytes;
                                if (!close_flag) {
                                    close_flag = true;
                                    EasylinkP2P.this.clearService();
                                    EasylinkP2P.this.aws.set_stop_broad_flag(true);
                                }
                                if (!Arrays.equals(recv_bytes = recvdata.getData(), default_str) && !Arrays.equals(recv_bytes, one_byte_str)) {
                                    if (send_cb) {
                                        String elcb_str = new String(recvdata.getData());
                                        Log.w((String)"yyy", (String)elcb_str);
                                        elcb_str = elcb_str.substring(0, recvdata.getLength() - 1);
                                        elcb_str = elcb_str + ",\"IP\":\"" + recvdata.getAddress().toString().replaceAll("/", "") + "\"}";
                                        EasylinkP2P.this.elcb.onSuccess(0, elcb_str);
                                        send_cb = false;
                                    }
                                    String ack_str = "{\"STATUS\":\"OK\",";
                                    ack_str = ack_str + "\"ExtraData\":\"" + ExtraData + "\"}";
                                    DatagramPacket dp = new DatagramPacket(ack_str.getBytes(), ack_str.getBytes().length, recvdata.getAddress(), recvdata.getPort());
                                    listen_socket.send(dp);
                                    EasylinkP2P.this.cdt.cancel();
                                }
                            }
                            Thread.sleep(20L);
                        }
                        catch (IOException | InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    listen_socket.close();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void discoverService() {
        this.serviceRequest = WifiP2pDnsSdServiceRequest.newInstance();
        this.manager.addServiceRequest(this.channel, (WifiP2pServiceRequest)this.serviceRequest, null);
        this.manager.discoverServices(this.channel, null);
    }

    private void clearService() {
        this.manager.clearLocalServices(this.channel, null);
        this.manager.clearServiceRequests(this.channel, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
            }

            public void onFailure(int reason) {
            }
        });
    }

    private void clearService(final EasyLinkCallBack easylinkcb) {
        this.clearName();
        this.manager.clearLocalServices(this.channel, null);
        this.manager.clearServiceRequests(this.channel, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
                easylinkcb.onSuccess(0, "stop easylink success");
            }

            public void onFailure(int reason) {
                easylinkcb.onFailure(1, "stop easylink failed");
            }
        });
    }

    private void clearService_internal(EasyLinkCallBack easylinkcb) {
        this.clearName();
        this.manager.clearLocalServices(this.channel, null);
        this.manager.clearServiceRequests(this.channel, null);
        easylinkcb.onFailure(1, "easylink timeout");
    }

    private void clearName() {
        new Thread(){

            @Override
            public void run() {
                try {
                    EasylinkP2P.this.chanelname = "Android_Easy";
                    Class[] partypes = new Class[]{WifiP2pManager.Channel.class, String.class, WifiP2pManager.ActionListener.class};
                    Method method = EasylinkP2P.this.manager.getClass().getMethod("setDeviceName", partypes);
                    method.setAccessible(true);
                    threadtag = false;
                    close_flag = false;
                    Object[] args = new Object[]{EasylinkP2P.this.channel, EasylinkP2P.this.chanelname, new WifiP2pManager.ActionListener(){

                        public void onSuccess() {
                        }

                        public void onFailure(int reason) {
                        }
                    }};
                    method.invoke((Object)EasylinkP2P.this.manager, args);
                    EasylinkP2P.this.discoverService();
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private String getData(String Ssid, String Key) {
        String param = null;
        try {
            param = new P2PData().bgProtocol(this.aws, Ssid, Key);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return param;
    }

    public String getSSID() {
        if (this.mContext != null) {
            this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            this.mWifiInfo = this.mWifiManager.getConnectionInfo();
            return this.mWifiInfo.getSSID().replaceAll("\"", "");
        }
        return null;
    }

    public void startEasyLink(EasyLinkParams elp, EasyLinkCallBack easylinkcb) {
        this.elcb = easylinkcb;
        threadtag = false;
        close_AWS_Listen_flag = false;
        this.send2handler(1, elp.extraData);
        this.aws.set_stop_broad_flag(false);
        this.chanelname = this.getData(elp.ssid, elp.password);
        this.cdt = new CountDownTimer(elp.runSecond * 1000, 1000L){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                EasylinkP2P.this.stopEasyLink_internel(EasylinkP2P.this.elcb);
            }
        };
        this.cdt.start();
        new Thread(){

            @Override
            public void run() {
                try {
                    Class[] partypes = new Class[]{WifiP2pManager.Channel.class, String.class, WifiP2pManager.ActionListener.class};
                    Method method = EasylinkP2P.this.manager.getClass().getMethod("setDeviceName", partypes);
                    method.setAccessible(true);
                    Object[] args = new Object[]{EasylinkP2P.this.channel, EasylinkP2P.this.chanelname, new WifiP2pManager.ActionListener(){

                        public void onSuccess() {
                        }

                        public void onFailure(int reason) {
                        }
                    }};
                    method.invoke((Object)EasylinkP2P.this.manager, args);
                    EasylinkP2P.this.discoverService();
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void stopEasyLink(EasyLinkCallBack easylinkcb) {
        this.cdt.cancel();
        close_AWS_Listen_flag = true;
        this.send2handler(2, "");
        if (this.aws != null) {
            this.aws.set_stop_broad_flag(true);
        }
        this.clearService(easylinkcb);
    }

    private void stopEasyLink_internel(EasyLinkCallBack easylinkcb) {
        close_AWS_Listen_flag = true;
        if (this.aws != null) {
            this.aws.set_stop_broad_flag(true);
        }
        this.clearService_internal(easylinkcb);
    }

    private void send2handler(int code, String message) {
        Message msg = new Message();
        msg.what = code;
        msg.obj = message;
        this.LHandler.sendMessage(msg);
    }
}

