package io.fogcloud.sdk.easylink.helper;

/**
 * Created by youxiaoxiang on 2017/11/1.
 */


import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UdpSend {
    private DatagramSocket ds;

    public UdpSend() {
        try {
            ds = new DatagramSocket();// 创建用来发送数据报包的套接字
        } catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public DatagramSocket get_socket()
    {
        return this.ds;
    }

    public UdpSend(int port) {
        try {
            ds = new DatagramSocket(port);// 创建用来发送数据报包的套接字
        } catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public void setReuseAddr()
    {
        try {
            ds.setReuseAddress(true);
        } catch (SocketException e) {
            e.printStackTrace();
        }
    }

    /*data source port,destination port*/
    public void sendConfigData(int length, int d_port) {
        byte[] byte_str = new byte[length];
        try {
            DatagramPacket dp = new DatagramPacket(byte_str, length, InetAddress.getByName("255.255.255.255"), d_port);
            // 构造数据报包，用来将长度为 length 的包发送到指定主机上的指定端口号
            if(!ds.isClosed())
                ds.send(dp);
        } catch (IOException e) {
            e.printStackTrace();
            ds.close();
        }
    }

    public void sendUdpunicast(byte[] byte_str,int length, int d_port, InetAddress ip) throws SocketException,
            UnknownHostException {
        DatagramPacket dp = new DatagramPacket(byte_str,
                length,
                ip, d_port);
        // 构造数据报包，用来将长度为 length 的包发送到指定主机上的指定端口号
        try {
            if(!ds.isClosed())
                ds.send(dp);
        } catch (IOException e) {
            ds.close();
            e.printStackTrace();
        }
    }

    public void recvPackage(DatagramPacket p)
    {
        try {
            ds.setSoTimeout(3000);
            ds.receive(p);
        }catch (IOException e) {
            e.printStackTrace();
        }
    }
}