/*
 * Decompiled with CFR 0.152.
 */
package io.fogcloud.sdk.easylink.helper;

import io.fogcloud.sdk.easylink.helper.Crc8Code;
import io.fogcloud.sdk.easylink.helper.RC4;
import java.io.UnsupportedEncodingException;

public class ProbeReqData {
    private static final String ARC4_KEY = "mxchip_easylink_minus";
    private static final int version = 1;
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public String[] bgProtocol(String ssid, String key, int ip) throws UnsupportedEncodingException {
        byte[] byteSSID = new byte[2];
        byteSSID[0] = 1;
        byte[] tmpSsidAndKey = new byte[5 + ssid.getBytes("UTF-8").length + key.getBytes("UTF-8").length];
        tmpSsidAndKey[0] = (byte)(ip & 0xFF);
        tmpSsidAndKey[1] = (byte)(ip >> 8 & 0xFF);
        tmpSsidAndKey[2] = (byte)(ip >> 16 & 0xFF);
        tmpSsidAndKey[3] = (byte)(ip >> 24 & 0xFF);
        tmpSsidAndKey[4] = (byte)ssid.getBytes("UTF-8").length;
        int i = 5;
        for (byte b : ssid.getBytes("UTF-8")) {
            tmpSsidAndKey[i++] = b;
        }
        for (byte b : key.getBytes("UTF-8")) {
            tmpSsidAndKey[i++] = b;
        }
        byte[] tdata1 = this.transfer(tmpSsidAndKey);
        byte[] data = new RC4(ARC4_KEY.getBytes("UTF-8")).encrypt(tmpSsidAndKey);
        byte[] tdata = this.transfer(data);
        int bagLen = tdata.length % 29 == 0 ? tdata.length / 29 : tdata.length / 29 + 1;
        String[] rstdata = new String[bagLen + 1];
        rstdata[0] = new String(tdata1);
        if (1 == bagLen) {
            byte[] result = new byte[3 + tdata.length];
            byte Seq = (byte)((bagLen & 0xF) << 4);
            Seq = (byte)(Seq + (byte)(bagLen & 0xF));
            byte[] ChecksumData = new byte[1 + tdata.length];
            ChecksumData[0] = Seq;
            for (int j = 0; j < tdata.length; ++j) {
                ChecksumData[j + 1] = tdata[j];
            }
            byteSSID[1] = 16;
            byte Checksum = Crc8Code.calcCrc8(ChecksumData);
            byteSSID[1] = (byte)(byteSSID[1] | Checksum & 0xF);
            result[0] = byteSSID[0];
            result[1] = byteSSID[1];
            result[2] = Seq;
            for (int j = 0; j < tdata.length; ++j) {
                result[j + 3] = tdata[j];
            }
            rstdata[1] = new String(result, "UTF-8");
        } else {
            for (int di = 0; di < bagLen; ++di) {
                int reslen = 0;
                reslen = di + 1 < bagLen ? 29 : tdata.length % 29;
                byte[] result = new byte[3 + reslen];
                byte[] ChecksumData = new byte[1 + reslen];
                byte Seq = (byte)((bagLen & 0xF) << 4);
                ChecksumData[0] = Seq = (byte)(Seq + (byte)(di + 1 & 0xF));
                for (int j = 0; j < reslen; ++j) {
                    result[j + 3] = tdata[j + di * 29];
                    ChecksumData[j + 1] = tdata[j + di * 29];
                }
                byteSSID[1] = 0;
                byteSSID[1] = 16;
                byte Checksum = Crc8Code.calcCrc8(ChecksumData);
                byteSSID[1] = (byte)(byteSSID[1] | Checksum & 0xF);
                result[0] = byteSSID[0];
                result[1] = byteSSID[1];
                result[2] = Seq;
                rstdata[di + 1] = new String(result, "UTF-8");
            }
        }
        return rstdata;
    }

    byte[] transfer(byte[] data_in) {
        int i;
        int len_in = data_in.length;
        byte[] data_out = new byte[len_in * 2];
        int j = 0;
        for (i = 0; i < len_in; ++i) {
            int k;
            int left;
            byte tmp = (byte)(data_in[i] & 0x7F);
            if (tmp == 126) {
                data_out[j++] = 126;
                data_out[j++] = 1;
            } else if (tmp == 0) {
                data_out[j++] = 126;
                data_out[j++] = 2;
            } else {
                data_out[j++] = tmp;
            }
            if (i % 7 == 6) {
                tmp = 0;
                left = i - 6;
                for (k = 0; k < 7; ++k) {
                    tmp = (byte)(tmp + ((data_in[left + k] & 0x80) >> 7 - k));
                }
                if (tmp == 126) {
                    data_out[j++] = 126;
                    data_out[j++] = 1;
                    continue;
                }
                if (tmp == 0) {
                    data_out[j++] = 126;
                    data_out[j++] = 2;
                    continue;
                }
                data_out[j++] = tmp;
                continue;
            }
            if (i != len_in - 1) continue;
            tmp = 0;
            left = len_in % 7;
            for (k = 0; k < left; ++k) {
                tmp = (byte)(tmp + ((data_in[len_in - left + k] & 0x80) >> 7 - k));
            }
            if (tmp == 126) {
                data_out[j++] = 126;
                data_out[j++] = 1;
                continue;
            }
            if (tmp == 0) {
                data_out[j++] = 126;
                data_out[j++] = 2;
                continue;
            }
            data_out[j++] = tmp;
        }
        byte[] result = new byte[j];
        for (i = 0; i < j; ++i) {
            result[i] = data_out[i];
        }
        return result;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(ProbeReqData.charToByte(hexChars[pos]) << 4 | ProbeReqData.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

