package io.fogcloud.sdk.easylink.api;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceRequest;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

import io.fogcloud.sdk.easylink.helper.*;

/**
 * Created by youxiaoxiang on 2017/11/7.
 */
public class EasylinkP2P {
    private Context mContext;// 上下文
    private String TAG = "---P2P---";
    private WifiP2pManager manager;
    private WifiP2pDnsSdServiceRequest serviceRequest;
    private WifiP2pManager.Channel channel;
    private aws_broadcast aws;
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private static boolean threadtag = true;
    private final int d_port = 65123;
    private static boolean close_flag = false;
    private static boolean close_AWS_Listen_flag = false;
    private String chanelname;
    private EasyLinkCallBack elcb;
    //    private UdpSend listen_tt;
    private boolean easylink_timeout = false;
    private CountDownTimer cdt;

    public EasylinkP2P(Context mContext_e) {
        mContext = mContext_e;
        manager = (WifiP2pManager) mContext.getSystemService(Context.WIFI_P2P_SERVICE);
        channel = manager.initialize(mContext, mContext.getMainLooper(), new WifiP2pManager.ChannelListener() {
            @Override
            public void onChannelDisconnected() {
            }
        });
        send2handler(3, "");
        aws = new aws_broadcast();
    }

    private void sendTargetPack() {
        new Thread() {
            final int d_port = 50000;

            @Override
            public void run() {
                UdpSend tt = new UdpSend();
                while (EasylinkP2P.threadtag) {
                    try {
//                        Log.w("yyy","sendpack");
                        tt.sendConfigData(0x4E0, d_port);
                        Thread.sleep(20);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

//    private void close_listenpack() {
//        if (listen_tt != null) {
//            //android 7.0需要关掉
////            EasylinkP2P.listen_tt.get_socket().disconnect();
//            listen_tt.get_socket().close();
//            listen_tt = null;
//        }
//    }

    private void listenModulepack() {
        new Thread() {
            public void run() {
                boolean send_cb = true;
                byte[] buf = new byte[1024];
                byte[] default_str = new byte[1024];
                DatagramSocket listen_socket;
                DatagramPacket recvdata = new DatagramPacket(buf, 1024);
                try {
                    listen_socket = new DatagramSocket(null);
                    listen_socket.setReuseAddress(true);
                    listen_socket.bind(new InetSocketAddress(d_port));
                    while (!EasylinkP2P.close_AWS_Listen_flag) {
                        try {
                            listen_socket.setSoTimeout(3000);
                            listen_socket.receive(recvdata);
                            if (recvdata.getLength() != 0) {
                                if (!EasylinkP2P.close_flag) {
                                /*关闭配网*/
                                    EasylinkP2P.close_flag = true;
                                    clearService();
                                    aws.set_stop_broad_flag(true);
                                }
                                byte[] recv_bytes = recvdata.getData();
                                if (!Arrays.equals(recv_bytes, default_str)) {
                                    if (send_cb) {
                                        String elcb_str = new String(recvdata.getData());
                                        Log.w("yyy", elcb_str);
                                        elcb_str = elcb_str.substring(0, recvdata.getLength() - 1);
                                        elcb_str = elcb_str + ",\"ip\":\"" + recvdata.getAddress().toString().replaceAll("/", "") + "\"}";
                                        elcb.onSuccess(0, elcb_str);
                                        send_cb = false;
                                    }
                            /*向模块发送单播回包*/
//                                listen_socket.sendUdpunicast(recvdata.getData(), recvdata.getLength(), recvdata.getPort(), recvdata.getAddress());
                                    DatagramPacket dp = new DatagramPacket(recvdata.getData(), recvdata.getLength(), recvdata.getAddress(), recvdata.getPort());
                                    listen_socket.send(dp);
                                    //超时任务关闭
                                    cdt.cancel();
                                }
                            }
                            Thread.sleep(20);
                        } catch (InterruptedException | IOException e) {
                            e.printStackTrace();
                        }
                    }
                    /*关闭socket*/
                    listen_socket.close();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }

            }
        }.start();
    }

    private void discoverService() {

        serviceRequest = WifiP2pDnsSdServiceRequest.newInstance();
        manager.addServiceRequest(channel, serviceRequest,
                null);
        manager.discoverServices(channel, null);
    }

    private void clearService() {

        manager.clearLocalServices(channel, null);
        manager.clearServiceRequests(channel, new WifiP2pManager.ActionListener() {

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(int reason) {
            }
        });
    }

    private void clearService(final EasyLinkCallBack easylinkcb) {

        clearName();
        manager.clearLocalServices(channel, null);
        manager.clearServiceRequests(channel, new WifiP2pManager.ActionListener() {
            @Override
            public void onSuccess() {
                easylinkcb.onSuccess(0, "stop easylink success");
            }

            @Override
            public void onFailure(int reason) {
                easylinkcb.onFailure(1, "stop easylink failed");
            }
        });
    }

    private void clearService_internal(final EasyLinkCallBack easylinkcb) {

        clearName();
        manager.clearLocalServices(channel, null);
        manager.clearServiceRequests(channel, null);
        //超时并且没有结束
//      Log.w("yyy","timeout");
        easylinkcb.onFailure(1, "easylink timeout");
    }

    private void clearName() {
        new Thread() {
            @Override
            public void run() {
                try {
                    //清空名字
                    chanelname = "Android_Easy";
                    Class<?> partypes[] = new Class[3];
                    partypes[0] = WifiP2pManager.Channel.class;
                    partypes[1] = String.class;
                    partypes[2] = WifiP2pManager.ActionListener.class;
                    Method method = manager.getClass().getMethod("setDeviceName", partypes);
                    method.setAccessible(true);

                    EasylinkP2P.threadtag = false;
                    EasylinkP2P.close_flag = false;

                    Object[] args = new Object[3];
                    args[0] = channel;
                    args[1] = chanelname;
                    args[2] = new WifiP2pManager.ActionListener() {

                        @Override
                        public void onSuccess() {
                        }

                        @Override
                        public void onFailure(int reason) {
                        }
                    };
                    method.invoke(manager, args);

                    discoverService();
                } catch (NoSuchMethodException | IllegalArgumentException | IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private String getData(String Ssid, String Key) {
        String param = null;
        try {
            param = new P2PData().bgProtocol(aws, Ssid, Key);
        } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return param;
    }

    /**
     * get ssid
     *
     * @return the wifi router which you connected
     */
    public String getSSID() {
        if (mContext != null) {
            mWifiManager = (WifiManager) mContext.getSystemService(Context.WIFI_SERVICE);
            mWifiInfo = mWifiManager.getConnectionInfo();
            return mWifiInfo.getSSID().replaceAll("\"", "");
        } else {
            return null;
        }
    }

    public void startEasyLink(final EasyLinkParams elp, EasyLinkCallBack easylinkcb) {

        elcb = easylinkcb;
        EasylinkP2P.threadtag = false;
        EasylinkP2P.close_AWS_Listen_flag = false;
        //如果调用两次会有问题，所以加个判断
        /*监听包*/
        send2handler(1, "");
        aws.set_stop_broad_flag(false);
        chanelname = getData(elp.ssid, elp.password);

        //超时之后关闭EasyLink
        cdt = new CountDownTimer(elp.runSecond * 1000, 1000) {
            @Override
            public void onTick(long millisUntilFinished) {
//                Log.d(TAG, "seconds remaining: " + millisUntilFinished / 1000);
            }

            @Override
            public void onFinish() {
                stopEasyLink_internel(elcb);
            }
        };
        cdt.start();

        new Thread() {
            @Override
            public void run() {
                try {
                    Class<?> partypes[] = new Class[3];
                    partypes[0] = WifiP2pManager.Channel.class;
                    partypes[1] = String.class;
                    partypes[2] = WifiP2pManager.ActionListener.class;
                    Method method = manager.getClass().getMethod("setDeviceName", partypes);
                    method.setAccessible(true);


                    Object[] args = new Object[3];
                    args[0] = channel;
                    args[1] = chanelname;
                    args[2] = new WifiP2pManager.ActionListener() {

                        @Override
                        public void onSuccess() {
//                            elcb.onSuccess(0,"success");
                        }

                        @Override
                        public void onFailure(int reason) {
//                            elcb.onFailure(1,"failed");
                        }
                    };
                    method.invoke(manager, args);

                    discoverService();
                } catch (NoSuchMethodException | IllegalArgumentException | IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void stopEasyLink(EasyLinkCallBack easylinkcb) {
        cdt.cancel();
        EasylinkP2P.close_AWS_Listen_flag = true;
        send2handler(2, "");
        if (aws != null)
            aws.set_stop_broad_flag(true);
        clearService(easylinkcb);
    }

    private void stopEasyLink_internel(EasyLinkCallBack easylinkcb) {
        EasylinkP2P.close_AWS_Listen_flag = true;
//        send2handler(2,"");
        if (aws != null)
            aws.set_stop_broad_flag(true);
        clearService_internal(easylinkcb);
    }

    private void send2handler(int code, String message) {
        Message msg = new Message();
        msg.what = code;
        msg.obj = message;
        LHandler.sendMessage(msg);
    }

    Handler LHandler = new Handler() {
        public void handleMessage(android.os.Message msg) {
            /*p2p*/
            /*定位包,监听udp*/
            if (msg.what == 1) {
                listenModulepack();
//            }else if(msg.what == 2) {
//                close_listenpack();
//            }
            } else if (msg.what == 3) {
                sendTargetPack();
            }
        }
    };
}
