/*
 * Decompiled with CFR 0.152.
 */
package io.fogcloud.sdk.easylink.api;

import android.content.Context;
import android.net.wifi.p2p.WifiP2pManager;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceRequest;
import android.net.wifi.p2p.nsd.WifiP2pServiceRequest;
import android.os.Handler;
import android.os.Message;
import io.fogcloud.sdk.easylink.helper.EasyLinkCallBack;
import io.fogcloud.sdk.easylink.helper.EasyLinkParams;
import io.fogcloud.sdk.easylink.helper.P2PData;
import io.fogcloud.sdk.easylink.helper.UdpSend;
import io.fogcloud.sdk.easylink.helper.aws_broadcast;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

public class EasylinkP2P {
    private Context mContext;
    private WifiP2pManager manager;
    private WifiP2pDnsSdServiceRequest serviceRequest;
    private WifiP2pManager.Channel channel;
    private aws_broadcast aws;
    private static boolean threadtag = true;
    private final int d_port = 65123;
    private static boolean close_flag = false;
    private static boolean close_AWS_Listen_flag = false;
    private String chanelname;
    private EasyLinkCallBack elcb;
    private static UdpSend listen_tt;
    Handler LHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                EasylinkP2P.this.listenModulepack();
            } else if (msg.what == 2) {
                EasylinkP2P.this.close_listenpack();
            } else if (msg.what == 3) {
                EasylinkP2P.this.sendTargetPack();
            }
        }
    };

    public EasylinkP2P(Context mContext_e) {
        this.mContext = mContext_e;
        this.manager = (WifiP2pManager)this.mContext.getSystemService("wifip2p");
        this.channel = this.manager.initialize(this.mContext, this.mContext.getMainLooper(), new WifiP2pManager.ChannelListener(){

            public void onChannelDisconnected() {
            }
        });
        this.send2handler(3, "");
    }

    private void sendTargetPack() {
        new Thread(){
            final int d_port = 50000;

            @Override
            public void run() {
                UdpSend tt = new UdpSend();
                while (threadtag) {
                    try {
                        tt.sendConfigData(1248, 50000);
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void close_listenpack() {
        if (listen_tt != null) {
            listen_tt.get_socket().disconnect();
            listen_tt.get_socket().close();
        }
    }

    private void listenModulepack() {
        new Thread(){

            @Override
            public void run() {
                byte[] buf = new byte[1024];
                byte[] default_str = new byte[1024];
                DatagramPacket recvdata = new DatagramPacket(buf, 1024);
                while (!close_AWS_Listen_flag) {
                    try {
                        listen_tt.recvPackage(recvdata);
                        if (recvdata.getLength() != 0) {
                            byte[] recv_bytes;
                            if (!close_flag) {
                                close_flag = true;
                                EasylinkP2P.this.clearService();
                                EasylinkP2P.this.aws.set_stop_broad_flag(true);
                            }
                            if (!Arrays.equals(recv_bytes = recvdata.getData(), default_str)) {
                                String elcb_str = new String(recvdata.getData());
                                elcb_str = elcb_str.substring(0, recvdata.getLength() - 1);
                                elcb_str = elcb_str + ",\"ip\":\"" + recvdata.getAddress().toString().replaceAll("/", "") + "\"}";
                                EasylinkP2P.this.elcb.onSuccess(0, elcb_str);
                                listen_tt.sendUdpunicast(recvdata.getData(), recvdata.getLength(), recvdata.getPort(), recvdata.getAddress());
                            }
                        }
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException | SocketException | UnknownHostException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void discoverService() {
        this.serviceRequest = WifiP2pDnsSdServiceRequest.newInstance();
        this.manager.addServiceRequest(this.channel, (WifiP2pServiceRequest)this.serviceRequest, null);
        this.manager.discoverServices(this.channel, null);
    }

    private void clearService() {
        this.manager.clearLocalServices(this.channel, null);
        this.manager.clearServiceRequests(this.channel, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
            }

            public void onFailure(int reason) {
            }
        });
    }

    private void clearService(final EasyLinkCallBack easylinkcb) {
        this.clearName();
        this.manager.clearLocalServices(this.channel, null);
        this.manager.clearServiceRequests(this.channel, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
                easylinkcb.onSuccess(0, "stop easylink success");
            }

            public void onFailure(int reason) {
                easylinkcb.onFailure(1, "stop easylink failed");
            }
        });
    }

    private void clearName() {
        new Thread(){

            @Override
            public void run() {
                try {
                    EasylinkP2P.this.chanelname = "Android_Easy";
                    Class[] partypes = new Class[]{WifiP2pManager.Channel.class, String.class, WifiP2pManager.ActionListener.class};
                    Method method = EasylinkP2P.this.manager.getClass().getMethod("setDeviceName", partypes);
                    method.setAccessible(true);
                    threadtag = false;
                    close_flag = false;
                    Object[] args = new Object[]{EasylinkP2P.this.channel, EasylinkP2P.this.chanelname, new WifiP2pManager.ActionListener(){

                        public void onSuccess() {
                        }

                        public void onFailure(int reason) {
                        }
                    }};
                    method.invoke((Object)EasylinkP2P.this.manager, args);
                    EasylinkP2P.this.discoverService();
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private String getData(String Ssid, String Key) {
        String param = null;
        try {
            param = new P2PData().bgProtocol(this.aws, Ssid, Key);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return param;
    }

    public void startEasyLink(EasyLinkParams elp, EasyLinkCallBack easylinkcb) {
        this.elcb = easylinkcb;
        listen_tt = new UdpSend(65123);
        this.aws = new aws_broadcast();
        threadtag = false;
        close_AWS_Listen_flag = false;
        this.send2handler(1, "");
        this.aws.set_stop_broad_flag(false);
        this.chanelname = this.getData(elp.ssid, elp.password);
        new Thread(){

            @Override
            public void run() {
                try {
                    Class[] partypes = new Class[]{WifiP2pManager.Channel.class, String.class, WifiP2pManager.ActionListener.class};
                    Method method = EasylinkP2P.this.manager.getClass().getMethod("setDeviceName", partypes);
                    method.setAccessible(true);
                    Object[] args = new Object[]{EasylinkP2P.this.channel, EasylinkP2P.this.chanelname, new WifiP2pManager.ActionListener(){

                        public void onSuccess() {
                        }

                        public void onFailure(int reason) {
                            EasylinkP2P.this.elcb.onFailure(1, "failed");
                        }
                    }};
                    method.invoke((Object)EasylinkP2P.this.manager, args);
                    EasylinkP2P.this.discoverService();
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void stopEasyLink(EasyLinkCallBack easylinkcb) {
        close_AWS_Listen_flag = true;
        this.send2handler(2, "");
        if (this.aws != null) {
            this.aws.set_stop_broad_flag(true);
        }
        this.clearService(easylinkcb);
    }

    private void send2handler(int code, String message) {
        Message msg = new Message();
        msg.what = code;
        msg.obj = message;
        this.LHandler.sendMessage(msg);
    }
}

