/*
 * Decompiled with CFR 0.152.
 */
package io.fogcloud.sdk.easylink.api;

import android.content.Context;
import io.fogcloud.sdk.easylink.helper.Helper;
import io.fogcloud.sdk.easylink.plus.EasyLink_v2;
import io.fogcloud.sdk.easylink.plus.EasyLink_v3;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EasyLink_plus {
    private static EasyLink_v2 e2;
    private static EasyLink_v3 e3;
    private static EasyLink_plus me;
    boolean sending = true;
    ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();

    private EasyLink_plus(Context ctx) {
        try {
            e2 = EasyLink_v2.getInstence();
            e3 = EasyLink_v3.getInstence();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static EasyLink_plus getInstence(Context ctx) {
        if (me == null) {
            me = new EasyLink_plus(ctx);
        }
        return me;
    }

    public void setSmallMtu(boolean onoff) {
        e3.SetSmallMTU(onoff);
    }

    public void transmitSettings(String ssid, String key, int ipAddress, final int sleeptime, String extraData, final String rc4key) {
        try {
            final byte[] ssid_byte = ssid.getBytes("UTF-8");
            final byte[] key_byte = key.getBytes("UTF-8");
            byte[] userinfo = null;
            if (0 != ipAddress) {
                int userinfoLen = 5 + extraData.getBytes().length;
                userinfo = new byte[userinfoLen];
                String strIP = String.format("%08x", ipAddress);
                if (!"".equals(extraData) || null != extraData) {
                    System.arraycopy(extraData.getBytes(), 0, userinfo, 0, extraData.getBytes().length);
                    userinfo[extraData.getBytes().length] = 35;
                    System.arraycopy(Helper.hexStringToBytes(strIP), 0, userinfo, extraData.getBytes().length + 1, 4);
                } else {
                    userinfo[0] = 35;
                    System.arraycopy(Helper.hexStringToBytes(strIP), 0, userinfo, 1, 4);
                }
            }
            final byte[] ipPextra = userinfo;
            this.singleThreadExecutor = Executors.newSingleThreadExecutor();
            this.sending = true;
            this.singleThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    while (EasyLink_plus.this.sending) {
                        try {
                            e2.transmitSettings(ssid_byte, key_byte, ipPextra, sleeptime);
                            e3.transmitSettings(ssid_byte, key_byte, ipPextra, rc4key, sleeptime);
                            try {
                                Thread.sleep(10000L);
                                e2.stopTransmitting();
                                e3.stopTransmitting();
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void transmitSettings(byte[] userinfo, byte[] ssid, byte[] key, int ipAddress, final int sleeptime, final String rc4key) {
        final byte[] ssid_byte = ssid;
        final byte[] key_byte = key;
        if (0 != ipAddress) {
            int userinfoLen = 5 + userinfo.length;
            byte[] userinfo_transfer = new byte[userinfoLen];
            String strIP = String.format("%08x", ipAddress);
            if (!"".equals(userinfo) || null != userinfo) {
                System.arraycopy(userinfo, 0, userinfo, 0, userinfo.length);
                userinfo_transfer[userinfo.length] = 35;
                System.arraycopy(Helper.hexStringToBytes(strIP), 0, userinfo_transfer, userinfo.length + 1, 4);
            } else {
                userinfo[0] = 35;
                System.arraycopy(Helper.hexStringToBytes(strIP), 0, userinfo_transfer, 1, 4);
            }
        }
        final byte[] ipPextra = userinfo;
        this.singleThreadExecutor = Executors.newSingleThreadExecutor();
        this.sending = true;
        this.singleThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                while (EasyLink_plus.this.sending) {
                    try {
                        e2.transmitSettings(ssid_byte, key_byte, ipPextra, sleeptime);
                        e3.transmitSettings(ssid_byte, key_byte, ipPextra, rc4key, sleeptime);
                        try {
                            Thread.sleep(10000L);
                            e2.stopTransmitting();
                            e3.stopTransmitting();
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void stopTransmitting() {
        this.sending = false;
        this.singleThreadExecutor.shutdown();
        e2.stopTransmitting();
        e3.stopTransmitting();
    }
}

