package io.fogcloud.sdk.easylink.helper;

import java.io.UnsupportedEncodingException;

/**
 * ͨʹssidprobe requestʵϢݸģ顣 ĿƣEasyLink_minus ˣRocke
 * ʱ䣺2015618 5:56:17
 *
 * @version 1.0
 */
public class ProbeReqData {
	//	private static final String TAG = "ProbeReqData";// ־
	private static final String ARC4_KEY = "mxchip_easylink_minus";// 
	private static final int version = 0x01;// 汾

	/**
	 * eq: 0x01 flag (Data) һֽʼ0x01ʾEasyLink Minusݡ Flagһֽڶ£
	 * Bit7=0 Bit6~4=version Bit3~0=checksum
	 * Version:17versionνssidݣ嶨ο棺
	 * ChecksumǶDataCRC8Уͼ㣬ȡ4bits DataǶԭʼͨARC4㷨ܺݡ
	 * ԭʼݣversionԭʼݵĲʽ
	 * ݣԭʼͨARC4㷨ʹ롱mxchip_easylink_minus
	 * Version汾
	 * 1. Version=1. ԭʼssid_len, (ssid), (key) 3ɣ Ssid_len
	 * Ssid Key ֻһprobe requestɣ
	 * ssid32ֽڣȥͷ0x01flagDataֻ30ֽ
	 * ssidkeyԭʼתΪData֮ܳȲܴ30ֽ.
	 *
	 * 2. Version=2. ԭʼssid_len, key_len, (ssid), (key), (extra
	 * data)Dataȴ30ֽڣҪVersion=3ݷͺݡ
	 *
	 * 3. Version=3.
	 * Ƕversion=2䡣 versionʱʹá
	 *
	 * @param ssid wifi ssid
	 * @param key key
	 * @param ip ip
	 * @return string[]
	 * @throws UnsupportedEncodingException  UnsupportedEncodingException
	 */
	public String[] bgProtocol(String ssid, String key, int ip)
			throws UnsupportedEncodingException {
		// ʵʴСȷĴСȷڵõdataĴС
		byte[] byteSSID = new byte[2];
		// һֽʼ0x01
		byteSSID[0] = (byte) 0x01; //
		// Bit6~4=version
		// byteSSID[1] = (byte) (version << 4); //

		// javaԴRC4㷨
		// Cipher cip;
		// try {
		// cip = Cipher.getInstance("RC4");
		// SecretKeySpec k = new SecretKeySpec(ARC4_KEY.getBytes("UTF-8"),
		// "RC4");
		// cip.init(Cipher.ENCRYPT_MODE, k);
		// byte [] r = cip.doFinal("abc".getBytes("UTF-8"));
		// byte[] r = new
		// RC4(ARC4_KEY.getBytes("UTF-8")).encrypt("012".getBytes("UTF-8"));
		// byte[] t = new RC4(ARC4_KEY.getBytes("UTF-8")).decrypt(r);
		// String txt = new String(t);
		// String h = bytesToHex(r);
		// Log.d(TAG, h);
		// } catch (Exception e) {
		// }

		// ȷԭʼݵĴСԭʼssid_len, <ssid>, <key> 3
		byte[] tmpSsidAndKey = new byte[5 + ssid.getBytes("UTF-8").length
				+ key.getBytes("UTF-8").length];

		// byte[] a = new byte[4];
		tmpSsidAndKey[0] = (byte) (ip & 0xFF);
		tmpSsidAndKey[1] = (byte) ((ip >> 8) & 0xFF);
		tmpSsidAndKey[2] = (byte) ((ip >> 16) & 0xFF);
		tmpSsidAndKey[3] = (byte) ((ip >> 24) & 0xFF);

		tmpSsidAndKey[4] = (byte) ssid.getBytes("UTF-8").length;
		int i = 5;
		for (byte b : ssid.getBytes("UTF-8")) {
			tmpSsidAndKey[i++] = b;
		}
		for (byte b : key.getBytes("UTF-8")) {
			tmpSsidAndKey[i++] = b;
		}
		byte[] tdata1 = transfer(tmpSsidAndKey);

		// DataǶԭʼͨARC4㷨ܺ
		byte[] data = new RC4(ARC4_KEY.getBytes("UTF-8"))
				.encrypt(tmpSsidAndKey);
		byte[] tdata = transfer(data);

		// ԭʼݲһҪٸ
		int bagLen = ((tdata.length % 29) == 0) ? (tdata.length / 29)
				: ((tdata.length / 29) + 1);
		String rstdata[] = new String[bagLen + 1];
		rstdata[0] = new String(tdata1);

		if (1 == bagLen) {
			// ȷʵʳ
			byte[] result = new byte[3 + tdata.length];

			byte Seq = (byte) ((bagLen & 0x0F) << 4);
			Seq += (byte) (bagLen & 0x0F);

			byte[] ChecksumData = new byte[1 + tdata.length];
			ChecksumData[0] = Seq;
			for (int j = 0; j < tdata.length; j++) {
				ChecksumData[j + 1] = tdata[j];
			}

			byteSSID[1] = (byte) (version << 4); //
			// ChecksumǶDataCRC8Уͼ㣬ȡ4bits
			byte Checksum = Crc8Code.calcCrc8(ChecksumData);
			byteSSID[1] |= Checksum & 0x0f;
			result[0] = byteSSID[0];
			result[1] = byteSSID[1];
			result[2] = Seq;

			for (int j = 0; j < tdata.length; j++) {
				result[j + 3] = tdata[j];
			}
//			Log.e(TAG, "tmpSsidAndKey:" + byteSSID.toString());

			// ǿתString
			// return result;
			rstdata[1] = new String(result, "UTF-8");
		} else {
			for (int di = 0; di < bagLen; di++) {
				// ȷʵʳ
				int reslen = 0;
				if (di + 1 < bagLen) {
					reslen = 29;
				} else {
					reslen = tdata.length % 29;
				}
				byte[] result = new byte[3 + reslen];
				byte[] ChecksumData = new byte[1 + reslen];

				byte Seq = (byte) ((bagLen & 0x0F) << 4);
				Seq += (byte) ((di + 1) & 0x0F);

				ChecksumData[0] = Seq;
				for (int j = 0; j < reslen; j++) {
					result[j + 3] = tdata[j + (di * 29)];
					ChecksumData[j + 1] = tdata[j + (di * 29)];
				}

				byteSSID[1] = 0x00;
				byteSSID[1] = (byte) (version << 4); //
				// ChecksumǶDataCRC8Уͼ㣬ȡ4bits
				byte Checksum = Crc8Code.calcCrc8(ChecksumData);
				// byte[] tishs = new byte[1];
				// tishs[0] = Checksum;
				// byte[] adadasds = bytesToHex(tishs).getBytes("UTF-8");
				byteSSID[1] |= Checksum & 0x0f;

				result[0] = byteSSID[0];
				result[1] = byteSSID[1];
				result[2] = Seq;

				rstdata[di + 1] = new String(result, "UTF-8");
			}
		}

		// if (tdata.length > 30) {
		// Log.e(TAG, "version 1 not support long ssid and key");
		// return null;
		// }

		// // ChecksumǶDataCRC8Уͼ㣬ȡ4bits
		// byte byteCrc8 = Crc8Code.calcCrc8(tdata);
		// byteSSID[1] |= byteCrc8 & 0x0f;
		//
		// // ȷʵʳ
		// byte[] result = new byte[2 + tdata.length];
		// result[0] = byteSSID[0];
		// result[1] = byteSSID[1];
		// for (int j = 0; j < tdata.length; j++) {
		// result[j + 2] = tdata[j];
		// }
		// Log.e(TAG, "tmpSsidAndKey:" + byteSSID.toString());
		//
		// // ǿתString
		// // return result;
		// rstdata[1] = new String(result);

		return rstdata;
	}

	/**
	 * Data: ڼһHexݣҪԼ±仯Dataݡ 1. 7ֽη飬һܲ7ֽڡ
	 * 2. ÿݺһֽڣһֽɸеbit7λɣǰݶֻ7λͿԱ֤ʼղ0x7F
	 * 3. ַҪת תб 0x7E 0x7E 0x01 0x00 0x7E 0x02
	 *
	 * һݣ {0x8E, 0x99, 0x80, 0x12, 0x13, 0x34, 0x45, 0x56, 0x78}
	 * Data {0x7E, 0x01, 0x19, 0x7E, 0x02, 0x12, 0x13, 0x34, 0x45, 0x03,
	 * 0x56, 0x78 ,0x7E, 0x02}
	 *
	 * @param data_in
	 * @return
	 */
	byte[] transfer(byte[] data_in) {
		int len_in = data_in.length;
		byte[] data_out = new byte[len_in * 2];
		int i, j = 0, k, left;
		byte tmp;

		for (i = 0; i < len_in; i++) {
			tmp = (byte) (data_in[i] & 0x7F);
			if (tmp == 0x7E) {
				data_out[j++] = 0x7E;
				data_out[j++] = 0x01;
			} else if (tmp == 0) {
				data_out[j++] = 0x7E;
				data_out[j++] = 0x02;
			} else {
				data_out[j++] = tmp;
			}
			if (((i % 7) == 6)) {
				tmp = 0;
				left = i - 6;
				for (k = 0; k < 7; k++) {
					tmp += ((data_in[left + k] & 0x80) >> (7 - k));
				}
				if (tmp == 0x7E) {
					data_out[j++] = 0x7E;
					data_out[j++] = 0x01;
				} else if (tmp == 0) {
					data_out[j++] = 0x7E;
					data_out[j++] = 0x02;
				} else {
					data_out[j++] = tmp;
				}
			} else if (i == len_in - 1) {
				tmp = 0;
				left = (len_in % 7);
				for (k = 0; k < left; k++) {
					tmp += ((data_in[len_in - left + k] & 0x80) >> (7 - k));
				}
				if (tmp == 0x7E) {
					data_out[j++] = 0x7E;
					data_out[j++] = 0x01;
				} else if (tmp == 0) {
					data_out[j++] = 0x7E;
					data_out[j++] = 0x02;
				} else {
					data_out[j++] = tmp;
				}
			}
		}
		byte[] result = new byte[j];
		for (i = 0; i < j; i++) {
			result[i] = data_out[i];
		}
		return result;
	}

	public static byte[] hexStringToBytes(String hexString) {
		if (hexString == null || hexString.equals("")) {
			return null;
		}
		// hexString = hexString.toUpperCase();
		int length = hexString.length() / 2;
		char[] hexChars = hexString.toCharArray();
		byte[] d = new byte[length];
		for (int i = 0; i < length; i++) {
			int pos = i * 2;
			d[i] = (byte) (charToByte(hexChars[pos]) << 4 | charToByte(hexChars[pos + 1]));
		}
		return d;
	}

	/**
	 * Convert char to byte
	 *
	 * @param c
	 *            char
	 * @return byte
	 */
	public static byte charToByte(char c) {
		return (byte) "0123456789ABCDEF".indexOf(c);
	}

	final protected static char[] hexArray = "0123456789ABCDEF".toCharArray();

	public static String bytesToHex(byte[] bytes) {
		char[] hexChars = new char[bytes.length * 2];
		for (int j = 0; j < bytes.length; j++) {
			int v = bytes[j] & 0xFF;
			hexChars[j * 2] = hexArray[v >>> 4];
			hexChars[j * 2 + 1] = hexArray[v & 0x0F];
		}
		return new String(hexChars);
	}
}
