/*
 * Decompiled with CFR 0.152.
 */
package io.fogcloud.sdk.easylink.helper;

public class RC4 {
    private final byte[] S = new byte[256];
    private final byte[] T = new byte[256];
    private final int keylen;

    public RC4(byte[] key) {
        if (key.length < 1 || key.length > 256) {
            throw new IllegalArgumentException("key must be between 1 and 256 bytes");
        }
        this.keylen = key.length;
        for (int i = 0; i < 256; ++i) {
            this.S[i] = (byte)i;
            this.T[i] = key[i % this.keylen];
        }
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            j = j + this.S[i] + this.T[i] & 0xFF;
            byte tmp = this.S[j];
            this.S[j] = this.S[i];
            this.S[i] = tmp;
        }
    }

    public byte[] encrypt(byte[] plaintext) {
        byte[] ciphertext = new byte[plaintext.length];
        int i = 0;
        int j = 0;
        for (int counter = 0; counter < plaintext.length; ++counter) {
            i = i + 1 & 0xFF;
            j = j + this.S[i] & 0xFF;
            byte tmp = this.S[j];
            this.S[j] = this.S[i];
            this.S[i] = tmp;
            int t = this.S[i] + this.S[j] & 0xFF;
            byte k = this.S[t];
            ciphertext[counter] = (byte)(plaintext[counter] ^ k);
        }
        return ciphertext;
    }

    public byte[] decrypt(byte[] ciphertext) {
        return this.encrypt(ciphertext);
    }
}

