/*
 * Decompiled with CFR 0.152.
 */
package io.fogcloud.sdk.easylink.plus;

import io.fogcloud.sdk.easylink.helper.ComHelper;
import io.fogcloud.sdk.easylink.helper.SinRC4;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class EasyLink_v3 {
    private static int START_FLAG1 = 1450;
    private static int START_FLAG2 = 1451;
    private static int START_FLAG3 = 1452;
    private static int UDP_START_PORT = 50000;
    private static boolean stopSending;
    private byte[] key = new byte[65];
    private byte[] ssid = new byte[65];
    private byte[] user_info = new byte[65];
    private boolean issendip = false;
    private static byte[] send_data;
    private static byte[] buffer;
    private static int len;
    private InetAddress address = null;
    private DatagramPacket send_packet = null;
    private int port = 0;
    private static EasyLink_v3 e3;
    private boolean small_mtu;

    private EasyLink_v3() {
        stopSending = false;
    }

    public static EasyLink_v3 getInstence() {
        if (e3 == null) {
            e3 = new EasyLink_v3();
        }
        return e3;
    }

    public void transmitSettings(byte[] Ssid, byte[] Key, byte[] Userinfo, String rc4key, final int sleeptime) {
        try {
            this.address = InetAddress.getByName("255.255.255.255");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ComHelper.checkPara(rc4key)) {
            this.ssid = SinRC4.encry_RC4_byte(Ssid, rc4key);
            this.key = SinRC4.encry_RC4_byte(Key, rc4key);
            if (null != Userinfo) {
                this.issendip = true;
                this.user_info = SinRC4.encry_RC4_byte(Userinfo, rc4key);
            }
        } else {
            this.ssid = Ssid;
            this.key = Key;
            if (null != Userinfo) {
                this.issendip = true;
                this.user_info = Userinfo;
            }
        }
        int i = 0;
        int checksum = 0;
        EasyLink_v3.send_data[i++] = (byte)(3 + this.ssid.length + this.key.length + (this.issendip ? this.user_info.length : 0) + 2);
        EasyLink_v3.send_data[i++] = (byte)this.ssid.length;
        EasyLink_v3.send_data[i++] = (byte)this.key.length;
        int j = 0;
        while (j < this.ssid.length) {
            EasyLink_v3.send_data[i] = this.ssid[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < this.key.length) {
            EasyLink_v3.send_data[i] = this.key[j];
            ++j;
            ++i;
        }
        if (this.issendip) {
            j = 0;
            while (j < this.user_info.length) {
                EasyLink_v3.send_data[i] = this.user_info[j];
                ++j;
                ++i;
            }
        }
        for (j = 0; j < i; ++j) {
            checksum = (short)(checksum + (send_data[j] & 0xFF));
        }
        EasyLink_v3.send_data[i++] = (byte)((checksum & 0xFFFF) >> 8);
        EasyLink_v3.send_data[i++] = (byte)(checksum & 0xFF);
        new Thread(new Runnable(){

            @Override
            public void run() {
                stopSending = false;
                EasyLink_v3.this.send(sleeptime);
            }
        }).start();
    }

    private void send(int sleeptime) {
        while (!stopSending) {
            try {
                this.port = UDP_START_PORT;
                int k = 0;
                this.UDP_SEND(START_FLAG1, sleeptime);
                this.UDP_SEND(START_FLAG2, sleeptime);
                this.UDP_SEND(START_FLAG3, sleeptime);
                int j = 1;
                for (int i = 0; i < send_data[0]; ++i) {
                    len = j * 256 + (send_data[i] & 0xFF);
                    this.UDP_SEND(len, sleeptime);
                    if (i % 4 == 3) {
                        len = 1280 + ++k;
                        this.UDP_SEND(len, sleeptime);
                    }
                    if (++j != 5) continue;
                    j = 1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void SetSmallMTU(boolean onoff) {
        this.small_mtu = onoff;
    }

    private void UDP_SEND(int length, int sleeptime) {
        try {
            Thread.sleep(sleeptime);
            DatagramSocket udpSocket = new DatagramSocket();
            udpSocket.setBroadcast(true);
            if (this.small_mtu) {
                if (length > 1280) {
                    length -= 1280;
                }
                if (length < 64) {
                    length += 176;
                }
            }
            this.send_packet = new DatagramPacket(buffer, length, this.address, this.port);
            udpSocket.send(this.send_packet);
            udpSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopTransmitting() {
        stopSending = true;
    }

    static {
        send_data = new byte[128];
        buffer = new byte[1500];
    }
}

