/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation.readers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.core.reflection.AnnotationData;
import org.boon.core.reflection.Annotations;
import org.boon.validation.ValidatorMetaData;
import org.boon.validation.ValidatorMetaDataReader;

public class AnnotationValidatorMetaDataReader
implements ValidatorMetaDataReader,
Serializable {
    private Map<String, List<ValidatorMetaData>> metaDataCache = new ConcurrentHashMap<String, List<ValidatorMetaData>>();
    private Set<String> validationAnnotationPackages = new HashSet<String>();

    public AnnotationValidatorMetaDataReader() {
        this.validationAnnotationPackages.add("org.boon.validation.annotations");
    }

    @Override
    public List<ValidatorMetaData> readMetaData(Class<?> clazz, String propertyName) {
        String propertyKey = clazz.getName() + "." + propertyName;
        List<ValidatorMetaData> validatorMetaDataList = this.metaDataCache.get(propertyKey);
        if (validatorMetaDataList == null) {
            validatorMetaDataList = this.extractValidatorMetaData(clazz, propertyName, validatorMetaDataList);
            this.metaDataCache.put(propertyKey, validatorMetaDataList);
        }
        return validatorMetaDataList;
    }

    private List<ValidatorMetaData> extractValidatorMetaData(Class<?> clazz, String propertyName, List<ValidatorMetaData> validatorMetaDataList) {
        if (validatorMetaDataList == null) {
            Collection<AnnotationData> annotations = Annotations.getAnnotationDataForFieldAndProperty(clazz, propertyName, this.validationAnnotationPackages);
            validatorMetaDataList = this.extractMetaDataFromAnnotations(annotations);
        }
        return validatorMetaDataList;
    }

    private List<ValidatorMetaData> extractMetaDataFromAnnotations(Collection<AnnotationData> annotations) {
        ArrayList<ValidatorMetaData> list = new ArrayList<ValidatorMetaData>();
        for (AnnotationData annotationData : annotations) {
            ValidatorMetaData validatorMetaData = this.convertAnnotationDataToValidatorMetaData(annotationData);
            list.add(validatorMetaData);
        }
        return list;
    }

    private ValidatorMetaData convertAnnotationDataToValidatorMetaData(AnnotationData annotationData) {
        ValidatorMetaData metaData = new ValidatorMetaData();
        metaData.setName(annotationData.getName());
        metaData.setProperties(annotationData.getValues());
        return metaData;
    }

    public void setValidationAnnotationPackages(Set<String> validationAnnotationPackages) {
        this.validationAnnotationPackages = validationAnnotationPackages;
    }
}

