/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.IO;
import org.boon.core.Typ;
import org.boon.core.Value;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.json.JsonParserAndMapper;
import org.boon.json.JsonParserFactory;
import org.boon.json.implementation.BaseJsonParserAndMapper;
import org.boon.json.implementation.JsonFastParser;
import org.boon.json.implementation.JsonParserLax;
import org.boon.primitive.CharBuf;

public class JsonMappingParser
implements JsonParserAndMapper {
    private final JsonParserAndMapper objectParser;
    private final JsonParserAndMapper basicParser;
    private final JsonParserAndMapper largeFileParser;
    private final FieldsAccessor fields;
    private final Charset charset;
    private CharBuf charBuf;
    private int bufSize = 32;

    public JsonMappingParser(FieldsAccessor fields, Charset charset, boolean lax, boolean chop, boolean lazyChop) {
        this.charset = charset;
        this.fields = fields;
        if (lax) {
            this.basicParser = new BaseJsonParserAndMapper(new JsonParserLax(false, chop, lazyChop), fields);
            this.objectParser = new BaseJsonParserAndMapper(new JsonParserLax(true), fields);
        } else {
            this.basicParser = new BaseJsonParserAndMapper(new JsonFastParser(false, chop, lazyChop), fields);
            this.objectParser = new BaseJsonParserAndMapper(new JsonFastParser(true), fields);
        }
        ((BaseJsonParserAndMapper)this.basicParser).setCharset(charset);
        ((BaseJsonParserAndMapper)this.objectParser).setCharset(charset);
        this.largeFileParser = new JsonParserFactory().createCharacterSourceParser();
    }

    @Override
    public Map<String, Object> parseMap(String value) {
        return this.basicParser.parseMap(value);
    }

    @Override
    public Map<String, Object> parseMap(char[] value) {
        return this.basicParser.parseMap(value);
    }

    @Override
    public Map<String, Object> parseMap(byte[] value) {
        return this.basicParser.parseMap(value);
    }

    @Override
    public Map<String, Object> parseMap(byte[] value, Charset charset) {
        return this.basicParser.parseMap(value, charset);
    }

    @Override
    public Map<String, Object> parseMap(InputStream value, Charset charset) {
        return this.basicParser.parseMap(value, charset);
    }

    @Override
    public Map<String, Object> parseMap(CharSequence value) {
        return this.basicParser.parseMap(value);
    }

    @Override
    public Map<String, Object> parseMap(InputStream value) {
        return this.basicParser.parseMap(value);
    }

    @Override
    public Map<String, Object> parseMap(Reader value) {
        return this.basicParser.parseMap(value);
    }

    @Override
    public Map<String, Object> parseMapFromFile(String file) {
        return (Map)this.parseFile(file);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, String jsonString) {
        return this.objectParser.parseList(componentType, jsonString);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, InputStream input) {
        return this.objectParser.parseList(componentType, input);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, Reader reader) {
        return this.objectParser.parseList(componentType, reader);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, InputStream input, Charset charset) {
        return this.objectParser.parseList(componentType, input, charset);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, byte[] jsonBytes) {
        return this.objectParser.parseList(componentType, jsonBytes);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, byte[] jsonBytes, Charset charset) {
        return this.objectParser.parseList(componentType, jsonBytes, charset);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, char[] chars) {
        return this.objectParser.parseList(componentType, chars);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, CharSequence jsonSeq) {
        return this.objectParser.parseList(componentType, jsonSeq);
    }

    @Override
    public <T> List<T> parseListFromFile(Class<T> componentType, String fileName) {
        return this.objectParser.parseListFromFile(componentType, fileName);
    }

    @Override
    public final <T> T parse(Class<T> type, String value) {
        if (Typ.isBasicTypeOrCollection(type)) {
            T obj = this.basicParser.parse(type, value);
            return obj;
        }
        Map objectMap = this.objectParser.parse(Map.class, value);
        return (T)MapObjectConversion.fromValueMap(this.fields, (Map<String, Value>)objectMap, type);
    }

    @Override
    public final <T> T parse(Class<T> type, byte[] value) {
        if (type == Object.class || type == Map.class || type == List.class || Typ.isBasicType(type)) {
            if (value.length < 100000) {
                return this.basicParser.parse(type, value);
            }
            return this.basicParser.parseAsStream(type, value);
        }
        Map objectMap = this.objectParser.parse(Map.class, value);
        return (T)MapObjectConversion.fromValueMap(this.fields, (Map<String, Value>)objectMap, type);
    }

    @Override
    public final <T> T parse(Class<T> type, byte[] value, Charset charset) {
        if (type == Object.class || type == Map.class || type == List.class || Typ.isBasicType(type)) {
            return this.basicParser.parse(type, value, charset);
        }
        Map objectMap = this.objectParser.parse(Map.class, value);
        return (T)MapObjectConversion.fromValueMap(this.fields, (Map<String, Value>)objectMap, type);
    }

    @Override
    public final <T> T parse(Class<T> type, CharSequence value) {
        if (type == Object.class || type == Map.class || type == List.class || Typ.isBasicType(type)) {
            return this.basicParser.parse(type, value);
        }
        Map objectMap = this.objectParser.parse(Map.class, value);
        return (T)MapObjectConversion.fromValueMap(this.fields, (Map<String, Value>)objectMap, type);
    }

    @Override
    public final <T> T parse(Class<T> type, char[] value) {
        if (type == Object.class || type == Map.class || type == List.class || Typ.isBasicType(type)) {
            return this.basicParser.parse(type, value);
        }
        Map objectMap = this.objectParser.parse(Map.class, value);
        return (T)MapObjectConversion.fromValueMap(this.fields, (Map<String, Value>)objectMap, type);
    }

    @Override
    public final <T> T parse(Class<T> type, Reader reader) {
        this.charBuf = IO.read(reader, this.charBuf, this.bufSize);
        return this.parse(type, this.charBuf.readForRecycle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T parseFile(Class<T> type, String fileName) {
        int bufSize = this.bufSize;
        try {
            Path filePath = IO.path(fileName);
            long size = Files.size(filePath);
            if (size > 10000000L) {
                T t = this.largeFileParser.parseFile(type, fileName);
                return t;
            }
            size = size > 2000000L ? (long)bufSize : size;
            this.bufSize = (int)size;
            if (size < 1000000L) {
                T t = this.parse(type, Files.newInputStream(filePath, new OpenOption[0]), this.charset);
                return t;
            }
            T t = this.parse(type, Files.newBufferedReader(filePath, this.charset));
            return t;
        }
        catch (IOException ex) {
            T t = Exceptions.handle(type, fileName, ex);
            return t;
        }
        finally {
            this.bufSize = bufSize;
        }
    }

    @Override
    public int parseInt(String jsonString) {
        return this.basicParser.parseInt(jsonString);
    }

    @Override
    public int parseInt(InputStream input) {
        return this.basicParser.parseInt(input);
    }

    @Override
    public int parseInt(InputStream input, Charset charset) {
        return this.basicParser.parseInt(input, charset);
    }

    @Override
    public int parseInt(byte[] jsonBytes) {
        return this.basicParser.parseInt(jsonBytes);
    }

    @Override
    public int parseInt(byte[] jsonBytes, Charset charset) {
        return this.basicParser.parseInt(jsonBytes, charset);
    }

    @Override
    public int parseInt(char[] chars) {
        return this.basicParser.parseInt(chars);
    }

    @Override
    public int parseInt(CharSequence jsonSeq) {
        return this.basicParser.parseInt(jsonSeq);
    }

    @Override
    public int parseIntFromFile(String fileName) {
        return this.basicParser.parseIntFromFile(fileName);
    }

    @Override
    public long parseLong(String jsonString) {
        return this.basicParser.parseLong(jsonString);
    }

    @Override
    public long parseLong(InputStream input) {
        return this.basicParser.parseLong(input);
    }

    @Override
    public long parseLong(InputStream input, Charset charset) {
        return this.basicParser.parseLong(input, charset);
    }

    @Override
    public long parseLong(byte[] jsonBytes) {
        return this.basicParser.parseLong(jsonBytes);
    }

    @Override
    public long parseLong(byte[] jsonBytes, Charset charset) {
        return this.basicParser.parseLong(jsonBytes, charset);
    }

    @Override
    public long parseLong(char[] chars) {
        return this.basicParser.parseLong(chars);
    }

    @Override
    public long parseLong(CharSequence jsonSeq) {
        return this.basicParser.parseLong(jsonSeq);
    }

    @Override
    public long parseLongFromFile(String fileName) {
        return this.basicParser.parseLongFromFile(fileName);
    }

    @Override
    public String parseString(String value) {
        return this.basicParser.parseString(value);
    }

    @Override
    public String parseString(InputStream value) {
        return this.basicParser.parseString(value);
    }

    @Override
    public String parseString(InputStream value, Charset charset) {
        return this.basicParser.parseString(value, charset);
    }

    @Override
    public String parseString(byte[] value) {
        return this.basicParser.parseString(value);
    }

    @Override
    public String parseString(byte[] value, Charset charset) {
        return this.basicParser.parseString(value, charset);
    }

    @Override
    public String parseString(char[] value) {
        return this.basicParser.parseString(value);
    }

    @Override
    public String parseString(CharSequence value) {
        return this.basicParser.parseString(value);
    }

    @Override
    public String parseStringFromFile(String value) {
        return this.basicParser.parseStringFromFile(value);
    }

    @Override
    public double parseDouble(String value) {
        return this.basicParser.parseDouble(value);
    }

    @Override
    public double parseDouble(InputStream value) {
        return this.basicParser.parseDouble(value);
    }

    @Override
    public double parseDouble(byte[] value) {
        return this.basicParser.parseDouble(value);
    }

    @Override
    public double parseDouble(char[] value) {
        return this.basicParser.parseDouble(value);
    }

    @Override
    public double parseDouble(CharSequence value) {
        return this.basicParser.parseDouble(value);
    }

    @Override
    public double parseDouble(byte[] value, Charset charset) {
        return this.basicParser.parseDouble(value, charset);
    }

    @Override
    public double parseDouble(InputStream value, Charset charset) {
        return this.basicParser.parseDouble(value, charset);
    }

    @Override
    public double parseDoubleFromFile(String fileName) {
        return this.basicParser.parseDoubleFromFile(fileName);
    }

    @Override
    public float parseFloat(String value) {
        return this.basicParser.parseFloat(value);
    }

    @Override
    public float parseFloat(InputStream value) {
        return this.basicParser.parseFloat(value);
    }

    @Override
    public float parseFloat(byte[] value) {
        return this.basicParser.parseFloat(value);
    }

    @Override
    public float parseFloat(char[] value) {
        return this.basicParser.parseFloat(value);
    }

    @Override
    public float parseFloat(CharSequence value) {
        return this.basicParser.parseFloat(value);
    }

    @Override
    public float parseFloat(byte[] value, Charset charset) {
        return this.basicParser.parseFloat(value, charset);
    }

    @Override
    public float parseFloat(InputStream value, Charset charset) {
        return this.basicParser.parseFloat(value, charset);
    }

    @Override
    public float parseFloatFromFile(String fileName) {
        return this.basicParser.parseFloatFromFile(fileName);
    }

    @Override
    public BigDecimal parseBigDecimal(String value) {
        return this.basicParser.parseBigDecimal(value);
    }

    @Override
    public BigDecimal parseBigDecimal(InputStream value) {
        return this.basicParser.parseBigDecimal(value);
    }

    @Override
    public BigDecimal parseBigDecimal(byte[] value) {
        return this.basicParser.parseBigDecimal(value);
    }

    @Override
    public BigDecimal parseBigDecimal(char[] value) {
        return this.basicParser.parseBigDecimal(value);
    }

    @Override
    public BigDecimal parseBigDecimal(CharSequence value) {
        return this.basicParser.parseBigDecimal(value);
    }

    @Override
    public BigDecimal parseBigDecimal(byte[] value, Charset charset) {
        return this.basicParser.parseBigDecimal(value, charset);
    }

    @Override
    public BigDecimal parseBigDecimal(InputStream value, Charset charset) {
        return this.basicParser.parseBigDecimal(value, charset);
    }

    @Override
    public BigDecimal parseBigDecimalFromFile(String fileName) {
        return this.basicParser.parseBigDecimalFromFile(fileName);
    }

    @Override
    public BigInteger parseBigInteger(String value) {
        return this.basicParser.parseBigInteger(value);
    }

    @Override
    public BigInteger parseBigInteger(InputStream value) {
        return this.basicParser.parseBigInteger(value);
    }

    @Override
    public BigInteger parseBigInteger(byte[] value) {
        return this.basicParser.parseBigInteger(value);
    }

    @Override
    public BigInteger parseBigInteger(char[] value) {
        return this.basicParser.parseBigInteger(value);
    }

    @Override
    public BigInteger parseBigInteger(CharSequence value) {
        return this.basicParser.parseBigInteger(value);
    }

    @Override
    public BigInteger parseBigInteger(byte[] value, Charset charset) {
        return this.basicParser.parseBigInteger(value, charset);
    }

    @Override
    public BigInteger parseBigInteger(InputStream value, Charset charset) {
        return this.basicParser.parseBigInteger(value, charset);
    }

    @Override
    public BigInteger parseBigIntegerFile(String fileName) {
        return this.basicParser.parseBigIntegerFile(fileName);
    }

    @Override
    public Date parseDate(String jsonString) {
        return this.basicParser.parseDate(jsonString);
    }

    @Override
    public Date parseDate(InputStream input) {
        return this.basicParser.parseDate(input);
    }

    @Override
    public Date parseDate(InputStream input, Charset charset) {
        return this.basicParser.parseDate(input, charset);
    }

    @Override
    public Date parseDate(byte[] jsonBytes) {
        return this.basicParser.parseDate(jsonBytes);
    }

    @Override
    public Date parseDate(byte[] jsonBytes, Charset charset) {
        return this.basicParser.parseDate(jsonBytes, charset);
    }

    @Override
    public Date parseDate(char[] chars) {
        return this.basicParser.parseDate(chars);
    }

    @Override
    public Date parseDate(CharSequence jsonSeq) {
        return this.basicParser.parseDate(jsonSeq);
    }

    @Override
    public Date parseDateFromFile(String fileName) {
        return this.basicParser.parseDateFromFile(fileName);
    }

    @Override
    public short parseShort(String jsonString) {
        return this.basicParser.parseShort(jsonString);
    }

    @Override
    public byte parseByte(String jsonString) {
        return this.basicParser.parseByte(jsonString);
    }

    @Override
    public char parseChar(String jsonString) {
        return this.basicParser.parseChar(jsonString);
    }

    @Override
    public <T extends Enum> T parseEnum(Class<T> type, String jsonString) {
        return this.basicParser.parseEnum(type, jsonString);
    }

    @Override
    public char[] parseCharArray(String jsonString) {
        return this.basicParser.parseCharArray(jsonString);
    }

    @Override
    public byte[] parseByteArray(String jsonString) {
        return this.basicParser.parseByteArray(jsonString);
    }

    @Override
    public short[] parseShortArray(String jsonString) {
        return this.basicParser.parseShortArray(jsonString);
    }

    @Override
    public int[] parseIntArray(String jsonString) {
        return this.basicParser.parseIntArray(jsonString);
    }

    @Override
    public float[] parseFloatArray(String jsonString) {
        return this.basicParser.parseFloatArray(jsonString);
    }

    @Override
    public double[] parseDoubleArray(String jsonString) {
        return this.basicParser.parseDoubleArray(jsonString);
    }

    @Override
    public long[] parseLongArray(String jsonString) {
        return this.basicParser.parseLongArray(jsonString);
    }

    @Override
    public Object parse(String jsonString) {
        return this.basicParser.parse(jsonString);
    }

    @Override
    public Object parse(byte[] bytes) {
        return this.basicParser.parse(bytes);
    }

    @Override
    public Object parse(byte[] bytes, Charset charset) {
        return this.basicParser.parse(bytes, charset);
    }

    @Override
    public Object parse(CharSequence charSequence) {
        return this.basicParser.parse(charSequence);
    }

    @Override
    public Object parse(char[] chars) {
        return this.basicParser.parse(chars);
    }

    @Override
    public Object parse(Reader reader) {
        return this.basicParser.parse(reader);
    }

    @Override
    public Object parse(InputStream input) {
        return this.basicParser.parse(input);
    }

    @Override
    public Object parse(InputStream input, Charset charset) {
        return this.basicParser.parse(input, charset);
    }

    @Override
    public Object parseDirect(byte[] value) {
        if (value.length < 20000 && this.charset == StandardCharsets.UTF_8) {
            CharBuf builder = CharBuf.createFromUTF8Bytes(value);
            return this.parse(builder.toCharArray());
        }
        return this.parse(new ByteArrayInputStream(value));
    }

    @Override
    public Object parseAsStream(byte[] value) {
        return this.basicParser.parseAsStream(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parseFile(String fileName) {
        int bufSize = this.bufSize;
        try {
            Path filePath = IO.path(fileName);
            long size = Files.size(filePath);
            if (size > 10000000L) {
                Object object = this.largeFileParser.parseFile(fileName);
                return object;
            }
            size = size > 2000000L ? (long)bufSize : size;
            this.bufSize = (int)size;
            if (size < 1000000L) {
                Object object = this.parse(Files.newInputStream(filePath, new OpenOption[0]), this.charset);
                return object;
            }
            Object object = this.parse(Files.newBufferedReader(filePath, this.charset));
            return object;
        }
        catch (IOException ex) {
            Object object = Exceptions.handle(Typ.object, fileName, ex);
            return object;
        }
        finally {
            this.bufSize = bufSize;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public final <T> T parse(Class<T> type, InputStream input) {
        this.charBuf = IO.read(input, this.charBuf, this.charset, this.bufSize);
        return this.parse(type, this.charBuf.readForRecycle());
    }

    @Override
    public final <T> T parse(Class<T> type, InputStream input, Charset charset) {
        this.charBuf = IO.read(input, this.charBuf, charset, this.bufSize);
        return this.parse(type, this.charBuf.readForRecycle());
    }

    @Override
    public final <T> T parseDirect(Class<T> type, byte[] value) {
        if (value.length < 20000 && this.charset == StandardCharsets.UTF_8) {
            CharBuf builder = CharBuf.createFromUTF8Bytes(value);
            return this.parse(type, builder.toCharArray());
        }
        return this.parse(type, new ByteArrayInputStream(value));
    }

    @Override
    public final <T> T parseAsStream(Class<T> type, byte[] value) {
        this.charBuf = IO.read(new InputStreamReader((InputStream)new ByteArrayInputStream(value), this.charset), this.charBuf, value.length);
        return this.basicParser.parse(type, this.charBuf.readForRecycle());
    }
}

