/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.core.Supplier;
import org.boon.di.Module;

public class InstanceModule
implements Module {
    private Map<Class, Supplier<Object>> supplierMap = new HashMap<Class, Supplier<Object>>();
    private Object module;

    public InstanceModule(Object object) {
        Method[] methods;
        this.module = object;
        for (Method method : methods = object.getClass().getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.getName().startsWith("provide")) continue;
            this.addCreationMethod(method);
        }
    }

    private void addCreationMethod(Method method) {
        Class<?>[] superTypes;
        Class<?> cls = method.getReturnType();
        Supplier<Object> supplier = this.createSupplier(method);
        this.supplierMap.put(cls, supplier);
        Class<?> superClass = cls.getSuperclass();
        for (Class<?> superType : superTypes = cls.getInterfaces()) {
            this.supplierMap.put(superType, supplier);
        }
        if (superClass != null) {
            while (superClass != Object.class) {
                this.supplierMap.put(superClass, supplier);
                for (Class<?> superType : superTypes = cls.getInterfaces()) {
                    this.supplierMap.put(superType, supplier);
                }
                superClass = cls.getSuperclass();
            }
        }
    }

    private Supplier<Object> createSupplier(final Method method) {
        method.setAccessible(true);
        return new Supplier<Object>(){

            @Override
            public Object get() {
                try {
                    return method.invoke(InstanceModule.this.module, new Object[0]);
                }
                catch (Exception e) {
                    return Exceptions.handle(Object.class, e);
                }
            }
        };
    }

    @Override
    public <T> T get(Class<T> type) {
        return (T)this.supplierMap.get(type).get();
    }

    @Override
    public boolean has(Class type) {
        return this.supplierMap.containsKey(type);
    }
}

