/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.di.Context;
import org.boon.di.Module;

public class ContextImpl
implements Context {
    private Set<Module> modules = new LinkedHashSet<Module>();

    public ContextImpl(Module ... modules) {
        for (Module module : modules) {
            this.modules.add(module);
        }
    }

    @Override
    public <T> T get(Class<T> type) {
        Object object = null;
        for (Module module : this.modules) {
            if (!module.has(type)) continue;
            object = module.get(type);
            break;
        }
        if (object != null) {
            Map<String, FieldAccess> fields = Reflection.getAllAccessorFields(object.getClass(), true);
            for (FieldAccess field : fields.values()) {
                if (!field.hasAnnotation("Inject")) continue;
                field.setObject(object, this.get(field.getType()));
            }
        }
        return (T)object;
    }
}

