/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di;

import java.util.HashMap;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.core.reflection.Reflection;
import org.boon.di.Module;

public class ClassListModule
implements Module {
    Map<Class, Class> classes = new HashMap<Class, Class>();

    public ClassListModule(Class ... classes) {
        for (Class cls : classes) {
            Class<?>[] superTypes;
            this.classes.put(cls, cls);
            Class superClass = cls.getSuperclass();
            for (Class<?> superType : superTypes = cls.getInterfaces()) {
                this.classes.put(superType, cls);
            }
            while (superClass != Object.class) {
                this.classes.put(superClass, cls);
                for (Class<?> superType : superTypes = cls.getInterfaces()) {
                    this.classes.put(superType, cls);
                }
                superClass = cls.getSuperclass();
            }
        }
    }

    @Override
    public <T> T get(Class<T> type) {
        try {
            return Reflection.newInstance(this.classes.get(type));
        }
        catch (Exception e) {
            Exceptions.handle(e);
            return null;
        }
    }

    @Override
    public boolean has(Class type) {
        return this.classes.containsKey(type);
    }
}

