/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl;

import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.boon.Str;
import org.boon.core.Function;
import org.boon.core.Supplier;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.datarepo.Filter;
import org.boon.datarepo.LookupIndex;
import org.boon.datarepo.ObjectEditor;
import org.boon.datarepo.Repo;
import org.boon.datarepo.RepoBuilder;
import org.boon.datarepo.SearchableCollection;
import org.boon.datarepo.impl.decorators.FilterWithSimpleCache;
import org.boon.datarepo.impl.decorators.ObjectEditorCloneDecorator;
import org.boon.datarepo.impl.decorators.ObjectEditorEventDecorator;
import org.boon.datarepo.impl.decorators.ObjectEditorLogNullCheckDecorator;
import org.boon.datarepo.impl.indexes.NestedKeySearchIndex;
import org.boon.datarepo.impl.indexes.TypeHierarchyIndex;
import org.boon.datarepo.modification.ModificationListener;
import org.boon.datarepo.spi.ObjectEditorComposer;
import org.boon.datarepo.spi.RepoComposer;
import org.boon.datarepo.spi.SPIFactory;
import org.boon.datarepo.spi.SearchIndex;
import org.boon.datarepo.spi.SearchableCollectionComposer;
import org.boon.predicates.PropertyNameUtils;

public class RepoBuilderDefault
implements RepoBuilder {
    Function<Class, SearchIndex> searchIndexFactory;
    Function<Class, LookupIndex> lookupIndexFactory;
    Function<Class, LookupIndex> uniqueLookupIndexFactory;
    Function<Class, SearchIndex> uniqueSearchIndexFactory;
    Supplier<ObjectEditorComposer> objectEditorFactory;
    Supplier<SearchableCollectionComposer> searchableCollectionFactory;
    Supplier<RepoComposer> repoComposerFactory;
    Supplier<Filter> filterFactory;
    String primaryKey;
    Set<String> searchIndexes = new HashSet<String>();
    Set<String> lookupIndexes = new HashSet<String>();
    Set<String> uniqueSearchIndexes = new HashSet<String>();
    Set<String> uniqueLookupIndexes = new HashSet<String>();
    Map<String, Function> keyGetterMap = new HashMap<String, Function>();
    boolean useField = true;
    boolean useUnSafe = false;
    boolean nullChecksAndLogging;
    boolean cloneEdits;
    boolean storeKeyInIndexOnly;
    boolean debug;
    Level level = Level.FINER;
    private Map<String, FieldAccess> fields;
    private RepoComposer repo;
    private ObjectEditor editor;
    private SearchableCollectionComposer query;
    private boolean cache = false;
    private Map<String, Comparator> collators = new HashMap<String, Comparator>();
    private Map<String, Function> keyTransformers = new HashMap<String, Function>();
    private Map<String, String[]> nestedIndexes = new HashMap<String, String[]>();
    private boolean indexHierarchy;
    private Map<String, Integer> indexBucketSize = new HashMap<String, Integer>();
    private boolean hashCodeOptimizationOn;
    private boolean removeDuplication;
    boolean events = false;
    ModificationListener[] listeners;

    @Override
    public RepoBuilder usePropertyForAccess(boolean useProperty) {
        this.useField = !useProperty;
        return this;
    }

    @Override
    public RepoBuilder useFieldForAccess(boolean useField) {
        this.useField = useField;
        return this;
    }

    @Override
    public RepoBuilder useUnsafe(boolean useUnSafe) {
        this.useUnSafe = useUnSafe;
        return this;
    }

    @Override
    public RepoBuilder nullChecks(boolean nullChecks) {
        this.nullChecksAndLogging = nullChecks;
        return this;
    }

    @Override
    public RepoBuilder addLogging(boolean logging) {
        this.nullChecksAndLogging = logging;
        return this;
    }

    @Override
    public RepoBuilder cloneEdits(boolean cloneEdits) {
        this.cloneEdits = cloneEdits;
        return this;
    }

    @Override
    public RepoBuilder useCache() {
        this.cache = true;
        return this;
    }

    @Override
    public RepoBuilder storeKeyInIndexOnly() {
        this.storeKeyInIndexOnly = true;
        return this;
    }

    @Override
    public RepoBuilder events(ModificationListener ... listeners) {
        this.events = true;
        this.listeners = listeners;
        return this;
    }

    @Override
    public RepoBuilder debug() {
        this.debug = true;
        return this;
    }

    @Override
    public RepoBuilder searchIndexFactory(Function<Class, SearchIndex> factory) {
        this.searchIndexFactory = factory;
        return this;
    }

    @Override
    public RepoBuilder uniqueLookupIndexFactory(Function<Class, LookupIndex> factory) {
        this.uniqueLookupIndexFactory = factory;
        return this;
    }

    @Override
    public RepoBuilder uniqueSearchIndexFactory(Function<Class, SearchIndex> factory) {
        this.uniqueSearchIndexFactory = factory;
        return this;
    }

    @Override
    public RepoBuilder lookupIndexFactory(Function<Class, LookupIndex> factory) {
        this.lookupIndexFactory = factory;
        return this;
    }

    @Override
    public RepoBuilder repoFactory(Supplier<RepoComposer> factory) {
        this.repoComposerFactory = factory;
        return this;
    }

    @Override
    public RepoBuilder filterFactory(Supplier<Filter> factory) {
        this.filterFactory = factory;
        return this;
    }

    @Override
    public RepoBuilder primaryKey(String propertyName) {
        this.primaryKey = propertyName;
        return this;
    }

    @Override
    public RepoBuilder lookupIndex(String propertyName) {
        this.lookupIndexes.add(propertyName);
        return this;
    }

    @Override
    public RepoBuilder uniqueLookupIndex(String propertyName) {
        return this.lookupIndex(propertyName, true);
    }

    public RepoBuilder lookupIndex(String propertyName, boolean unique) {
        if (unique) {
            this.lookupIndexes.add(propertyName);
        } else {
            this.uniqueLookupIndexes.add(propertyName);
        }
        return this;
    }

    @Override
    public RepoBuilder searchIndex(String propertyName) {
        this.searchIndexes.add(propertyName);
        return this;
    }

    @Override
    public RepoBuilder uniqueSearchIndex(String propertyName) {
        return this.searchIndex(propertyName, true);
    }

    @Override
    public RepoBuilder collateIndex(String propertyName) {
        this.collators.put(propertyName, Collator.getInstance());
        return this;
    }

    @Override
    public RepoBuilder collateIndex(String propertyName, Locale locale) {
        this.collators.put(propertyName, Collator.getInstance(locale));
        return this;
    }

    @Override
    public RepoBuilder collateIndex(String propertyName, Comparator collator) {
        this.collators.put(propertyName, collator);
        return this;
    }

    public RepoBuilder searchIndex(String propertyName, boolean unique) {
        if (unique) {
            this.searchIndexes.add(propertyName);
        } else {
            this.uniqueSearchIndexes.add(propertyName);
        }
        return this;
    }

    @Override
    public RepoBuilder keyGetter(String propertyName, Function<?, ?> keyGetter) {
        this.keyGetterMap.put(propertyName, keyGetter);
        return this;
    }

    private void initializeTheFactories() {
        if (this.repoComposerFactory == null) {
            this.repoComposerFactory = SPIFactory.getRepoFactory();
        }
        if (this.lookupIndexFactory == null) {
            this.lookupIndexFactory = SPIFactory.getLookupIndexFactory();
        }
        if (this.searchIndexFactory == null) {
            this.searchIndexFactory = SPIFactory.getSearchIndexFactory();
        }
        if (this.uniqueLookupIndexFactory == null) {
            this.uniqueLookupIndexFactory = SPIFactory.getUniqueLookupIndexFactory();
        }
        if (this.searchableCollectionFactory == null) {
            this.searchableCollectionFactory = SPIFactory.getSearchableCollectionFactory();
        }
        if (this.filterFactory == null) {
            this.filterFactory = SPIFactory.getFilterFactory();
        }
        if (this.objectEditorFactory == null) {
            this.objectEditorFactory = SPIFactory.getObjectEditorFactory();
        }
    }

    @Override
    public <KEY, ITEM> Repo<KEY, ITEM> build(Class<KEY> key, Class<ITEM> clazz, Class<?> ... classes) {
        return this.build((Class<?>)null, key, clazz, classes);
    }

    public <KEY, ITEM> Repo<KEY, ITEM> build(Class<?> primitiveKey, Class<KEY> key, Class<ITEM> clazz, Class<?> ... classes) {
        this.initializeTheFactories();
        this.loadFields(clazz, classes);
        this.repo = this.repoComposerFactory.get();
        this.editor = this.constructObjectEditor(this.fields);
        SearchableCollectionComposer query = this.constructSearchableCollection(primitiveKey, clazz, this.repo, this.fields);
        query.setRemoveDuplication(this.removeDuplication);
        this.repo.setSearchableCollection((SearchableCollection)((Object)query));
        ((ObjectEditorComposer)((Object)this.editor)).setSearchableCollection((SearchableCollection)((Object)query));
        this.editor = this.decorateEditor(this.editor);
        this.repo.setObjectEditor(this.editor);
        return (Repo)((Object)this.repo);
    }

    private <ITEM> void loadFields(Class<ITEM> clazz, Class<?>[] classes) {
        this.fields = BeanUtils.getPropertyFieldAccessMap(clazz);
        for (Class<?> cls : classes) {
            Map<String, FieldAccess> fieldsComponentType = BeanUtils.getPropertyFieldAccessMap(cls);
            for (String sKey : fieldsComponentType.keySet()) {
                if (this.fields.containsKey(sKey)) continue;
                this.fields.put(sKey, fieldsComponentType.get(sKey));
            }
        }
    }

    private SearchableCollectionComposer constructSearchableCollection(Class<?> primitiveKey, Class<?> itemClazz, RepoComposer repo, Map<String, FieldAccess> fields) {
        this.query = this.searchableCollectionFactory.get();
        Filter filter = this.filterFactory.get();
        this.configPrimaryKey(primitiveKey == null ? itemClazz : primitiveKey, fields);
        this.configIndexes(repo, fields);
        this.query.setFilter(filter);
        this.query.setFields(fields);
        this.query.init();
        if (this.cache) {
            filter = new FilterWithSimpleCache(filter);
        }
        this.query.setFilter(filter);
        return this.query;
    }

    private ObjectEditor constructObjectEditor(Map<String, FieldAccess> fields) {
        ObjectEditorComposer editorComposer = this.objectEditorFactory.get();
        if (this.hashCodeOptimizationOn) {
            editorComposer.hashCodeOptimizationOn();
        }
        ObjectEditor editor = (ObjectEditor)((Object)editorComposer);
        editorComposer.init();
        if (this.cloneEdits) {
            editorComposer.setLookupAndExcept(true);
        }
        editorComposer.setFields(fields);
        return editor;
    }

    private ObjectEditor decorateEditor(ObjectEditor editor) {
        if (this.debug || this.nullChecksAndLogging) {
            ObjectEditorLogNullCheckDecorator logNullCheckDecorator = new ObjectEditorLogNullCheckDecorator(editor);
            logNullCheckDecorator.setLevel(this.level);
            logNullCheckDecorator.setDebug(this.debug);
            editor = logNullCheckDecorator;
        }
        if (this.cloneEdits) {
            editor = new ObjectEditorCloneDecorator(editor);
        }
        if (this.events) {
            ObjectEditorEventDecorator eventManager = new ObjectEditorEventDecorator(editor);
            for (ModificationListener l : this.listeners) {
                eventManager.add(l);
            }
            editor = eventManager;
        }
        return editor;
    }

    @Override
    public RepoBuilder level(Level level) {
        this.level = level;
        return this;
    }

    @Override
    public RepoBuilder upperCaseIndex(String property) {
        this.keyTransformers.put(property, PropertyNameUtils.upperCase);
        return this;
    }

    @Override
    public RepoBuilder lowerCaseIndex(String property) {
        this.keyTransformers.put(property, PropertyNameUtils.lowerCase);
        return this;
    }

    @Override
    public RepoBuilder camelCaseIndex(String property) {
        this.keyTransformers.put(property, PropertyNameUtils.camelCase);
        return this;
    }

    @Override
    public RepoBuilder underBarCaseIndex(String property) {
        this.keyTransformers.put(property, PropertyNameUtils.underBarCase);
        return this;
    }

    @Override
    public RepoBuilder nestedIndex(String ... propertyPath) {
        this.nestedIndexes.put(Str.join('.', propertyPath), propertyPath);
        return this;
    }

    @Override
    public RepoBuilder indexHierarchy() {
        this.indexHierarchy = true;
        return this;
    }

    @Override
    public RepoBuilder indexBucketSize(String propertyName, int size) {
        this.indexBucketSize.put(propertyName, size);
        return this;
    }

    @Override
    public RepoBuilder hashCodeOptimizationOn() {
        this.hashCodeOptimizationOn = true;
        return this;
    }

    @Override
    public RepoBuilder removeDuplication(boolean removeDuplication) {
        this.removeDuplication = removeDuplication;
        return this;
    }

    private Function createKeyGetter(final FieldAccess field) {
        Objects.requireNonNull(field, "field cannot be null");
        return new Function(){

            public Object apply(Object o) {
                return field.getValue(o);
            }
        };
    }

    private void configIndexes(RepoComposer repo, Map<String, FieldAccess> fields) {
        LookupIndex index;
        FieldAccess fieldAccess;
        if (this.indexHierarchy) {
            TypeHierarchyIndex index2 = new TypeHierarchyIndex();
            index2.setComparator(this.collators.get("_type"));
            index2.setInputKeyTransformer(this.keyTransformers.get("_type"));
            index2.init();
            ((SearchableCollection)((Object)this.query)).addSearchIndex("_type", index2);
        }
        for (String prop : this.nestedIndexes.keySet()) {
            NestedKeySearchIndex index3 = new NestedKeySearchIndex(this.nestedIndexes.get(prop));
            this.configIndex(prop, index3);
        }
        for (String prop : this.searchIndexes) {
            fieldAccess = fields.get(prop);
            Objects.requireNonNull(fieldAccess, "Field access for property was null. " + prop);
            Class<?> type = fieldAccess.getType();
            SearchIndex searchIndex = this.searchIndexFactory.apply(type);
            this.configSearchIndex(fields, prop, searchIndex);
        }
        for (String prop : this.uniqueSearchIndexes) {
            fieldAccess = fields.get(prop);
            Objects.requireNonNull(fieldAccess, "Field access for property was null. " + prop);
            SearchIndex searchIndex = this.uniqueSearchIndexFactory.apply(fieldAccess.getType());
            this.configSearchIndex(fields, prop, searchIndex);
        }
        for (String prop : this.lookupIndexes) {
            fieldAccess = fields.get(prop);
            Objects.requireNonNull(fieldAccess, "Field access for property was null. " + prop);
            index = this.lookupIndexFactory.apply(fieldAccess.getType());
            this.configLookupIndex(fields, prop, index);
        }
        for (String prop : this.uniqueLookupIndexes) {
            fieldAccess = fields.get(prop);
            Objects.requireNonNull(fieldAccess, "Field access for property was null. " + prop);
            index = this.uniqueLookupIndexFactory.apply(fieldAccess.getType());
            this.configLookupIndex(fields, prop, index);
        }
    }

    private void configLookupIndex(Map<String, FieldAccess> fields, String prop, LookupIndex index) {
        Function kg = this.getKeyGetterOrCreate(fields, prop);
        index.setInputKeyTransformer(this.keyTransformers.get(prop));
        index.setKeyGetter(kg);
        index.setBucketSize(this.indexBucketSize.get(prop) == null ? 3 : this.indexBucketSize.get(prop));
        index.init();
        ((SearchableCollection)((Object)this.query)).addLookupIndex(prop, index);
    }

    private void configSearchIndex(Map<String, FieldAccess> fields, String prop, SearchIndex searchIndex) {
        searchIndex.setComparator(this.collators.get(prop));
        searchIndex.setInputKeyTransformer(this.keyTransformers.get(prop));
        Function kg = this.getKeyGetterOrCreate(fields, prop);
        searchIndex.setKeyGetter(kg);
        searchIndex.setBucketSize(this.indexBucketSize.get(prop) == null ? 3 : this.indexBucketSize.get(prop));
        searchIndex.init();
        ((SearchableCollection)((Object)this.query)).addSearchIndex(prop, searchIndex);
    }

    private void configIndex(String prop, NestedKeySearchIndex index) {
        index.setComparator(this.collators.get(prop));
        index.setInputKeyTransformer(this.keyTransformers.get(prop));
        index.setBucketSize(this.indexBucketSize.get(prop) == null ? 3 : this.indexBucketSize.get(prop));
        index.init();
        ((SearchableCollection)((Object)this.query)).addSearchIndex(prop, index);
    }

    private Function getKeyGetterOrCreate(Map<String, FieldAccess> fields, String prop) {
        Objects.requireNonNull(fields, "field cannot be null");
        Objects.requireNonNull(prop, "prop cannot be null");
        Function kg = null;
        kg = this.keyGetterMap.get(prop);
        if (kg == null) {
            FieldAccess field = fields.get(prop);
            kg = this.createKeyGetter(field);
            this.keyGetterMap.put(prop, kg);
        }
        return kg;
    }

    private void configPrimaryKey(Class<?> type, Map<String, FieldAccess> fields) {
        Objects.requireNonNull(this.primaryKey, "primary key cannot be null");
        LookupIndex primaryKeyIndex = this.uniqueLookupIndexFactory.apply(type);
        if (!fields.containsKey(this.primaryKey)) {
            throw new IllegalStateException(String.format("Fields does not have primary key %s", this.primaryKey));
        }
        primaryKeyIndex.setKeyGetter(this.getKeyGetterOrCreate(fields, this.primaryKey));
        this.query.setPrimaryKeyName(this.primaryKey);
        this.query.setPrimaryKeyGetter(this.keyGetterMap.get(this.primaryKey));
        ((SearchableCollection)((Object)this.query)).addLookupIndex(this.primaryKey, primaryKeyIndex);
    }
}

