/*
 * Decompiled with CFR 0.152.
 */
package org.boon.criteria;

import java.util.Arrays;
import java.util.Map;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.Criteria;
import org.boon.criteria.Grouping;
import org.boon.primitive.CharBuf;

public abstract class Group
extends Criteria {
    protected Criteria[] expressions;
    private final int hashCode;
    private String toString;
    private Grouping grouping = Grouping.AND;

    @Override
    public void prepareForGroupTest(Map<String, FieldAccess> fields, Object owner) {
    }

    @Override
    public void cleanAfterGroupTest() {
    }

    public Group(Grouping grouping, Criteria ... expressions) {
        this.grouping = grouping;
        this.expressions = expressions;
        this.hashCode = this.doHashCode();
    }

    private int doHashCode() {
        int result = this.expressions != null ? Arrays.hashCode(this.expressions) : 0;
        result = 31 * result + (this.grouping != null ? this.grouping.hashCode() : 0);
        return result;
    }

    private String doToString() {
        if (this.toString == null) {
            CharBuf builder = CharBuf.create(80);
            builder.add("{");
            builder.add("\"expressions\":");
            builder.add(Arrays.toString(this.expressions));
            builder.add(", \"grouping\":");
            builder.add(String.valueOf((Object)this.grouping));
            builder.add('}');
            this.toString = builder.toString();
        }
        return this.toString;
    }

    public Grouping getGrouping() {
        return this.grouping;
    }

    public Criteria[] getExpressions() {
        return this.expressions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        if (!Arrays.equals(this.expressions, group.expressions)) {
            return false;
        }
        return this.grouping == group.grouping;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.doToString();
    }

    public static class Or
    extends Group {
        public Or(Criteria ... expressions) {
            super(Grouping.OR, expressions);
        }

        @Override
        public void prepareForGroupTest(Map<String, FieldAccess> fields, Object owner) {
        }

        @Override
        public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
            for (Criteria c : this.expressions) {
                c.prepareForGroupTest(fields, owner);
                if (c.test(owner)) {
                    return true;
                }
                c.cleanAfterGroupTest();
            }
            return false;
        }
    }

    public static class And
    extends Group {
        public And(Criteria ... expressions) {
            super(Grouping.AND, expressions);
        }

        @Override
        public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
            for (Criteria c : this.expressions) {
                c.prepareForGroupTest(fields, owner);
                if (!c.test(owner)) {
                    return false;
                }
                c.cleanAfterGroupTest();
            }
            return true;
        }
    }
}

