/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import sun.misc.Unsafe;

public class FastStringUtils {
    public static final Unsafe UNSAFE;
    public static final long STRING_VALUE_FIELD_OFFSET;
    public static final long STRING_OFFSET_FIELD_OFFSET;
    public static final long STRING_COUNT_FIELD_OFFSET;
    public static final boolean ENABLED;
    private static final boolean WRITE_TO_FINAL_FIELDS;
    private static final boolean DISABLE;

    public static boolean hasUnsafe() {
        return ENABLED;
    }

    public static char[] toCharArray(String string) {
        if (ENABLED) {
            char[] value = (char[])UNSAFE.getObject(string, STRING_VALUE_FIELD_OFFSET);
            if (STRING_OFFSET_FIELD_OFFSET != -1L) {
                int offset = (Integer)UNSAFE.getObject(string, STRING_OFFSET_FIELD_OFFSET);
                int count = (Integer)UNSAFE.getObject(string, STRING_COUNT_FIELD_OFFSET);
                if (offset == 0 && count == value.length) {
                    return value;
                }
                char[] result = new char[count];
                System.arraycopy(value, offset, result, 0, count);
                return result;
            }
            return value;
        }
        return string.toCharArray();
    }

    public static char[] toCharArray(CharSequence charSequence) {
        return FastStringUtils.toCharArray(charSequence.toString());
    }

    public static char[] toCharArrayFromBytes(byte[] bytes, Charset charset) {
        return FastStringUtils.toCharArray(new String(bytes, charset != null ? charset : StandardCharsets.UTF_8));
    }

    public static String noCopyStringFromChars(char[] chars) {
        if (WRITE_TO_FINAL_FIELDS && ENABLED) {
            String string = new String();
            UNSAFE.putObject(string, STRING_VALUE_FIELD_OFFSET, chars);
            if (STRING_COUNT_FIELD_OFFSET != -1L) {
                UNSAFE.putObject(string, STRING_COUNT_FIELD_OFFSET, chars.length);
            }
            return string;
        }
        return new String(chars);
    }

    static {
        WRITE_TO_FINAL_FIELDS = Boolean.parseBoolean(System.getProperty("org.boon.write.to.final.fields", "false"));
        DISABLE = Boolean.parseBoolean(System.getProperty("org.boon.faststringutils", "false"));
        if (!DISABLE) {
            Unsafe unsafe;
            try {
                Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                unsafe = (Unsafe)unsafeField.get(null);
            }
            catch (Throwable cause) {
                unsafe = null;
            }
            UNSAFE = unsafe;
            ENABLED = unsafe != null;
            long stringValueFieldOffset = -1L;
            long stringOffsetFieldOffset = -1L;
            long stringCountFieldOffset = -1L;
            if (ENABLED) {
                try {
                    stringValueFieldOffset = unsafe.objectFieldOffset(String.class.getDeclaredField("value"));
                    stringOffsetFieldOffset = unsafe.objectFieldOffset(String.class.getDeclaredField("offset"));
                    stringCountFieldOffset = unsafe.objectFieldOffset(String.class.getDeclaredField("count"));
                }
                catch (Throwable cause) {
                    // empty catch block
                }
            }
            STRING_VALUE_FIELD_OFFSET = stringValueFieldOffset;
            STRING_OFFSET_FIELD_OFFSET = stringOffsetFieldOffset;
            STRING_COUNT_FIELD_OFFSET = stringCountFieldOffset;
        } else {
            STRING_VALUE_FIELD_OFFSET = -1L;
            STRING_OFFSET_FIELD_OFFSET = -1L;
            STRING_COUNT_FIELD_OFFSET = -1L;
            UNSAFE = null;
            ENABLED = false;
        }
    }
}

