/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.boon.Boon;
import org.boon.primitive.ByteBuf;
import org.boon.primitive.CharBuf;

public class Exceptions {
    public static boolean die() {
        throw new SoftenedException("died");
    }

    public static boolean die(String message) {
        throw new SoftenedException(message);
    }

    public static <T> T die(Class<T> clazz, String message) {
        throw new SoftenedException(message);
    }

    public static void handle(Exception e) {
        throw new SoftenedException(e);
    }

    public static <T> T handle(Class<T> clazz, Exception e) {
        if (e instanceof SoftenedException) {
            throw (SoftenedException)e;
        }
        throw new SoftenedException(e);
    }

    public static <T> T handle(Class<T> clazz, String message, Throwable e) {
        throw new SoftenedException(message, e);
    }

    public static <T> T tryIt(Class<T> clazz, TrialWithReturn<T> tryIt) {
        try {
            return tryIt.tryIt();
        }
        catch (Exception ex) {
            throw new SoftenedException(ex);
        }
    }

    public static void tryIt(Trial tryIt) {
        try {
            tryIt.tryIt();
        }
        catch (Exception ex) {
            throw new SoftenedException(ex);
        }
    }

    public static void handle(String message, Throwable e) {
        throw new SoftenedException(message, e);
    }

    public static void tryIt(String message, Trial tryIt) {
        try {
            tryIt.tryIt();
        }
        catch (Exception ex) {
            throw new SoftenedException(message, ex);
        }
    }

    public static String toString(Exception ex) {
        StackTraceElement[] stackTrace;
        CharBuf buffer = CharBuf.create(255);
        buffer.addLine(ex.getLocalizedMessage());
        for (StackTraceElement element : stackTrace = ex.getStackTrace()) {
            buffer.add(element.getClassName());
            Boon.sputs(buffer, "class", element.getClassName(), "method", element.getMethodName(), "line", element.getLineNumber());
        }
        return buffer.toString();
    }

    public static String toJSON(Exception ex) {
        ByteBuf buffer = ByteBuf.create(255);
        buffer.addByte(123);
        buffer.add("\n    ").addJSONEncodedString("message").add(" : ").addJSONEncodedString(ex.getMessage()).add(",\n");
        buffer.add("    ").addJSONEncodedString("localizedMessage").add(" : ").addJSONEncodedString(ex.getLocalizedMessage()).add(",\n");
        buffer.add("    ").addJSONEncodedString("stackTrace").add(" : ").addByte(91).addByte(10);
        StackTraceElement[] stackTrace = ex.getStackTrace();
        for (int index = 0; index < (stackTrace.length > 10 ? 10 : stackTrace.length); ++index) {
            StackTraceElement element = stackTrace[index];
            if (index != 0) {
                buffer.addByte(44);
                buffer.addByte(10);
            }
            ++index;
            buffer.add("           { ");
            buffer.add("             ").addJSONEncodedString("className").add(" : ").addJSONEncodedString(element.getClassName()).add(",\n");
            buffer.add("             ").addJSONEncodedString("methodName").add(" : ").addJSONEncodedString(element.getMethodName()).add(",\n");
            buffer.add("             ").addJSONEncodedString("lineNumber").add(" : ").add("" + element.getLineNumber()).add("}\n");
        }
        buffer.add("\n    ]\n}");
        return buffer.toString();
    }

    public static class SoftenedException
    extends RuntimeException {
        public SoftenedException(String message) {
            super(message);
        }

        public SoftenedException(String message, Throwable cause) {
            super(message, cause);
        }

        public SoftenedException(Throwable cause) {
            super("Wrapped Exception", cause);
        }

        @Override
        public void printStackTrace(PrintStream s) {
            s.println(this.getMessage());
            if (this.getCause() != null) {
                s.println("This Exception was wrapped, the original exception\nstack trace is:\n");
                this.getCause().printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public String getMessage() {
            return super.getMessage() + (this.getCause() == null ? "" : this.getCauseMessage());
        }

        private String getCauseMessage() {
            return "\n CAUSE " + this.getCause().getClass().getName() + " :: " + this.getCause().getMessage();
        }

        @Override
        public String getLocalizedMessage() {
            return this.getMessage();
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            if (this.getCause() != null) {
                return this.getCause().getStackTrace();
            }
            return super.getStackTrace();
        }

        @Override
        public Throwable getCause() {
            return super.getCause();
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            s.println(this.getMessage());
            if (this.getCause() != null) {
                s.println("This Exception was wrapped, the original exception\nstack trace is:\n");
                this.getCause().printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public void printStackTrace() {
            System.err.println(this.getMessage());
            if (this.getCause() != null) {
                System.err.println("This Exception was wrapped, the original exception\nstack trace is:\n");
                this.getCause().printStackTrace();
            } else {
                super.printStackTrace();
            }
        }
    }

    public static interface TrialWithReturn<T> {
        public T tryIt() throws Exception;
    }

    public static interface Trial {
        public void tryIt() throws Exception;
    }
}

