/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.IO;
import org.boon.Lists;
import org.boon.Maps;
import org.boon.StringScanner;

public class Classpaths {
    private static FileSystem zipFileSystem(URI fileJarURI) {
        FileSystem fs;
        FileSystemProvider provider;
        block5: {
            Map<String, String> env = Maps.map("create", "true");
            provider = null;
            for (FileSystemProvider p : FileSystemProvider.installedProviders()) {
                if (!"jar".equals(p.getScheme())) continue;
                provider = p;
                break;
            }
            Objects.requireNonNull(provider, "Zip file provider not found");
            fs = null;
            try {
                fs = provider.getFileSystem(fileJarURI);
            }
            catch (Exception ex) {
                if (provider == null) break block5;
                try {
                    fs = provider.newFileSystem(fileJarURI, env);
                }
                catch (IOException ex2) {
                    Exceptions.handle(FileSystem.class, Boon.sputs("unable to load", fileJarURI, "as zip file system"), ex2);
                }
            }
        }
        Objects.requireNonNull(provider, "Zip file system was not found");
        return fs;
    }

    public static List<URL> classpathResources(ClassLoader loader, String resource) {
        try {
            Enumeration<URL> resources = loader.getResources(resource);
            List<URL> list = Lists.list(resources);
            if (Lists.isEmpty(list) && resource.startsWith("/")) {
                resource = resource.substring(1);
                return Classpaths.classpathResources(loader, resource);
            }
            return list;
        }
        catch (Exception ex) {
            return Exceptions.handle(List.class, Boon.sputs("Unable to load resources for", resource), ex);
        }
    }

    public static List<URL> classpathResources(Class<?> clazz, String resource) {
        List<URL> list = Classpaths.classpathResources(Thread.currentThread().getContextClassLoader(), resource);
        if (Lists.isEmpty(list)) {
            list = Classpaths.classpathResources(clazz.getClassLoader(), resource);
        }
        if (Lists.isEmpty(list) && resource.startsWith("/")) {
            resource = resource.substring(1);
            return Classpaths.classpathResources(clazz, resource);
        }
        return list;
    }

    public static List<Path> resources(Class<?> clazz, String resource) {
        List<Path> list = Classpaths.resources(Thread.currentThread().getContextClassLoader(), resource);
        if (Lists.isEmpty(list)) {
            list = Classpaths.resources(clazz.getClassLoader(), resource);
        }
        if (Lists.isEmpty(list) && resource.startsWith("/")) {
            resource = resource.substring(1);
            return Classpaths.resources(clazz, resource);
        }
        return list;
    }

    public static List<Path> resources(ClassLoader loader, String resource) {
        List<URL> resourceURLs = Classpaths.classpathResources(loader, resource);
        List<Path> resourcePaths = Lists.list(Path.class);
        HashMap<URI, FileSystem> pathToZipFileSystems = new HashMap<URI, FileSystem>();
        for (URL resourceURL : resourceURLs) {
            if (resourceURL.getProtocol().equals("jar")) {
                Classpaths.resourcesFromJar(resourcePaths, resourceURL, pathToZipFileSystems);
                continue;
            }
            Classpaths.resourcesFromFileSystem(resourcePaths, resourceURL);
        }
        return resourcePaths;
    }

    private static void resourcesFromFileSystem(List<Path> resourcePaths, URL u) {
        URI fileURI = IO.createURI(u.toString());
        Lists.add(resourcePaths, IO.uriToPath(fileURI));
    }

    private static void resourcesFromJar(List<Path> resourcePaths, URL resourceURL, Map<URI, FileSystem> pathToZipFileSystems) {
        String str = resourceURL.toString();
        String[] strings = StringScanner.split(str, '!');
        URI fileJarURI = URI.create(strings[0]);
        String resourcePath = strings[1];
        if (!pathToZipFileSystems.containsKey(fileJarURI)) {
            pathToZipFileSystems.put(fileJarURI, Classpaths.zipFileSystem(fileJarURI));
        }
        FileSystem fileSystem = pathToZipFileSystems.get(fileJarURI);
        Lists.add(resourcePaths, fileSystem.getPath(resourcePath, new String[0]));
    }
}

