/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Universal;
import org.boon.core.reflection.Reflection;

public class Arrays {
    @Universal
    public static <V> V[] array(Class<V> clasz, int size) {
        Object newArray = Array.newInstance(clasz, size);
        return (Object[])newArray;
    }

    public static <V> V[] grow(V[] array, int size) {
        Objects.requireNonNull(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length + size);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return (Object[])newArray;
    }

    public static <V> V[] grow(V[] array) {
        Objects.requireNonNull(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length * 2);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return (Object[])newArray;
    }

    public static <V> V[] shrink(V[] array, int size) {
        Objects.requireNonNull(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length - size);
        System.arraycopy(array, 0, (Object[])newArray, 0, array.length - size);
        return (Object[])newArray;
    }

    public static <V> V[] compact(V[] array) {
        Objects.requireNonNull(array);
        int nullCount = 0;
        for (V anArray1 : array) {
            if (anArray1 != null) continue;
            ++nullCount;
        }
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length - nullCount);
        int j = 0;
        for (V anArray : array) {
            if (anArray == null) continue;
            Array.set(newArray, j, anArray);
            ++j;
        }
        return (Object[])newArray;
    }

    @SafeVarargs
    public static <V> V[] array(V ... array) {
        return array;
    }

    @Universal
    public static <V> int len(V[] array) {
        return array.length;
    }

    @Universal
    public static <V> V idx(V[] array, int index) {
        int i = Arrays.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static <V> void idx(V[] array, int index, V value) {
        int i = Arrays.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static <V> V[] slc(V[] array, int startIndex, int endIndex) {
        Objects.requireNonNull(array);
        int start = Arrays.calculateIndex(array, startIndex);
        int end = Arrays.calculateIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newLength);
        System.arraycopy(array, start, newArray, 0, newLength);
        return (Object[])newArray;
    }

    @Universal
    public static <V> boolean in(V value, V[] array) {
        for (V currentValue : array) {
            if (!currentValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static <V> V[] slc(V[] array, int startIndex) {
        Objects.requireNonNull(array);
        int start = Arrays.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newLength);
        System.arraycopy(array, start, newArray, 0, newLength);
        return (Object[])newArray;
    }

    @Universal
    public static <V> V[] copy(V[] array) {
        Objects.requireNonNull(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return (Object[])newArray;
    }

    @Universal
    public static <V> V[] add(V[] array, V v) {
        Objects.requireNonNull(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        Array.set(newArray, array.length, v);
        return (Object[])newArray;
    }

    @Universal
    public static <V> V[] add(V[] array, V[] array2) {
        Objects.requireNonNull(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length + array2.length);
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return (Object[])newArray;
    }

    @Universal
    public static <V> V[] insert(V[] array, int index, V v) {
        Objects.requireNonNull(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingArrayLengthAfterIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingArrayLengthAfterIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingArrayLengthAfterIndex);
        }
        Array.set(newArray, index, v);
        return (Object[])newArray;
    }

    @Universal
    public static <V> V[] slcEnd(V[] array, int endIndex) {
        int end;
        Objects.requireNonNull(array);
        int newLength = end = Arrays.calculateIndex(array, endIndex);
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("end index %d, length %d", endIndex, array.length));
        }
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newLength);
        System.arraycopy(array, 0, newArray, 0, newLength);
        return (Object[])newArray;
    }

    private static <T> int calculateIndex(T[] array, int originalIndex) {
        int length = array.length;
        Objects.requireNonNull(array, "array cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    public static <V> V[] array(Collection<V> collection) {
        if (collection.size() > 0) {
            Object newInstance = Array.newInstance(collection.iterator().next().getClass(), collection.size());
            return collection.toArray((Object[])newInstance);
        }
        Exceptions.die("array(listStream): The collection has to have at least one item in it");
        return null;
    }

    public static List<Map<String, Object>> toListOfMaps(Object ... array) {
        return Reflection.toListOfMaps(Lists.list(array));
    }
}

