/*
 * Decompiled with CFR 0.152.
 */
package org.boon.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.boon.Exceptions;
import org.boon.Pair;

public class ConcurrentWeakHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final ThreadLocal<HardRefKeyValue> HARD_REF = new ThreadLocal<HardRefKeyValue>(){

        @Override
        protected HardRefKeyValue initialValue() {
            return new HardRefKeyValue();
        }
    };
    private final ConcurrentHashMap<KeyValue<K, V>, V> map;
    private final ReferenceQueue<K> referenceQueue = new ReferenceQueue();
    private EntrySet entrySet;

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public ConcurrentWeakHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public ConcurrentWeakHashMap() {
        this(16, 0.75f, 16);
    }

    private HardRefKeyValue<K, V> createHardRef(K k) {
        HardRefKeyValue hardKey = HARD_REF.get();
        hardKey.set(k, null, k.hashCode());
        return hardKey;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            Exceptions.die("Null keys not allowed");
        }
        HardRefKeyValue<Object, V> hardRef = this.createHardRef(key);
        V result = this.map.get(hardRef);
        hardRef.clear();
        return result;
    }

    @Override
    public V put(K key, V value) {
        this.evictEntires();
        if (key == null) {
            Exceptions.die("No null keys");
        }
        KeyValue<K, V> weakKey = this.createWeakKey(key, value);
        return this.map.put(weakKey, value);
    }

    @Override
    public V remove(Object key) {
        this.evictEntires();
        if (key == null) {
            Exceptions.die("Null keys not allowed");
        }
        HardRefKeyValue<Object, V> hardRef = this.createHardRef(key);
        V removedValue = this.map.remove(hardRef);
        hardRef.clear();
        return removedValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Set<Map.Entry<K, V>> entries = map.entrySet();
        for (Map.Entry<K, V> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public void clear() {
        this.evictEntires();
        this.map.clear();
    }

    @Override
    public Collection<V> values() {
        this.evictEntires();
        return this.map.values();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            Exceptions.die("Null keys not allowed");
        }
        HardRefKeyValue<Object, V> hardRef = this.createHardRef(key);
        boolean containsKey = this.map.containsKey(hardRef);
        hardRef.clear();
        return containsKey;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsKey(value);
    }

    private boolean evictEntires() {
        WeakRefKeyValue weakKeyValue = (WeakRefKeyValue)this.referenceQueue.poll();
        boolean processed = false;
        while (weakKeyValue != null) {
            Object value = weakKeyValue.getValue();
            this.map.remove(weakKeyValue, value);
            processed = true;
        }
        return processed;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.evictEntires();
        return this.map.putIfAbsent(this.createWeakKey(key, value), value);
    }

    private KeyValue<K, V> createWeakKey(K key, V value) {
        return new WeakRefKeyValue(key, value, this.referenceQueue);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.evictEntires();
        return this.map.remove(this.createWeakKey(key, value), value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.evictEntires();
        return this.map.replace(this.createWeakKey(key, oldValue), oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        this.evictEntires();
        return this.map.replace(this.createWeakKey(key, value), value);
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final Iterator<Map.Entry<KeyValue<K, V>, V>> iterator;

        private EntrySet() {
            this.iterator = ConcurrentWeakHashMap.this.map.entrySet().iterator();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Pair<K, V> next = null;

                @Override
                public boolean hasNext() {
                    this.next = null;
                    while (EntrySet.this.iterator.hasNext()) {
                        Object key;
                        Map.Entry entry = EntrySet.this.iterator.next();
                        KeyValue kv = entry.getKey();
                        Object k = key = kv != null ? (Object)kv.getKey() : null;
                        if (key == null) continue;
                        this.next = new Pair(key, kv.getValue());
                    }
                    return this.next != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    return this.next;
                }

                @Override
                public void remove() {
                    EntrySet.this.iterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int count = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++count;
                i.next();
            }
            return count;
        }

        @Override
        public boolean remove(Object o) {
            ConcurrentWeakHashMap.this.evictEntires();
            HardRefKeyValue key = ConcurrentWeakHashMap.this.createHardRef(o);
            boolean removed = ConcurrentWeakHashMap.this.map.remove(key) != null;
            key.clear();
            return removed;
        }
    }

    private static class WeakRefKeyValue<K, V>
    extends WeakReference<K>
    implements KeyValue {
        protected final ReferenceQueue<K> referenceQueue;
        private final int hashCode;
        private final V value;

        private WeakRefKeyValue(K referent, V v, ReferenceQueue<K> q) {
            super(referent, q);
            this.value = v;
            this.hashCode = referent.hashCode();
            this.referenceQueue = q;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyValue)) {
                return false;
            }
            Object ours = this.get();
            Object theirs = ((KeyValue)o).getKey();
            if (theirs == null || ours == null) {
                return false;
            }
            if (ours == theirs) {
                return true;
            }
            return ours.equals(theirs);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class HardRefKeyValue<K, V>
    implements KeyValue<K, V> {
        K key;
        V value;
        int hashCode;

        private HardRefKeyValue() {
        }

        void set(K key, V value, int hashCode) {
            this.key = key;
            this.value = value;
            this.hashCode = hashCode;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public void clear() {
            this.value = null;
            this.hashCode = 0;
            this.key = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyValue)) {
                return false;
            }
            K ours = this.getKey();
            Object theirs = ((KeyValue)o).getKey();
            if (theirs == null || ours == null) {
                return false;
            }
            if (ours == theirs) {
                return true;
            }
            return ours.equals(theirs);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }
    }

    private static interface KeyValue<K, V> {
        public K getKey();

        public V getValue();

        public int hashCode();
    }
}

