/*
 * Decompiled with CFR 0.152.
 */
package org.boon.criteria;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Str;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.Type;
import org.boon.core.Value;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.ObjectFilter;
import org.boon.criteria.internal.Criteria;
import org.boon.criteria.internal.Operator;
import org.boon.primitive.CharBuf;

public abstract class Criterion<VALUE>
extends Criteria {
    private Object name;
    private Operator operator;
    protected VALUE value;
    protected VALUE value2;
    protected VALUE[] values;
    private final int hashCode;
    private final String toString;
    private boolean initialized;
    private Criterion nativeDelegate;
    private boolean useDelegate;
    private FieldAccess field;
    protected Object objectUnderTest;
    private Map<String, FieldAccess> fields;
    private ThisField fakeField = null;
    private boolean path;
    boolean convert1st;
    boolean convert2nd;

    public Criterion(String name, Operator operator, VALUE ... values) {
        Exceptions.requireNonNull(name, "name cannot be null");
        Exceptions.requireNonNull((Object)operator, "operator cannot be null");
        Exceptions.requireNonNull(values, "values cannot be null");
        this.path = Criterion.isPropPath(name);
        this.name = name;
        this.operator = operator;
        this.setValues(values);
        this.hashCode = this.doHashCode();
        this.toString = this.doToString();
    }

    public FieldAccess field() {
        if (this.path) {
            FieldAccess field = BeanUtils.idxField(this.objectUnderTest, this.name.toString());
            if (field == null) {
                return this.fakeField();
            }
            return field;
        }
        if (this.name instanceof Enum) {
            this.name = Str.camelCaseLower(this.name.toString());
        }
        FieldAccess field = this.fields().get(this.name);
        return field;
    }

    private FieldAccess fakeField() {
        if (this.fakeField == null) {
            this.fakeField = new ThisField(this.name.toString(), this.objectUnderTest);
        }
        this.fakeField.thisObject = this.objectUnderTest;
        return this.fakeField;
    }

    public Object fieldValue() {
        if (!this.path) {
            FieldAccess field1 = this.field();
            return field1.getValue(this.objectUnderTest);
        }
        return BeanUtils.atIndex(this.objectUnderTest, this.name.toString());
    }

    public int fieldInt() {
        if (!this.path) {
            FieldAccess field1 = this.field();
            return field1.getInt(this.objectUnderTest);
        }
        return BeanUtils.idxInt(this.objectUnderTest, this.name.toString());
    }

    public short fieldShort() {
        if (!this.path) {
            FieldAccess field1 = this.field();
            return field1.getShort(this.objectUnderTest);
        }
        return BeanUtils.idxShort(this.objectUnderTest, this.name.toString());
    }

    public long fieldLong() {
        if (!this.path) {
            FieldAccess field1 = this.field();
            return field1.getLong(this.objectUnderTest);
        }
        return BeanUtils.idxLong(this.objectUnderTest, this.name.toString());
    }

    public float fieldFloat() {
        if (!this.path) {
            FieldAccess field1 = this.field();
            return field1.getFloat(this.objectUnderTest);
        }
        return BeanUtils.idxFloat(this.objectUnderTest, this.name.toString());
    }

    public double fieldDouble() {
        if (!this.path) {
            FieldAccess field1 = this.field();
            return field1.getDouble(this.objectUnderTest);
        }
        return BeanUtils.idxDouble(this.objectUnderTest, this.name.toString());
    }

    public boolean fieldBoolean() {
        if (!this.path) {
            FieldAccess field1 = this.field();
            return field1.getBoolean(this.objectUnderTest);
        }
        return BeanUtils.idxBoolean(this.objectUnderTest, this.name.toString());
    }

    public byte fieldByte() {
        if (!this.path) {
            FieldAccess field1 = this.field();
            return field1.getByte(this.objectUnderTest);
        }
        return BeanUtils.idxByte(this.objectUnderTest, this.name.toString());
    }

    public char fieldChar() {
        if (!this.path) {
            FieldAccess field1 = this.field();
            return field1.getChar(this.objectUnderTest);
        }
        return BeanUtils.idxChar(this.objectUnderTest, this.name.toString());
    }

    public Set<Object> valueSet() {
        if (!this.convert1st) {
            HashSet<VALUE> set = new HashSet<VALUE>(this.values.length);
            FieldAccess field = this.field();
            Class<?> classType = field.type();
            for (Object v : this.values) {
                v = Conversions.coerce(classType, this.value);
                set.add(v);
            }
            this.value = set;
            this.convert1st = true;
        }
        return (Set)this.value;
    }

    public Object value() {
        if (!this.convert1st) {
            FieldAccess field = this.field();
            if (field != null) {
                switch (field.typeEnum()) {
                    case ARRAY: 
                    case COLLECTION: 
                    case SET: 
                    case NUMBER: {
                        this.value = Conversions.coerce(field.type(), this.value);
                        return new MyNumber(this.value);
                    }
                    case LIST: {
                        this.value = Conversions.coerce(field.getComponentClass(), this.value);
                        break;
                    }
                    default: {
                        this.value = Conversions.coerce(field.type(), this.value);
                    }
                }
            }
            this.convert1st = true;
        }
        return this.value;
    }

    public Object value2() {
        if (!this.convert2nd) {
            FieldAccess field = this.field();
            this.value2 = Conversions.coerce(field.type(), this.value2);
            this.convert2nd = true;
        }
        return this.value2;
    }

    public String getName() {
        return this.name.toString();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public VALUE getValue() {
        return this.value;
    }

    public VALUE[] getValues() {
        return this.values;
    }

    public void setValues(VALUE[] values) {
        if (values.length > 0) {
            this.value = values[0];
        }
        if (values.length > 1) {
            this.value2 = values[1];
        }
        this.values = values;
    }

    private static boolean isPropPath(String prop) {
        return BeanUtils.isPropPath(prop);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Criterion)) {
            return false;
        }
        Criterion criterion = (Criterion)o;
        if (this.name != null ? !this.name.equals(criterion.name) : criterion.name != null) {
            return false;
        }
        if (this.operator != criterion.operator) {
            return false;
        }
        if (this.value != null ? !this.value.equals(criterion.value) : criterion.value != null) {
            return false;
        }
        return Arrays.equals(this.values, criterion.values);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int doHashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.values != null ? Arrays.hashCode(this.values) : 0);
        return result;
    }

    public String toString() {
        return this.toString;
    }

    public String doToString() {
        CharBuf builder = CharBuf.create(80);
        builder.add("c{");
        builder.add("\"name\":'");
        builder.add(String.valueOf(this.name));
        builder.add(", \"operator\":");
        builder.add(String.valueOf((Object)this.operator));
        builder.add(", \"set\":");
        builder.add(String.valueOf(this.value));
        builder.add(", \"update\":");
        builder.add(Arrays.toString(this.values));
        builder.add("}");
        return builder.toString();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void clean() {
        this.field = null;
        this.fields = null;
        this.objectUnderTest = null;
    }

    public abstract boolean resolve(Object var1);

    public boolean test(Object o) {
        FieldAccess field = null;
        try {
            Exceptions.requireNonNull(o, "object under test can't be null");
            this.objectUnderTest = o;
            this.initIfNeeded();
            if (this.useDelegate) {
                this.nativeDelegate.fields = this.fields;
                this.nativeDelegate.objectUnderTest = this.objectUnderTest;
                return this.nativeDelegate.resolve(o);
            }
            field = this.field();
            if (!this.path && field == null && o instanceof Map) {
                return false;
            }
            boolean result = this.resolve(o);
            return result;
        }
        catch (Exception ex) {
            return Exceptions.handle(Typ.bool, Boon.sputl("In class " + this.getClass().getName(), "the test method is unable to test the following criteria operator", String.valueOf((Object)this.getOperator()), Boon.sputs("The field name is          :          ", this.getName()), Boon.sputs("The value is               :          ", this.getValue()), Boon.sputs("The value type is          :          ", this.getValue().getClass().getName()), Boon.sputs("The object under test      :          ", this.objectUnderTest), Boon.sputs("The object under test type :          ", this.objectUnderTest == null ? "null" : this.objectUnderTest.getClass().getName()), Boon.sputs("Field                      :          ", field), Boon.sputs("Fields                     :          ", this.fields), Boon.sputs(new Object[0])), ex);
        }
    }

    private Map<String, FieldAccess> fields() {
        if (this.objectUnderTest instanceof Map) {
            return BeanUtils.getFieldsFromObject(this.objectUnderTest);
        }
        if (this.fields == null) {
            this.fields = BeanUtils.getFieldsFromObject(this.objectUnderTest);
        }
        return this.fields;
    }

    private void initForShortValue(short v) {
        this.value = v;
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqShort(this.name, v);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqShort(this.name, v);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltShort(this.name, v);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteShort(this.name, v);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtShort(this.name, v);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteShort(this.name, v);
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inShorts(this.name, Conversions.sarray(this.values));
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenShort(this.name, v, Conversions.toShort(this.values[1]));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInShorts(this.name, Conversions.sarray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initIfNeeded() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        String name = this.name.toString();
        FieldAccess field = this.field();
        if (field == null) {
            return;
        }
        Class<?> type = field.type();
        if (!type.isPrimitive() && type != Typ.date) {
            return;
        }
        if (type == Typ.date) {
            if (!(this.value instanceof Date)) {
                this.initForDate();
            }
            return;
        }
        this.useDelegate = true;
        if (type == Typ.intgr) {
            int v = Conversions.toInt(this.value);
            this.initForInt(v);
        } else if (type == Typ.bt) {
            byte v = Conversions.toByte(this.value);
            this.initForByte(v);
        } else if (type == Typ.shrt) {
            short v = Conversions.toShort(this.value);
            this.initForShortValue(v);
        } else if (type == Typ.lng) {
            long v = Conversions.toLong(this.value);
            this.initForLong(v);
        } else if (type == Typ.flt) {
            float v = Conversions.toFloat(this.value);
            this.initForFloat(v);
        } else if (type == Typ.dbl) {
            double v = Conversions.toDouble(this.value);
            this.initForDouble(v);
        } else if (type == Typ.bln) {
            switch (this.operator) {
                case EQUAL: {
                    this.nativeDelegate = ObjectFilter.eqBoolean(name, Conversions.toBoolean(this.value));
                    break;
                }
                case NOT_EQUAL: {
                    this.nativeDelegate = ObjectFilter.notEqBoolean(name, Conversions.toBoolean(this.value));
                    break;
                }
                default: {
                    this.useDelegate = false;
                    break;
                }
            }
        } else if (type == Typ.chr) {
            char v = Conversions.toChar(this.value);
            this.initForChar(v);
        }
    }

    private void initForChar(char value) {
        this.value = Character.valueOf(value);
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqChar(this.name, value);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqChar(this.name, value);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltChar(this.name, value);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteChar(this.name, value);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtChar(this.name, value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteChar(this.name, value);
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenChar(this.name, value, Conversions.toChar(this.values[1]));
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inChars(this.name, Conversions.carray(this.values));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInChars(this.name, Conversions.carray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initForDouble(double value) {
        this.value = value;
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqDouble(this.name, value);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqDouble(this.name, value);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltDouble(this.name, value);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteDouble(this.name, value);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtDouble(this.name, value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteDouble(this.name, value);
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenDouble(this.name, value, Conversions.toDouble(this.values[1]));
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inDoubles(this.name, Conversions.darray(this.values));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInDoubles(this.name, Conversions.darray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initForFloat(float value) {
        this.value = Float.valueOf(value);
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqFloat(this.name, value);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqFloat(this.name, value);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltFloat(this.name, value);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteFloat(this.name, value);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtFloat(this.name, value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteFloat(this.name, value);
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenFloat(this.name, value, Conversions.toFloat(this.values[1]));
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inFloats(this.name, Conversions.farray(this.values));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInFloats(this.name, Conversions.farray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initForLong(long value) {
        this.value = value;
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqLong(this.name, value);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqLong(this.name, value);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltLong(this.name, value);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteLong(this.name, value);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtLong(this.name, value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteLong(this.name, value);
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inLongs(this.name, Conversions.larray(this.values));
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenLong(this.name, value, Conversions.toLong(this.values[1]));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInLongs(this.name, Conversions.larray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initForByte(byte value) {
        this.value = value;
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqByte(this.name, value);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqByte(this.name, value);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltByte(this.name, value);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteByte(this.name, value);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtByte(this.name, value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteByte(this.name, value);
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inBytes(this.name, Conversions.barray(this.values));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInBytes(this.name, Conversions.barray(this.values));
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenByte(this.name, value, Conversions.toByte(this.values[1]));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initForDate() {
        this.value = Conversions.toDate(this.value);
        if (this.operator == Operator.BETWEEN) {
            this.values[0] = Conversions.toDate(this.values[0]);
            this.values[1] = Conversions.toDate(this.values[1]);
        }
    }

    private void initForInt(int v) {
        this.value = v;
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqInt(this.name, v);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqInt(this.name, v);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltInt(this.name, v);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteInt(this.name, v);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtInt(this.name, v);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteInt(this.name, v);
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenInt(this.name, v, Conversions.toInt(this.values[1]));
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inInts(this.name, Conversions.iarray(this.values));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInInts(this.name, Conversions.iarray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private static class MyNumber
    extends Number
    implements Comparable<Number> {
        Object value;

        MyNumber(Object value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return Conversions.toInt(this.value);
        }

        @Override
        public long longValue() {
            return Conversions.toLong(this.value);
        }

        @Override
        public float floatValue() {
            return Conversions.toFloat(this.value);
        }

        @Override
        public double doubleValue() {
            return Conversions.toDouble(this.value);
        }

        @Override
        public int compareTo(Number number) {
            double thatValue;
            double thisDouble = this.doubleValue();
            if (thisDouble > (thatValue = number.doubleValue())) {
                return 1;
            }
            if (thisDouble < thatValue) {
                return -1;
            }
            return 0;
        }
    }

    static class ThisField
    implements FieldAccess {
        Object thisObject;
        private final String name;

        ThisField(String name, Object thisObject) {
            this.name = name;
            this.thisObject = thisObject;
        }

        @Override
        public boolean injectable() {
            return false;
        }

        @Override
        public boolean requiresInjection() {
            return false;
        }

        @Override
        public boolean isNamed() {
            return false;
        }

        @Override
        public boolean hasAlias() {
            return false;
        }

        @Override
        public String alias() {
            return null;
        }

        @Override
        public String named() {
            return null;
        }

        @Override
        public String name() {
            return null;
        }

        @Override
        public Object getValue(Object obj) {
            if (this.name.equals("this")) {
                return this.thisObject;
            }
            return BeanUtils.atIndex(this.thisObject, this.name);
        }

        @Override
        public void setValue(Object obj, Object value) {
        }

        @Override
        public void setFromValue(Object obj, Value value) {
        }

        @Override
        public boolean getBoolean(Object obj) {
            return false;
        }

        @Override
        public void setBoolean(Object obj, boolean value) {
        }

        @Override
        public int getInt(Object obj) {
            return 0;
        }

        @Override
        public void setInt(Object obj, int value) {
        }

        @Override
        public short getShort(Object obj) {
            return 0;
        }

        @Override
        public void setShort(Object obj, short value) {
        }

        @Override
        public char getChar(Object obj) {
            return '\u0000';
        }

        @Override
        public void setChar(Object obj, char value) {
        }

        @Override
        public long getLong(Object obj) {
            return 0L;
        }

        @Override
        public void setLong(Object obj, long value) {
        }

        @Override
        public double getDouble(Object obj) {
            return 0.0;
        }

        @Override
        public void setDouble(Object obj, double value) {
        }

        @Override
        public float getFloat(Object obj) {
            return 0.0f;
        }

        @Override
        public void setFloat(Object obj, float value) {
        }

        @Override
        public byte getByte(Object obj) {
            return 0;
        }

        @Override
        public void setByte(Object obj, byte value) {
        }

        @Override
        public Object getObject(Object obj) {
            return this.thisObject;
        }

        @Override
        public void setObject(Object obj, Object value) {
        }

        @Override
        public Type typeEnum() {
            Object o = this.getValue(this.thisObject);
            return Type.getInstanceType(o);
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isVolatile() {
            return false;
        }

        @Override
        public boolean isQualified() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isWriteOnly() {
            return false;
        }

        @Override
        public Class<?> type() {
            if (this.name.equals("this")) {
                return this.thisObject != null ? this.thisObject.getClass() : Object.class;
            }
            return Object.class;
        }

        @Override
        public Class<?> declaringParent() {
            return null;
        }

        @Override
        public Object parent() {
            return null;
        }

        @Override
        public Field getField() {
            return null;
        }

        @Override
        public boolean include() {
            return false;
        }

        @Override
        public boolean ignore() {
            return false;
        }

        @Override
        public ParameterizedType getParameterizedType() {
            return null;
        }

        @Override
        public Class<?> getComponentClass() {
            Collection c;
            Object o = this.getValue(this.thisObject);
            if (o instanceof Collection && (c = (Collection)o).iterator().hasNext()) {
                return c.iterator().next().getClass();
            }
            return Object.class;
        }

        @Override
        public boolean hasAnnotation(String annotationName) {
            return false;
        }

        @Override
        public Map<String, Object> getAnnotationData(String annotationName) {
            return null;
        }

        @Override
        public boolean isViewActive(String activeView) {
            return false;
        }

        @Override
        public void setStaticValue(Object newValue) {
        }

        @Override
        public Type componentType() {
            return null;
        }
    }

    static class ThisMap
    implements Map<String, FieldAccess> {
        ThisField thisField;
        private final String name;

        ThisMap(String name, Object thisObject) {
            this.name = name;
            this.thisField = new ThisField(name, thisObject);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public FieldAccess get(Object key) {
            return this.thisField;
        }

        @Override
        public FieldAccess put(String key, FieldAccess value) {
            return null;
        }

        @Override
        public FieldAccess remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends FieldAccess> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return null;
        }

        @Override
        public Collection<FieldAccess> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<String, FieldAccess>> entrySet() {
            return null;
        }
    }
}

