/*
 * Decompiled with CFR 0.152.
 */
package org.boon.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.boon.StringScanner;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.primitive.Lng;

public class LongList
extends AbstractList<Long> {
    private long[] values;
    private int end;

    public static LongList toLongList(Collection<?> inputList, String propertyPath) {
        if (inputList.size() == 0) {
            return new LongList(0);
        }
        LongList outputList = new LongList(inputList.size());
        if (propertyPath.contains(".") || propertyPath.contains("[")) {
            String[] properties = StringScanner.splitByDelimiters(propertyPath, ".[]");
            for (Object o : inputList) {
                outputList.add(BeanUtils.getPropertyLong(o, properties));
            }
        } else {
            Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(inputList.iterator().next());
            FieldAccess fieldAccess = fields.get(propertyPath);
            for (Object o : inputList) {
                outputList.add(fieldAccess.getLong(o));
            }
        }
        return outputList;
    }

    public LongList(int capacity) {
        this.values = new long[capacity];
    }

    public LongList() {
        this.values = new long[10];
    }

    public LongList(long[] values) {
        this.values = values;
        this.end = values.length;
    }

    @Override
    public Long get(int index) {
        return this.values[index];
    }

    public final long getInt(int index) {
        return this.values[index];
    }

    @Override
    public boolean add(Long integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Lng.grow(this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return true;
    }

    public boolean addLong(long integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Lng.grow(this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return true;
    }

    public LongList add(long integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Lng.grow(this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return this;
    }

    public boolean addArray(long ... integers) {
        if (this.end + integers.length >= this.values.length) {
            this.values = Lng.grow(this.values, (this.values.length + integers.length) * 2);
        }
        System.arraycopy(integers, 0, this.values, this.end, integers.length);
        this.end += integers.length;
        return true;
    }

    @Override
    public Long set(int index, Long element) {
        long oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    public long setLong(int index, int element) {
        long oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    @Override
    public int size() {
        return this.end;
    }

    public long sum() {
        return Lng.sum(this.values, this.end);
    }

    public long[] toValueArray() {
        return Arrays.copyOfRange(this.values, 0, this.end);
    }

    public long reduceBy(Object function) {
        return Lng.reduceBy(this.values, this.end, function);
    }

    public long reduceBy(Object function, String name) {
        return Lng.reduceBy(this.values, this.end, function, name);
    }

    public long reduceBy(Lng.ReduceBy reduceBy) {
        return Lng.reduceBy(this.values, this.end, reduceBy);
    }

    public long mean() {
        return Lng.mean(this.values, this.end);
    }

    public long standardDeviation() {
        return Lng.standardDeviation(this.values, this.end);
    }

    public long variance() {
        return Lng.variance(this.values, this.end);
    }

    public long max() {
        return Lng.max(this.values, this.end);
    }

    public long min() {
        return Lng.min(this.values, this.end);
    }

    public long median() {
        return Lng.median(this.values, this.end);
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.end);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongList longs = (LongList)o;
        if (this.end != longs.end) {
            return false;
        }
        return Lng.equals(0, this.end, this.values, longs.values);
    }

    @Override
    public int hashCode() {
        int result = 131313;
        result = 31 * result + (this.values != null ? Lng.hashCode(0, this.end, this.values) : 0);
        result = 31 * result + this.end;
        return result;
    }

    @Override
    public void clear() {
        this.values = new long[10];
        this.end = 0;
    }
}

