/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Maps;
import org.boon.core.Conversions;
import org.boon.core.Function;
import org.boon.core.Typ;
import org.boon.core.Type;
import org.boon.core.Value;
import org.boon.core.reflection.BaseAccess;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.ConstructorAccess;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.core.reflection.fields.FieldsAccessorFieldThenProp;
import org.boon.core.value.ValueContainer;
import org.boon.core.value.ValueList;
import org.boon.core.value.ValueMap;
import org.boon.core.value.ValueMapImpl;
import org.boon.primitive.Arry;
import org.boon.primitive.CharBuf;

public class Mapper {
    private final FieldsAccessor fieldsAccessor;
    private final Set<String> ignoreSet;
    private final String view;
    private final boolean respectIgnore;
    private final boolean acceptSingleValueAsArray;

    public Mapper(FieldAccessMode fieldAccessType, boolean useAnnotations, boolean caseInsensitiveFields, Set<String> ignoreSet, String view, boolean respectIgnore, boolean acceptSingleValueAsArray) {
        this.fieldsAccessor = FieldAccessMode.create(fieldAccessType, useAnnotations, caseInsensitiveFields);
        this.ignoreSet = ignoreSet;
        this.view = view;
        this.respectIgnore = respectIgnore;
        this.acceptSingleValueAsArray = acceptSingleValueAsArray;
    }

    public Mapper(FieldsAccessor fieldsAccessor, Set<String> ignoreSet, String view, boolean respectIgnore) {
        this.fieldsAccessor = fieldsAccessor;
        this.ignoreSet = ignoreSet;
        this.view = view;
        this.respectIgnore = respectIgnore;
        this.acceptSingleValueAsArray = false;
    }

    public Mapper(Set<String> ignoreSet, String view, boolean respectIgnore) {
        this.fieldsAccessor = new FieldsAccessorFieldThenProp(true);
        this.ignoreSet = ignoreSet;
        this.view = view;
        this.respectIgnore = respectIgnore;
        this.acceptSingleValueAsArray = false;
    }

    public Mapper(Set<String> ignoreSet) {
        this.fieldsAccessor = new FieldsAccessorFieldThenProp(true);
        this.ignoreSet = ignoreSet;
        this.view = null;
        this.respectIgnore = true;
        this.acceptSingleValueAsArray = false;
    }

    public Mapper(boolean acceptSingleValueAsArray) {
        this.fieldsAccessor = new FieldsAccessorFieldThenProp(true);
        this.ignoreSet = null;
        this.view = null;
        this.respectIgnore = true;
        this.acceptSingleValueAsArray = acceptSingleValueAsArray;
    }

    public Mapper() {
        this.fieldsAccessor = new FieldsAccessorFieldThenProp(true);
        this.ignoreSet = null;
        this.view = null;
        this.respectIgnore = true;
        this.acceptSingleValueAsArray = false;
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> convertListOfMapsToObjects(List<Map> list, Class<T> componentType) {
        ArrayList<T> newList = new ArrayList<T>(list.size());
        for (Map map : list) {
            void var5_5;
            if (map instanceof Value) {
                Object object = ((Value)((Object)map)).toValue();
            }
            if (var5_5 instanceof Map) {
                Map map2 = (Map)var5_5;
                if (map2 instanceof ValueMapImpl) {
                    newList.add(this.fromValueMap(map2, componentType));
                    continue;
                }
                newList.add(this.fromMap(map2, componentType));
                continue;
            }
            newList.add(Conversions.coerce(componentType, var5_5));
        }
        return newList;
    }

    public <T> T fromMap(Map<String, Object> map, Class<T> cls) {
        T toObject = Reflection.newInstance(cls);
        Map<String, FieldAccess> fields = this.fieldsAccessor.getFields(toObject.getClass());
        Set<Map.Entry<String, Object>> mapKeyValuesEntrySet = map.entrySet();
        for (Map.Entry<String, Object> mapEntry : mapKeyValuesEntrySet) {
            FieldAccess field;
            String key = mapEntry.getKey();
            if (this.ignoreSet != null && this.ignoreSet.contains(key) || (field = fields.get(this.fieldsAccessor.isCaseInsensitive() ? key.toLowerCase() : key)) == null || this.view != null && !field.isViewActive(this.view) || this.respectIgnore && field.ignore()) continue;
            Object value = mapEntry.getValue();
            if (value instanceof Value) {
                if (((Value)value).isContainer()) {
                    value = ((Value)value).toValue();
                } else {
                    field.setFromValue(toObject, (Value)value);
                    continue;
                }
            }
            if (value == null) {
                field.setObject(toObject, null);
                continue;
            }
            if (value.getClass() == field.type() || field.type() == Object.class) {
                field.setValue(toObject, value);
                continue;
            }
            if (Typ.isBasicType(value)) {
                field.setValue(toObject, value);
                continue;
            }
            if (value instanceof Map) {
                this.setFieldValueFromMap(toObject, field, (Map)value);
                continue;
            }
            if (value instanceof Collection) {
                this.processCollectionFromMapUsingFields(toObject, field, (Collection)value);
                continue;
            }
            if (value instanceof Map[]) {
                this.processArrayOfMaps(toObject, field, (Map[])value);
                continue;
            }
            field.setValue(toObject, value);
        }
        return toObject;
    }

    public <T> T fromList(List<?> argList, Class<T> clazz) {
        int size = argList.size();
        ArrayList<Object> convertedArguments = new ArrayList<Object>(argList);
        ClassMeta<T> classMeta = ClassMeta.classMeta(clazz);
        ConstructorAccess<T> constructorToMatch = null;
        Object[] finalArgs = null;
        boolean[] flag = new boolean[1];
        try {
            constructorToMatch = this.lookupConstructorMeta(size, convertedArguments, classMeta, constructorToMatch, flag, false);
            if (constructorToMatch == null) {
                constructorToMatch = this.lookupConstructorMeta(size, convertedArguments, classMeta, constructorToMatch, flag, true);
            }
            if (constructorToMatch != null) {
                finalArgs = convertedArguments.toArray(new Object[convertedArguments.size()]);
                return constructorToMatch.create(finalArgs);
            }
            return (T)Exceptions.die(Object.class, "Unable to convert list", convertedArguments, "into", clazz);
        }
        catch (Exception e) {
            if (constructorToMatch != null) {
                CharBuf buf = CharBuf.create(200);
                buf.addLine();
                buf.multiply('-', 10).add("FINAL ARGUMENTS").multiply('-', 10).addLine();
                if (finalArgs != null) {
                    for (Object o : finalArgs) {
                        buf.puts("argument type    ", Boon.className(o));
                    }
                }
                buf.multiply('-', 10).add("CONSTRUCTOR").add(constructorToMatch).multiply('-', 10).addLine();
                buf.multiply('-', 10).add("CONSTRUCTOR PARAMS").multiply('-', 10).addLine();
                for (Class<?> c : constructorToMatch.parameterTypes()) {
                    buf.puts("constructor type ", c);
                }
                buf.multiply('-', 35).addLine();
                if (Boon.debugOn()) {
                    Boon.puts(buf);
                }
                buf.addLine("PARAMETER TYPES");
                buf.add(Lists.list(constructorToMatch.parameterTypes())).addLine();
                buf.addLine("ORIGINAL TYPES PASSED");
                buf.add(Type.gatherTypes(convertedArguments)).addLine();
                buf.add(Type.gatherActualTypes(convertedArguments)).addLine();
                buf.addLine("CONVERTED ARGUMENT TYPES");
                buf.add(Type.gatherTypes(convertedArguments)).addLine();
                buf.add(Type.gatherActualTypes(convertedArguments)).addLine();
                Boon.error(e, "unable to create object based on constructor", buf);
                return (T)Exceptions.handle(Object.class, e, buf.toString());
            }
            return (T)Exceptions.handle(Object.class, e, "\nlist args after conversion", convertedArguments, "types", Type.gatherTypes(convertedArguments), "\noriginal args", argList, "original types", Type.gatherTypes(argList));
        }
    }

    private void processArrayOfMaps(Object newInstance, FieldAccess field, Map<String, Object>[] maps) {
        List<Map<String, Object>> list = Lists.list(maps);
        this.handleCollectionOfMaps(newInstance, field, list);
    }

    private void handleCollectionOfMaps(Object newInstance, FieldAccess field, Collection<Map<String, Object>> collectionOfMaps) {
        Collection<Object> newCollection = Conversions.createCollection(field.type(), collectionOfMaps.size());
        Class<?> componentClass = field.getComponentClass();
        if (componentClass != null) {
            for (Map<String, Object> mapComponent : collectionOfMaps) {
                newCollection.add(this.fromMap(mapComponent, componentClass));
            }
            field.setObject(newInstance, newCollection);
        }
    }

    private <T> ConstructorAccess<T> lookupConstructorMeta(int size, List<Object> convertedArguments, ClassMeta<T> classMeta, ConstructorAccess<T> constructorToMatch, boolean[] flag, boolean loose) {
        block0: for (ConstructorAccess<T> constructor : classMeta.constructors()) {
            Class[] parameterTypes = constructor.parameterTypes();
            if (parameterTypes.length != size) continue;
            for (int index = 0; index < size; ++index) {
                if (!this.matchAndConvertArgs(convertedArguments, constructor, parameterTypes, index, flag, loose)) continue block0;
            }
            constructorToMatch = constructor;
        }
        return constructorToMatch;
    }

    private boolean matchAndConvertArgs(List<Object> convertedArgumentList, BaseAccess methodAccess, Class[] parameterTypes, int index, boolean[] flag, boolean loose) {
        try {
            Class parameterClass = parameterTypes[index];
            Object item = convertedArgumentList.get(index);
            Type parameterType = Type.getType(parameterClass);
            if (item instanceof ValueContainer) {
                item = ((ValueContainer)item).toValue();
                convertedArgumentList.set(index, item);
            }
            if (item == null) {
                return true;
            }
            switch (parameterType) {
                case BOOLEAN: 
                case INT: 
                case SHORT: 
                case BYTE: 
                case FLOAT: 
                case DOUBLE: 
                case LONG: 
                case CHAR: {
                    if (item == null) {
                        return false;
                    }
                }
                case NUMBER: 
                case DOUBLE_WRAPPER: 
                case FLOAT_WRAPPER: 
                case INTEGER_WRAPPER: 
                case SHORT_WRAPPER: 
                case BOOLEAN_WRAPPER: 
                case BYTE_WRAPPER: 
                case LONG_WRAPPER: 
                case CHAR_SEQUENCE: 
                case CHAR_WRAPPER: {
                    if (!loose && item instanceof CharSequence) {
                        return false;
                    }
                    Object value = Conversions.coerceWithFlag(parameterType, parameterClass, flag, item);
                    if (!flag[0]) {
                        return false;
                    }
                    convertedArgumentList.set(index, value);
                    return true;
                }
                case CLASS: 
                case STRING: 
                case ENUM: {
                    if (!loose && !(item instanceof CharSequence)) {
                        return false;
                    }
                    Object value = Conversions.coerceWithFlag(parameterType, parameterClass, flag, item);
                    if (!flag[0]) {
                        return false;
                    }
                    convertedArgumentList.set(index, value);
                    return true;
                }
                case MAP: 
                case VALUE_MAP: {
                    if (!(item instanceof Map)) break;
                    Map itemMap = (Map)item;
                    java.lang.reflect.Type type = methodAccess.getGenericParameterTypes()[index];
                    if (!(type instanceof ParameterizedType)) break;
                    ParameterizedType pType = (ParameterizedType)type;
                    Class keyType = (Class)pType.getActualTypeArguments()[0];
                    Class valueType = (Class)pType.getActualTypeArguments()[1];
                    Map<?, ?> newMap = Conversions.createMap(parameterClass, itemMap.size());
                    Iterator i$ = itemMap.entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = i$.next();
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        key = ValueContainer.toObject(key);
                        value = (value = ValueContainer.toObject(value)) instanceof List ? this.fromList((List)value, valueType) : (value instanceof Map ? this.fromMap((Map)value, valueType) : Conversions.coerce(valueType, value));
                        key = key instanceof List ? this.fromList((List)key, keyType) : (value instanceof Map ? this.fromMap((Map)key, keyType) : Conversions.coerce(keyType, key));
                        newMap.put(key, value);
                    }
                    convertedArgumentList.set(index, newMap);
                    return true;
                }
                case INSTANCE: {
                    if (parameterClass.isInstance(item)) {
                        return true;
                    }
                    if (item instanceof Map) {
                        item = this.fromMap((Map)item, parameterClass);
                        convertedArgumentList.set(index, item);
                        return true;
                    }
                    if (item instanceof List) {
                        List listItem = null;
                        listItem = (List)item;
                        Object value = this.fromList(listItem, parameterClass);
                        convertedArgumentList.set(index, value);
                        return true;
                    }
                    convertedArgumentList.set(index, Conversions.coerce(parameterClass, item));
                    return true;
                }
                case INTERFACE: 
                case ABSTRACT: {
                    if (parameterClass.isInstance(item)) {
                        return true;
                    }
                    if (!(item instanceof Map)) break;
                    String className = (String)((Map)item).get("class");
                    if (className != null) {
                        item = this.fromMap((Map)item, Reflection.loadClass(className));
                        convertedArgumentList.set(index, item);
                        return true;
                    }
                    return false;
                }
                case LIST: 
                case SET: 
                case COLLECTION: {
                    if (item instanceof List) {
                        List itemList = (List)item;
                        if (itemList.size() > 0 && (itemList.get(0) instanceof List || itemList.get(0) instanceof ValueContainer)) {
                            java.lang.reflect.Type type = methodAccess.getGenericParameterTypes()[index];
                            if (type instanceof ParameterizedType) {
                                ParameterizedType pType = (ParameterizedType)type;
                                Class componentType = !(pType.getActualTypeArguments()[0] instanceof Class) ? Object.class : (Class)pType.getActualTypeArguments()[0];
                                Collection<Object> newList = Conversions.createCollection(parameterClass, itemList.size());
                                for (Object o : itemList) {
                                    if (o instanceof ValueContainer) {
                                        o = ((ValueContainer)o).toValue();
                                    }
                                    if (componentType == Object.class) {
                                        newList.add(o);
                                        continue;
                                    }
                                    List fromList = (List)o;
                                    o = this.fromList(fromList, componentType);
                                    newList.add(o);
                                }
                                convertedArgumentList.set(index, newList);
                                return true;
                            }
                        } else {
                            java.lang.reflect.Type type = methodAccess.getGenericParameterTypes()[index];
                            if (type instanceof ParameterizedType) {
                                ParameterizedType pType = (ParameterizedType)type;
                                Class componentType = pType.getActualTypeArguments()[0] instanceof Class ? (Class)pType.getActualTypeArguments()[0] : Object.class;
                                Collection<Object> newList = Conversions.createCollection(parameterClass, itemList.size());
                                for (Object o : itemList) {
                                    if (o instanceof ValueContainer) {
                                        o = ((ValueContainer)o).toValue();
                                    }
                                    if (o instanceof List) {
                                        if (componentType != Object.class) {
                                            List fromList = (List)o;
                                            o = this.fromList(fromList, componentType);
                                        }
                                        newList.add(o);
                                        continue;
                                    }
                                    if (o instanceof Map) {
                                        Map fromMap = (Map)o;
                                        o = this.fromMap(fromMap, componentType);
                                        newList.add(o);
                                        continue;
                                    }
                                    newList.add(Conversions.coerce(componentType, o));
                                }
                                convertedArgumentList.set(index, newList);
                                return true;
                            }
                        }
                    }
                    return false;
                }
                default: {
                    Type itemType = Type.getInstanceType(item);
                    switch (itemType) {
                        case LIST: {
                            convertedArgumentList.set(index, this.fromList((List)item, parameterClass));
                            return true;
                        }
                        case MAP: 
                        case VALUE_MAP: {
                            convertedArgumentList.set(index, this.fromMap((Map)item, parameterClass));
                            return true;
                        }
                        case NUMBER: 
                        case BOOLEAN: 
                        case INT: 
                        case SHORT: 
                        case BYTE: 
                        case FLOAT: 
                        case DOUBLE: 
                        case LONG: 
                        case DOUBLE_WRAPPER: 
                        case FLOAT_WRAPPER: 
                        case INTEGER_WRAPPER: 
                        case SHORT_WRAPPER: 
                        case BOOLEAN_WRAPPER: 
                        case BYTE_WRAPPER: 
                        case LONG_WRAPPER: 
                        case CLASS: 
                        case VALUE: {
                            Object value = Conversions.coerceWithFlag(parameterClass, flag, item);
                            if (!flag[0]) {
                                return false;
                            }
                            convertedArgumentList.set(index, value);
                            return true;
                        }
                        case CHAR_SEQUENCE: 
                        case STRING: {
                            Object value = Conversions.coerceWithFlag(parameterClass, flag, item);
                            if (!flag[0]) {
                                return false;
                            }
                            convertedArgumentList.set(index, value);
                            return true;
                        }
                    }
                }
            }
            if (parameterClass.isInstance(item)) {
                return true;
            }
        }
        catch (Exception ex) {
            Boon.error(ex, "PROBLEM WITH oldMatchAndConvertArgs", "respectIgnore", this.respectIgnore, "view", this.view, "fieldsAccessor", this.fieldsAccessor, "list", convertedArgumentList, "constructor", methodAccess, "parameters", parameterTypes, "index", index, "ignoreSet", this.ignoreSet);
            return false;
        }
        return false;
    }

    private void handleCollectionOfValues(Object newInstance, FieldAccess field, Collection<Value> acollectionOfValues) {
        Collection<Value> collectionOfValues = acollectionOfValues;
        if (null == collectionOfValues) {
            field.setObject(newInstance, null);
            return;
        }
        if (field.typeEnum() == Type.INSTANCE) {
            field.setObject(newInstance, this.fromList((List)acollectionOfValues, field.type()));
            return;
        }
        if (collectionOfValues instanceof ValueList) {
            collectionOfValues = ((ValueList)collectionOfValues).list();
        }
        Class<?> componentClass = field.getComponentClass();
        switch (field.typeEnum()) {
            case LIST: 
            case SET: 
            case COLLECTION: {
                Collection<Object> newCollection = Conversions.createCollection(field.type(), collectionOfValues.size());
                for (Value value : (List)collectionOfValues) {
                    if (value.isContainer()) {
                        Object oValue = value.toValue();
                        if (!(oValue instanceof Map)) continue;
                        newCollection.add(this.fromValueMap((Map)oValue, componentClass));
                        continue;
                    }
                    newCollection.add(Conversions.coerce(componentClass, value.toValue()));
                }
                field.setObject(newInstance, newCollection);
                break;
            }
            case ARRAY: {
                Type componentType = field.componentType();
                int index = 0;
                switch (componentType) {
                    case INT: {
                        int[] iarray = new int[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            iarray[index] = value.intValue();
                            ++index;
                        }
                        field.setObject(newInstance, iarray);
                        return;
                    }
                    case SHORT: {
                        short[] sarray = new short[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            sarray[index] = value.shortValue();
                            ++index;
                        }
                        field.setObject(newInstance, sarray);
                        return;
                    }
                    case DOUBLE: {
                        double[] darray = new double[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            darray[index] = value.doubleValue();
                            ++index;
                        }
                        field.setObject(newInstance, darray);
                        return;
                    }
                    case FLOAT: {
                        float[] farray = new float[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            farray[index] = value.floatValue();
                            ++index;
                        }
                        field.setObject(newInstance, farray);
                        return;
                    }
                    case LONG: {
                        long[] larray = new long[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            larray[index] = value.longValue();
                            ++index;
                        }
                        field.setObject(newInstance, larray);
                        return;
                    }
                    case BYTE: {
                        byte[] barray = new byte[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            barray[index] = value.byteValue();
                            ++index;
                        }
                        field.setObject(newInstance, barray);
                        return;
                    }
                    case CHAR: {
                        char[] chars = new char[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            chars[index] = value.charValue();
                            ++index;
                        }
                        field.setObject(newInstance, chars);
                        return;
                    }
                    case STRING: {
                        CharBuf buffer = CharBuf.create(100);
                        String[] strings = new String[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            strings[index] = value.stringValue(buffer);
                            ++index;
                        }
                        field.setObject(newInstance, strings);
                        return;
                    }
                }
                Object array = Array.newInstance(componentClass, collectionOfValues.size());
                for (Value value : (List)collectionOfValues) {
                    Object o;
                    if (value instanceof ValueContainer) {
                        o = value.toValue();
                        if (o instanceof List) {
                            if (!componentClass.isInstance(o = this.fromList((List)o, componentClass))) break;
                            Array.set(array, index, o);
                        } else if (o instanceof Map) {
                            if (!componentClass.isInstance(o = this.fromMap((Map)o, componentClass))) break;
                            Array.set(array, index, o);
                        }
                    } else {
                        o = value.toValue();
                        if (componentClass.isInstance(o)) {
                            Array.set(array, index, o);
                        } else {
                            Array.set(array, index, Conversions.coerce(componentClass, o));
                        }
                    }
                    ++index;
                }
                field.setValue(newInstance, array);
            }
        }
    }

    public Object fromValueMap(Map<String, Value> valueMap) {
        try {
            String className = valueMap.get("class").toString();
            Class<?> cls = Reflection.loadClass(className);
            return this.fromValueMap(valueMap, cls);
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, Boon.sputs("fromValueMap", "map", valueMap, "fieldAccessor", this.fieldsAccessor), ex);
        }
    }

    public <T> T fromValueMap(Map<String, Value> valueMap, Class<T> cls) {
        Map.Entry<String, Value>[] entries;
        int size;
        T newInstance = Reflection.newInstance(cls);
        ValueMap map = (ValueMap)valueMap;
        Map<String, FieldAccess> fields = this.fieldsAccessor.getFields(cls);
        FieldAccess field = null;
        String fieldName = null;
        if (!map.hydrated()) {
            size = map.len();
            entries = map.items();
        } else {
            size = map.size();
            entries = map.entrySet().toArray(new Map.Entry[size]);
        }
        if (size == 0 || entries == null) {
            return newInstance;
        }
        for (int index = 0; index < size; ++index) {
            Value value = null;
            try {
                Map.Entry<String, Value> entry = entries[index];
                fieldName = entry.getKey();
                if (this.ignoreSet != null && this.ignoreSet.contains(fieldName) || (field = fields.get(this.fieldsAccessor.isCaseInsensitive() ? fieldName.toLowerCase() : fieldName)) == null || this.view != null && !field.isViewActive(this.view) || this.respectIgnore && field.ignore()) continue;
                value = entry.getValue();
                if (value instanceof Value) {
                    this.fromValueMapHandleValueCase(newInstance, field, value);
                    continue;
                }
                this.fromMapHandleNonValueCase(newInstance, field, value);
                continue;
            }
            catch (Exception ex) {
                return (T)Exceptions.handle(Object.class, ex, "fieldName", fieldName, "of class", cls, "had issues for value", value, "for field", field);
            }
        }
        return newInstance;
    }

    private <T> void fromMapHandleNonValueCase(T newInstance, FieldAccess field, Object objectValue) {
        try {
            if (objectValue instanceof Map) {
                Class<?> clazz = field.type();
                if (!clazz.isInterface() && !Typ.isAbstract(clazz)) {
                    objectValue = this.fromValueMap((Map)objectValue, field.type());
                } else {
                    String className = ((Value)((Map)objectValue).get("class")).toString();
                    Class<?> cls = Reflection.loadClass(className);
                    objectValue = this.fromValueMap((Map)objectValue, cls);
                }
                field.setValue(newInstance, objectValue);
            } else if (objectValue instanceof Collection) {
                this.handleCollectionOfValues(newInstance, field, (Collection)objectValue);
            } else {
                field.setValue(newInstance, objectValue);
            }
        }
        catch (Exception ex) {
            Exceptions.handle(Boon.sputs("Problem handling non value case of fromValueMap", "field", field.name(), "fieldType", field.type().getName(), "object from map", objectValue), (Throwable)ex);
        }
    }

    private <T> void fromValueMapHandleValueCase(T newInstance, FieldAccess field, Value value) {
        List<Object> objValue = ValueContainer.toObject(value);
        Class<?> clazz = field.type();
        switch (field.typeEnum()) {
            case INTERFACE: 
            case ABSTRACT: 
            case OBJECT: {
                if (objValue instanceof Map) {
                    Map valueMap = (Map)((Object)objValue);
                    Value aClass = (Value)valueMap.get("class");
                    clazz = Reflection.loadClass(aClass.stringValue());
                }
            }
            case INSTANCE: {
                switch (value.type()) {
                    case MAP: {
                        objValue = this.fromValueMap((Map)((Object)objValue), clazz);
                        break;
                    }
                    case LIST: {
                        objValue = this.fromList(objValue, clazz);
                    }
                }
                field.setValue(newInstance, objValue);
                break;
            }
            case MAP: 
            case VALUE_MAP: {
                Class keyType = (Class)field.getParameterizedType().getActualTypeArguments()[0];
                Class valueType = (Class)field.getParameterizedType().getActualTypeArguments()[1];
                Map mapInner = (Map)((Object)objValue);
                Set set = mapInner.entrySet();
                LinkedHashMap newMap = new LinkedHashMap();
                for (Map.Entry entry : set) {
                    Object evalue = entry.getValue();
                    Object key = entry.getKey();
                    if (evalue instanceof ValueContainer) {
                        evalue = ((ValueContainer)evalue).toValue();
                    }
                    key = Conversions.coerce(keyType, key);
                    evalue = Conversions.coerce(valueType, evalue);
                    newMap.put(key, evalue);
                }
                objValue = newMap;
                field.setValue(newInstance, objValue);
                break;
            }
            case LIST: 
            case SET: 
            case COLLECTION: 
            case ARRAY: {
                if (this.acceptSingleValueAsArray && ValueContainer.NULL != value && !(objValue instanceof Collection)) {
                    objValue = objValue instanceof ValueMapImpl ? Arrays.asList(new ValueContainer(objValue, Type.MAP, false)) : Arrays.asList(objValue);
                }
                this.handleCollectionOfValues(newInstance, field, (Collection<Value>)objValue);
                break;
            }
            default: {
                field.setFromValue(newInstance, value);
            }
        }
    }

    private void setFieldValueFromMap(Object parentObject, FieldAccess field, Map mapInner) {
        Class<?> fieldClassType = field.type();
        LinkedHashMap value = null;
        if (!Typ.isMap(fieldClassType)) {
            Object oClassName;
            value = !fieldClassType.isInterface() && !Typ.isAbstract(fieldClassType) ? (LinkedHashMap)this.fromMap(mapInner, field.type()) : ((oClassName = mapInner.get("class")) != null ? (LinkedHashMap)this.fromMap(mapInner, Reflection.loadClass(oClassName.toString())) : null);
        } else if (Typ.isMap(fieldClassType)) {
            Class keyType = (Class)field.getParameterizedType().getActualTypeArguments()[0];
            Class valueType = (Class)field.getParameterizedType().getActualTypeArguments()[1];
            Set set = mapInner.entrySet();
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry entry : set) {
                Object evalue = entry.getValue();
                Object key = entry.getKey();
                if (evalue instanceof ValueContainer) {
                    evalue = ((ValueContainer)evalue).toValue();
                }
                key = Conversions.coerce(keyType, key);
                evalue = Conversions.coerce(valueType, evalue);
                newMap.put(key, evalue);
            }
            value = newMap;
        }
        field.setValue(parentObject, value);
    }

    private void processCollectionFromMapUsingFields(Object newInstance, FieldAccess field, Collection<?> collection) {
        Class<?> fieldComponentClass = field.getComponentClass();
        Class<?> valueComponentClass = Reflection.getComponentType(collection);
        if (Typ.isMap(valueComponentClass)) {
            this.handleCollectionOfMaps(newInstance, field, collection);
            return;
        }
        if (Typ.isValue(valueComponentClass)) {
            this.handleCollectionOfValues(newInstance, field, collection);
            return;
        }
        if (Typ.implementsInterface(collection.getClass(), field.type()) && fieldComponentClass != null && fieldComponentClass.isAssignableFrom(valueComponentClass)) {
            field.setValue(newInstance, collection);
            return;
        }
        if (!field.typeEnum().isCollection()) {
            if (collection instanceof List) {
                try {
                    Object value = this.fromList((List)collection, field.getComponentClass());
                    field.setValue(newInstance, value);
                }
                catch (Exception ex) {
                    field.setValue(newInstance, collection);
                }
            } else {
                field.setValue(newInstance, collection);
            }
            return;
        }
        Collection<Object> newCollection = Conversions.createCollection(field.type(), collection.size());
        if (fieldComponentClass == null || fieldComponentClass.isAssignableFrom(valueComponentClass)) {
            newCollection.addAll(collection);
            field.setValue(newInstance, newCollection);
            return;
        }
        for (Map<String, Object> itemValue : collection) {
            newCollection.add(Conversions.coerce(fieldComponentClass, itemValue));
            field.setValue(newInstance, newCollection);
        }
    }

    public Object fromMap(Map<String, Object> map) {
        String clazz = (String)map.get("class");
        Class<?> cls = Reflection.loadClass(clazz);
        return this.fromMap(map, cls);
    }

    public Map<String, Object> toMap(Object object) {
        if (object == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map<String, FieldAccess> fieldMap = Reflection.getAllAccessorFields(object.getClass());
        ArrayList<FieldAccess> fields = new ArrayList<FieldAccess>(fieldMap.values());
        Collections.reverse(fields);
        List<Maps.Entry<String, Object>> entries = Conversions.mapFilterNulls(new FieldToEntryConverter(object), fields);
        map.put("class", object.getClass().getName());
        for (Maps.Entry<String, Object> entry : entries) {
            Object value;
            String key = entry.key();
            if (this.ignoreSet != null && this.ignoreSet.contains(key) || (value = entry.value()) == null) continue;
            if (Typ.isBasicType(value)) {
                map.put(key, entry.value());
                continue;
            }
            if (Boon.isArray(value) && Typ.isBasicType(value.getClass().getComponentType())) {
                map.put(key, entry.value());
                continue;
            }
            if (Boon.isArray(value)) {
                int length = Arry.len(value);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(length);
                for (int index = 0; index < length; ++index) {
                    Object item = BeanUtils.idx(value, index);
                    list.add(this.toMap(item));
                }
                map.put(key, list);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Class<?> componentType = Reflection.getComponentType(collection, fieldMap.get(entry.key()));
                if (Typ.isBasicType(componentType)) {
                    map.put(key, value);
                    continue;
                }
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(collection.size());
                for (Object item : collection) {
                    if (item == null) continue;
                    list.add(this.toMap(item));
                }
                map.put(entry.key(), list);
                continue;
            }
            if (value instanceof Map) {
                map.put(entry.key(), value);
                continue;
            }
            map.put(entry.key(), this.toMap(value));
        }
        return map;
    }

    public List<Map<String, Object>> toListOfMaps(Collection<?> collection) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Object o : collection) {
            list.add(this.toMap(o));
        }
        return list;
    }

    public List<?> toList(Object object) {
        Type instanceType = Type.getInstanceType(object);
        switch (instanceType) {
            case NULL: {
                return Lists.list(new Object[]{null});
            }
            case ARRAY: {
                return Conversions.toList(object);
            }
            case INSTANCE: {
                if (!Reflection.respondsTo(object, "toList")) break;
                return (List)Reflection.invoke(object, "toList", new Object[0]);
            }
        }
        return Lists.list(object);
    }

    public static class FieldToEntryConverter
    implements Function<FieldAccess, Maps.Entry<String, Object>> {
        final Object object;

        public FieldToEntryConverter(Object object) {
            this.object = object;
        }

        @Override
        public Maps.Entry<String, Object> apply(FieldAccess from) {
            if (from.isReadOnly()) {
                return null;
            }
            Maps.EntryImpl<String, Object> entry = new Maps.EntryImpl<String, Object>(from.name(), from.getValue(this.object));
            return entry;
        }
    }
}

