/*
 * Decompiled with CFR 0.152.
 */
package org.boon.template;

import java.util.ArrayList;
import java.util.List;
import org.boon.Boon;
import org.boon.core.reflection.FastStringUtils;
import org.boon.primitive.CharScanner;

public class HandleBarsCoreParser {
    char[] charArray;
    int index;
    int ch;
    private List<Token> tokenList;

    public void TemplateParser() {
    }

    public void parse(String string) {
        this.charArray = FastStringUtils.toCharArray(string);
        this.index = 0;
        this.tokenList = new ArrayList<Token>();
        this.processLoop();
    }

    private void processLoop() {
        int startIndex = 0;
        do {
            startIndex = this.index;
            this.index = CharScanner.findChars(TokenTypes.EXPRESSION_START.chars, this.index, this.charArray);
            if (this.index > 0) {
                this.tokenList.add(Token.text(startIndex, this.index));
                this.index += TokenTypes.EXPRESSION_START.chars.length;
                if (this.handleCommandOrExpression()) continue;
            } else {
                this.tokenList.add(Token.text(startIndex, this.charArray.length));
            }
            break;
        } while (this.index <= this.charArray.length && this.index != -1);
    }

    private boolean handleCommandOrExpression() {
        if (this.index > this.charArray.length) {
            return false;
        }
        this.ch = this.charArray[this.index];
        if (this.ch == 35) {
            return this.handleCommand();
        }
        return this.handleExpression();
    }

    private boolean handleExpression() {
        int startIndex = this.index;
        this.index = CharScanner.findChars(TokenTypes.EXPRESSION_END.chars, this.index, this.charArray);
        if (this.index > 0) {
            this.tokenList.add(Token.expression(startIndex, this.index));
            this.index += TokenTypes.EXPRESSION_END.chars.length;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleCommand() {
        int startIndex = this.index + 1;
        this.index = CharScanner.findChars(TokenTypes.EXPRESSION_END.chars, this.index, this.charArray);
        if (this.index == -1) {
            return false;
        }
        this.tokenList.add(Token.commandStart(startIndex, this.index));
        this.index += TokenTypes.EXPRESSION_END.chars.length;
        Token commandBody = Token.commandBody(this.index, -1);
        this.tokenList.add(commandBody);
        while (true) {
            startIndex = this.index;
            this.index = CharScanner.findChars(TokenTypes.EXPRESSION_START.chars, this.index, this.charArray);
            if (this.index == -1) {
                return false;
            }
            this.tokenList.add(Token.text(startIndex, this.index));
            this.index += TokenTypes.EXPRESSION_START.chars.length;
            if (this.index >= this.charArray.length) {
                return false;
            }
            this.ch = this.charArray[this.index];
            if (this.ch == 35) {
                if (this.handleCommand()) continue;
                return true;
            }
            if (this.ch == 47) {
                commandBody.stop = this.index - 3;
                this.index = CharScanner.findChars(TokenTypes.EXPRESSION_END.chars, this.index, this.charArray);
                if (this.index < 0) {
                    return false;
                }
                this.index += TokenTypes.EXPRESSION_END.chars.length;
                return true;
            }
            if (!this.handleExpression()) return true;
        }
    }

    public static void main(String ... args) {
        HandleBarsCoreParser parser = new HandleBarsCoreParser();
        Boon.putl(parser.tokenList);
        parser.parse("Hi Mom {{#if test}}{{fine}}{{/if}} How are you?");
        Boon.putl(parser.tokenList);
        parser.parse("Hi Mom {{#if test}} Good {{fine}} Good {{#if}}boyyah{{/if}} {{/if}} How are you?");
        Boon.putl(parser.tokenList);
    }

    public static enum TokenTypes {
        COMMAND(""),
        COMMAND_BODY(""),
        EXPRESSION(""),
        COMMAND_START("{{#"),
        COMMAND_END_START("{{/"),
        EXPRESSION_START("{{"),
        EXPRESSION_END("}}"),
        TEXT("");

        char[] chars;

        private TokenTypes(String str) {
            this.chars = FastStringUtils.toCharArray(str);
        }
    }

    public static class Token {
        int start;
        int stop;
        TokenTypes type;

        public Token(int start, int stop, TokenTypes type) {
            this.start = start;
            this.stop = stop;
            this.type = type;
        }

        public Token() {
        }

        public static Token text(int start, int stop) {
            Token token = new Token();
            token.start = start;
            token.stop = stop;
            token.type = TokenTypes.TEXT;
            return token;
        }

        public static Token commandStart(int start, int stop) {
            Token token = new Token();
            token.start = start;
            token.stop = stop;
            token.type = TokenTypes.COMMAND;
            return token;
        }

        public static Token commandBody(int start, int stop) {
            Token token = new Token();
            token.start = start;
            token.stop = stop;
            token.type = TokenTypes.COMMAND_BODY;
            return token;
        }

        public static Token expression(int start, int stop) {
            Token token = new Token();
            token.start = start;
            token.stop = stop;
            token.type = TokenTypes.EXPRESSION;
            return token;
        }

        public String toString() {
            return "Token{start=" + this.start + ", stop=" + this.stop + ", type=" + (Object)((Object)this.type) + '}';
        }
    }
}

