/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Str;
import org.boon.cache.Cache;
import org.boon.cache.CacheType;
import org.boon.cache.SimpleCache;
import org.boon.core.Dates;
import org.boon.core.reflection.FastStringUtils;
import org.boon.primitive.Byt;
import org.boon.primitive.ByteScanner;
import org.boon.primitive.CharScanner;
import org.boon.primitive.Chr;

public class CharBuf
extends PrintWriter
implements CharSequence {
    protected int capacity = 16;
    protected int location = 0;
    protected char[] buffer;
    private Cache<Integer, char[]> icache;
    final char[] trueChars = "true".toCharArray();
    final char[] falseChars = "false".toCharArray();
    private Cache<Double, char[]> dcache;
    private Cache<Float, char[]> fcache;
    int jsonControlCount;
    final byte[] encoded = new byte[2];
    final byte[] charTo = new byte[2];
    static final char[] nullChars = "null".toCharArray();
    private Cache<BigDecimal, char[]> bigDCache;
    private Cache<BigInteger, char[]> bigICache;
    private Cache<Long, char[]> lcache;
    private Cache<Currency, char[]> currencyCache;
    static final char[] controlMap = new char[255];
    protected static final int DOUBLE_QUOTE = 34;
    protected static final int ESCAPE = 92;
    protected static final int LETTER_N = 110;
    protected static final int LETTER_U = 117;
    protected static final int LETTER_T = 116;
    protected static final int LETTER_R = 114;
    protected static final int LETTER_B = 98;
    protected static final int LETTER_F = 102;
    protected static final int FORWARD_SLASH = 47;

    public CharBuf(char[] buffer) {
        super(CharBuf.writer());
        this.buffer = buffer;
        this.capacity = buffer.length;
    }

    public CharBuf(byte[] bytes) {
        super(CharBuf.writer());
        String str = new String(bytes, StandardCharsets.UTF_8);
        this.buffer = FastStringUtils.toCharArray(str);
        this.location = this.buffer.length;
        this.capacity = this.buffer.length;
    }

    public static CharBuf createExact(int capacity) {
        return new CharBuf(capacity){

            @Override
            public CharBuf add(char[] chars) {
                Chr._idx(this.buffer, this.location, chars);
                this.location += chars.length;
                return this;
            }
        };
    }

    public static CharBuf create(int capacity) {
        return new CharBuf(capacity);
    }

    public static CharBuf createCharBuf(int capacity) {
        return new CharBuf(capacity);
    }

    public static CharBuf createCharBuf() {
        return new CharBuf(100);
    }

    public static CharBuf create(char[] buffer) {
        return new CharBuf(buffer);
    }

    public static CharBuf createFromUTF8Bytes(byte[] buffer) {
        return new CharBuf(buffer);
    }

    protected CharBuf(int capacity) {
        super(CharBuf.writer());
        this.capacity = capacity;
        this.init();
    }

    protected CharBuf() {
        super(CharBuf.writer());
        this.init();
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off == 0 && cbuf.length == len) {
            this.add(cbuf);
        } else {
            char[] buffer = Arrays.copyOfRange(cbuf, off, off + len);
            this.add(buffer);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public void init() {
        this.buffer = new char[this.capacity];
    }

    public final CharBuf add(Object str) {
        this.add(FastStringUtils.toCharArray(Str.str(str)));
        return this;
    }

    public final CharBuf add(String str) {
        this.add(FastStringUtils.toCharArray(str));
        return this;
    }

    public final CharBuf add(CharSequence str) {
        this.add(FastStringUtils.toCharArray(str));
        return this;
    }

    public final CharBuf addString(String str) {
        this.add(FastStringUtils.toCharArray(str));
        return this;
    }

    public final CharBuf addObject(Object object) {
        String str = object.toString();
        this.addString(str);
        return this;
    }

    public final CharBuf add(int i) {
        this.add(Integer.toString(i));
        return this;
    }

    public final CharBuf addInt(int i) {
        switch (i) {
            case 0: {
                this.addChar('0');
                return this;
            }
            case 1: {
                this.addChar('1');
                return this;
            }
            case -1: {
                this.addChar('-');
                this.addChar('1');
                return this;
            }
        }
        this.addInt((Integer)i);
        return this;
    }

    public final CharBuf addInt(Integer key) {
        char[] chars;
        if (this.icache == null) {
            this.icache = new SimpleCache<Integer, char[]>(1000, CacheType.LRU);
        }
        if ((chars = this.icache.get(key)) == null) {
            String str = Integer.toString(key);
            chars = FastStringUtils.toCharArray(str);
            this.icache.put(key, chars);
        }
        this.addChars(chars);
        return this;
    }

    public final CharBuf add(boolean b) {
        this.addChars(b ? this.trueChars : this.falseChars);
        return this;
    }

    public final CharBuf addBoolean(boolean b) {
        this.add(Boolean.toString(b));
        return this;
    }

    public final CharBuf add(byte i) {
        this.add(Byte.toString(i));
        return this;
    }

    public final CharBuf addByte(byte i) {
        this.addInt(i);
        return this;
    }

    public final CharBuf add(short i) {
        this.add(Short.toString(i));
        return this;
    }

    public final CharBuf addShort(short i) {
        this.addInt(i);
        return this;
    }

    public final CharBuf add(long l) {
        this.add(Long.toString(l));
        return this;
    }

    public final CharBuf add(double d) {
        this.add(Double.toString(d));
        return this;
    }

    public final CharBuf addDouble(double d) {
        this.addDouble((Double)d);
        return this;
    }

    public final CharBuf addDouble(Double key) {
        char[] chars;
        if (this.dcache == null) {
            this.dcache = new SimpleCache<Double, char[]>(100, CacheType.LRU);
        }
        if ((chars = this.dcache.get(key)) == null) {
            String str = Double.toString(key);
            chars = FastStringUtils.toCharArray(str);
            this.dcache.put(key, chars);
        }
        this.add(chars);
        return this;
    }

    public final CharBuf add(float d) {
        this.add(Float.toString(d));
        return this;
    }

    public final CharBuf addFloat(float d) {
        this.addFloat(Float.valueOf(d));
        return this;
    }

    public final CharBuf addFloat(Float key) {
        char[] chars;
        if (this.fcache == null) {
            this.fcache = new SimpleCache<Float, char[]>(100, CacheType.LRU);
        }
        if ((chars = this.fcache.get(key)) == null) {
            String str = Float.toString(key.floatValue());
            chars = FastStringUtils.toCharArray(str);
            this.fcache.put(key, chars);
        }
        this.add(chars);
        return this;
    }

    public final CharBuf addChar(byte i) {
        this.add((char)i);
        return this;
    }

    public final CharBuf addChar(int i) {
        this.add((char)i);
        return this;
    }

    public final CharBuf addChar(short i) {
        this.add((char)i);
        return this;
    }

    public final CharBuf addChar(char ch) {
        if (1 + this.location > this.capacity) {
            this.buffer = Chr.grow(this.buffer);
            this.capacity = this.buffer.length;
        }
        this.buffer[this.location] = ch;
        ++this.location;
        return this;
    }

    public final CharBuf add(char ch) {
        if (1 + this.location > this.capacity) {
            this.buffer = Chr.grow(this.buffer);
            this.capacity = this.buffer.length;
        }
        this.buffer[this.location] = ch;
        ++this.location;
        return this;
    }

    public CharBuf addLine(String str) {
        this.add(FastStringUtils.toCharArray(str));
        this.add('\n');
        return this;
    }

    public CharBuf addLine(Object str) {
        this.add(FastStringUtils.toCharArray(Str.str(str)));
        this.add('\n');
        return this;
    }

    public CharBuf addLine() {
        this.add('\n');
        return this;
    }

    public CharBuf addLine(char[] chars) {
        this.add(chars);
        this.add('\n');
        return this;
    }

    public CharBuf addLine(CharSequence str) {
        this.add(str.toString());
        this.add('\n');
        return this;
    }

    public CharBuf add(char[] chars) {
        if (chars.length + this.location > this.capacity) {
            this.buffer = Chr.grow(this.buffer, this.buffer.length * 2 + chars.length);
            this.capacity = this.buffer.length;
        }
        Chr._idx(this.buffer, this.location, chars);
        this.location += chars.length;
        return this;
    }

    public final CharBuf addChars(char[] chars) {
        if (chars.length + this.location > this.capacity) {
            this.buffer = Chr.grow(this.buffer, this.buffer.length * 2 + chars.length);
            this.capacity = this.buffer.length;
        }
        System.arraycopy(chars, 0, this.buffer, this.location, chars.length);
        this.location += chars.length;
        return this;
    }

    public final CharBuf addQuoted(char[] chars) {
        int sizeNeeded = chars.length + 2 + this.location;
        if (sizeNeeded > this.capacity) {
            this.buffer = Chr.grow(this.buffer, sizeNeeded * 2);
            this.capacity = this.buffer.length;
        }
        this.buffer[this.location] = 34;
        ++this.location;
        System.arraycopy(chars, 0, this.buffer, this.location, chars.length);
        this.location += chars.length;
        this.buffer[this.location] = 34;
        ++this.location;
        return this;
    }

    public final CharBuf asJsonString(String jsonString) {
        char[] charArray = FastStringUtils.toCharArray(jsonString);
        return this.addJsonEscapedString(charArray);
    }

    private static boolean isJSONControlOrUnicode(int c) {
        return c < 30 || c == 34 || c == 92 || c > 126;
    }

    private final boolean hasAnyJSONControlOrUnicodeChars(char[] charArray) {
        int index = 0;
        do {
            char c;
            if (!CharBuf.isJSONControlOrUnicode(c = charArray[index])) continue;
            ++this.jsonControlCount;
        } while (++index < charArray.length);
        return this.jsonControlCount > 0;
    }

    public final CharBuf addJsonEscapedString(char[] charArray) {
        this.jsonControlCount = 0;
        if (charArray.length > 0 && this.hasAnyJSONControlOrUnicodeChars(charArray)) {
            return this.doAddJsonEscapedString(charArray);
        }
        return this.addQuoted(charArray);
    }

    private final CharBuf doAddJsonEscapedString(char[] charArray) {
        char[] _buffer = this.buffer;
        int _location = this.location;
        byte[] _encoded = this.encoded;
        byte[] _charTo = this.charTo;
        int ensureThisMuch = charArray.length + (this.jsonControlCount + 1) * 5;
        int sizeNeeded = ensureThisMuch + _location;
        if (sizeNeeded > this.capacity) {
            int growBy = _buffer.length * 2 < sizeNeeded ? sizeNeeded : _buffer.length * 2;
            _buffer = Chr.grow(_buffer, growBy);
            this.capacity = _buffer.length;
        }
        _buffer[_location] = 34;
        ++_location;
        int index = 0;
        do {
            char c;
            if (CharBuf.isJSONControlOrUnicode(c = charArray[index])) {
                switch (c) {
                    case '\"': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 34;
                        ++_location;
                        break;
                    }
                    case '\\': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 92;
                        ++_location;
                        break;
                    }
                    case '\b': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 98;
                        ++_location;
                        break;
                    }
                    case '\f': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 102;
                        ++_location;
                        break;
                    }
                    case '\n': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 110;
                        ++_location;
                        break;
                    }
                    case '\r': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 114;
                        ++_location;
                        break;
                    }
                    case '\t': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 116;
                        ++_location;
                        break;
                    }
                    default: {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 117;
                        ++_location;
                        if (c <= '\u00ff') {
                            _buffer[_location] = 48;
                            _buffer[++_location] = 48;
                            ++_location;
                            ByteScanner.encodeByteIntoTwoAsciiCharBytes(c, _encoded);
                            for (byte b : _encoded) {
                                _buffer[_location] = (char)b;
                                ++_location;
                            }
                        } else {
                            Byt.charTo(_charTo, c);
                            for (byte charByte : _charTo) {
                                ByteScanner.encodeByteIntoTwoAsciiCharBytes(charByte, _encoded);
                                for (byte b : _encoded) {
                                    _buffer[_location] = (char)b;
                                    ++_location;
                                }
                            }
                        }
                    }
                }
                continue;
            }
            _buffer[_location] = c;
            ++_location;
        } while (++index < charArray.length);
        _buffer[_location] = 34;
        this.buffer = _buffer;
        this.location = ++_location;
        return this;
    }

    public final CharBuf addJsonFieldName(String str) {
        return this.addJsonFieldName(FastStringUtils.toCharArray(str));
    }

    public final CharBuf addJsonFieldName(char[] chars) {
        int sizeNeeded = chars.length + 4 + this.location;
        if (sizeNeeded > this.capacity) {
            this.buffer = Chr.grow(this.buffer, sizeNeeded * 2);
            this.capacity = this.buffer.length;
        }
        this.buffer[this.location] = 34;
        ++this.location;
        System.arraycopy(chars, 0, this.buffer, this.location, chars.length);
        this.location += chars.length;
        this.buffer[this.location] = 34;
        ++this.location;
        this.buffer[this.location] = 58;
        ++this.location;
        return this;
    }

    public final CharBuf addQuoted(String str) {
        char[] chars = FastStringUtils.toCharArray(str);
        this.addQuoted(chars);
        return this;
    }

    public CharBuf add(char[] chars, int length) {
        if (length + this.location < this.capacity) {
            Chr._idx(this.buffer, this.location, chars, length);
        } else {
            this.buffer = Chr.grow(this.buffer, this.buffer.length * 2 + length);
            Chr._idx(this.buffer, this.location, chars);
            this.capacity = this.buffer.length;
        }
        this.location += length;
        return this;
    }

    public CharBuf add(byte[] chars) {
        if (chars.length + this.location < this.capacity) {
            Chr._idx(this.buffer, this.location, chars);
        } else {
            this.buffer = Chr.grow(this.buffer, this.buffer.length * 2 + chars.length);
            Chr._idx(this.buffer, this.location, chars);
            this.capacity = this.buffer.length;
        }
        this.location += chars.length;
        return this;
    }

    public CharBuf add(byte[] bytes, int start, int end) {
        int charsLength = end - start;
        if (charsLength + this.location > this.capacity) {
            this.buffer = Chr.grow(this.buffer, this.buffer.length * 2 + charsLength);
        }
        Chr._idx(this.buffer, this.location, bytes, start, end);
        this.capacity = this.buffer.length;
        this.location += charsLength;
        return this;
    }

    @Override
    public int length() {
        return this.len();
    }

    @Override
    public char charAt(int index) {
        return this.buffer[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new String(this.buffer, start, end - start);
    }

    @Override
    public String toString() {
        return FastStringUtils.noCopyStringFromCharsNoCheck(this.buffer, this.location);
    }

    public String toDebugString() {
        return "CharBuf{capacity=" + this.capacity + ", location=" + this.location + '}';
    }

    public String toStringAndRecycle() {
        String str = new String(this.buffer, 0, this.location);
        this.location = 0;
        return str;
    }

    public int len() {
        return this.location;
    }

    public char[] toCharArray() {
        return this.buffer;
    }

    public void _len(int location) {
        this.location = location;
    }

    public char[] readForRecycle() {
        this.location = 0;
        return this.buffer;
    }

    public void recycle() {
        this.location = 0;
    }

    public double doubleValue() {
        return CharScanner.parseDouble(this.buffer, 0, this.location);
    }

    public float floatValue() {
        return CharScanner.parseFloat(this.buffer, 0, this.location);
    }

    public int intValue() {
        return CharScanner.parseIntFromTo(this.buffer, 0, this.location);
    }

    public long longValue() {
        return CharScanner.parseLongFromTo(this.buffer, 0, this.location);
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public short shortValue() {
        return (short)this.intValue();
    }

    public Number toIntegerWrapper() {
        if (CharScanner.isInteger(this.buffer, 0, this.location)) {
            return this.intValue();
        }
        return this.longValue();
    }

    public void addAsUTF(byte[] value) {
        String str = new String(value, StandardCharsets.UTF_8);
        char[] chars = FastStringUtils.toCharArray(str);
        this.add(chars);
    }

    public final void addNull() {
        this.add(nullChars);
    }

    public void removeLastChar() {
        --this.location;
        if (this.location < 0) {
            this.location = 0;
        }
    }

    public CharBuf addBigDecimal(BigDecimal key) {
        char[] chars;
        if (this.bigDCache == null) {
            this.bigDCache = new SimpleCache<BigDecimal, char[]>(100, CacheType.LRU);
        }
        if ((chars = this.bigDCache.get(key)) == null) {
            String str = key.toString();
            chars = FastStringUtils.toCharArray(str);
            this.bigDCache.put(key, chars);
        }
        this.add(chars);
        return this;
    }

    public CharBuf addBigInteger(BigInteger key) {
        char[] chars;
        if (this.bigICache == null) {
            this.bigICache = new SimpleCache<BigInteger, char[]>(100, CacheType.LRU);
        }
        if ((chars = this.bigICache.get(key)) == null) {
            String str = key.toString();
            chars = FastStringUtils.toCharArray(str);
            this.bigICache.put(key, chars);
        }
        this.add(chars);
        return this;
    }

    public final CharBuf addLong(long l) {
        this.addLong((Long)l);
        return this;
    }

    public final CharBuf addLong(Long key) {
        char[] chars;
        if (this.lcache == null) {
            this.lcache = new SimpleCache<Long, char[]>(100, CacheType.LRU);
        }
        if ((chars = this.lcache.get(key)) == null) {
            String str = Long.toString(key);
            chars = FastStringUtils.toCharArray(str);
            this.lcache.put(key, chars);
        }
        this.add(chars);
        return this;
    }

    public CharBuf addCurrency(Currency key) {
        char[] chars;
        if (this.currencyCache == null) {
            this.currencyCache = new SimpleCache<Currency, char[]>(100, CacheType.LRU);
        }
        if ((chars = this.currencyCache.get(key)) == null) {
            String str = '\"' + key.toString() + '\"';
            chars = FastStringUtils.toCharArray(str);
            this.currencyCache.put(key, chars);
        }
        this.add(chars);
        return this;
    }

    public CharSequence addHex(int decoded) {
        int _location = this.location;
        char[] _buffer = this.buffer;
        int _capacity = this.capacity;
        if (2 + _location > _capacity) {
            _buffer = Chr.grow(_buffer);
            _capacity = _buffer.length;
        }
        _buffer[_location] = (char)CharBuf.encodeNibbleToHexAsciiCharByte(decoded >> 4 & 0xF);
        _buffer[++_location] = (char)CharBuf.encodeNibbleToHexAsciiCharByte(decoded & 0xF);
        this.location = ++_location;
        this.buffer = _buffer;
        this.capacity = _capacity;
        return this;
    }

    protected static int encodeNibbleToHexAsciiCharByte(int nibble) {
        switch (nibble) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return nibble + 48;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return nibble + 87;
            }
        }
        Exceptions.die("illegal nibble: " + nibble);
        return -1;
    }

    public final CharBuf decodeJsonString(char[] chars) {
        return this.decodeJsonString(chars, 0, chars.length);
    }

    public final CharBuf decodeJsonString(char[] chars, int start, int to) {
        int len = to - start;
        char[] buffer = this.buffer;
        int location = this.location;
        if (len > this.capacity) {
            buffer = Chr.grow(buffer, buffer.length * 2 + len);
            this.capacity = buffer.length;
            this.buffer = buffer;
        }
        int index = start;
        while (true) {
            char c;
            if ((c = chars[index]) == '\\' && index < to - 1) {
                if ((c = chars[++index]) != 'u') {
                    buffer[location++] = controlMap[c];
                } else if (index + 4 < to) {
                    String hex = new String(chars, index + 1, 4);
                    char unicode = (char)Integer.parseInt(hex, 16);
                    buffer[location++] = unicode;
                    index += 4;
                }
            } else {
                buffer[location++] = c;
            }
            if (index >= to - 1) break;
            ++index;
        }
        this.buffer = buffer;
        this.location = location;
        return this;
    }

    public final CharBuf decodeJsonString(byte[] bytes, int start, int to) {
        String str = new String(bytes, start, to - start, StandardCharsets.UTF_8);
        char[] chars = FastStringUtils.toCharArray(str);
        this.decodeJsonString(chars);
        return this;
    }

    public void ensure(int i) {
        if (i + this.location > this.capacity) {
            this.buffer = Chr.grow(this.buffer, i * 2);
            this.capacity = this.buffer.length;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof CharSequence) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public CharBuf multiply(char c, int len) {
        for (int index = 0; index < len; ++index) {
            this.add(c);
        }
        return this;
    }

    public CharBuf multiply(CharSequence str, int len) {
        for (int index = 0; index < len; ++index) {
            this.add(str.toString());
        }
        return this;
    }

    public void puts(Object ... messages) {
        for (Object message : messages) {
            if (message == null) {
                this.add("<NULL>");
            } else if (message instanceof char[]) {
                this.add((char[])message);
            } else if (message.getClass().isArray()) {
                this.add(Lists.toListOrSingletonList(message).toString());
            } else {
                this.add(message.toString());
            }
            this.add(' ');
        }
        this.addLine();
    }

    @Override
    public void println(String message) {
        this.addLine(message);
    }

    @Override
    public void println(Object object) {
        this.addLine(Str.toString(object));
    }

    public CharBuf indent(int i) {
        return this.multiply(' ', i);
    }

    public void jsonDate(long millis) {
        Dates.jsonDateChars(new Date(millis), this);
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        return super.append(csq);
    }

    private static Writer writer() {
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public void print(boolean b) {
        this.addBoolean(b);
    }

    @Override
    public void print(char c) {
        this.add(c);
    }

    @Override
    public void print(int i) {
        this.addInt(i);
    }

    @Override
    public void print(long l) {
        this.addLong(l);
    }

    @Override
    public void print(float f) {
        this.add(f);
    }

    @Override
    public void print(double d) {
        this.add(d);
    }

    @Override
    public void print(char[] s) {
        this.addChars(s);
    }

    @Override
    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.addString(s);
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.addLine();
    }

    @Override
    public void println(boolean x) {
        this.addBoolean(x).addLine();
    }

    @Override
    public void println(char x) {
        this.addChar(x).addLine();
    }

    @Override
    public void println(int x) {
        this.addInt(x).addLine();
    }

    @Override
    public void println(long x) {
        this.addLong(x).addLine();
    }

    @Override
    public void println(float x) {
        this.add(x).addLine();
    }

    @Override
    public void println(double x) {
        this.add(x).addLine();
    }

    @Override
    public void println(char[] x) {
        this.add(x).addLine();
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        this.addLine(String.format(format, args));
        return this;
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        this.addLine(String.format(l, format, args));
        return this;
    }

    public void display() {
        System.out.println(this.toString());
    }

    static {
        CharBuf.controlMap[110] = 10;
        CharBuf.controlMap[98] = 8;
        CharBuf.controlMap[47] = 47;
        CharBuf.controlMap[102] = 12;
        CharBuf.controlMap[114] = 13;
        CharBuf.controlMap[116] = 9;
        CharBuf.controlMap[92] = 92;
        CharBuf.controlMap[34] = 34;
    }
}

