/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.boon.Exceptions;

public class MBeans {
    public static Map<String, Object> map(MBeanServer server, ObjectName name) {
        Exceptions.requireNonNull(server, "server cannot be null");
        Exceptions.requireNonNull(name, "name cannot be null");
        MBeanInfo info = null;
        try {
            info = server.getMBeanInfo(name);
            String[] attributeNames = MBeans.getAttributeNames(info);
            HashMap<String, Object> result = new HashMap<String, Object>(attributeNames.length);
            AttributeList attributeList = server.getAttributes(name, attributeNames);
            for (Object obj : attributeList) {
                Attribute attribute = (Attribute)obj;
                result.put(attribute.getName(), MBeans.convertValue(attribute.getValue()));
            }
            return result;
        }
        catch (Exception ex) {
            return Exceptions.handle(Map.class, String.format("Unable to turn mbean into map %s ", name.getCanonicalName()), ex);
        }
    }

    public static String[] getAttributeNames(MBeanInfo info) {
        MBeanAttributeInfo[] attributes = info.getAttributes();
        String[] attributeNames = new String[attributes.length];
        for (int index = 0; index < attributes.length; ++index) {
            attributeNames[index] = attributes[index].getName();
        }
        return attributeNames;
    }

    private static Object convertValue(Object value) {
        if (value == null) {
            value = "null";
        }
        if (value.getClass().isArray()) {
            value = MBeans.convertFromArrayToList(value);
        } else if (value instanceof CompositeData) {
            value = MBeans.convertFromCompositeDataToToMap(value);
        } else if (value instanceof TabularData) {
            value = MBeans.convertFromTabularDataToMap(value);
        }
        return value;
    }

    private static Object convertFromTabularDataToMap(Object value) {
        TabularData data = (TabularData)((Object)value);
        Set<?> keys = data.keySet();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (List key : keys) {
            Object subValue = MBeans.convertValue(data.get(key.toArray()));
            if (key.size() == 1) {
                map.put(MBeans.convertValue(key.get(0)).toString(), subValue);
                continue;
            }
            map.put(MBeans.convertValue(key).toString(), subValue);
        }
        value = map;
        return value;
    }

    private static Object convertFromCompositeDataToToMap(Object value) {
        CompositeData data = (CompositeData)((Object)value);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<String> keySet = data.getCompositeType().keySet();
        for (String key : keySet) {
            map.put(key, MBeans.convertValue(data.get(key)));
        }
        value = map;
        return value;
    }

    private static Object convertFromArrayToList(Object value) {
        ArrayList<Object> list = new ArrayList<Object>();
        int length = Array.getLength(value);
        for (int index = 0; index < length; ++index) {
            list.add(MBeans.convertValue(Array.get(value, index)));
        }
        value = list;
        return value;
    }

    public static DynamicMBean createMBean(Object instance, Class<?> managedInterface) {
        Exceptions.requireNonNull(instance, "instance cannot be null");
        Exceptions.requireNonNull(managedInterface, "managedInterface cannot be null");
        try {
            return new StandardMBean(instance, managedInterface);
        }
        catch (NotCompliantMBeanException ex) {
            return Exceptions.handle(DynamicMBean.class, String.format("createMBean unable to register %s under interface %s", instance.getClass().getName(), managedInterface.getClass().getName()), ex);
        }
    }

    public static void registerMBean(String prefix, String name, Object mbean) {
        Exceptions.requireNonNull(prefix, "prefix can't be null");
        Exceptions.requireNonNull(name, "name can't be null");
        Exceptions.requireNonNull(mbean, "mbean can't be null");
        String nameOfBean = String.format("%s.%s:type=%s", prefix, mbean.getClass().getSimpleName(), name);
        try {
            ObjectName objectName = new ObjectName(nameOfBean);
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            beanServer.registerMBean(mbean, objectName);
        }
        catch (Exception ex) {
            Exceptions.handle(String.format("registerMBean %s %s %s %s", prefix, name, mbean, nameOfBean), (Throwable)ex);
        }
    }
}

