/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.boon.Universal;
import org.boon.collections.DoubleList;
import org.boon.collections.FloatList;
import org.boon.collections.IntList;
import org.boon.collections.LongList;
import org.boon.core.Conversions;
import org.boon.core.Function;
import org.boon.core.Predicate;
import org.boon.core.Reducer;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.ConstructorAccess;
import org.boon.core.reflection.Invoker;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.MethodAccess;
import org.boon.core.reflection.Reflection;

public class Lists {
    public static <T> List<T> lazyAdd(List<T> list, T ... items) {
        list = list == null ? new ArrayList<T>() : list;
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    public static <T> List<T> lazyAdd(ArrayList<T> list, T ... items) {
        list = list == null ? new ArrayList<T>() : list;
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    public static <T> List<T> safeLazyAdd(CopyOnWriteArrayList<T> list, T ... items) {
        list = list == null ? new CopyOnWriteArrayList<T>() : list;
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    public static <T> List<T> lazyAdd(CopyOnWriteArrayList<T> list, T ... items) {
        list = list == null ? new CopyOnWriteArrayList<T>() : list;
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    public static <T> List<T> lazyCreate(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <T> List<T> lazyCreate(ArrayList<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <T> List<T> lazyCreate(CopyOnWriteArrayList<T> list) {
        return list == null ? new CopyOnWriteArrayList() : list;
    }

    public static <T> List<T> safeLazyCreate(CopyOnWriteArrayList<T> list) {
        return list == null ? new CopyOnWriteArrayList() : list;
    }

    public static <T> T fromList(List<Object> list, Class<T> clazz) {
        return MapObjectConversion.fromList(list, clazz);
    }

    public static <V> List<V> list(Class<V> clazz) {
        return new ArrayList();
    }

    public static <V> List<V> copy(Collection<V> collection) {
        return new ArrayList<V>(collection);
    }

    public static <V> List<V> deepCopy(Collection<V> collection) {
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (V v : collection) {
            list.add(BeanUtils.copy(v));
        }
        return list;
    }

    public static <V> List<V> deepCopyToList(Collection<V> src, List<V> dst) {
        for (V v : src) {
            dst.add(BeanUtils.copy(v));
        }
        return dst;
    }

    public static <V, T> List<T> deepCopy(Collection<V> src, Class<T> dest) {
        ArrayList<T> list = new ArrayList<T>(src.size());
        for (V v : src) {
            list.add(BeanUtils.createFromSrc(v, dest));
        }
        return list;
    }

    @Universal
    public static <V> List<V> deepCopy(List<V> list) {
        if (list instanceof LinkedList) {
            return Lists.deepCopyToList(list, new LinkedList());
        }
        if (list instanceof CopyOnWriteArrayList) {
            return Lists.deepCopyToList(list, new CopyOnWriteArrayList());
        }
        return Lists.deepCopy(list);
    }

    public static <V> List<List<V>> lists(Collection<V> ... collections) {
        ArrayList<List<V>> lists = new ArrayList<List<V>>(collections.length);
        for (Collection<V> collection : collections) {
            lists.add(new ArrayList<V>(collection));
        }
        return lists;
    }

    public static <V> List<V> list(Iterable<V> iterable) {
        ArrayList<V> list = new ArrayList<V>();
        for (V o : iterable) {
            list.add(o);
        }
        return list;
    }

    public static List<?> toListOrSingletonList(Object item) {
        if (item == null) {
            return new ArrayList();
        }
        if (item.getClass().isArray()) {
            int length = Array.getLength(item);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int index = 0; index < length; ++index) {
                list.add(Array.get(item, index));
            }
            return list;
        }
        if (item instanceof Collection) {
            return Lists.list((Collection)item);
        }
        if (item instanceof Iterator) {
            return Lists.list((Iterator)item);
        }
        if (item instanceof Enumeration) {
            return Lists.list((Enumeration)item);
        }
        if (item instanceof Iterable) {
            return Lists.list((Iterable)item);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(item);
        return list;
    }

    public static <PROP> List<PROP> toList(List<?> inputList, Class<PROP> cls, String propertyPath) {
        ArrayList<Object> outputList = new ArrayList<Object>();
        for (Object o : inputList) {
            outputList.add(BeanUtils.idx(o, propertyPath));
        }
        return outputList;
    }

    public static IntList toIntList(List<?> inputList, String propertyPath) {
        return IntList.toIntList(inputList, propertyPath);
    }

    public static FloatList toFloatList(List<?> inputList, String propertyPath) {
        return FloatList.toFloatList(inputList, propertyPath);
    }

    public static DoubleList toDoubleList(List<?> inputList, String propertyPath) {
        return DoubleList.toDoubleList(inputList, propertyPath);
    }

    public static LongList toLongList(List<?> inputList, String propertyPath) {
        return LongList.toLongList(inputList, propertyPath);
    }

    public static List<?> toList(List<?> inputList, String propertyPath) {
        ArrayList<Object> outputList = new ArrayList<Object>();
        for (Object o : inputList) {
            outputList.add(BeanUtils.idx(o, propertyPath));
        }
        return outputList;
    }

    public static List<?> toList(Object item) {
        if (item != null && item.getClass().isArray()) {
            int length = Array.getLength(item);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int index = 0; index < length; ++index) {
                list.add(Array.get(item, index));
            }
            return list;
        }
        if (item instanceof Collection) {
            return Lists.list((Collection)item);
        }
        if (item instanceof Iterator) {
            return Lists.list((Iterator)item);
        }
        if (item instanceof Enumeration) {
            return Lists.list((Enumeration)item);
        }
        if (item instanceof Iterable) {
            return Lists.list((Iterable)item);
        }
        return MapObjectConversion.toList(item);
    }

    public static <V, WRAP> List<WRAP> convert(Class<WRAP> wrapper, Iterable<V> collection) {
        ArrayList<WRAP> list = new ArrayList<WRAP>();
        for (V v : collection) {
            list.add(Conversions.coerce(wrapper, v));
        }
        return list;
    }

    public static <V, WRAP> List<WRAP> convert(Class<WRAP> wrapper, Collection<V> collection) {
        ArrayList<WRAP> list = new ArrayList<WRAP>(collection.size());
        for (V v : collection) {
            list.add(Conversions.coerce(wrapper, v));
        }
        return list;
    }

    public static <V, WRAP> List<WRAP> convert(Class<WRAP> wrapper, V[] collection) {
        ArrayList<WRAP> list = new ArrayList<WRAP>(collection.length);
        for (V v : collection) {
            list.add(Conversions.coerce(wrapper, v));
        }
        return list;
    }

    public static <V, WRAP> List<WRAP> wrap(Class<WRAP> wrapper, Iterable<V> collection) {
        ArrayList<WRAP> list = new ArrayList<WRAP>();
        for (V v : collection) {
            WRAP wrap = Reflection.newInstance(wrapper, v);
            list.add(wrap);
        }
        return list;
    }

    public static <V, WRAP> List<WRAP> wrap(Class<WRAP> wrapper, Collection<V> collection) {
        if (collection.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WRAP> list = new ArrayList<WRAP>(collection.size());
        ClassMeta<WRAP> cls = ClassMeta.classMeta(wrapper);
        ConstructorAccess<WRAP> declaredConstructor = cls.declaredConstructor(collection.iterator().next().getClass());
        for (V v : collection) {
            WRAP wrap = declaredConstructor.create(v);
            list.add(wrap);
        }
        return list;
    }

    public static <V, WRAP> List<WRAP> wrap(Class<WRAP> wrapper, V[] collection) {
        ArrayList<WRAP> list = new ArrayList<WRAP>(collection.length);
        for (V v : collection) {
            WRAP wrap = Reflection.newInstance(wrapper, v);
            list.add(wrap);
        }
        return list;
    }

    public static <V> List<V> list(Enumeration<V> enumeration) {
        ArrayList<V> list = new ArrayList<V>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static <V> Enumeration<V> enumeration(List<V> list) {
        final Iterator<V> iter = list.iterator();
        return new Enumeration<V>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public V nextElement() {
                return iter.next();
            }
        };
    }

    public static <V> List<V> list(Iterator<V> iterator) {
        ArrayList<V> list = new ArrayList<V>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    @SafeVarargs
    public static <V> List<V> list(V ... array) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList(array.length);
        Collections.addAll(list, array);
        return list;
    }

    @SafeVarargs
    public static <V> List<V> safeList(V ... array) {
        return new CopyOnWriteArrayList<V>(array);
    }

    @SafeVarargs
    public static <V> List<V> linkedList(V ... array) {
        if (array == null) {
            return new ArrayList();
        }
        LinkedList list = new LinkedList();
        Collections.addAll(list, array);
        return list;
    }

    public static <V> List<V> safeList(Collection<V> collection) {
        return new CopyOnWriteArrayList<V>(collection);
    }

    public static <V> List<V> linkedList(Collection<V> collection) {
        return new LinkedList<V>(collection);
    }

    @Universal
    public static int len(List<?> list) {
        return list.size();
    }

    @Universal
    public static int lengthOf(List<?> list) {
        return Lists.len(list);
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    @Universal
    public static <V> boolean in(V value, List<?> list) {
        return list.contains(value);
    }

    @Universal
    public static <V> void add(List<V> list, V value) {
        list.add(value);
    }

    @Universal
    public static <V> void add(List<V> list, V ... values) {
        for (V v : values) {
            list.add(v);
        }
    }

    @Universal
    public static <T> T atIndex(List<T> list, int index) {
        return Lists.idx(list, index);
    }

    @Universal
    public static <T> T idx(List<T> list, int index) {
        int i = Lists.calculateIndex(list, index);
        if (i > list.size() - 1) {
            i = list.size() - 1;
        }
        return list.get(i);
    }

    public static <T> List idxList(List<T> list, int index) {
        return (List)Lists.idx(list, index);
    }

    public static <T> Map idxMap(List<T> list, int index) {
        return (Map)Lists.idx(list, index);
    }

    @Universal
    public static <V> void atIndex(List<V> list, int index, V v) {
        Lists.idx(list, index, v);
    }

    @Universal
    public static <V> void idx(List<V> list, int index, V v) {
        int i = Lists.calculateIndex(list, index);
        list.set(i, v);
    }

    @Universal
    public static <V> List<V> sliceOf(List<V> list, int startIndex, int endIndex) {
        return Lists.slc(list, startIndex, endIndex);
    }

    @Universal
    public static <V> List<V> slc(List<V> list, int startIndex, int endIndex) {
        int start = Lists.calculateIndex(list, startIndex);
        int end = Lists.calculateIndex(list, endIndex);
        return list.subList(start, end);
    }

    @Universal
    public static <V> List<V> sliceOf(List<V> list, int startIndex) {
        return Lists.slc(list, startIndex);
    }

    @Universal
    public static <V> List<V> slc(List<V> list, int startIndex) {
        return Lists.slc(list, startIndex, list.size());
    }

    @Universal
    public static <V> List<V> endSliceOf(List<V> list, int endIndex) {
        return Lists.slcEnd(list, endIndex);
    }

    @Universal
    public static <V> List<V> slcEnd(List<V> list, int endIndex) {
        return Lists.slc(list, 0, endIndex);
    }

    @Universal
    public static <V> List<V> copy(List<V> list) {
        if (list instanceof LinkedList) {
            return new LinkedList<V>(list);
        }
        if (list instanceof CopyOnWriteArrayList) {
            return new CopyOnWriteArrayList<V>(list);
        }
        return new ArrayList<V>(list);
    }

    @Universal
    public static <V> List<V> copy(CopyOnWriteArrayList<V> list) {
        return new CopyOnWriteArrayList<V>(list);
    }

    @Universal
    public static <V> List<V> copy(ArrayList<V> list) {
        return new ArrayList<V>(list);
    }

    @Universal
    public static <V> List<V> copy(LinkedList<V> list) {
        return new LinkedList<V>(list);
    }

    @Universal
    public static <V> void insert(List<V> list, int index, V v) {
        int i = Lists.calculateIndex(list, index);
        list.add(i, v);
    }

    private static <T> int calculateIndex(List<T> list, int originalIndex) {
        int length = list.size();
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > length) {
            index = length;
        }
        return index;
    }

    public static <T> List<T> listFromProperty(Class<T> propertyType, String propertyPath, Collection<?> list) {
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object item : list) {
            Object newItem = BeanUtils.idx(item, propertyPath);
            newList.add(newItem);
        }
        return newList;
    }

    public static <T> List<T> listFromProperty(Class<T> propertyType, String propertyPath, Iterable<?> list) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (Object item : list) {
            Object newItem = BeanUtils.idx(item, propertyPath);
            newList.add(newItem);
        }
        return newList;
    }

    public static List<Map<String, Object>> toListOfMaps(List<?> list) {
        return MapObjectConversion.toListOfMaps(list);
    }

    public static void setListProperty(List<?> list, String propertyName, Object value) {
        for (Object object : list) {
            BeanUtils.idx(object, propertyName, value);
        }
    }

    public static List<?> mapBy(Object[] objects, Object instance, String methodName) {
        ArrayList<Object> list = new ArrayList<Object>(objects.length);
        for (Object o : objects) {
            list.add(Invoker.invoke(instance, methodName, o));
        }
        return list;
    }

    public static List<?> mapBy(Object[] objects, Class<?> cls, String methodName) {
        ArrayList<Object> list = new ArrayList<Object>(objects.length);
        for (Object o : objects) {
            list.add(Invoker.invoke(cls, methodName, o));
        }
        return list;
    }

    public static List<?> mapBy(Iterable<?> objects, Class<?> cls, String methodName) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : objects) {
            list.add(Invoker.invoke(cls, methodName, o));
        }
        return list;
    }

    public static List<?> mapBy(Iterable<?> objects, Object instance, String methodName) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : objects) {
            list.add(Invoker.invoke(instance, methodName, o));
        }
        return list;
    }

    public static List<?> mapBy(Collection<?> objects, Class<?> cls, String methodName) {
        ArrayList<Object> list = new ArrayList<Object>(objects.size());
        MethodAccess methodAccess = Invoker.invokeMethodAccess(cls, methodName);
        for (Object o : objects) {
            list.add(methodAccess.invokeStatic(o));
        }
        return list;
    }

    public static List<?> mapBy(Collection<?> objects, Object function) {
        MethodAccess methodAccess = Invoker.invokeFunctionMethodAccess(function);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : objects) {
            list.add(methodAccess.invoke(function, o));
        }
        return list;
    }

    public static <T> List<T> mapBy(Class<T> cls, Collection<?> objects, Object function) {
        return Lists.mapBy(objects, function);
    }

    public static List<?> mapBy(Iterable<?> objects, Object function) {
        MethodAccess methodAccess = Invoker.invokeFunctionMethodAccess(function);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : objects) {
            list.add(methodAccess.invoke(function, o));
        }
        return list;
    }

    public static List<?> mapBy(Object[] objects, Object function) {
        MethodAccess methodAccess = Invoker.invokeFunctionMethodAccess(function);
        ArrayList<Object> list = new ArrayList<Object>(objects.length);
        for (Object o : objects) {
            list.add(methodAccess.invoke(function, o));
        }
        return list;
    }

    public static List<?> mapBy(Collection<?> objects, Object object, String methodName) {
        MethodAccess methodAccess = Invoker.invokeMethodAccess(object.getClass(), methodName);
        ArrayList<Object> list = new ArrayList<Object>(objects.size());
        for (Object o : objects) {
            list.add(methodAccess.invoke(object, o));
        }
        return list;
    }

    public static <V, N> List<N> mapBy(V[] array, Function<V, N> function) {
        ArrayList<N> list = new ArrayList<N>(array.length);
        for (V v : array) {
            list.add(function.apply(v));
        }
        return list;
    }

    public static <V, N> List<N> mapBy(Collection<V> array, Function<V, N> function) {
        ArrayList<N> list = new ArrayList<N>(array.size());
        for (V v : array) {
            list.add(function.apply(v));
        }
        return list;
    }

    public static <V, N> List<N> mapBy(Iterable<V> array, Function<V, N> function) {
        ArrayList<N> list = new ArrayList<N>();
        for (V v : array) {
            list.add(function.apply(v));
        }
        return list;
    }

    public static <V, SUM> SUM reduceBy(Iterable<V> array, Reducer<V, SUM> function) {
        Object sum = null;
        for (V v : array) {
            sum = function.apply(sum, v);
        }
        return sum;
    }

    public static Object reduceBy(Iterable<?> array, Object object) {
        Object sum = null;
        for (Object v : array) {
            sum = Invoker.invokeReducer(object, sum, v);
        }
        return sum;
    }

    public static <T> List<T> filterBy(Iterable<T> array, Predicate<T> predicate) {
        ArrayList<T> list = new ArrayList<T>();
        for (T v : array) {
            if (!predicate.test(v)) continue;
            list.add(v);
        }
        return list;
    }

    public static <T> List<T> filterBy(Collection<T> array, Predicate<T> predicate) {
        ArrayList<T> list = new ArrayList<T>(array.size());
        for (T v : array) {
            if (!predicate.test(v)) continue;
            list.add(v);
        }
        return list;
    }

    public static <T> List<T> filterBy(Predicate<T> predicate, T[] array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T v : array) {
            if (!predicate.test(v)) continue;
            list.add(v);
        }
        return list;
    }

    public static <T> List<T> filterBy(Iterable<T> array, Object object) {
        ArrayList<T> list = new ArrayList<T>();
        for (T v : array) {
            if (!Invoker.invokeBooleanReturn(object, v)) continue;
            list.add(v);
        }
        return list;
    }

    public static <T> List<T> filterBy(Collection<T> array, Object object) {
        ArrayList<T> list = new ArrayList<T>(array.size());
        for (T v : array) {
            if (!Invoker.invokeBooleanReturn(object, v)) continue;
            list.add(v);
        }
        return list;
    }

    public static <T> List<T> filterBy(T[] array, Object object) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T v : array) {
            if (!Invoker.invokeBooleanReturn(object, v)) continue;
            list.add(v);
        }
        return list;
    }

    public static <T> List<T> filterBy(Iterable<T> array, Object object, String methodName) {
        ArrayList<T> list = new ArrayList<T>();
        for (T v : array) {
            if (!((Boolean)Invoker.invokeEither(object, methodName, v)).booleanValue()) continue;
            list.add(v);
        }
        return list;
    }

    public static <T> List<T> filterBy(Collection<T> array, Object object, String methodName) {
        ArrayList<T> list = new ArrayList<T>(array.size());
        for (T v : array) {
            if (!((Boolean)Invoker.invokeEither(object, methodName, v)).booleanValue()) continue;
            list.add(v);
        }
        return list;
    }

    public static <T> List<T> filterBy(T[] array, Object object, String methodName) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T v : array) {
            if (!((Boolean)Invoker.invokeEither(object, methodName, v)).booleanValue()) continue;
            list.add(v);
        }
        return list;
    }
}

