/*
 * Decompiled with CFR 0.152.
 */
package org.boon.sort;

import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.boon.Boon;
import org.boon.Lists;
import org.boon.Logger;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.Fields;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.sort.Sort;

public class Sorting {
    private static final Logger log = Boon.configurableLogger(Sorting.class.getName());

    public static void sort(List list, Sort ... sorts) {
        Sort.sorts(sorts).sort(list);
    }

    public static void sort(List list, String sortBy, boolean ascending, boolean nullsFirst) {
        FieldAccess field;
        if (list == null || list.size() == 0) {
            return;
        }
        if (sortBy.equals("this")) {
            Collections.sort(list, Sorting.thisUniversalComparator(ascending, nullsFirst));
            return;
        }
        Iterator iterator = list.iterator();
        Object object = iterator.next();
        Map<String, FieldAccess> fields = null;
        if (object != null) {
            fields = BeanUtils.getFieldsFromObject(object);
        } else {
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object == null) continue;
                fields = BeanUtils.getFieldsFromObject(object);
                break;
            }
        }
        if (fields != null && (field = fields.get(sortBy)) != null) {
            Collections.sort(list, Sorting.universalComparator(field, ascending, nullsFirst));
        }
    }

    public static <V> Collection<V> sort(Class<V> componentType, Collection<V> collection, String sortBy, boolean ascending, boolean nullsFirst) {
        if (collection instanceof List) {
            Sorting.sort((List)collection, sortBy, ascending, nullsFirst);
            return collection;
        }
        V[] array = Conversions.toArray(componentType, collection);
        Sorting.sort(array, sortBy, ascending, nullsFirst);
        if (collection instanceof LinkedHashSet) {
            return new LinkedHashSet<V>(Lists.list(array));
        }
        return Lists.list(array);
    }

    public static <K, V> Collection<Map.Entry<K, V>> sortEntries(Class<V> componentType, Map<K, V> map, String sortBy, boolean ascending, boolean nullsFirst) {
        return Sorting.sort(componentType, map.entrySet(), sortBy, ascending, nullsFirst);
    }

    public static <K, V> Collection<Map.Entry<K, V>> sortValues(Class<V> componentType, Map<K, V> map, String sortBy, boolean ascending, boolean nullsFirst) {
        return Sorting.sort(componentType, map.values(), sortBy, ascending, nullsFirst);
    }

    public static <K, V> Collection<Map.Entry<K, V>> sortKeys(Class<V> componentType, Map<K, V> map, String sortBy, boolean ascending, boolean nullsFirst) {
        return Sorting.sort(componentType, map.keySet(), sortBy, ascending, nullsFirst);
    }

    public static <V> Iterable<V> sort(Class<V> componentType, Iterable<V> iterable, String sortBy, boolean ascending, boolean nullsFirst) {
        if (iterable instanceof List) {
            Sorting.sort((List)iterable, sortBy, ascending, nullsFirst);
            return iterable;
        }
        if (iterable instanceof Collection) {
            return Sorting.sort(componentType, (Collection)iterable, sortBy, ascending, nullsFirst);
        }
        List<V> list = Lists.list(iterable);
        Sorting.sort(list, sortBy, ascending, nullsFirst);
        return list;
    }

    public static <T> void sort(T[] array, String sortBy, boolean ascending, boolean nullsFirst) {
        FieldAccess field;
        if (array == null || array.length == 0) {
            return;
        }
        if (sortBy.equals("this")) {
            Arrays.sort(array, Sorting.thisUniversalComparator(ascending, nullsFirst));
            return;
        }
        T object = array[0];
        Map<String, FieldAccess> fields = null;
        if (object != null) {
            fields = BeanUtils.getFieldsFromObject(object);
        } else {
            for (int index = 1; index < array.length; ++index) {
                object = array[index];
                if (object == null) continue;
                fields = BeanUtils.getFieldsFromObject(object);
                break;
            }
        }
        if (fields != null && (field = fields.get(sortBy)) != null) {
            Arrays.sort(array, Sorting.universalComparator(field, ascending, nullsFirst));
        }
    }

    public static void sort(List list) {
        Sorting.sort(list, "this", true, false);
    }

    public static <T> void sort(T[] array) {
        Sorting.sort(array, "this", true, false);
    }

    public static <T> Collection<T> sort(Class<T> componentType, Collection<T> collection) {
        return Sorting.sort(componentType, collection, "this", true, false);
    }

    public static <T> Iterable<T> sort(Class<T> componentType, Iterable<T> iterable) {
        return Sorting.sort(componentType, iterable, "this", true, false);
    }

    public static void sortNullsFirst(List list) {
        Sorting.sort(list, "this", true, true);
    }

    public static <T> void sortNullsFirst(T[] array) {
        Sorting.sort(array, "this", true, true);
    }

    public static <T> Collection<T> sortNullsFirst(Class<T> componentType, Collection<T> collection) {
        return Sorting.sort(componentType, collection, "this", true, true);
    }

    public static <T> Iterable<T> sortNullsFirst(Class<T> componentType, Iterable<T> iterable) {
        return Sorting.sort(componentType, iterable, "this", true, true);
    }

    public static void sortDesc(List list) {
        Sorting.sort(list, "this", false, false);
    }

    public static <T> void sortDesc(T[] array) {
        Sorting.sort(array, "this", false, false);
    }

    public static <T> Iterable<T> sortDesc(Class<T> componentType, Iterable<T> iterable) {
        return Sorting.sort(componentType, iterable, "this", false, false);
    }

    public static <T> Collection<T> sortDesc(Class<T> componentType, Collection<T> collection) {
        return Sorting.sort(componentType, collection, "this", false, false);
    }

    public static void sortDescNullsFirst(List list) {
        Sorting.sort(list, "this", false, true);
    }

    public static <T> void sortDescNullsFirst(T[] array) {
        Sorting.sort(array, "this", false, true);
    }

    public static <T> Iterable<T> sortDescNullsFirst(Class<T> componentType, Iterable<T> iterable) {
        return Sorting.sort(componentType, iterable, "this", false, true);
    }

    public static <T> Collection<T> sortDescNullsFirst(Class<T> componentType, Collection<T> collection) {
        return Sorting.sort(componentType, collection, "this", false, true);
    }

    public static void sort(List list, String sortBy) {
        Sorting.sort(list, sortBy, true, false);
    }

    public static <T> void sort(T[] array, String sortBy) {
        Sorting.sort(array, sortBy, true, false);
    }

    public static <T> Iterable<T> sort(Class<T> componentType, Iterable<T> iterable, String sortBy) {
        return Sorting.sort(componentType, iterable, sortBy, true, false);
    }

    public static <T> Collection<T> sort(Class<T> componentType, Collection<T> collection, String sortBy) {
        return Sorting.sort(componentType, collection, sortBy, true, false);
    }

    public static void sortNullsFirst(List list, String sortBy) {
        Sorting.sort(list, sortBy, true, true);
    }

    public static <T> void sortNullsFirst(T[] array, String sortBy) {
        Sorting.sort(array, sortBy, true, true);
    }

    public static <T> Iterable<T> sortNullsFirst(Class<T> componentType, Iterable<T> iterable, String sortBy) {
        return Sorting.sort(componentType, iterable, sortBy, true, true);
    }

    public static <T> Collection<T> sortNullsFirst(Class<T> componentType, Collection<T> collection, String sortBy) {
        return Sorting.sort(componentType, collection, sortBy, true, true);
    }

    public static void sortDesc(List list, String sortBy) {
        Sorting.sort(list, sortBy, false, false);
    }

    public static <T> void sortDesc(T[] array, String sortBy) {
        Sorting.sort(array, sortBy, false, false);
    }

    public static <T> Iterable<T> sortDesc(Class<T> componentType, Iterable<T> iterable, String sortBy) {
        return Sorting.sort(componentType, iterable, sortBy, false, false);
    }

    public static <T> Collection<T> sortDesc(Class<T> componentType, Collection<T> collection, String sortBy) {
        return Sorting.sort(componentType, collection, sortBy, false, false);
    }

    public static void sortDescNullsFirst(List list, String sortBy) {
        Sorting.sort(list, sortBy, false, true);
    }

    public static <T> void sortDescNullsFirst(T[] array, String sortBy) {
        Sorting.sort(array, sortBy, false, true);
    }

    public static <T> Iterable<T> sortDescNullsFirst(Class<T> componentType, Iterable<T> iterable, String sortBy) {
        return Sorting.sort(componentType, iterable, sortBy, false, true);
    }

    public static <T> Collection<T> sortDescNullsFirst(Class<T> componentType, Collection<T> collection, String sortBy) {
        return Sorting.sort(componentType, collection, sortBy, false, true);
    }

    public static Comparator universalComparator(final FieldAccess field, final boolean ascending, final boolean nullsFirst) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                Object value1 = null;
                Object value2 = null;
                if (ascending) {
                    value1 = field.getValue(o1);
                    value2 = field.getValue(o2);
                } else {
                    value1 = field.getValue(o2);
                    value2 = field.getValue(o1);
                }
                return Sorting.compare(value1, value2, nullsFirst);
            }
        };
    }

    public static Comparator thisUniversalComparator(final boolean ascending, final boolean nullsFirst) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                Object value2;
                Object value1;
                if (ascending) {
                    value1 = o1;
                    value2 = o2;
                } else {
                    value1 = o2;
                    value2 = o1;
                }
                return Sorting.compare(value1, value2, nullsFirst);
            }
        };
    }

    public static int compare(Object value1, Object value2) {
        return Sorting.compare(value1, value2, false);
    }

    public static int compare(Object value1, Object value2, boolean nullsLast) {
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null && value2 != null) {
            return nullsLast ? -1 : 1;
        }
        if (value1 != null && value2 == null) {
            return nullsLast ? 1 : -1;
        }
        if (value1 instanceof CharSequence) {
            String str1 = Conversions.toString(value1);
            String str2 = Conversions.toString(value2);
            Collator collator = Collator.getInstance();
            return collator.compare(str1, str2);
        }
        if (Typ.isComparable(value1)) {
            Comparable c1 = Conversions.comparable(value1);
            Comparable c2 = Conversions.comparable(value2);
            return c1.compareTo(c2);
        }
        String name = Fields.getSortableField(value1);
        String sv1 = (String)BeanUtils.getPropByPath(value1, name);
        String sv2 = (String)BeanUtils.getPropByPath(value2, name);
        return Sorting.compare(sv1, sv2);
    }
}

