/*
 * Decompiled with CFR 0.152.
 */
package org.boon.sort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Lists;
import org.boon.core.Conversions;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.sort.SortType;
import org.boon.sort.UniversalComparator;

public class Sort {
    private final String name;
    private final SortType type;
    private final boolean nullsFirst;
    private List<Sort> sorts = new ArrayList<Sort>();
    private String toString = null;
    private int hashCode = -1;
    private List<Comparator> comparators;
    private Comparator comparator;

    public Sort() {
        this.name = "this";
        this.type = SortType.ASCENDING;
        this.nullsFirst = false;
        this.hashCode = this.doHashCode();
    }

    public Sort(String name, SortType type, boolean nullsFirst) {
        this.name = name;
        this.type = type;
        this.nullsFirst = nullsFirst;
    }

    public Sort(String name, SortType type) {
        this.name = name;
        this.type = type;
        this.nullsFirst = false;
    }

    public static Sort sorts(Sort ... sorts) {
        if (sorts == null || sorts.length == 0) {
            return null;
        }
        Sort main = sorts[0];
        for (int index = 1; index < sorts.length; ++index) {
            main.then(sorts[index]);
        }
        return main;
    }

    public static Sort asc(String name) {
        return new Sort(name, SortType.ASCENDING);
    }

    public static Sort sortBy(String name) {
        return new Sort(name, SortType.ASCENDING);
    }

    public static Sort sortByNullsFirst(String name) {
        return new Sort(name, SortType.ASCENDING, true);
    }

    public static Sort desc(String name) {
        return new Sort(name, SortType.DESCENDING);
    }

    public static Sort sortByDesc(String name) {
        return new Sort(name, SortType.DESCENDING);
    }

    public static Sort sortByDescending(String name) {
        return new Sort(name, SortType.DESCENDING);
    }

    public static Sort sortByDescendingNullsFirst(String name) {
        return new Sort(name, SortType.ASCENDING, true);
    }

    public static Sort descNullsFirst(String name) {
        return new Sort(name, SortType.ASCENDING, true);
    }

    public SortType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Sort then(Sort sort) {
        this.sorts.add(sort);
        return this;
    }

    public Sort then(String name) {
        this.sorts.add(new Sort(name, SortType.ASCENDING));
        return this;
    }

    public Sort thenAsc(String name) {
        this.sorts.add(new Sort(name, SortType.ASCENDING));
        return this;
    }

    public Sort thenDesc(String name) {
        this.sorts.add(new Sort(name, SortType.DESCENDING));
        return this;
    }

    public void sort(List list, Map<String, FieldAccess> fields) {
        Collections.sort(list, this.comparator(fields));
    }

    public void sort(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        Object item = list.iterator().next();
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(item);
        Collections.sort(list, this.comparator(fields));
    }

    public <T> Collection<T> sort(Class<T> componentClass, Collection<T> collection) {
        if (collection instanceof List) {
            this.sort((List)collection);
            return collection;
        }
        if (collection == null || collection.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(componentClass);
        T[] array = Conversions.toArray(componentClass, collection);
        Arrays.sort(array, this.comparator(fields));
        if (collection instanceof Set) {
            return new LinkedHashSet<T>(Lists.list(array));
        }
        return Lists.list(array);
    }

    public <T> Iterable<T> sort(Class<T> componentClass, Iterable<T> iterable) {
        if (iterable instanceof List) {
            this.sort((List)iterable);
            return iterable;
        }
        if (iterable instanceof Collection) {
            return this.sort(componentClass, (Collection)iterable);
        }
        if (iterable == null) {
            return Collections.EMPTY_LIST;
        }
        List<T> list = Lists.list(iterable);
        this.sort(list);
        return list;
    }

    public <T> void sort(T[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        T item = array[0];
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(item);
        Arrays.sort(array, this.comparator(fields));
    }

    public Comparator comparator(Map<String, FieldAccess> fields) {
        if (this.comparator == null) {
            this.comparator = UniversalComparator.universalComparator(this.getName(), fields, this.getType(), this.childComparators(fields));
        }
        return this.comparator;
    }

    private List<Comparator> childComparators(Map<String, FieldAccess> fields) {
        if (this.comparators == null) {
            this.comparators = new ArrayList<Comparator>(this.sorts.size() + 1);
            for (Sort sort : this.sorts) {
                Comparator comparator = UniversalComparator.universalComparator(sort.getName(), fields, sort.getType(), sort.childComparators(fields));
                this.comparators.add(comparator);
            }
        }
        return this.comparators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sort sort = (Sort)o;
        if (this.hashCode != sort.hashCode) {
            return false;
        }
        if (this.nullsFirst != sort.nullsFirst) {
            return false;
        }
        if (this.comparator != null ? !this.comparator.equals(sort.comparator) : sort.comparator != null) {
            return false;
        }
        if (this.comparators != null ? !this.comparators.equals(sort.comparators) : sort.comparators != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(sort.name) : sort.name != null) {
            return false;
        }
        if (this.sorts != null ? !this.sorts.equals(sort.sorts) : sort.sorts != null) {
            return false;
        }
        if (this.toString != null ? !this.toString.equals(sort.toString) : sort.toString != null) {
            return false;
        }
        return this.type == sort.type;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.doHashCode();
        }
        return this.hashCode;
    }

    public int doHashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.nullsFirst ? 1 : 0);
        result = 31 * result + (this.sorts != null ? this.sorts.hashCode() : 0);
        result = 31 * result + (this.toString != null ? this.toString.hashCode() : 0);
        result = 31 * result + this.hashCode;
        result = 31 * result + (this.comparators != null ? this.comparators.hashCode() : 0);
        result = 31 * result + (this.comparator != null ? this.comparator.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Sort{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", nullsFirst=" + this.nullsFirst + ", sorts=" + this.sorts + ", toString='" + this.toString + '\'' + ", hashCode=" + this.hashCode + ", comparators=" + this.comparators + ", comparator=" + this.comparator + '}';
    }
}

