/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.serializers.impl;

import java.util.Map;
import java.util.Set;
import org.boon.core.reflection.FastStringUtils;
import org.boon.json.serializers.JsonSerializerInternal;
import org.boon.json.serializers.MapSerializer;
import org.boon.primitive.CharBuf;

public class MapSerializerImpl
implements MapSerializer {
    private static final char[] EMPTY_MAP_CHARS = new char[]{'{', '}'};

    private void serializeFieldName(String name, CharBuf builder) {
        builder.addJsonFieldName(FastStringUtils.toCharArray(name));
    }

    @Override
    public final void serializeMap(JsonSerializerInternal serializer, Map<String, Object> map, CharBuf builder) {
        if (map.size() == 0) {
            builder.addChars(EMPTY_MAP_CHARS);
            return;
        }
        builder.addChar('{');
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        int index = 0;
        for (Map.Entry<String, Object> entry : entrySet) {
            if (entry.getValue() == null) continue;
            this.serializeFieldName(entry.getKey(), builder);
            serializer.serializeObject(entry.getValue(), builder);
            builder.addChar(',');
            ++index;
        }
        if (index > 0) {
            builder.removeLastChar();
        }
        builder.addChar('}');
    }
}

