/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.serializers.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.boon.core.Type;
import org.boon.core.reflection.FastStringUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.json.serializers.FieldSerializer;
import org.boon.json.serializers.JsonSerializerInternal;
import org.boon.primitive.CharBuf;

public class FieldSerializerImpl
implements FieldSerializer {
    private void serializeFieldName(String name, CharBuf builder) {
        builder.addJsonFieldName(FastStringUtils.toCharArray(name));
    }

    @Override
    public final boolean serializeField(JsonSerializerInternal serializer, Object parent, FieldAccess fieldAccess, CharBuf builder) {
        String fieldName = fieldAccess.name();
        Type typeEnum = fieldAccess.typeEnum();
        switch (typeEnum) {
            case INT: {
                int value = fieldAccess.getInt(parent);
                if (value != 0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addInt(value);
                    return true;
                }
                return false;
            }
            case BOOLEAN: {
                boolean bvalue = fieldAccess.getBoolean(parent);
                if (bvalue) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addBoolean(bvalue);
                    return true;
                }
                return false;
            }
            case BYTE: {
                byte byvalue = fieldAccess.getByte(parent);
                if (byvalue != 0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addByte(byvalue);
                    return true;
                }
                return false;
            }
            case LONG: {
                long lvalue = fieldAccess.getLong(parent);
                if (lvalue != 0L) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addLong(lvalue);
                    return true;
                }
                return false;
            }
            case DOUBLE: {
                double dvalue = fieldAccess.getDouble(parent);
                if (dvalue != 0.0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addDouble(dvalue);
                    return true;
                }
                return false;
            }
            case FLOAT: {
                float fvalue = fieldAccess.getFloat(parent);
                if (fvalue != 0.0f) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addFloat(fvalue);
                    return true;
                }
                return false;
            }
            case SHORT: {
                short svalue = fieldAccess.getShort(parent);
                if (svalue != 0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addShort(svalue);
                    return true;
                }
                return false;
            }
            case CHAR: {
                char cvalue = fieldAccess.getChar(parent);
                if (cvalue != '\u0000') {
                    this.serializeFieldName(fieldName, builder);
                    builder.addChar(cvalue);
                    return true;
                }
                return false;
            }
        }
        Object value = fieldAccess.getObject(parent);
        if (value == null) {
            return false;
        }
        if (value == parent) {
            return false;
        }
        switch (typeEnum) {
            case BIG_DECIMAL: {
                this.serializeFieldName(fieldName, builder);
                builder.addBigDecimal((BigDecimal)value);
                return true;
            }
            case BIG_INT: {
                this.serializeFieldName(fieldName, builder);
                builder.addBigInteger((BigInteger)value);
                return true;
            }
            case DATE: {
                this.serializeFieldName(fieldName, builder);
                serializer.serializeDate((Date)value, builder);
                return true;
            }
            case STRING: {
                this.serializeFieldName(fieldName, builder);
                serializer.serializeString((String)value, builder);
                return true;
            }
            case CLASS: {
                this.serializeFieldName(fieldName, builder);
                builder.addQuoted(((Class)value).getName());
                return true;
            }
            case TIME_ZONE: {
                this.serializeFieldName(fieldName, builder);
                TimeZone zone = (TimeZone)value;
                builder.addQuoted(zone.getID());
                return true;
            }
            case CHAR_SEQUENCE: {
                this.serializeFieldName(fieldName, builder);
                serializer.serializeString(value.toString(), builder);
                return true;
            }
            case INTEGER_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addInt((Integer)value);
                return true;
            }
            case LONG_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addLong((Long)value);
                return true;
            }
            case FLOAT_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addFloat((Float)value);
                return true;
            }
            case DOUBLE_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addDouble((Double)value);
                return true;
            }
            case SHORT_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addShort((Short)value);
                return true;
            }
            case BYTE_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addByte((Byte)value);
                return true;
            }
            case CHAR_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addChar(((Character)value).charValue());
                return true;
            }
            case ENUM: {
                this.serializeFieldName(fieldName, builder);
                builder.addQuoted(value.toString());
                return true;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                Collection collection = (Collection)value;
                if (collection.size() > 0) {
                    this.serializeFieldName(fieldName, builder);
                    serializer.serializeCollection(collection, builder);
                    return true;
                }
                return false;
            }
            case MAP: {
                Map map = (Map)value;
                if (map.size() > 0) {
                    this.serializeFieldName(fieldName, builder);
                    serializer.serializeMap(map, builder);
                    return true;
                }
                return false;
            }
            case ARRAY: {
                Object[] array = (Object[])value;
                if (array.length > 0) {
                    this.serializeFieldName(fieldName, builder);
                    serializer.serializeArray(value, builder);
                    return true;
                }
                return false;
            }
            case INTERFACE: 
            case ABSTRACT: {
                this.serializeFieldName(fieldName, builder);
                serializer.serializeSubtypeInstance(value, builder);
                return true;
            }
            case INSTANCE: {
                this.serializeFieldName(fieldName, builder);
                if (fieldAccess.type() == value.getClass()) {
                    serializer.serializeInstance(value, builder);
                } else {
                    serializer.serializeSubtypeInstance(value, builder);
                }
                return true;
            }
            case CURRENCY: {
                this.serializeFieldName(fieldName, builder);
                builder.addCurrency((Currency)value);
                return true;
            }
        }
        this.serializeFieldName(fieldName, builder);
        serializer.serializeUnknown(value, builder);
        return true;
    }
}

