/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.timer;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.boon.core.timer.TimeKeeper;

public class TimeKeeperBasic
implements TimeKeeper {
    private final AtomicInteger callEveryNowAndThen = new AtomicInteger();
    private final AtomicLong time = new AtomicLong();
    private final int TIME_KEEPER_FREQUENCY = Integer.parseInt(System.getProperty("org.boon.timekeeper.frequency", "100"));
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicLong lastDeltaTime = new AtomicLong();

    @Override
    public final long time() {
        long limit = this.callEveryNowAndThen.incrementAndGet();
        boolean shouldGetTime = false;
        if (limit > (long)this.TIME_KEEPER_FREQUENCY) {
            this.callEveryNowAndThen.set(0);
            shouldGetTime = true;
        }
        long time = this.time.get() + limit;
        if (!shouldGetTime && limit % 20L == 0L) {
            this.checkForDrift(time);
        }
        return time;
    }

    private long checkForDrift(long time) {
        long lastDelta;
        long delta = Math.abs(System.currentTimeMillis() - time);
        if (delta > (lastDelta = this.lastDeltaTime.getAndSet(delta)) + 200L) {
            return this.getTheTime(time);
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTheTime(long time) {
        boolean locked = this.lock.tryLock();
        if (locked) {
            try {
                time = System.nanoTime() / 1000000L;
                this.time.set(time);
                long l = time;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }
        return time;
    }
}

