/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Maps;
import org.boon.Sets;
import org.boon.core.Conversions;
import org.boon.core.Function;
import org.boon.core.Typ;
import org.boon.core.Type;
import org.boon.core.Value;
import org.boon.core.reflection.BaseAccess;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.ConstructorAccess;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.core.value.ValueContainer;
import org.boon.core.value.ValueList;
import org.boon.core.value.ValueMap;
import org.boon.core.value.ValueMapImpl;
import org.boon.primitive.Arry;
import org.boon.primitive.CharBuf;

public class MapObjectConversion {
    public static <T> T fromListUsingFields(List<Object> list, Class<T> clazz) {
        return MapObjectConversion.fromListUsingFields(false, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(false), list, clazz, null);
    }

    public static <T> T fromListUsingFields(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, List<Object> list, Class<T> clazz, Set<String> ignoreSet) {
        Map<String, FieldAccess> fieldMap = fieldsAccessor.getFields(clazz);
        List<Field> fields = Reflection.getFields(clazz);
        T toObject = Reflection.newInstance(clazz);
        for (int index = 0; index < fields.size(); ++index) {
            Field field = fields.get(index);
            Class<?> fieldType = field.getType();
            Object item = list.get(index);
            FieldAccess fieldAccess = fieldMap.get(field.getName());
            if (Typ.isList(fieldType) && item instanceof List) {
                List itemList = (List)item;
                if (itemList.size() <= 0 || !(itemList.get(0) instanceof List)) continue;
                Class<?> componentType = fieldAccess.getComponentClass();
                ArrayList newList = new ArrayList(itemList.size());
                for (Object o : itemList) {
                    List fromList = (List)o;
                    newList.add(MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, fromList, componentType, ignoreSet));
                }
                fieldAccess.setValue(toObject, newList);
                continue;
            }
            if (fieldType.isInstance(item)) {
                fieldAccess.setObject(toObject, item);
                continue;
            }
            if (item instanceof Map) {
                MapObjectConversion.setFieldValueFromMap(respectIgnore, view, fieldsAccessor, ignoreSet, toObject, fieldAccess, item);
                continue;
            }
            fieldAccess.setValue(toObject, item);
        }
        return toObject;
    }

    public static <T> T fromList(List<?> argList, Class<T> clazz) {
        return MapObjectConversion.fromList(FieldAccessMode.FIELD_THEN_PROPERTY.create(false), argList, clazz);
    }

    public static <T> T fromList(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, List<?> argList, Class<T> clazz, Set<String> ignoreSet) {
        int size = argList.size();
        ArrayList<Object> convertedArguments = new ArrayList<Object>(argList);
        ClassMeta<T> classMeta = ClassMeta.classMeta(clazz);
        ConstructorAccess<T> constructorToMatch = null;
        Object[] finalArgs = null;
        boolean[] flag = new boolean[1];
        try {
            constructorToMatch = MapObjectConversion.lookupConstructorMeta(respectIgnore, view, fieldsAccessor, ignoreSet, size, convertedArguments, classMeta, constructorToMatch, flag, false);
            if (constructorToMatch == null) {
                constructorToMatch = MapObjectConversion.lookupConstructorMeta(respectIgnore, view, fieldsAccessor, ignoreSet, size, convertedArguments, classMeta, constructorToMatch, flag, true);
            }
            if (constructorToMatch != null) {
                finalArgs = convertedArguments.toArray(new Object[convertedArguments.size()]);
                return constructorToMatch.create(finalArgs);
            }
            return (T)Exceptions.die(Object.class, "Unable to convert list", convertedArguments, "into", clazz);
        }
        catch (Exception e) {
            if (constructorToMatch != null) {
                CharBuf buf = CharBuf.create(200);
                buf.addLine();
                buf.multiply('-', 10).add("FINAL ARGUMENTS").multiply('-', 10).addLine();
                if (finalArgs != null) {
                    for (Object o : finalArgs) {
                        buf.puts("argument type    ", Boon.className(o));
                    }
                }
                buf.multiply('-', 10).add("CONSTRUCTOR").add(constructorToMatch).multiply('-', 10).addLine();
                buf.multiply('-', 10).add("CONSTRUCTOR PARAMS").multiply('-', 10).addLine();
                for (Class<?> c : constructorToMatch.parameterTypes()) {
                    buf.puts("constructor type ", c);
                }
                buf.multiply('-', 35).addLine();
                if (Boon.debugOn()) {
                    Boon.puts(buf);
                }
                buf.addLine("PARAMETER TYPES");
                buf.add(Lists.list(constructorToMatch.parameterTypes())).addLine();
                buf.addLine("ORIGINAL TYPES PASSED");
                buf.add(Type.gatherTypes(convertedArguments)).addLine();
                buf.add(Type.gatherActualTypes(convertedArguments)).addLine();
                buf.addLine("CONVERTED ARGUMENT TYPES");
                buf.add(Type.gatherTypes(convertedArguments)).addLine();
                buf.add(Type.gatherActualTypes(convertedArguments)).addLine();
                Boon.error(e, "unable to create object based on constructor", buf);
                return (T)Exceptions.handle(Object.class, e, buf.toString());
            }
            return (T)Exceptions.handle(Object.class, e, "\nlist args after conversion", convertedArguments, "types", Type.gatherTypes(convertedArguments), "\noriginal args", argList, "original types", Type.gatherTypes(argList));
        }
    }

    private static <T> ConstructorAccess<T> lookupConstructorMeta(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Set<String> ignoreSet, int size, List<Object> convertedArguments, ClassMeta<T> classMeta, ConstructorAccess<T> constructorToMatch, boolean[] flag, boolean loose) {
        block0: for (ConstructorAccess<T> constructor : classMeta.constructors()) {
            Class[] parameterTypes = constructor.parameterTypes();
            if (parameterTypes.length != size) continue;
            for (int index = 0; index < size; ++index) {
                if (!MapObjectConversion.matchAndConvertArgs(respectIgnore, view, fieldsAccessor, convertedArguments, constructor, parameterTypes, index, ignoreSet, flag, loose)) continue block0;
            }
            constructorToMatch = constructor;
        }
        return constructorToMatch;
    }

    public static <T> T fromList(FieldsAccessor fieldsAccessor, List<?> argList, Class<T> clazz) {
        return MapObjectConversion.fromList(false, null, fieldsAccessor, argList, clazz, null);
    }

    public static boolean matchAndConvertArgs(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, List<Object> convertedArgumentList, BaseAccess methodAccess, Class[] parameterTypes, int index, Set<String> ignoreSet, boolean[] flag, boolean loose) {
        try {
            Class parameterClass = parameterTypes[index];
            Object item = convertedArgumentList.get(index);
            Type parameterType = Type.getType(parameterClass);
            if (item instanceof ValueContainer) {
                item = ((ValueContainer)item).toValue();
                convertedArgumentList.set(index, item);
            }
            if (item == null) {
                return true;
            }
            switch (parameterType) {
                case BOOLEAN: 
                case INT: 
                case SHORT: 
                case BYTE: 
                case FLOAT: 
                case DOUBLE: 
                case LONG: 
                case CHAR: {
                    if (item == null) {
                        return false;
                    }
                }
                case NUMBER: 
                case DOUBLE_WRAPPER: 
                case FLOAT_WRAPPER: 
                case INTEGER_WRAPPER: 
                case SHORT_WRAPPER: 
                case BOOLEAN_WRAPPER: 
                case BYTE_WRAPPER: 
                case LONG_WRAPPER: 
                case CHAR_SEQUENCE: 
                case CHAR_WRAPPER: {
                    if (!loose && item instanceof CharSequence) {
                        return false;
                    }
                    Object value = Conversions.coerceWithFlag(parameterType, parameterClass, flag, item);
                    if (!flag[0]) {
                        return false;
                    }
                    convertedArgumentList.set(index, value);
                    return true;
                }
                case CLASS: 
                case STRING: 
                case ENUM: {
                    if (!loose && !(item instanceof CharSequence)) {
                        return false;
                    }
                    Object value = Conversions.coerceWithFlag(parameterType, parameterClass, flag, item);
                    if (!flag[0]) {
                        return false;
                    }
                    convertedArgumentList.set(index, value);
                    return true;
                }
                case MAP: 
                case VALUE_MAP: {
                    if (!(item instanceof Map)) break;
                    Map itemMap = (Map)item;
                    java.lang.reflect.Type type = methodAccess.getGenericParameterTypes()[index];
                    if (!(type instanceof ParameterizedType)) break;
                    ParameterizedType pType = (ParameterizedType)type;
                    Class keyType = (Class)pType.getActualTypeArguments()[0];
                    Class valueType = (Class)pType.getActualTypeArguments()[1];
                    Map<?, ?> newMap = Conversions.createMap(parameterClass, itemMap.size());
                    Iterator i$ = itemMap.entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = i$.next();
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        key = ValueContainer.toObject(key);
                        value = (value = ValueContainer.toObject(value)) instanceof List ? MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, (List)value, valueType, ignoreSet) : (value instanceof Map ? MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, (Map)value, valueType, ignoreSet) : Conversions.coerce(valueType, value));
                        key = key instanceof List ? MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, (List)key, keyType, ignoreSet) : (value instanceof Map ? MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, (Map)key, keyType, ignoreSet) : Conversions.coerce(keyType, key));
                        newMap.put(key, value);
                    }
                    convertedArgumentList.set(index, newMap);
                    return true;
                }
                case INSTANCE: {
                    if (parameterClass.isInstance(item)) {
                        return true;
                    }
                    if (item instanceof Map) {
                        item = MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, (Map)item, parameterClass, ignoreSet);
                        convertedArgumentList.set(index, item);
                        return true;
                    }
                    if (item instanceof List) {
                        List listItem = null;
                        listItem = (List)item;
                        Object value = MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, listItem, parameterClass, ignoreSet);
                        convertedArgumentList.set(index, value);
                        return true;
                    }
                    convertedArgumentList.set(index, Conversions.coerce(parameterClass, item));
                    return true;
                }
                case INTERFACE: 
                case ABSTRACT: {
                    if (parameterClass.isInstance(item)) {
                        return true;
                    }
                    if (!(item instanceof Map)) break;
                    String className = (String)((Map)item).get("class");
                    if (className != null) {
                        item = MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, (Map)item, Reflection.loadClass(className), ignoreSet);
                        convertedArgumentList.set(index, item);
                        return true;
                    }
                    return false;
                }
                case LIST: 
                case SET: 
                case COLLECTION: {
                    if (item instanceof List) {
                        List itemList = (List)item;
                        if (itemList.size() > 0 && (itemList.get(0) instanceof List || itemList.get(0) instanceof ValueContainer)) {
                            java.lang.reflect.Type type = methodAccess.getGenericParameterTypes()[index];
                            if (type instanceof ParameterizedType) {
                                ParameterizedType pType = (ParameterizedType)type;
                                Class componentType = !(pType.getActualTypeArguments()[0] instanceof Class) ? Object.class : (Class)pType.getActualTypeArguments()[0];
                                Collection<Object> newList = Conversions.createCollection(parameterClass, itemList.size());
                                for (Object o : itemList) {
                                    if (o instanceof ValueContainer) {
                                        o = ((ValueContainer)o).toValue();
                                    }
                                    if (componentType == Object.class) {
                                        newList.add(o);
                                        continue;
                                    }
                                    List fromList = (List)o;
                                    o = MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, fromList, componentType, ignoreSet);
                                    newList.add(o);
                                }
                                convertedArgumentList.set(index, newList);
                                return true;
                            }
                        } else {
                            java.lang.reflect.Type type = methodAccess.getGenericParameterTypes()[index];
                            if (type instanceof ParameterizedType) {
                                ParameterizedType pType = (ParameterizedType)type;
                                Class componentType = pType.getActualTypeArguments()[0] instanceof Class ? (Class)pType.getActualTypeArguments()[0] : Object.class;
                                Collection<Object> newList = Conversions.createCollection(parameterClass, itemList.size());
                                for (Object o : itemList) {
                                    if (o instanceof ValueContainer) {
                                        o = ((ValueContainer)o).toValue();
                                    }
                                    if (o instanceof List) {
                                        if (componentType != Object.class) {
                                            List fromList = (List)o;
                                            o = MapObjectConversion.fromList(fieldsAccessor, fromList, componentType);
                                        }
                                        newList.add(o);
                                        continue;
                                    }
                                    if (o instanceof Map) {
                                        Map fromMap = (Map)o;
                                        o = MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, fromMap, componentType, ignoreSet);
                                        newList.add(o);
                                        continue;
                                    }
                                    newList.add(Conversions.coerce(componentType, o));
                                }
                                convertedArgumentList.set(index, newList);
                                return true;
                            }
                        }
                    }
                    return false;
                }
                default: {
                    Type itemType = Type.getInstanceType(item);
                    switch (itemType) {
                        case LIST: {
                            convertedArgumentList.set(index, MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, (List)item, parameterClass, ignoreSet));
                        }
                        case MAP: 
                        case VALUE_MAP: {
                            convertedArgumentList.set(index, MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, (Map)item, parameterClass, ignoreSet));
                        }
                        case NUMBER: 
                        case BOOLEAN: 
                        case INT: 
                        case SHORT: 
                        case BYTE: 
                        case FLOAT: 
                        case DOUBLE: 
                        case LONG: 
                        case DOUBLE_WRAPPER: 
                        case FLOAT_WRAPPER: 
                        case INTEGER_WRAPPER: 
                        case SHORT_WRAPPER: 
                        case BOOLEAN_WRAPPER: 
                        case BYTE_WRAPPER: 
                        case LONG_WRAPPER: 
                        case CLASS: 
                        case VALUE: {
                            Object value = Conversions.coerceWithFlag(parameterClass, flag, item);
                            if (!flag[0]) {
                                return false;
                            }
                            convertedArgumentList.set(index, value);
                            return true;
                        }
                        case CHAR_SEQUENCE: 
                        case STRING: {
                            Object value = Conversions.coerceWithFlag(parameterClass, flag, item);
                            if (!flag[0]) {
                                return false;
                            }
                            convertedArgumentList.set(index, value);
                            return true;
                        }
                    }
                }
            }
            if (parameterClass.isInstance(item)) {
                return true;
            }
        }
        catch (Exception ex) {
            Boon.error(ex, "PROBLEM WITH oldMatchAndConvertArgs", "respectIgnore", respectIgnore, "view", view, "fieldsAccessor", fieldsAccessor, "list", convertedArgumentList, "constructor", methodAccess, "parameters", parameterTypes, "index", index, "ignoreSet", ignoreSet);
            return false;
        }
        return false;
    }

    public static List<?> toList(Object object) {
        Type instanceType = Type.getInstanceType(object);
        switch (instanceType) {
            case NULL: {
                return Lists.list(new Object[]{null});
            }
            case ARRAY: {
                return Conversions.toList(object);
            }
            case INSTANCE: {
                if (!Reflection.respondsTo(object, "toList")) break;
                return (List)Reflection.invoke(object, "toList", new Object[0]);
            }
        }
        return Lists.list(object);
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> clazz) {
        return MapObjectConversion.fromMap(false, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(true), map, clazz, null);
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> clazz, String ... excludeProperties) {
        Set<String> ignoreProps = excludeProperties.length > 0 ? Sets.set(excludeProperties) : null;
        return MapObjectConversion.fromMap(false, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(true), map, clazz, ignoreProps);
    }

    public static Object fromMap(Map<String, Object> map) {
        String clazz = (String)map.get("class");
        Class<?> cls = Reflection.loadClass(clazz);
        return MapObjectConversion.fromMap(false, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(true), map, cls, null);
    }

    public static <T> T fromMap(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Map<String, Object> map, Class<T> cls, Set<String> ignoreSet) {
        T toObject = Reflection.newInstance(cls);
        Map<String, FieldAccess> fields = fieldsAccessor.getFields(toObject.getClass());
        Set<Map.Entry<String, Object>> mapKeyValuesEntrySet = map.entrySet();
        for (Map.Entry<String, Object> mapEntry : mapKeyValuesEntrySet) {
            FieldAccess field;
            String key = mapEntry.getKey();
            if (ignoreSet != null && ignoreSet.contains(key) || (field = fields.get(key)) == null || view != null && !field.isViewActive(view) || respectIgnore && field.ignore()) continue;
            Object value = mapEntry.getValue();
            if (value instanceof Value) {
                if (((Value)value).isContainer()) {
                    value = ((Value)value).toValue();
                } else {
                    field.setFromValue(toObject, (Value)value);
                    continue;
                }
            }
            if (value == null) {
                field.setObject(toObject, null);
                continue;
            }
            if (value.getClass() == field.type() || field.type() == Object.class) {
                field.setValue(toObject, value);
                continue;
            }
            if (Typ.isBasicType(value)) {
                field.setValue(toObject, value);
                continue;
            }
            if (value instanceof Map) {
                MapObjectConversion.setFieldValueFromMap(respectIgnore, view, fieldsAccessor, ignoreSet, toObject, field, value);
                continue;
            }
            if (value instanceof Collection) {
                MapObjectConversion.processCollectionFromMapUsingFields(respectIgnore, view, fieldsAccessor, toObject, field, (Collection)value, ignoreSet);
                continue;
            }
            if (value instanceof Map[]) {
                MapObjectConversion.processArrayOfMaps(respectIgnore, view, fieldsAccessor, toObject, field, value, ignoreSet);
                continue;
            }
            field.setValue(toObject, value);
        }
        return toObject;
    }

    private static <T> void setFieldValueFromMap(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Set<String> ignoreSet, T toObject, FieldAccess field, Object value) {
        Class<?> fieldClassType = field.type();
        Map mapInner = (Map)value;
        if (!Typ.isMap(fieldClassType)) {
            String className;
            value = !fieldClassType.isInterface() && !Typ.isAbstract(fieldClassType) ? MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, mapInner, field.type(), ignoreSet) : ((className = (String)((Map)value).get("class")) != null ? MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, mapInner, Reflection.loadClass(className), ignoreSet) : null);
        } else if (Typ.isMap(fieldClassType)) {
            Class keyType = (Class)field.getParameterizedType().getActualTypeArguments()[0];
            Class valueType = (Class)field.getParameterizedType().getActualTypeArguments()[1];
            Set set = mapInner.entrySet();
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry entry : set) {
                Object evalue = entry.getValue();
                Object key = entry.getKey();
                if (evalue instanceof ValueContainer) {
                    evalue = ((ValueContainer)evalue).toValue();
                }
                key = Conversions.coerce(keyType, key);
                evalue = Conversions.coerce(valueType, evalue);
                newMap.put(key, evalue);
            }
            value = newMap;
        }
        field.setValue(toObject, value);
    }

    private static Object fromValueMap(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Map<String, Value> valueMap, Set<String> ignoreSet) {
        try {
            String className = valueMap.get("class").toString();
            Class<?> cls = Reflection.loadClass(className);
            return MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, valueMap, cls, ignoreSet);
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, Boon.sputs("fromValueMap", "map", valueMap, "fieldAccessor", fieldsAccessor), ex);
        }
    }

    public static <T> T fromValueMap(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Map<String, Value> valueMap, Class<T> cls, Set<String> ignoreSet) {
        Map.Entry<String, Value>[] entries;
        int size;
        T newInstance = Reflection.newInstance(cls);
        ValueMap map = (ValueMap)valueMap;
        Map<String, FieldAccess> fields = fieldsAccessor.getFields(cls);
        FieldAccess field = null;
        String fieldName = null;
        if (!map.hydrated()) {
            size = map.len();
            entries = map.items();
        } else {
            size = map.size();
            entries = map.entrySet().toArray(new Map.Entry[size]);
        }
        if (size == 0 || entries == null) {
            return newInstance;
        }
        for (int index = 0; index < size; ++index) {
            Value value = null;
            try {
                Map.Entry<String, Value> entry = entries[index];
                fieldName = entry.getKey();
                if (ignoreSet != null && ignoreSet.contains(fieldName) || (field = fields.get(fieldName)) == null || view != null && !field.isViewActive(view) || respectIgnore && field.ignore()) continue;
                value = entry.getValue();
                if (value instanceof Value) {
                    MapObjectConversion.fromValueMapHandleValueCase(respectIgnore, view, fieldsAccessor, newInstance, field, value, ignoreSet);
                    continue;
                }
                MapObjectConversion.fromMapHandleNonValueCase(respectIgnore, view, fieldsAccessor, newInstance, field, value, ignoreSet);
                continue;
            }
            catch (Exception ex) {
                return (T)Exceptions.handle(Object.class, ex, "fieldName", fieldName, "of class", cls, "had issues for value", value, "for field", field);
            }
        }
        return newInstance;
    }

    private static <T> void fromMapHandleNonValueCase(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, T newInstance, FieldAccess field, Object objectValue, Set<String> ignoreSet) {
        try {
            if (objectValue instanceof Map) {
                Class<?> clazz = field.type();
                objectValue = !clazz.isInterface() && !Typ.isAbstract(clazz) ? MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, (Map)objectValue, field.type(), ignoreSet) : MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, (Map)objectValue, ignoreSet);
                field.setValue(newInstance, objectValue);
            } else if (objectValue instanceof Collection) {
                MapObjectConversion.handleCollectionOfValues(respectIgnore, view, fieldsAccessor, newInstance, field, (Collection)objectValue, ignoreSet);
            } else {
                field.setValue(newInstance, objectValue);
            }
        }
        catch (Exception ex) {
            Exceptions.handle(Boon.sputs("Problem handling non value case of fromValueMap", "field", field.name(), "fieldType", field.type().getName(), "object from map", objectValue), (Throwable)ex);
        }
    }

    private static <T> void fromValueMapHandleValueCaseOLD(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, T newInstance, FieldAccess field, Value value, Set<String> ignoreSet) {
        Object objValue = null;
        try {
            if (value.isContainer()) {
                objValue = value.toValue();
                if (objValue instanceof Map) {
                    Value aClass;
                    Map mapObjectValue = (Map)objValue;
                    Class<?> clazz = field.type();
                    if (clazz == Object.class && (aClass = (Value)mapObjectValue.get("class")) != null) {
                        String strClass = aClass.stringValue();
                        clazz = Class.forName(strClass);
                    }
                    if (!clazz.isInterface() && !Typ.isAbstract(clazz)) {
                        objValue = MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, mapObjectValue, clazz, ignoreSet);
                    } else if (Typ.isMap(field.type())) {
                        Class keyType = (Class)field.getParameterizedType().getActualTypeArguments()[0];
                        Class valueType = (Class)field.getParameterizedType().getActualTypeArguments()[1];
                        Map mapInner = (Map)objValue;
                        Set set = mapInner.entrySet();
                        LinkedHashMap newMap = new LinkedHashMap();
                        for (Map.Entry entry : set) {
                            Object evalue = entry.getValue();
                            Object key = entry.getKey();
                            if (evalue instanceof ValueContainer) {
                                evalue = ((ValueContainer)evalue).toValue();
                            }
                            key = Conversions.coerce(keyType, key);
                            evalue = Conversions.coerce(valueType, evalue);
                            newMap.put(key, evalue);
                        }
                        objValue = newMap;
                    } else {
                        objValue = MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, (Map)objValue, ignoreSet);
                    }
                    field.setValue(newInstance, objValue);
                } else if (objValue instanceof Collection) {
                    MapObjectConversion.handleCollectionOfValues(respectIgnore, view, fieldsAccessor, newInstance, field, (Collection)objValue, ignoreSet);
                }
            } else {
                field.setFromValue(newInstance, value);
            }
        }
        catch (Exception ex) {
            Exceptions.handle(Boon.sputs("Problem handling non value case of fromValueMap", "field", field.name(), "fieldType", field.type().getName(), "object from map", "objValue", objValue, "value", value), (Throwable)ex);
        }
    }

    private static <T> void fromValueMapHandleValueCase(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, T newInstance, FieldAccess field, Value value, Set<String> ignoreSet) {
        LinkedHashMap objValue = ValueContainer.toObject(value);
        Class<?> clazz = field.type();
        switch (field.typeEnum()) {
            case INTERFACE: 
            case ABSTRACT: 
            case OBJECT: {
                if (objValue instanceof Map) {
                    Map valueMap = objValue;
                    Value aClass = (Value)valueMap.get("class");
                    clazz = Reflection.loadClass(aClass.stringValue());
                }
            }
            case INSTANCE: {
                switch (value.type()) {
                    case MAP: {
                        objValue = MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, objValue, clazz, ignoreSet);
                        break;
                    }
                    case LIST: {
                        objValue = MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, (List)((Object)objValue), clazz, ignoreSet);
                    }
                }
                field.setValue(newInstance, objValue);
                break;
            }
            case MAP: 
            case VALUE_MAP: {
                Class keyType = (Class)field.getParameterizedType().getActualTypeArguments()[0];
                Class valueType = (Class)field.getParameterizedType().getActualTypeArguments()[1];
                Map mapInner = objValue;
                Set set = mapInner.entrySet();
                LinkedHashMap newMap = new LinkedHashMap();
                for (Map.Entry entry : set) {
                    Object evalue = entry.getValue();
                    Object key = entry.getKey();
                    if (evalue instanceof ValueContainer) {
                        evalue = ((ValueContainer)evalue).toValue();
                    }
                    key = Conversions.coerce(keyType, key);
                    evalue = Conversions.coerce(valueType, evalue);
                    newMap.put(key, evalue);
                }
                objValue = newMap;
                field.setValue(newInstance, objValue);
                break;
            }
            case LIST: 
            case SET: 
            case COLLECTION: 
            case ARRAY: {
                MapObjectConversion.handleCollectionOfValues(respectIgnore, view, fieldsAccessor, newInstance, field, (Collection)((Object)objValue), ignoreSet);
                break;
            }
            default: {
                field.setFromValue(newInstance, value);
            }
        }
    }

    private static <T> void fromValueMapHandleValueCase2(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, T newInstance, FieldAccess field, Value value, Set<String> ignoreSet) {
        Class<?> clazz = field.type();
        switch (value.type()) {
            case MAP: {
                Map valueMap = (Map)ValueContainer.toObject(value);
                switch (field.typeEnum()) {
                    case INTERFACE: 
                    case ABSTRACT: 
                    case OBJECT: {
                        Value aClass = (Value)valueMap.get("class");
                        clazz = Reflection.loadClass(aClass.stringValue());
                    }
                    case INSTANCE: {
                        field.setObject(newInstance, MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, valueMap, clazz, ignoreSet));
                        break;
                    }
                    case MAP: 
                    case VALUE_MAP: {
                        Class keyType = (Class)field.getParameterizedType().getActualTypeArguments()[0];
                        Class valueType = (Class)field.getParameterizedType().getActualTypeArguments()[1];
                        Set set = valueMap.entrySet();
                        LinkedHashMap newMap = new LinkedHashMap();
                        for (Map.Entry entry : set) {
                            Object evalue = entry.getValue();
                            evalue = ValueContainer.toObject(evalue);
                            Object key = entry.getKey();
                            key = Conversions.coerce(keyType, key);
                            evalue = Conversions.coerce(valueType, evalue);
                            newMap.put(key, evalue);
                        }
                        field.setValue(newInstance, newMap);
                    }
                }
                break;
            }
            case LIST: {
                MapObjectConversion.handleCollectionOfValues(respectIgnore, view, fieldsAccessor, newInstance, field, (Collection)ValueContainer.toObject(value), ignoreSet);
                break;
            }
            case NUMBER: 
            case CHAR_SEQUENCE: 
            case TRUE: 
            case FALSE: {
                field.setFromValue(newInstance, value);
            }
        }
    }

    private static void processCollectionFromMapUsingFields(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Collection<?> collection, Set<String> ignoreSet) {
        Class<?> fieldComponentClass = field.getComponentClass();
        Class<?> valueComponentClass = Reflection.getComponentType(collection);
        if (Typ.isMap(valueComponentClass)) {
            MapObjectConversion.handleCollectionOfMaps(respectIgnore, view, fieldsAccessor, newInstance, field, collection, ignoreSet);
            return;
        }
        if (Typ.isValue(valueComponentClass)) {
            MapObjectConversion.handleCollectionOfValues(respectIgnore, view, fieldsAccessor, newInstance, field, collection, ignoreSet);
            return;
        }
        if (Typ.implementsInterface(collection.getClass(), field.type()) && fieldComponentClass != null && fieldComponentClass.isAssignableFrom(valueComponentClass)) {
            field.setValue(newInstance, collection);
            return;
        }
        if (!field.typeEnum().isCollection()) {
            if (collection instanceof List) {
                try {
                    Object value = MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, (List)collection, field.getComponentClass(), ignoreSet);
                    field.setValue(newInstance, value);
                }
                catch (Exception ex) {
                    field.setValue(newInstance, collection);
                }
            } else {
                field.setValue(newInstance, collection);
            }
            return;
        }
        Collection<Object> newCollection = Conversions.createCollection(field.type(), collection.size());
        if (fieldComponentClass == null || fieldComponentClass.isAssignableFrom(valueComponentClass)) {
            newCollection.addAll(collection);
            field.setValue(newInstance, newCollection);
            return;
        }
        for (Map<String, Object> itemValue : collection) {
            newCollection.add(Conversions.coerce(fieldComponentClass, itemValue));
            field.setValue(newInstance, newCollection);
        }
    }

    private static void processArrayOfMaps(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Object value, Set<String> ignoreSet) {
        Map[] maps = (Map[])value;
        List<Map<String, Object>> list = Lists.list(maps);
        MapObjectConversion.handleCollectionOfMaps(respectIgnore, view, fieldsAccessor, newInstance, field, list, ignoreSet);
    }

    private static void handleCollectionOfMaps(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Collection<Map<String, Object>> collectionOfMaps, Set<String> ignoreSet) {
        Collection<Object> newCollection = Conversions.createCollection(field.type(), collectionOfMaps.size());
        Class<?> componentClass = field.getComponentClass();
        if (componentClass != null) {
            for (Map<String, Object> mapComponent : collectionOfMaps) {
                newCollection.add(MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, mapComponent, componentClass, ignoreSet));
            }
            field.setObject(newInstance, newCollection);
        }
    }

    private static void handleCollectionOfValues(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Collection<Value> acollectionOfValues, Set<String> ignoreSet) {
        Collection<Value> collectionOfValues = acollectionOfValues;
        if (field.typeEnum() == Type.INSTANCE) {
            field.setObject(newInstance, MapObjectConversion.fromList(fieldsAccessor, (List)acollectionOfValues, field.type()));
            return;
        }
        if (collectionOfValues instanceof ValueList) {
            collectionOfValues = ((ValueList)collectionOfValues).list();
        }
        Collection<Object> newCollection = Conversions.createCollection(field.type(), collectionOfValues.size());
        Class<?> componentClass = field.getComponentClass();
        switch (field.typeEnum()) {
            case LIST: 
            case SET: 
            case COLLECTION: {
                for (Value value : (List)collectionOfValues) {
                    if (value.isContainer()) {
                        Object oValue = value.toValue();
                        if (!(oValue instanceof Map)) continue;
                        newCollection.add(MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, (Map)oValue, componentClass, ignoreSet));
                        continue;
                    }
                    newCollection.add(Conversions.coerce(componentClass, value.toValue()));
                }
                field.setObject(newInstance, newCollection);
                break;
            }
            case ARRAY: {
                Type componentType = Type.getType(componentClass);
                int index = 0;
                switch (componentType) {
                    case INT: {
                        int[] iarray = new int[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            iarray[index] = value.intValue();
                            ++index;
                        }
                        field.setObject(newInstance, iarray);
                        return;
                    }
                    case SHORT: {
                        short[] sarray = new short[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            sarray[index] = value.shortValue();
                            ++index;
                        }
                        field.setObject(newInstance, sarray);
                        return;
                    }
                    case DOUBLE: {
                        double[] darray = new double[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            darray[index] = value.doubleValue();
                            ++index;
                        }
                        field.setObject(newInstance, darray);
                        return;
                    }
                    case FLOAT: {
                        float[] farray = new float[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            farray[index] = value.floatValue();
                            ++index;
                        }
                        field.setObject(newInstance, farray);
                        return;
                    }
                    case LONG: {
                        long[] larray = new long[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            larray[index] = value.longValue();
                            ++index;
                        }
                        field.setObject(newInstance, larray);
                        return;
                    }
                    case BYTE: {
                        byte[] barray = new byte[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            barray[index] = value.byteValue();
                            ++index;
                        }
                        field.setObject(newInstance, barray);
                        return;
                    }
                    case CHAR: {
                        char[] chars = new char[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            chars[index] = value.charValue();
                            ++index;
                        }
                        field.setObject(newInstance, chars);
                        return;
                    }
                }
                Object array = Array.newInstance(componentClass, collectionOfValues.size());
                for (Value value : (List)collectionOfValues) {
                    Object o;
                    if (value instanceof ValueContainer) {
                        o = value.toValue();
                        if (o instanceof List) {
                            if (!componentClass.isInstance(o = MapObjectConversion.fromList(fieldsAccessor, (List)o, componentClass))) break;
                            Array.set(array, index, o);
                        }
                    } else {
                        o = value.toValue();
                        if (componentClass.isInstance(o)) {
                            Array.set(array, index, o);
                        } else {
                            Array.set(array, index, Conversions.coerce(componentClass, o));
                        }
                    }
                    ++index;
                }
                field.setValue(newInstance, array);
            }
        }
    }

    public static Map<String, Object> toMap(Object object, String ... ignore) {
        return MapObjectConversion.toMap(object, Sets.set(ignore));
    }

    public static Map<String, Object> toMap(Object object, Set<String> ignore) {
        if (object == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map<String, FieldAccess> fieldMap = Reflection.getAllAccessorFields(object.getClass());
        ArrayList<FieldAccess> fields = new ArrayList<FieldAccess>(fieldMap.values());
        Collections.reverse(fields);
        List<Maps.Entry<String, Object>> entries = Conversions.mapFilterNulls(new FieldToEntryConverter(object), new ArrayList<FieldAccess>(fields));
        map.put("class", object.getClass().getName());
        for (Maps.Entry<String, Object> entry : entries) {
            Object value;
            String key = entry.key();
            if (ignore.contains(key) || (value = entry.value()) == null) continue;
            if (Typ.isBasicType(value)) {
                map.put(key, entry.value());
                continue;
            }
            if (Boon.isArray(value) && Typ.isBasicType(value.getClass().getComponentType())) {
                map.put(key, entry.value());
                continue;
            }
            if (Boon.isArray(value)) {
                int length = Arry.len(value);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(length);
                for (int index = 0; index < length; ++index) {
                    Object item = BeanUtils.idx(value, index);
                    list.add(MapObjectConversion.toMap(item, ignore));
                }
                map.put(key, list);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Class<?> componentType = Reflection.getComponentType(collection, fieldMap.get(entry.key()));
                if (Typ.isBasicType(componentType)) {
                    map.put(key, value);
                    continue;
                }
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(collection.size());
                for (Object item : collection) {
                    if (item == null) continue;
                    list.add(MapObjectConversion.toMap(item, ignore));
                }
                map.put(entry.key(), list);
                continue;
            }
            if (value instanceof Map) continue;
            map.put(entry.key(), MapObjectConversion.toMap(value, ignore));
        }
        return map;
    }

    public static Map<String, Object> toMap(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map<String, FieldAccess> fieldMap = Reflection.getAllAccessorFields(object.getClass());
        ArrayList<FieldAccess> fields = new ArrayList<FieldAccess>(fieldMap.values());
        Collections.reverse(fields);
        List<Maps.Entry<String, Object>> entries = Conversions.mapFilterNulls(new FieldToEntryConverter(object), new ArrayList<FieldAccess>(fields));
        map.put("class", object.getClass().getName());
        for (Maps.Entry<String, Object> entry : entries) {
            Object value = entry.value();
            if (value == null) continue;
            if (Typ.isBasicType(value)) {
                map.put(entry.key(), entry.value());
                continue;
            }
            if (Boon.isArray(value) && Typ.isBasicType(value.getClass().getComponentType())) {
                map.put(entry.key(), entry.value());
                continue;
            }
            if (Boon.isArray(value)) {
                int length = Arry.len(value);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(length);
                for (int index = 0; index < length; ++index) {
                    Object item = BeanUtils.idx(value, index);
                    list.add(MapObjectConversion.toMap(item));
                }
                map.put(entry.key(), list);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Class<?> componentType = Reflection.getComponentType(collection, fieldMap.get(entry.key()));
                if (Typ.isBasicType(componentType)) {
                    map.put(entry.key(), value);
                    continue;
                }
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(collection.size());
                for (Object item : collection) {
                    if (item == null) continue;
                    list.add(MapObjectConversion.toMap(item));
                }
                map.put(entry.key(), list);
                continue;
            }
            if (value instanceof Map) continue;
            map.put(entry.key(), MapObjectConversion.toMap(value));
        }
        return map;
    }

    public static <T> List<T> convertListOfMapsToObjects(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Class<T> componentType, List<?> list, Set<String> ignoreProperties) {
        ArrayList<T> newList = new ArrayList<T>(list.size());
        for (Object obj : list) {
            if (obj instanceof Value) {
                obj = ((Value)obj).toValue();
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                if (map instanceof ValueMapImpl) {
                    newList.add(MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, map, componentType, ignoreProperties));
                    continue;
                }
                newList.add(MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, map, componentType, ignoreProperties));
                continue;
            }
            newList.add(Conversions.coerce(componentType, obj));
        }
        return newList;
    }

    public static List<Map<String, Object>> toListOfMaps(Collection<?> collection) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Object o : collection) {
            list.add(MapObjectConversion.toMap(o));
        }
        return list;
    }

    public static class FieldToEntryConverter
    implements Function<FieldAccess, Maps.Entry<String, Object>> {
        final Object object;

        public FieldToEntryConverter(Object object) {
            this.object = object;
        }

        @Override
        public Maps.Entry<String, Object> apply(FieldAccess from) {
            if (from.isReadOnly()) {
                return null;
            }
            Maps.EntryImpl<String, Object> entry = new Maps.EntryImpl<String, Object>(from.name(), from.getValue(this.object));
            return entry;
        }
    }
}

