/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.invoke.ConstantCallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.core.Typ;
import org.boon.core.Type;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.MethodAccess;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.primitive.CharBuf;

public class Invoker {
    public static Object invokeOverloadedFromObject(Object object, String name, Object args) {
        return Invoker.invokeOverloadedFromObject(false, null, null, object, name, args);
    }

    public static Object invokeOverloadedFromObject(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, String name, Object args) {
        try {
            if (args instanceof Map) {
                return Invoker.invokeOverloadedFromList(respectIgnore, view, ignoreProperties, object, name, Lists.list(args));
            }
            if (args instanceof List) {
                List list = (List)args;
                ClassMeta<?> classMeta = ClassMeta.classMeta(object.getClass());
                MethodAccess m = classMeta.method(name);
                if (m.parameterTypes().length == 1 && list.size() > 0) {
                    Object firstArg = list.get(0);
                    if (firstArg instanceof Map || firstArg instanceof List) {
                        return Invoker.invokeOverloadedFromList(respectIgnore, view, ignoreProperties, object, name, list);
                    }
                    return Invoker.invokeOverloadedFromList(respectIgnore, view, ignoreProperties, object, name, Lists.list(args));
                }
                return Invoker.invokeOverloadedFromList(respectIgnore, view, ignoreProperties, object, name, list);
            }
            if (args == null) {
                return Invoker.invoke(object, name, new Object[0]);
            }
            return Invoker.invokeOverloadedFromList(respectIgnore, view, ignoreProperties, object, name, Lists.list(args));
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, ex, "Unable to invoke method object", object, "name", name, "args", args);
        }
    }

    public static Object invokeFromObject(Object object, String name, Object args) {
        return Invoker.invokeFromObject(false, null, null, object, name, args);
    }

    public static Object invokeFromObject(Class<?> cls, String name, Object args) {
        return Invoker.invokeFromObject(false, null, null, cls, null, name, args);
    }

    public static Object invokeMethodFromObjectArg(Object object, MethodAccess method, Object args) {
        return Invoker.invokeMethodFromObjectArg(false, null, null, object, method, args);
    }

    public static Object invokeMethodFromObjectArg(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, MethodAccess method, Object args) {
        try {
            if (args instanceof Map) {
                return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, Lists.list(args));
            }
            if (args instanceof List) {
                List list = (List)args;
                Class<?>[] paramTypes = method.parameterTypes();
                if (paramTypes.length == 1 && list.size() > 0) {
                    Class<?> firstParamType = paramTypes[0];
                    Object firstArg = list.get(0);
                    if (firstArg instanceof Map) {
                        return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, list);
                    }
                    if (firstArg instanceof List && !Typ.isCollection(firstParamType) && !firstParamType.isArray()) {
                        return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, list);
                    }
                    return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, Lists.list(args));
                }
                return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, list);
            }
            if (args == null) {
                return method.invoke(object, new Object[0]);
            }
            return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, Lists.list(args));
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, ex, "Unable to invoke method object", object, "method", method, "args", args);
        }
    }

    public static Object invokeFromObject(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, String name, Object args) {
        return Invoker.invokeFromObject(respectIgnore, view, ignoreProperties, object.getClass(), object, name, args);
    }

    public static Object invokeFromObject(boolean respectIgnore, String view, Set<String> ignoreProperties, Class<?> cls, Object object, String name, Object args) {
        try {
            if (args instanceof Map) {
                return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, cls, object, name, Lists.list(args));
            }
            if (args instanceof List) {
                List list = (List)args;
                ClassMeta<?> classMeta = ClassMeta.classMeta(cls);
                MethodAccess m = classMeta.method(name);
                if (m.parameterTypes().length == 1 && list.size() > 0) {
                    Object firstArg = list.get(0);
                    if (firstArg instanceof Map || firstArg instanceof List) {
                        return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, cls, object, name, list);
                    }
                    return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, cls, object, name, Lists.list(args));
                }
                return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, cls, object, name, list);
            }
            if (args == null) {
                return Invoker.invoke(object, name, new Object[0]);
            }
            return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, cls, object, name, Lists.list(args));
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, ex, "Unable to invoke method object", object, "name", name, "args", args);
        }
    }

    public static Object invokeFromList(Object object, String name, List<?> args) {
        return Invoker.invokeFromList(true, null, null, object, name, args);
    }

    public static Object invokeFromList(Class<?> cls, String name, List<?> args) {
        return Invoker.invokeFromList(true, null, null, cls, null, name, args);
    }

    public static Object invokeFromList(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, String name, List<?> args) {
        return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, object.getClass(), object, name, args);
    }

    private static Object[] convertArguments(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, List<?> argsList, MethodAccess methodAccess) {
        ArrayList<Object> convertedArguments = new ArrayList<Object>(argsList);
        Class[] parameterTypes = methodAccess.parameterTypes();
        boolean[] flag = new boolean[1];
        if (convertedArguments.size() != parameterTypes.length) {
            return Exceptions.die(Object[].class, "The list size does not match the parameter length of the method. Unable to invoke method", methodAccess.name(), "on object", object, "with arguments", convertedArguments);
        }
        FieldsAccessor fieldsAccessor = FieldAccessMode.FIELD.create(true);
        for (int index = 0; index < parameterTypes.length; ++index) {
            if (MapObjectConversion.matchAndConvertArgs(respectIgnore, view, fieldsAccessor, convertedArguments, methodAccess, parameterTypes, index, ignoreProperties, flag, true)) continue;
            return Exceptions.die(Object[].class, index, "Unable to invoke method as argument types did not match", methodAccess.name(), "on object", object, "with arguments", convertedArguments, "\nValue at index = ", convertedArguments.get(index));
        }
        return convertedArguments.toArray(new Object[convertedArguments.size()]);
    }

    public static Object invokeFromList(boolean respectIgnore, String view, Set<String> ignoreProperties, Class<?> cls, Object object, String name, List<?> argsList) {
        Object[] finalArgs = null;
        ClassMeta<?> classMeta = ClassMeta.classMeta(cls);
        MethodAccess methodAccess = classMeta.method(name);
        try {
            finalArgs = Invoker.convertArguments(respectIgnore, view, ignoreProperties, object, argsList, methodAccess);
            return methodAccess.invoke(object, finalArgs);
        }
        catch (Exception ex) {
            if (methodAccess != null) {
                CharBuf buf = CharBuf.create(200);
                buf.addLine();
                buf.multiply('-', 10).add("FINAL ARGUMENTS").multiply('-', 10).addLine();
                if (finalArgs != null) {
                    for (Object o : finalArgs) {
                        buf.puts("argument type    ", Boon.className(o));
                    }
                }
                buf.multiply('-', 10).add("INVOKE METHOD").add(methodAccess).multiply('-', 10).addLine();
                buf.multiply('-', 10).add("INVOKE METHOD PARAMS").multiply('-', 10).addLine();
                for (Class<?> c : methodAccess.parameterTypes()) {
                    buf.puts("constructor type ", c);
                }
                buf.multiply('-', 35).addLine();
                if (Boon.debugOn()) {
                    Boon.puts(buf);
                }
                Boon.error(ex, "unable to create invoke method", buf);
                return Exceptions.handle(Object.class, ex, buf.toString(), "\nconstructor parameter types", methodAccess.parameterTypes(), "\noriginal args\n", argsList, "\nlist args after conversion", finalArgs, "\nconverted types\n", Type.gatherTypes(finalArgs), "original types\n", Type.gatherTypes(argsList), "\n");
            }
            return Exceptions.handle(Object.class, ex, "\nlist args after conversion", finalArgs, "types", Type.gatherTypes(finalArgs), "\noriginal args", argsList, "original types\n", Type.gatherTypes(argsList), "\n");
        }
    }

    public static Object invokeMethodFromList(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, MethodAccess method, List<?> argsList) {
        try {
            if (argsList == null && method.parameterTypes().length == 0) {
                return method.invoke(object, new Object[0]);
            }
            Object[] finalArgs = Invoker.convertArguments(respectIgnore, view, ignoreProperties, object, argsList, method);
            return method.invoke(object, finalArgs);
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, ex, "Unable to invoke method object", object, "method", method, "args", argsList);
        }
    }

    public static Object invokeEither(Object object, String name, Object ... args) {
        if (object instanceof Class) {
            return Invoker.invoke((Class)object, name, args);
        }
        return Invoker.invoke(object, name, args);
    }

    public static Object invoke(Object object, String name, Object ... args) {
        return ClassMeta.classMetaUnTyped(object.getClass()).invokeUntyped(object, name, args);
    }

    public static MethodAccess invokeMethodAccess(Object object, String name) {
        return ClassMeta.classMeta(object.getClass()).invokeMethodAccess(name);
    }

    public static MethodAccess invokeMethodAccess(Class<?> cls, String name) {
        return ClassMeta.classMeta(cls).invokeMethodAccess(name);
    }

    public static Object invoke(Class cls, String name, Object ... args) {
        return ClassMeta.classMeta(cls).invokeStatic(name, args);
    }

    public static Object invokeOverloaded(Object object, String name, Object ... args) {
        ClassMeta<?> classMeta = ClassMeta.classMeta(object.getClass());
        Iterable<MethodAccess> invokers = classMeta.methods(name);
        for (MethodAccess m : invokers) {
            if (!m.respondsTo(args)) continue;
            return m.invoke(object, args);
        }
        return Exceptions.die(Object.class, "Unable to invoke method", name, "on object", object, "with arguments", args);
    }

    public static Object invokeOverloadedFromList(Object object, String name, List<?> args) {
        return Invoker.invokeOverloadedFromList(true, null, null, object, name, args);
    }

    public static Object invokeOverloadedFromList(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, String name, List<?> args) {
        boolean[] flag;
        FieldsAccessor fieldsAccessor;
        ArrayList<Object> list;
        ClassMeta<?> classMeta = ClassMeta.classMeta(object.getClass());
        Iterable<MethodAccess> invokers = classMeta.methods(name);
        MethodAccess method = Invoker.lookupOverloadedMethod(respectIgnore, view, ignoreProperties, invokers, list = new ArrayList<Object>(args), fieldsAccessor = FieldAccessMode.FIELD.create(true), flag = new boolean[1], false);
        if (method == null) {
            method = Invoker.lookupOverloadedMethod(respectIgnore, view, ignoreProperties, invokers, list, fieldsAccessor, flag, true);
        }
        if (method != null) {
            return method.invoke(object, list.toArray(new Object[list.size()]));
        }
        return Exceptions.die(Object.class, "Unable to invoke method", name, "on object", object, "with arguments", args);
    }

    private static MethodAccess lookupOverloadedMethod(boolean respectIgnore, String view, Set<String> ignoreProperties, Iterable<MethodAccess> invokers, List<Object> list, FieldsAccessor fieldsAccessor, boolean[] flag, boolean loose) {
        MethodAccess method = null;
        block0: for (MethodAccess m : invokers) {
            Class[] parameterTypes = m.parameterTypes();
            if (parameterTypes.length != list.size()) continue;
            for (int index = 0; index < parameterTypes.length; ++index) {
                if (!MapObjectConversion.matchAndConvertArgs(respectIgnore, view, fieldsAccessor, list, m, parameterTypes, index, ignoreProperties, flag, loose)) continue block0;
            }
            method = m;
            break;
        }
        return method;
    }

    public static void invokeMethodWithAnnotationNoReturn(Object object, String annotation) {
        Invoker.invokeMethodWithAnnotationWithReturnType(object, annotation, Void.TYPE);
    }

    public static void invokeMethodWithAnnotationWithReturnType(Object object, String annotation, Class<?> returnType) {
        Invoker.invokeMethodWithAnnotationWithReturnType(object.getClass(), object, annotation, returnType);
    }

    public static void invokeMethodWithAnnotationWithReturnType(Class<?> type, Object object, String annotation, Class<?> returnType) {
        ClassMeta<?> classMeta = ClassMeta.classMeta(type);
        Iterable<MethodAccess> iterate = classMeta.methods();
        for (MethodAccess m : iterate) {
            if (!m.hasAnnotation(annotation) || m.parameterTypes().length != 0 || m.returnType() != Void.TYPE) continue;
            m.invoke(object, new Object[0]);
            break;
        }
    }

    public static <T> boolean invokeBooleanReturn(Object object, T v) {
        Class<?> cls;
        Object instance = null;
        if (object instanceof Class) {
            cls = (Class<?>)object;
        } else {
            cls = object.getClass();
            instance = object;
        }
        ClassMeta<?> meta = ClassMeta.classMeta(cls);
        return meta.invokePredicate(instance, v);
    }

    public static Object invokeReducer(Object object, Object sum, Object value) {
        if (object instanceof Class) {
            ClassMeta meta = ClassMeta.classMeta((Class)object);
            return meta.invokeReducer(null, sum, value);
        }
        ClassMeta<?> meta = ClassMeta.classMeta(object.getClass());
        return meta.invokeReducer(object, sum, value);
    }

    public static Object invokeFunction(Object object, Object arg) {
        if (object instanceof Class) {
            ClassMeta meta = ClassMeta.classMeta((Class)object);
            return meta.invokeFunction(null, arg);
        }
        ClassMeta<?> meta = ClassMeta.classMeta(object.getClass());
        return meta.invokeFunction(object, arg);
    }

    public static MethodAccess invokeFunctionMethodAccess(Object object) {
        if (object instanceof Class) {
            ClassMeta meta = ClassMeta.classMeta((Class)object);
            return meta.invokeFunctionMethodAccess();
        }
        ClassMeta<?> meta = ClassMeta.classMeta(object.getClass());
        return meta.invokeFunctionMethodAccess();
    }

    public static ConstantCallSite invokeReducerLongIntReturnLongMethodHandle(Object object) {
        ClassMeta<?> meta = ClassMeta.classMeta(object.getClass());
        return meta.invokeReducerLongIntReturnLongMethodHandle(object);
    }

    public static <T> ConstantCallSite invokeReducerLongIntReturnLongMethodHandle(T object, String methodName) {
        ClassMeta<?> meta = ClassMeta.classMeta(object.getClass());
        return meta.invokeReducerLongIntReturnLongMethodHandle(object, methodName);
    }

    public static Method invokeReducerLongIntReturnLongMethod(Object object) {
        ClassMeta<?> meta = ClassMeta.classMeta(object.getClass());
        return meta.invokeReducerLongIntReturnLongMethod(object);
    }

    public static <T> Method invokeReducerLongIntReturnLongMethod(T object, String methodName) {
        ClassMeta<?> meta = ClassMeta.classMeta(object.getClass());
        return meta.invokeReducerLongIntReturnLongMethod(object, methodName);
    }
}

