/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Sets;
import org.boon.Str;
import org.boon.StringScanner;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.Type;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.MapField;
import org.boon.primitive.CharScanner;

public class BeanUtils {
    static Map<String, String[]> splitsPathsCache = new ConcurrentHashMap<String, String[]>();

    private static Map<String, FieldAccess> getPropertyFieldAccessMap(Class<?> clazz) {
        return Reflection.getPropertyFieldAccessMapFieldFirst(clazz);
    }

    public static FieldAccess getField(Class clazz, String name) {
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(clazz);
        if (fields != null) {
            return fields.get(name);
        }
        return null;
    }

    public static FieldAccess getField(Object object, String name) {
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        if (fields != null) {
            return fields.get(name);
        }
        return null;
    }

    public static Map<String, FieldAccess> getFieldsFromObject(Class<?> cls) {
        return BeanUtils.getPropertyFieldAccessMap(cls);
    }

    public static Map<String, FieldAccess> getFieldsFromObject(Object object) {
        try {
            Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
            if (object instanceof Map) {
                fields = BeanUtils.getFieldsFromMap(fields, (Map)object);
            }
            return fields;
        }
        catch (Exception ex) {
            Exceptions.requireNonNull(object, "Item cannot be null");
            return Exceptions.handle(Map.class, ex, "Unable to get fields from object", Boon.className(object));
        }
    }

    private static Map<String, FieldAccess> getFieldsFromMap(Map<String, FieldAccess> fields, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            fields.put(entry.getKey(), new MapField(entry.getKey()));
        }
        return fields;
    }

    public static void setPropertyValue(Object root, Object newValue, String ... properties) {
        Object object = root;
        int index = 0;
        try {
            for (String property : properties) {
                Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
                FieldAccess field = fields.get(property);
                if (StringScanner.isDigits(property)) {
                    object = BeanUtils.idx(object, Integer.parseInt(property));
                } else {
                    if (field == null) {
                        Exceptions.die(Boon.sputs("We were unable to access property=", property, "\nThe properties passed were=", properties, "\nThe root object is =", root.getClass().getName(), "\nThe current object is =", object.getClass().getName()));
                    }
                    if (index == properties.length - 1) {
                        field.setValue(object, newValue);
                    } else {
                        object = field.getObject(object);
                    }
                }
                ++index;
            }
        }
        catch (Exception ex) {
            Exceptions.requireNonNull(root, "Root cannot be null");
            Exceptions.handle(ex, "Unable to set property for root object", Boon.className(root), "for property path", properties, "with new value", newValue, "last object in the tree was", Boon.className(object), "current property index", index);
        }
    }

    public static void setPropertyValue(Class<?> root, Object newValue, String ... properties) {
        Object object = root;
        int index = 0;
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(root);
        try {
            for (String property : properties) {
                FieldAccess field = fields.get(property);
                if (StringScanner.isDigits(property)) {
                    object = BeanUtils.idx(object, Integer.parseInt(property));
                } else {
                    if (field == null) {
                        Exceptions.die(Boon.sputs("We were unable to access property=", property, "\nThe properties passed were=", properties, "\nThe root object is =", root.getClass().getName(), "\nThe current object is =", object.getClass().getName()));
                    }
                    if (index == properties.length - 1) {
                        if (object instanceof Class) {
                            field.setStaticValue(newValue);
                        } else {
                            field.setValue(object, newValue);
                        }
                    } else if ((object = field.getObject(object)) != null) {
                        fields = BeanUtils.getFieldsFromObject(root);
                    }
                }
                ++index;
            }
        }
        catch (Exception ex) {
            Exceptions.requireNonNull(root, "Root cannot be null");
            Exceptions.handle(ex, "Unable to set property for root object", Boon.className(root), "for property path", properties, "with new value", newValue, "last object in the tree was", Boon.className(object), "current property index", index);
        }
    }

    public static Object getPropertyValue(Object root, String ... properties) {
        Object object = root;
        for (String property : properties) {
            if (object == null) {
                return null;
            }
            if (property.equals("this")) {
                Object aThis;
                if (!(object instanceof Map) || (aThis = ((Map)object).get("this")) == null) continue;
                object = aThis;
                continue;
            }
            if (object instanceof Map) {
                object = ((Map)object).get(property);
                continue;
            }
            char c = property.charAt(0);
            if (CharScanner.isDigit(c)) {
                object = BeanUtils.idx(object, Integer.parseInt(property));
                continue;
            }
            if (object instanceof Collection) {
                object = BeanUtils.getFieldValuesFromCollection((Collection)object, property);
                object = Conversions.unifyListOrArray(object);
                continue;
            }
            Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
            FieldAccess field = fields.get(property);
            if (field == null) {
                return null;
            }
            object = field.getValue(object);
        }
        return object;
    }

    private static Object _getPropertyValue(Object root, String property) {
        Object object = root;
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            object = BeanUtils.getFieldValuesFromCollection((Collection)object, property);
            object = Conversions.unifyList((List)object);
            return object;
        }
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
        FieldAccess field = fields.get(property);
        if (field == null) {
            return null;
        }
        object = field.getValue(object);
        return object;
    }

    public static Class<?> getPropertyType(Object root, String property) {
        Exceptions.requireNonNull(root);
        Exceptions.requireNonNull(property);
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(root.getClass());
        FieldAccess field = fields.get(property);
        return field.type();
    }

    public static <T> T idxGeneric(Class<T> t, Object object, String path) {
        Exceptions.requireNonNull(object);
        Exceptions.requireNonNull(path);
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return (T)BeanUtils.getPropByPath(object, properties);
    }

    public static <T> List<T> idxList(Class<T> cls, Object items, String ... path) {
        return (List)BeanUtils.getPropByPath(items, path);
    }

    public static Object getPropByPath(Object item, String ... path) {
        Object o = item;
        for (int index = 0; index < path.length; ++index) {
            String propName = path[index];
            if (o == null) {
                return null;
            }
            if (o.getClass().isArray() || o instanceof Collection) {
                o = BeanUtils.getCollectionProp(o, propName, index, path);
                break;
            }
            o = BeanUtils.getProp(o, propName);
        }
        return Conversions.unifyListOrArray(o);
    }

    public static Object idx(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyValue(object, properties);
    }

    public static Object indexOf(Object object, String path) {
        return BeanUtils.atIndex(object, path);
    }

    public static Object atIndex(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyValue(object, properties);
    }

    private static String[] propertyPathAsStringArray(String path) {
        String[] split = splitsPathsCache.get(path);
        if (split != null) {
            return split;
        }
        split = StringScanner.splitByCharsNoneEmpty(path, '.', '[', ']', '/');
        splitsPathsCache.put(path, split);
        return split;
    }

    public static Object findProperty(Object context, String propertyPath) {
        int index = propertyPath.indexOf(124);
        String defaultValue = null;
        if (index != -1) {
            String[] splitByPipe = Str.splitByPipe(propertyPath);
            defaultValue = splitByPipe[1];
            propertyPath = splitByPipe[0];
        } else {
            defaultValue = null;
        }
        Object object = null;
        Iterator iterator = Conversions.iterator(context);
        while (iterator.hasNext()) {
            Object ctx = iterator.next();
            object = BeanUtils.idx(ctx, propertyPath);
            if (object == null) continue;
            return object;
        }
        return defaultValue;
    }

    public static void injectIntoProperty(Object object, String path, Object value) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        BeanUtils.setPropertyValue(object, value, properties);
    }

    public static void idx(Object object, String path, Object value) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        BeanUtils.setPropertyValue(object, value, properties);
    }

    public static void idx(Class<?> cls, String path, Object value) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        BeanUtils.setPropertyValue(cls, value, properties);
    }

    public static Object byPath(Object object, String path) {
        try {
            String[] properties = BeanUtils.propertyPathAsStringArray(path);
            return BeanUtils.getPropByPath(object, properties);
        }
        catch (Exception ex) {
            Exceptions.requireNonNull(object);
            Exceptions.requireNonNull(path);
            return Exceptions.handle(Object.class, ex, object, path);
        }
    }

    private static Object getCollectionProp(Object o, String propName, int index, String[] path) {
        o = BeanUtils.getFieldValuesFromCollection(o, propName);
        if (index + 1 == path.length) {
            return o;
        }
        return BeanUtils.getCollectionProp(o, path[++index], index, path);
    }

    public static Object getProp(Object object, String property) {
        Class<?> cls;
        Map<String, FieldAccess> fields;
        if (object == null) {
            return null;
        }
        if (StringScanner.isDigits(property)) {
            object = BeanUtils.idx(object, Integer.parseInt(property));
        }
        if (!(fields = Reflection.getPropertyFieldAccessors(cls = object.getClass())).containsKey(property)) {
            fields = Reflection.getAllAccessorFields(cls);
        }
        if (!fields.containsKey(property)) {
            return null;
        }
        return fields.get(property).getValue(object);
    }

    public static int getPropertyInt(Object root, String ... properties) {
        Exceptions.requireNonNull(root);
        Exceptions.requireNonNull(properties);
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        String lastProperty = properties[properties.length - 1];
        FieldAccess field = fields.get(lastProperty);
        if (field.type() == Typ.intgr) {
            return field.getInt(object);
        }
        return Conversions.toInt(field.getValue(object));
    }

    private static Object baseForGetProperty(Object root, String[] properties) {
        Object object = root;
        Map<String, FieldAccess> fields = null;
        for (int index = 0; index < properties.length - 1; ++index) {
            if (object == null) {
                return null;
            }
            String property = properties[index];
            if (property.equals("this")) continue;
            fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
            FieldAccess field = fields.get(property);
            if (StringScanner.isDigits(property)) {
                object = BeanUtils.idx(object, Integer.parseInt(property));
                continue;
            }
            if (field == null) {
                return null;
            }
            object = field.getObject(object);
        }
        return object;
    }

    private static Class<?> baseForGetProperty(Class<?> root, String[] properties) {
        Class<?> cls = root;
        Map<String, FieldAccess> fields = null;
        for (int index = 0; index < properties.length - 1; ++index) {
            fields = BeanUtils.getPropertyFieldAccessMap(cls);
            String property = properties[index];
            FieldAccess field = fields.get(property);
            cls = field.type();
        }
        return cls;
    }

    public static int idxInt(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyInt(object, properties);
    }

    public static String idxStr(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyString(object, properties);
    }

    private static String getPropertyString(Object root, String[] properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.type() == Typ.string) {
            return (String)field.getObject(object);
        }
        return Conversions.toString(field.getValue(object));
    }

    public static byte getPropertyByte(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.type() == Typ.bt) {
            return field.getByte(object);
        }
        return Conversions.toByte(field.getValue(object));
    }

    public static byte idxByte(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyByte(object, properties);
    }

    public static float getPropertyFloat(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.type() == Typ.flt) {
            return field.getFloat(object);
        }
        return Conversions.toFloat(field.getValue(object));
    }

    public static float idxFloat(Object object, String path) {
        Exceptions.requireNonNull(object);
        Exceptions.requireNonNull(path);
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyFloat(object, properties);
    }

    public static short getPropertyShort(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.type() == Typ.shrt) {
            return field.getShort(object);
        }
        return Conversions.toShort(field.getValue(object));
    }

    public static Class<?> getPropertyPathType(Object root, String ... properties) {
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        String lastProperty = properties[properties.length - 1];
        FieldAccess field = fields.get(lastProperty);
        return field.type();
    }

    public static FieldAccess getPropertyPathField(Object root, String ... properties) {
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        String lastProperty = properties[properties.length - 1];
        FieldAccess field = fields.get(lastProperty);
        return field;
    }

    public static FieldAccess getPropertyPathField(Class root, String ... properties) {
        Class<?> cls = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(cls);
        String lastProperty = properties[properties.length - 1];
        FieldAccess field = fields.get(lastProperty);
        return field;
    }

    public static short idxShort(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyShort(object, properties);
    }

    public static Class idxType(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyPathType(object, properties);
    }

    public static FieldAccess idxField(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyPathField(object, properties);
    }

    public static FieldAccess idxField(Class<?> cls, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyPathField(cls, properties);
    }

    public static char getPropertyChar(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.type() == Typ.chr) {
            return field.getChar(object);
        }
        return Conversions.toChar(field.getValue(object));
    }

    public static char idxChar(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyChar(object, properties);
    }

    public static double getPropertyDouble(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.type() == Typ.dbl) {
            return field.getDouble(object);
        }
        return Conversions.toDouble(field.getValue(object));
    }

    public static double idxDouble(Object object, String path) {
        Exceptions.requireNonNull(object);
        Exceptions.requireNonNull(path);
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyDouble(object, properties);
    }

    public static long getPropertyLong(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.type() == Typ.lng) {
            return field.getLong(object);
        }
        return Conversions.toLong(field.getValue(object));
    }

    public static long idxLong(Object object, String path) {
        Exceptions.requireNonNull(object);
        Exceptions.requireNonNull(path);
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyLong(object, properties);
    }

    public static boolean getPropertyBoolean(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.type() == Typ.bln) {
            return field.getBoolean(object);
        }
        return Conversions.toBoolean(field.getValue(object));
    }

    public static boolean idxBoolean(Object object, String path) {
        Exceptions.requireNonNull(object);
        Exceptions.requireNonNull(path);
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyBoolean(object, properties);
    }

    public static <V> Map<String, V> collectionToMap(String propertyKey, Collection<V> values) {
        LinkedHashMap<String, V> map = new LinkedHashMap<String, V>(values.size());
        Iterator<V> iterator = values.iterator();
        for (V v : values) {
            String key = BeanUtils.idxGeneric(Typ.string, v, propertyKey);
            map.put(key, v);
        }
        return map;
    }

    public static void copyProperties(Object object, Map<String, Object> properties) {
        Set<Map.Entry<String, Object>> props = properties.entrySet();
        for (Map.Entry<String, Object> entry : props) {
            BeanUtils.setPropertyValue(object, entry.getValue(), entry.getKey());
        }
    }

    public static Object getFieldValuesFromCollection(Collection collection, String key) {
        if (collection.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        Object firstItem = collection instanceof List ? ((List)collection).get(0) : collection.iterator().next();
        if (firstItem instanceof Map) {
            for (Object item : collection) {
                Map map = (Map)item;
                list.add(map.get(key));
            }
            return list;
        }
        if (firstItem instanceof Collection) {
            for (Object item : collection) {
                list.add(BeanUtils._getPropertyValue(item, key));
            }
            return list;
        }
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(Typ.getComponentType(collection));
        for (Object item : collection) {
            FieldAccess field = fields.get(key);
            list.add(field.getValue(item));
        }
        return list;
    }

    public static Object getFieldValuesFromCollection(Object object, String key) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Object> list = new ArrayList<Object>(collection.size());
            Object firstItem = collection.iterator().next();
            if (firstItem instanceof Map) {
                for (Object item : collection) {
                    Map map = (Map)item;
                    list.add(map.get(key));
                }
                return list;
            }
            Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(Typ.getComponentType(collection));
            for (Object item : collection) {
                FieldAccess field = fields.get(key);
                if (field == null) {
                    list.add(BeanUtils.idx(item, key));
                    continue;
                }
                list.add(field.getValue(item));
            }
            return list;
        }
        if (object.getClass().isArray()) {
            int len = Array.getLength(object);
            ArrayList<Object> list = new ArrayList<Object>(len);
            Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass().getComponentType());
            for (int index = 0; index < len; ++index) {
                list.add(fields.get(key).getValue(Array.get(object, index)));
            }
            return list;
        }
        return BeanUtils.atIndex(object, key);
    }

    public static <T> T copy(T item) {
        if (item instanceof Cloneable) {
            return (T)ClassMeta.classMeta(item.getClass()).invokeUntyped(item, "clone", null);
        }
        return BeanUtils.fieldByFieldCopy(item);
    }

    public static <T> T fieldByFieldCopy(T item) {
        Class<?> aClass = item.getClass();
        Map<String, FieldAccess> fields = Reflection.getAllAccessorFields(aClass);
        Object clone = Reflection.newInstance(aClass);
        for (FieldAccess field : fields.values()) {
            try {
                if (field.isStatic() || field.isWriteOnly()) continue;
                if (field.isPrimitive()) {
                    field.setValue(clone, field.getValue(item));
                    continue;
                }
                Object value = field.getObject(item);
                if (value == null) {
                    field.setObject(clone, null);
                    continue;
                }
                if (!field.isPrimitive() && !Typ.isBasicType(field.type())) {
                    field.setObject(clone, BeanUtils.copy(value));
                    continue;
                }
                if (Typ.isBasicType(field.type())) {
                    field.setObject(clone, value);
                    continue;
                }
                if (Typ.isCollection(field.type())) {
                    Collection src = (Collection)value;
                    Class<?> collectionType = field.type();
                    Collection<Object> dst = Conversions.createCollection(collectionType, src.size());
                    for (Object o : src) {
                        dst.add(BeanUtils.copy(o));
                    }
                    field.setObject(clone, dst);
                    continue;
                }
                if (Typ.isMap(field.type()) || !field.type().isArray()) continue;
                int length = Array.getLength(value);
                Object dst = Array.newInstance(field.getComponentClass(), length);
                for (int index = 0; index < length; ++index) {
                    Object o = Array.get(value, index);
                    Array.set(dst, index, BeanUtils.copy(o));
                }
                field.setObject(clone, dst);
            }
            catch (Exception ex) {
                return (T)Exceptions.handle(Object.class, "" + field, ex);
            }
        }
        return (T)clone;
    }

    public static void copyProperties(Object src, Object dest) {
        BeanUtils.fieldByFieldCopy(src, dest);
    }

    public static <T> T createFromSrc(Object src, Class<T> dest) {
        T instance = Reflection.newInstance(dest);
        BeanUtils.fieldByFieldCopy(src, instance);
        return instance;
    }

    public static void copyProperties(Object src, Object dest, String ... ignore) {
        BeanUtils.fieldByFieldCopy(src, dest, Sets.set(ignore));
    }

    public static void copyProperties(Object src, Object dest, Set<String> ignore) {
        BeanUtils.fieldByFieldCopy(src, dest, ignore);
    }

    private static void fieldByFieldCopy(Object src, Object dst, Set<String> ignore) {
        Class<?> srcClass = src.getClass();
        Map<String, FieldAccess> srcFields = Reflection.getAllAccessorFields(srcClass);
        Class<?> dstClass = dst.getClass();
        Map<String, FieldAccess> dstFields = Reflection.getAllAccessorFields(dstClass);
        for (FieldAccess srcField : srcFields.values()) {
            if (ignore.contains(srcField.name())) continue;
            FieldAccess dstField = dstFields.get(srcField.name());
            try {
                BeanUtils.copySrcFieldToDestField(src, dst, dstField, srcField, ignore);
            }
            catch (Exception ex) {
                Exceptions.handle(Boon.sputs("copying field", srcField.name(), srcClass, " to ", dstField.name(), dstClass), (Throwable)ex);
            }
        }
    }

    private static void fieldByFieldCopy(Object src, Object dst) {
        Class<?> srcClass = src.getClass();
        Map<String, FieldAccess> srcFields = Reflection.getAllAccessorFields(srcClass);
        Class<?> dstClass = dst.getClass();
        Map<String, FieldAccess> dstFields = Reflection.getAllAccessorFields(dstClass);
        for (FieldAccess srcField : srcFields.values()) {
            FieldAccess dstField = dstFields.get(srcField.name());
            try {
                BeanUtils.copySrcFieldToDestField(src, dst, dstField, srcField, null);
            }
            catch (Exception ex) {
                Exceptions.handle(Boon.sputs("copying field", srcField.name(), srcClass, " to ", dstField.name(), dstClass), (Throwable)ex);
            }
        }
    }

    private static void copySrcFieldToDestField(Object src, Object dst, FieldAccess dstField, FieldAccess srcField, Set<String> ignore) {
        if (srcField.isStatic()) {
            return;
        }
        if (dstField == null) {
            return;
        }
        if (srcField.isPrimitive()) {
            dstField.setValue(dst, srcField.getValue(src));
            return;
        }
        Object srcValue = srcField.getObject(src);
        if (srcValue == null) {
            if (!dstField.isPrimitive()) {
                dstField.setObject(dst, null);
            }
            return;
        }
        if (Typ.isBasicType(srcField.type())) {
            Object value = srcField.getObject(src);
            dstField.setValue(dst, value);
            return;
        }
        if (!(srcValue instanceof Collection) && dstField.type() == srcValue.getClass() || Typ.isSuperType(dstField.type(), srcValue.getClass())) {
            dstField.setObject(dst, BeanUtils.copy(srcField.getObject(src)));
            return;
        }
        if (srcValue instanceof Collection && dstField.getComponentClass() != null && Typ.isCollection(dstField.type())) {
            BeanUtils.handleCollectionFieldCopy(dst, dstField, (Collection)srcValue);
            return;
        }
        if (dstField.typeEnum() != Type.ABSTRACT && dstField.typeEnum() != Type.INTERFACE) {
            Object newInstance = Reflection.newInstance(dstField.type());
            if (ignore == null) {
                BeanUtils.fieldByFieldCopy(srcField.getObject(src), newInstance);
            } else {
                BeanUtils.fieldByFieldCopy(srcField.getObject(src), newInstance, ignore);
            }
            dstField.setObject(dst, newInstance);
        }
    }

    private static void handleCollectionFieldCopy(Object dst, FieldAccess dstField, Collection srcValue) {
        if (dstField.getComponentClass() != Typ.string) {
            Collection<Object> dstCollection = Conversions.createCollection(dstField.type(), srcValue.size());
            for (Object srcComponentValue : srcValue) {
                Object newInstance = Reflection.newInstance(dstField.getComponentClass());
                BeanUtils.fieldByFieldCopy(srcComponentValue, newInstance);
                dstCollection.add(newInstance);
            }
            dstField.setObject(dst, dstCollection);
        } else {
            Collection<Object> dstCollection = Conversions.createCollection(dstField.type(), srcValue.size());
            for (Object srcComponentValue : srcValue) {
                if (srcComponentValue == null) continue;
                dstCollection.add(srcComponentValue.toString());
            }
            dstField.setObject(dst, dstCollection);
        }
    }

    public static Object idx(Object object, int index) {
        if (Boon.isArray(object)) {
            object = Array.get(object, index);
        } else if (object instanceof List) {
            object = Lists.idx((List)object, index);
        }
        return object;
    }

    public static void idx(Object object, int index, Object value) {
        try {
            if (Boon.isArray(object)) {
                Array.set(object, index, value);
            } else if (object instanceof List) {
                Lists.idx((List)object, index, value);
            }
        }
        catch (Exception notExpected) {
            String msg = Str.lines("An unexpected error has occurred", "This is likely a programming error!", String.format("Object is %s, index is %s, and set is %s", object, index, value), String.format("The object is an array? %s", object == null ? "null" : Boolean.valueOf(object.getClass().isArray())), String.format("The object is of type %s", object == null ? "null" : object.getClass().getName()), String.format("The set is of type %s", value == null ? "null" : value.getClass().getName()), "");
            Exceptions.handle(msg, (Throwable)notExpected);
        }
    }

    public static <T> T idx(Class<T> type, Object object, String property) {
        return (T)BeanUtils.idx(object, property);
    }

    public static <T> T atIndex(Class<T> type, Object object, String property) {
        return (T)BeanUtils.idx(object, property);
    }

    public static boolean isPropPath(String prop) {
        if (prop.contains(".")) {
            return true;
        }
        if (prop.equals("this")) {
            return true;
        }
        return prop.contains("[");
    }

    public static void setCollectionProperty(Collection<?> list, String propertyName, Object value) {
        for (Object object : list) {
            BeanUtils.idx(object, propertyName, value);
        }
    }

    public static void setIterableProperty(Iterable<?> list, String propertyName, Object value) {
        for (Object object : list) {
            BeanUtils.idx(object, propertyName, value);
        }
    }
}

