/*
 * Decompiled with CFR 0.152.
 */
package org.boon.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.boon.StringScanner;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.primitive.Dbl;

public class DoubleList
extends AbstractList<Double> {
    private double[] values;
    private int end;

    public static DoubleList toDoubleList(Collection<?> inputList, String propertyPath) {
        if (inputList.size() == 0) {
            return new DoubleList(0);
        }
        DoubleList outputList = new DoubleList(inputList.size());
        if (propertyPath.contains(".") || propertyPath.contains("[")) {
            String[] properties = StringScanner.splitByDelimiters(propertyPath, ".[]");
            for (Object o : inputList) {
                outputList.add(BeanUtils.getPropertyDouble(o, properties));
            }
        } else {
            Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(inputList.iterator().next());
            FieldAccess fieldAccess = fields.get(propertyPath);
            for (Object o : inputList) {
                outputList.add(fieldAccess.getDouble(o));
            }
        }
        return outputList;
    }

    public DoubleList(int capacity) {
        this.values = new double[capacity];
    }

    public DoubleList() {
        this.values = new double[10];
    }

    public DoubleList(double[] values) {
        this.values = values;
        this.end = values.length;
    }

    @Override
    public Double get(int index) {
        return this.values[index];
    }

    public double idx(int index) {
        return this.values[index];
    }

    public double atIndex(int index) {
        return this.values[index];
    }

    public final double getFloat(int index) {
        return this.values[index];
    }

    @Override
    public boolean add(Double integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Dbl.grow(this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return true;
    }

    public boolean addFloat(double value) {
        if (this.end + 1 >= this.values.length) {
            this.values = Dbl.grow(this.values);
        }
        this.values[this.end] = value;
        ++this.end;
        return true;
    }

    public DoubleList add(double integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Dbl.grow(this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return this;
    }

    public boolean addArray(double ... integers) {
        if (this.end + integers.length >= this.values.length) {
            this.values = Dbl.grow(this.values, (this.values.length + integers.length) * 2);
        }
        System.arraycopy(integers, 0, this.values, this.end, integers.length);
        this.end += integers.length;
        return true;
    }

    @Override
    public Double set(int index, Double element) {
        double oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    public double idx(int index, double element) {
        double oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    public double atIndex(int index, double element) {
        double oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    public double setFloat(int index, double element) {
        double oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    @Override
    public int size() {
        return this.end;
    }

    public double sum() {
        return Dbl.sum(this.values, this.end);
    }

    public double[] toValueArray() {
        return Arrays.copyOfRange(this.values, 0, this.end);
    }

    public double reduceBy(Object function) {
        return Dbl.reduceBy(this.values, this.end, function);
    }

    public double reduceBy(Object function, String name) {
        return Dbl.reduceBy(this.values, this.end, function, name);
    }

    public double reduceBy(Dbl.ReduceBy reduceBy) {
        return Dbl.reduceBy(this.values, this.end, reduceBy);
    }

    public double mean() {
        return Dbl.mean(this.values, this.end);
    }

    public double standardDeviation() {
        return Dbl.standardDeviation(this.values, this.end);
    }

    public double variance() {
        return Dbl.variance(this.values, this.end);
    }

    public double max() {
        return Dbl.max(this.values, this.end);
    }

    public double min() {
        return Dbl.min(this.values, this.end);
    }

    public double median() {
        return Dbl.median(this.values, this.end);
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.end);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleList values = (DoubleList)o;
        if (this.end != values.end) {
            return false;
        }
        return Dbl.equals(0, this.end, this.values, values.values);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.values != null ? Dbl.hashCode(0, this.end, this.values) : 0);
        result = 31 * result + this.end;
        return result;
    }
}

