/*
 * Decompiled with CFR 0.152.
 */
package org.boon.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.boon.Boon;
import org.boon.Lists;
import org.boon.core.Function;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.template.BoonTemplate;

public abstract class Selector {
    protected String name;
    protected String alias;
    protected final boolean path;

    public static void collectFrom(List<Selector> selectors, Collection<?> results) {
        if (results.size() == 0) {
            return;
        }
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(results.iterator().next());
        Selector.collectFrom(selectors, results, fields);
    }

    public static void collectFrom(List<Selector> selectors, Collection<?> results, Map<String, FieldAccess> fields) {
        for (Selector s : selectors) {
            s.handleStart(results);
        }
        int index = 0;
        for (Object item : results) {
            for (Selector s : selectors) {
                s.handleRow(index, null, item, fields);
            }
            ++index;
        }
        for (Selector s : selectors) {
            s.handleComplete(null);
        }
    }

    public static <ITEM> List<Map<String, Object>> selectFrom(List<Selector> selectors, Collection<ITEM> results) {
        if (results.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(results.iterator().next());
        return Selector.selectFrom(selectors, results, fields);
    }

    public static <ITEM> List<Map<String, Object>> selectFrom(List<Selector> selectors, Collection<ITEM> results, Map<String, FieldAccess> fields) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(results.size());
        for (Selector s : selectors) {
            s.handleStart(results);
        }
        int index = 0;
        for (ITEM item : results) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            for (Selector s : selectors) {
                s.handleRow(index, row, item, fields);
            }
            ++index;
            rows.add(row);
        }
        for (Selector s : selectors) {
            s.handleComplete(rows);
        }
        return rows;
    }

    public static List<Selector> selects(Selector ... selects) {
        return Lists.list(selects);
    }

    private static boolean isPropPath(String prop) {
        return BeanUtils.isPropPath(prop);
    }

    public Selector() {
        this.path = false;
    }

    public Selector(String nameOrPath, String alias) {
        this.name = nameOrPath;
        this.alias = alias == null ? nameOrPath : alias;
        this.path = Selector.isPropPath(this.name);
    }

    public Selector(String nameOrPath) {
        this.alias = this.name = nameOrPath;
        this.path = Selector.isPropPath(this.name);
    }

    public String getName() {
        return this.name;
    }

    protected void getPropertyValueAndPutIntoRow(Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
        if (!this.path && fields != null) {
            row.put(this.alias, fields.get(this.name).getValue(item));
        } else {
            row.put(this.alias, BeanUtils.atIndex(item, this.name));
        }
    }

    protected Object getPropertyValue(Object item, Map<String, FieldAccess> fields) {
        if (!this.path && fields != null) {
            return fields.get(this.name).getValue(item);
        }
        return BeanUtils.atIndex(item, this.name);
    }

    public static Selector select(String propName) {
        return new Selector(propName, propName){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                this.getPropertyValueAndPutIntoRow(row, item, fields);
            }

            @Override
            public void handleStart(Collection<?> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector selectAs(String propName, String alias) {
        return new Selector(propName, alias){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                this.getPropertyValueAndPutIntoRow(row, item, fields);
            }

            @Override
            public void handleStart(Collection<?> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector selectAs(final String propName, String alias, final Function transform) {
        return new Selector(propName, alias){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                if (!this.path && fields != null) {
                    row.put(this.name, transform.apply(fields.get(this.name).getValue(item)));
                } else {
                    row.put(this.alias, transform.apply(BeanUtils.atIndex(item, propName)));
                }
            }

            @Override
            public void handleStart(Collection<?> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector selectAsTemplate(String alias, final String template, final BoonTemplate transform) {
        return new Selector(alias, alias){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                if (!this.path && fields != null) {
                    row.put(this.name, transform.replace(template, item));
                } else {
                    row.put(this.alias, transform.replace(template, item));
                }
            }

            @Override
            public void handleStart(Collection<?> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector toStr(String name) {
        return new Selector(name + ".toString()", null){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                Object selected = fields.get(this.name).getValue(item);
                row.put(this.name, selected == null ? "" : selected.toString());
            }

            @Override
            public void handleStart(Collection<?> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector toStr() {
        return new Selector("toString()", null){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                row.put(this.name, item.toString());
            }

            @Override
            public void handleStart(Collection<?> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    @Deprecated
    public static Selector select(final String ... ppath) {
        return new Selector(Boon.joinBy('.', ppath), null){
            int index;
            {
                super(x0, x1);
                this.index = 0;
            }

            @Override
            public void handleRow(int rowNum, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                Object o = BeanUtils.getPropByPath(item, ppath);
                row.put(this.name, o);
            }

            @Override
            public void handleStart(Collection<?> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    @Deprecated
    public static Selector toStr(final String ... ppath) {
        return new Selector(Boon.joinBy('.', ppath) + ".toString()", null){
            int index;
            {
                super(x0, x1);
                this.index = 0;
            }

            @Override
            public void handleRow(int rowNum, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                Object o = BeanUtils.getPropByPath(item, ppath);
                row.put(this.name, o == null ? "" : o.toString());
            }

            @Override
            public void handleStart(Collection<?> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    @Deprecated
    public static Selector selectPropPath(final String ... ppath) {
        return new Selector(Boon.joinBy('.', ppath), null){

            @Override
            public void handleRow(int rowNum, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                Object o = BeanUtils.getPropByPath(item, ppath);
                row.put(this.name, o);
            }

            @Override
            public void handleStart(Collection<?> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector rowId() {
        return new Selector("rowId", null){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                row.put(this.name, index);
            }

            @Override
            public void handleStart(Collection<?> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public abstract void handleRow(int var1, Map<String, Object> var2, Object var3, Map<String, FieldAccess> var4);

    public abstract void handleStart(Collection<?> var1);

    public abstract void handleComplete(List<Map<String, Object>> var1);

    public String getAlias() {
        return this.alias;
    }
}

