/*
 * Decompiled with CFR 0.152.
 */
package org.boon.logging;

import java.io.PrintWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.boon.Exceptions;
import org.boon.primitive.CharBuf;

public class BoonLogFormatter
extends Formatter {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    @Override
    public String format(LogRecord record) {
        CharBuf sb = CharBuf.create(255);
        sb.jsonDate(record.getMillis());
        sb.add("[").add(Thread.currentThread().getName()).append("]");
        sb.add(record.getLevel()).add(" [");
        sb.add(record.getLoggerName()).add("]").add("  ");
        sb.add(record.getMessage());
        sb.append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            StackTraceElement[] filteredStackTrace = Exceptions.getFilteredStackTrace(record.getThrown().getStackTrace());
            if (filteredStackTrace.length > 0) {
                Exceptions.stackTraceToJson(sb, filteredStackTrace);
            }
            PrintWriter pw = new PrintWriter(sb);
            record.getThrown().printStackTrace(pw);
            pw.close();
        }
        return sb.toString();
    }
}

