/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.implementation;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.IO;
import org.boon.core.reflection.FastStringUtils;
import org.boon.json.JsonParser;
import org.boon.primitive.CharBuf;

public abstract class BaseJsonParser
implements JsonParser {
    protected static final int COLON = 58;
    protected static final int COMMA = 44;
    protected static final int CLOSED_CURLY = 125;
    protected static final int CLOSED_BRACKET = 93;
    protected static final int LETTER_E = 101;
    protected static final int LETTER_BIG_E = 69;
    protected static final int MINUS = 45;
    protected static final int PLUS = 43;
    protected static final int DECIMAL_POINT = 46;
    protected static final int ALPHA_0 = 48;
    protected static final int ALPHA_1 = 49;
    protected static final int ALPHA_2 = 50;
    protected static final int ALPHA_3 = 51;
    protected static final int ALPHA_4 = 52;
    protected static final int ALPHA_5 = 53;
    protected static final int ALPHA_6 = 54;
    protected static final int ALPHA_7 = 55;
    protected static final int ALPHA_8 = 56;
    protected static final int ALPHA_9 = 57;
    protected static final int DOUBLE_QUOTE = 34;
    protected static final int ESCAPE = 92;
    protected static final boolean internKeys = Boolean.parseBoolean(System.getProperty("org.boon.json.implementation.internKeys", "false"));
    protected static ConcurrentHashMap<String, String> internedKeysCache;
    protected Charset charset = StandardCharsets.UTF_8;
    protected int bufSize = 256;
    private final CharBuf builder = CharBuf.create(20);
    private CharBuf fileInputBuf;
    int[] indexHolder = new int[1];

    protected String charDescription(int c) {
        String charString = c == 32 ? "[SPACE]" : (c == 9 ? "[TAB]" : (c == 10 ? "[NEWLINE]" : "'" + (char)c + "'"));
        charString = charString + " with an int value of " + c;
        return charString;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Object parse(String jsonString) {
        return this.parse(FastStringUtils.toCharArray(jsonString));
    }

    @Override
    public Object parse(byte[] bytes) {
        return this.parse(bytes, this.charset);
    }

    @Override
    public Object parse(CharSequence charSequence) {
        return this.parse(FastStringUtils.toCharArray(charSequence));
    }

    @Override
    public Object parse(Reader reader) {
        this.fileInputBuf = IO.read(reader, this.fileInputBuf, this.bufSize);
        return this.parse(this.fileInputBuf.readForRecycle());
    }

    @Override
    public Object parse(InputStream input) {
        return this.parse(input, this.charset);
    }

    @Override
    public Object parse(InputStream input, Charset charset) {
        return this.parse(new InputStreamReader(input, charset));
    }

    static {
        if (internKeys) {
            internedKeysCache = new ConcurrentHashMap();
        }
    }
}

