/*
 * Decompiled with CFR 0.152.
 */
package org.boon.criteria;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.boon.Boon;
import org.boon.Lists;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;

public abstract class Selector {
    protected String name;

    public Selector() {
    }

    public Selector(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public static List<Selector> selects(Selector ... selects) {
        return Lists.list(selects);
    }

    public static Selector select(String name) {
        return new Selector(name){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                row.put(this.name, fields.get(this.name).getValue(item));
            }

            @Override
            public void handleStart(List<? extends Object> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector toStr(String name) {
        return new Selector(name + ".toString()"){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                Object selected = fields.get(this.name).getValue(item);
                row.put(this.name, selected == null ? "" : selected.toString());
            }

            @Override
            public void handleStart(List<? extends Object> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector toStr() {
        return new Selector("toString()"){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                row.put(this.name, item.toString());
            }

            @Override
            public void handleStart(List<? extends Object> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector select(final String ... path) {
        return new Selector(Boon.joinBy('.', path)){
            int index;
            {
                super(x0);
                this.index = 0;
            }

            @Override
            public void handleRow(int rowNum, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                Object o = BeanUtils.getPropByPath(item, path);
                row.put(this.name, o);
            }

            @Override
            public void handleStart(List<? extends Object> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector toStr(final String ... path) {
        return new Selector(Boon.joinBy('.', path) + ".toString()"){
            int index;
            {
                super(x0);
                this.index = 0;
            }

            @Override
            public void handleRow(int rowNum, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                Object o = BeanUtils.getPropByPath(item, path);
                row.put(this.name, o == null ? "" : o.toString());
            }

            @Override
            public void handleStart(List<? extends Object> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector selectPropPath(final String ... path) {
        return new Selector(Boon.joinBy('.', path)){

            @Override
            public void handleRow(int rowNum, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                Object o = BeanUtils.getPropByPath(item, path);
                row.put(this.name, o);
            }

            @Override
            public void handleStart(List<? extends Object> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static Selector rowId() {
        return new Selector("rowId"){

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                row.put(this.name, index);
            }

            @Override
            public void handleStart(List<? extends Object> results) {
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
            }
        };
    }

    public static <ITEM> List<Map<String, Object>> performSelection(List<Selector> selectors, List<ITEM> results, Map<String, FieldAccess> fields) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(results.size());
        for (Selector s : selectors) {
            s.handleStart(results);
        }
        int index = 0;
        for (ITEM item : results) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            for (Selector s : selectors) {
                s.handleRow(index, row, item, fields);
            }
            ++index;
            rows.add(row);
        }
        for (Selector s : selectors) {
            s.handleComplete(rows);
        }
        return rows;
    }

    public abstract void handleRow(int var1, Map<String, Object> var2, Object var3, Map<String, FieldAccess> var4);

    public abstract void handleStart(List<? extends Object> var1);

    public abstract void handleComplete(List<Map<String, Object>> var1);
}

