/*
 * Decompiled with CFR 0.152.
 */
package org.boon.criteria;

import java.util.List;
import java.util.Map;
import org.boon.Lists;
import org.boon.Str;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.Selector;

public abstract class ProjectedSelector
extends Selector {
    public static List<ProjectedSelector> projections(ProjectedSelector ... projections) {
        return Lists.list(projections);
    }

    public static Selector max(final String fieldName) {
        return new Selector(Str.join('.', "max", fieldName)){
            Comparable max;

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                Comparable value = (Comparable)fields.get(fieldName).getValue(item);
                if (this.max == null) {
                    this.max = value;
                }
                if (value.compareTo(this.max) > 0) {
                    this.max = value;
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.max = null;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.max);
                }
            }
        };
    }

    public static Selector min(final String fieldName) {
        return new Selector(Str.join('.', "min", fieldName)){
            Comparable min;

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                Comparable value = (Comparable)fields.get(fieldName).getValue(item);
                if (this.min == null) {
                    this.min = value;
                }
                if (value.compareTo(this.min) < 0) {
                    this.min = value;
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.min = null;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.min);
                }
            }
        };
    }

    public static Selector sum(final String fieldName) {
        return new Selector(Str.join('.', "sum", fieldName)){
            long sum;
            {
                super(x0);
                this.sum = 0L;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                FieldAccess field = fields.get(fieldName);
                if (field.type() == Typ.intgr) {
                    int value = field.getInt(item);
                    this.sum += (long)value;
                } else {
                    Integer ovalue = Conversions.toInt(field.getValue(item));
                    this.sum += (long)ovalue.intValue();
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.sum = Integer.MIN_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.sum);
                }
            }
        };
    }

    public static Selector sumFloat(final String fieldName) {
        return new Selector(Str.join('.', "sum", fieldName)){
            double sum;
            {
                super(x0);
                this.sum = 0.0;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                FieldAccess field = fields.get(fieldName);
                if (field.type() == Typ.flt) {
                    float value = field.getFloat(item);
                    this.sum += (double)value;
                } else {
                    Float ovalue = Float.valueOf(Conversions.toFloat(field.getValue(item)));
                    this.sum += (double)ovalue.floatValue();
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.sum = -2.147483648E9;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.sum);
                }
            }
        };
    }

    public static Selector maxInt(final String fieldName) {
        return new Selector(Str.join('.', "max", fieldName)){
            int max;
            {
                super(x0);
                this.max = Integer.MIN_VALUE;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                FieldAccess field = fields.get(fieldName);
                if (field.type() == Typ.intgr) {
                    int value = field.getInt(item);
                    if (value > this.max) {
                        this.max = value;
                    }
                } else {
                    Integer ovalue = Conversions.toInt(field.getValue(item));
                    if (ovalue > this.max) {
                        this.max = ovalue;
                    }
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.max = Integer.MIN_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.max);
                }
            }
        };
    }

    public static Selector maxLong(final String fieldName) {
        return new Selector(Str.join('.', "max", fieldName)){
            long max;
            {
                super(x0);
                this.max = Long.MIN_VALUE;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                FieldAccess field = fields.get(fieldName);
                if (field.type() == Typ.lng) {
                    long value = field.getLong(item);
                    if (value > this.max) {
                        this.max = value;
                    }
                } else {
                    Long ovalue = Conversions.toLong(field.getValue(item));
                    if (ovalue > this.max) {
                        this.max = ovalue;
                    }
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.max = Long.MIN_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.max);
                }
            }
        };
    }

    public static Selector minInt(final String fieldName) {
        return new Selector(Str.join('.', "min", fieldName)){
            int min;
            {
                super(x0);
                this.min = Integer.MAX_VALUE;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                FieldAccess field = fields.get(fieldName);
                if (field.type() == Typ.intgr) {
                    int value = field.getInt(item);
                    if (value < this.min) {
                        this.min = value;
                    }
                } else {
                    Integer ovalue = Conversions.toInt(field.getValue(item));
                    if (ovalue < this.min) {
                        this.min = ovalue;
                    }
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.min = Integer.MAX_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.min);
                }
            }
        };
    }

    public static Selector minLong(final String fieldName) {
        return new Selector(Str.join('.', "min", fieldName)){
            long min;
            {
                super(x0);
                this.min = Long.MAX_VALUE;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                FieldAccess field = fields.get(fieldName);
                if (field.type() == Typ.lng) {
                    long value = field.getLong(item);
                    if (value < this.min) {
                        this.min = value;
                    }
                } else {
                    Long ovalue = Conversions.toLong(field.getValue(item));
                    if (ovalue < this.min) {
                        this.min = ovalue;
                    }
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.min = Long.MAX_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.min);
                }
            }
        };
    }

    public static Selector maxFloat(final String fieldName) {
        return new Selector(Str.join('.', "max", fieldName)){
            float max;
            {
                super(x0);
                this.max = Float.MIN_VALUE;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                FieldAccess field = fields.get(fieldName);
                if (field.type() == Typ.flt) {
                    float value = field.getFloat(item);
                    if (value > this.max) {
                        this.max = value;
                    }
                } else {
                    Float ovalue = Float.valueOf(Conversions.toFloat(field.getValue(item)));
                    if (ovalue.floatValue() > this.max) {
                        this.max = ovalue.floatValue();
                    }
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.max = Float.MIN_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, Float.valueOf(this.max));
                }
            }
        };
    }

    public static Selector minFloat(final String fieldName) {
        return new Selector(Str.join('.', "min", fieldName)){
            float min;
            {
                super(x0);
                this.min = Float.MAX_VALUE;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                FieldAccess field = fields.get(fieldName);
                if (field.type() == Typ.flt) {
                    float value = field.getFloat(item);
                    if (value > this.min) {
                        this.min = value;
                    }
                } else {
                    Float ovalue = Float.valueOf(Conversions.toFloat(field.getValue(item)));
                    if (ovalue.floatValue() > this.min) {
                        this.min = ovalue.floatValue();
                    }
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.min = Float.MAX_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, Float.valueOf(this.min));
                }
            }
        };
    }

    public static Selector maxDouble(final String fieldName) {
        return new Selector(Str.join('.', "max", fieldName)){
            double max;
            {
                super(x0);
                this.max = Double.MIN_VALUE;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                double value = fields.get(fieldName).getDouble(item);
                if (value > this.max) {
                    this.max = value;
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.max = Double.MIN_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.max);
                }
            }
        };
    }

    public static Selector minDouble(final String fieldName) {
        return new Selector(Str.join('.', "min", fieldName)){
            double min;
            {
                super(x0);
                this.min = Double.MAX_VALUE;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                double value = fields.get(fieldName).getDouble(item);
                if (value < this.min) {
                    this.min = value;
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.min = Double.MIN_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.min);
                }
            }
        };
    }

    public static Selector minShort(final String fieldName) {
        return new Selector(Str.join('.', "min", fieldName)){
            short min;
            {
                super(x0);
                this.min = Short.MAX_VALUE;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                short value = fields.get(fieldName).getShort(item);
                if (value < this.min) {
                    this.min = value;
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.min = Short.MAX_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.min);
                }
            }
        };
    }

    public static Selector maxShort(final String fieldName) {
        return new Selector(Str.join('.', "max", fieldName)){
            short max;
            {
                super(x0);
                this.max = Short.MIN_VALUE;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                short value = fields.get(fieldName).getShort(item);
                if (value > this.max) {
                    this.max = value;
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.max = Short.MIN_VALUE;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.max);
                }
            }
        };
    }

    public static Selector maxByte(final String fieldName) {
        return new Selector(Str.join('.', "max", fieldName)){
            byte max;
            {
                super(x0);
                this.max = (byte)-128;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                byte value = fields.get(fieldName).getByte(item);
                if (value > this.max) {
                    this.max = value;
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.max = (byte)-128;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.max);
                }
            }
        };
    }

    public static Selector minByte(final String fieldName) {
        return new Selector(Str.join('.', "min", fieldName)){
            byte min;
            {
                super(x0);
                this.min = (byte)127;
            }

            @Override
            public void handleRow(int index, Map<String, Object> row, Object item, Map<String, FieldAccess> fields) {
                byte value = fields.get(fieldName).getByte(item);
                if (value < this.min) {
                    this.min = value;
                }
            }

            @Override
            public void handleStart(List<? extends Object> results) {
                this.min = (byte)-128;
            }

            @Override
            public void handleComplete(List<Map<String, Object>> rows) {
                if (rows.size() > 0) {
                    rows.get(0).put(this.name, this.min);
                }
            }
        };
    }
}

