/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Exceptions;
import org.boon.core.reflection.AnnotationData;
import org.boon.core.reflection.Annotations;
import org.boon.core.reflection.MethodAccess;

public class MethodAccessImpl
implements MethodAccess {
    public final Method method;
    final List<AnnotationData> annotationData;
    final Map<String, AnnotationData> annotationMap;
    Object instance;

    public MethodAccessImpl() {
        this.method = null;
        this.annotationData = null;
        this.annotationMap = null;
    }

    public MethodAccessImpl(Method method) {
        this.method = method;
        this.method.setAccessible(true);
        this.annotationData = Annotations.getAnnotationDataForMethod(method);
        this.annotationMap = new ConcurrentHashMap<String, AnnotationData>();
        for (AnnotationData data : this.annotationData) {
            this.annotationMap.put(data.getName(), data);
            this.annotationMap.put(data.getSimpleClassName(), data);
            this.annotationMap.put(data.getFullClassName(), data);
        }
    }

    @Override
    public Object invoke(Object object, Object ... args) {
        try {
            return this.method.invoke(object, args);
        }
        catch (Throwable ex) {
            return Exceptions.handle(Object.class, ex, "unable to invoke method", this.method, " on object ", object, "with arguments", args, "\nparameter types", this.parameterTypes(), "\nargument types are");
        }
    }

    public Object invokeBound(Object ... args) {
        try {
            return this.method.invoke(this.instance, args);
        }
        catch (Throwable ex) {
            return Exceptions.handle(Object.class, ex, "unable to invoke method", this.method, " on object with arguments", args, "\nparameter types", this.parameterTypes(), "\nargument types are");
        }
    }

    @Override
    public Object invokeStatic(Object ... args) {
        try {
            return this.method.invoke(null, args);
        }
        catch (Throwable ex) {
            return Exceptions.handle(Object.class, ex, "unable to invoke method", this.method, " with arguments", args);
        }
    }

    @Override
    public MethodAccess bind(Object instance) {
        Exceptions.die("Bind does not work for cached methodAccess make a copy with methodAccsess() first");
        return null;
    }

    @Override
    public MethodAccess methodAccess() {
        return new MethodAccessImpl(this.method){

            @Override
            public MethodAccess bind(Object instance) {
                this.instance = instance;
                return this;
            }

            @Override
            public Object bound() {
                return this.instance;
            }
        };
    }

    @Override
    public Object bound() {
        return null;
    }

    @Override
    public Iterable<AnnotationData> annotationData() {
        return new Iterable<AnnotationData>(){

            @Override
            public Iterator<AnnotationData> iterator() {
                return MethodAccessImpl.this.annotationData.iterator();
            }
        };
    }

    @Override
    public boolean hasAnnotation(String annotationName) {
        return this.annotationMap.containsKey(annotationName);
    }

    @Override
    public AnnotationData annotation(String annotationName) {
        return this.annotationMap.get(annotationName);
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public String name() {
        return this.method.getName();
    }

    @Override
    public Class<?> declaringType() {
        return this.method.getDeclaringClass();
    }

    @Override
    public Class<?> returnType() {
        return this.method.getReturnType();
    }

    @Override
    public boolean respondsTo(Class<?>[] parametersToMatch) {
        boolean match = true;
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (parameterTypes.length != parametersToMatch.length) {
            return false;
        }
        for (int index = 0; index < parameterTypes.length; ++index) {
            Class<?> type = parameterTypes[index];
            Class<?> matchToType = parametersToMatch[index];
            if (type.isPrimitive()) {
                if (type == Integer.TYPE && (matchToType == Integer.class || matchToType == Integer.TYPE) || type == Boolean.TYPE && (matchToType == Boolean.class || matchToType == Boolean.TYPE) || type == Long.TYPE && (matchToType == Long.class || matchToType == Long.TYPE) || type == Float.TYPE && (matchToType == Float.class || matchToType == Float.TYPE) || type == Double.TYPE && (matchToType == Double.class || matchToType == Double.TYPE) || type == Short.TYPE && (matchToType == Short.class || matchToType == Short.TYPE) || type == Byte.TYPE && (matchToType == Byte.class || matchToType == Byte.TYPE) || type == Character.TYPE && (matchToType == Character.class || matchToType == Character.TYPE)) continue;
                match = false;
                break;
            }
            if (type.isAssignableFrom(matchToType)) continue;
            match = false;
            break;
        }
        return match;
    }

    @Override
    public boolean respondsTo(Object ... args) {
        boolean match = true;
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (parameterTypes.length != args.length) {
            return false;
        }
        for (int index = 0; index < parameterTypes.length; ++index) {
            Class<?> matchToType;
            Object arg = args[index];
            Class<?> type = parameterTypes[index];
            Class<?> clazz = matchToType = arg != null ? arg.getClass() : null;
            if (type.isPrimitive()) {
                if (arg == null) {
                    match = false;
                    break;
                }
                if (type == Integer.TYPE && matchToType == Integer.class || type == Boolean.TYPE && matchToType == Boolean.class || type == Long.TYPE && matchToType == Long.class || type == Float.TYPE && matchToType == Float.class || type == Double.TYPE && matchToType == Double.class || type == Short.TYPE && matchToType == Short.class || type == Byte.TYPE && matchToType == Byte.class || type == Character.TYPE && matchToType == Character.class) continue;
                match = false;
                break;
            }
            if (arg == null || type.isInstance(arg)) continue;
            match = false;
            break;
        }
        return match;
    }

    @Override
    public Class<?>[] parameterTypes() {
        return this.method.getParameterTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    public String toString() {
        return "MethodAccessImpl{method=" + this.method + ", annotationData=" + this.annotationData + ", instance=" + this.instance + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodAccessImpl that = (MethodAccessImpl)o;
        if (this.annotationData != null ? !this.annotationData.equals(that.annotationData) : that.annotationData != null) {
            return false;
        }
        if (this.annotationMap != null ? !this.annotationMap.equals(that.annotationMap) : that.annotationMap != null) {
            return false;
        }
        if (this.instance != null ? !this.instance.equals(that.instance) : that.instance != null) {
            return false;
        }
        return !(this.method != null ? !this.method.equals(that.method) : that.method != null);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.annotationData != null ? this.annotationData.hashCode() : 0);
        result = 31 * result + (this.annotationMap != null ? this.annotationMap.hashCode() : 0);
        result = 31 * result + (this.instance != null ? this.instance.hashCode() : 0);
        return result;
    }
}

