/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Maps;
import org.boon.Sets;
import org.boon.core.Conversions;
import org.boon.core.Function;
import org.boon.core.Typ;
import org.boon.core.Type;
import org.boon.core.Value;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.ConstructorAccess;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.core.value.ValueContainer;
import org.boon.core.value.ValueList;
import org.boon.core.value.ValueMap;
import org.boon.core.value.ValueMapImpl;
import org.boon.primitive.Arry;
import org.boon.primitive.CharBuf;

public class MapObjectConversion {
    public static <T> T fromListUsingFields(List<Object> list, Class<T> clazz) {
        return MapObjectConversion.fromListUsingFields(false, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(false), list, clazz, null);
    }

    public static <T> T fromListUsingFields(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, List<Object> list, Class<T> clazz, Set<String> ignoreSet) {
        Map<String, FieldAccess> fieldMap = fieldsAccessor.getFields(clazz);
        List<Field> fields = Reflection.getFields(clazz);
        T toObject = Reflection.newInstance(clazz);
        for (int index = 0; index < fields.size(); ++index) {
            Field field = fields.get(index);
            Class<?> paramType = field.getType();
            Object item = list.get(index);
            FieldAccess fieldAccess = fieldMap.get(field.getName());
            if (Typ.isList(paramType) && item instanceof List) {
                List itemList = (List)item;
                if (itemList.size() <= 0 || !(itemList.get(0) instanceof List)) continue;
                Class<?> componentType = fieldAccess.getComponentClass();
                ArrayList newList = new ArrayList(itemList.size());
                for (Object o : itemList) {
                    List fromList = (List)o;
                    newList.add(MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, fromList, componentType, ignoreSet));
                }
                fieldAccess.setValue(toObject, newList);
                continue;
            }
            if (paramType.isInstance(item)) {
                fieldAccess.setValue(toObject, item);
                continue;
            }
            if (item instanceof Map) {
                MapObjectConversion.setFieldValueFromMap(respectIgnore, view, fieldsAccessor, ignoreSet, toObject, fieldAccess, item);
                continue;
            }
            fieldAccess.setValue(toObject, item);
        }
        return toObject;
    }

    public static <T> T fromList(List<Object> argList, Class<T> clazz) {
        return MapObjectConversion.fromList(FieldAccessMode.FIELD_THEN_PROPERTY.create(false), argList, clazz);
    }

    public static <T> T fromList(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, List<?> argList, Class<T> clazz, Set<String> ignoreSet) {
        int size = argList.size();
        ArrayList<Object> list = new ArrayList<Object>(argList);
        ClassMeta classMeta = ClassMeta.classMeta(clazz);
        ConstructorAccess match = null;
        Object[] finalArgs = null;
        try {
            block2: for (ConstructorAccess constructor : classMeta.constructors()) {
                Class[] parameterTypes = constructor.parameterTypes();
                if (parameterTypes.length != size) continue;
                for (int index = 0; index < size; ++index) {
                    if (!MapObjectConversion.matchAndConvertArgs(respectIgnore, view, fieldsAccessor, list, constructor, parameterTypes, index, ignoreSet)) continue block2;
                }
                match = constructor;
            }
            if (match != null) {
                finalArgs = list.toArray(new Object[list.size()]);
                return match.create(finalArgs);
            }
            return (T)Exceptions.die(Object.class, "Unable to convert list", list, "into", clazz);
        }
        catch (Exception e) {
            if (match != null) {
                CharBuf buf = CharBuf.create(200);
                buf.addLine();
                buf.multiply('-', 10).add("FINAL ARGUMENTS").multiply('-', 10).addLine();
                if (finalArgs != null) {
                    for (Object o : finalArgs) {
                        buf.puts("argument type    ", Boon.className(o));
                    }
                }
                buf.multiply('-', 10).add("CONSTRUCTOR").add(match).multiply('-', 10).addLine();
                buf.multiply('-', 10).add("CONSTRUCTOR PARAMS").multiply('-', 10).addLine();
                for (Class<?> c : match.parameterTypes()) {
                    buf.puts("constructor type ", c);
                }
                buf.multiply('-', 35).addLine();
                return (T)Exceptions.handle(Object.class, e, buf.toString(), "\nconstructor parameter types", match.parameterTypes(), "\nlist args after conversion", list, "types", Type.gatherTypes(list), "\noriginal args", argList, "original types", Type.gatherTypes(argList));
            }
            return (T)Exceptions.handle(Object.class, e, "\nlist args after conversion", list, "types", Type.gatherTypes(list), "\noriginal args", argList, "original types", Type.gatherTypes(argList));
        }
    }

    public static <T> T fromList(FieldsAccessor fieldsAccessor, List<Object> argList, Class<T> clazz) {
        return MapObjectConversion.fromList(false, null, fieldsAccessor, argList, clazz, null);
    }

    public static boolean matchAndConvertArgs(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, List<Object> list, ConstructorAccess constructor, Class[] parameterTypes, int index, Set<String> ignoreSet) {
        block30: {
            try {
                Class paramType = parameterTypes[index];
                Object item = list.get(index);
                if (item instanceof ValueContainer) {
                    item = ((ValueContainer)item).toValue();
                    list.set(index, item);
                }
                if (paramType.isPrimitive() && item == null) {
                    return false;
                }
                if (item == null) {
                    return true;
                }
                if (Typ.isPrimitiveOrWrapper(paramType) && (item instanceof Number || item instanceof Boolean || item instanceof CharSequence)) {
                    Object o = Conversions.coerceOrDie(paramType, item);
                    list.set(index, o);
                    break block30;
                }
                if (item instanceof Map && !Typ.isMap(paramType)) {
                    if (!paramType.isInterface() && !Typ.isAbstract(paramType)) {
                        item = MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, (Map)item, paramType, ignoreSet);
                        list.set(index, item);
                        break block30;
                    }
                    String className = (String)((Map)item).get("class");
                    if (className != null) {
                        item = MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, (Map)item, Reflection.loadClass(className), ignoreSet);
                        list.set(index, item);
                        break block30;
                    }
                    return false;
                }
                if (item instanceof Map) {
                    Map itemMap = (Map)item;
                    java.lang.reflect.Type type = constructor.getGenericParameterTypes()[index];
                    if (type instanceof ParameterizedType) {
                        ParameterizedType pType = (ParameterizedType)type;
                        Class keyType = (Class)pType.getActualTypeArguments()[0];
                        Class valueType = (Class)pType.getActualTypeArguments()[1];
                        Map<?, ?> newMap = Conversions.createMap(paramType, itemMap.size());
                        Iterator i$ = itemMap.entrySet().iterator();
                        while (i$.hasNext()) {
                            Map.Entry o;
                            Map.Entry entry = o = i$.next();
                            Object key = entry.getKey();
                            Object value = entry.getValue();
                            key = ValueContainer.toObject(key);
                            value = (value = ValueContainer.toObject(value)) instanceof List ? MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, (List)value, valueType, ignoreSet) : (value instanceof Map ? MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, (Map)value, valueType, ignoreSet) : Conversions.coerce(valueType, value));
                            key = key instanceof List ? MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, (List)key, keyType, ignoreSet) : (value instanceof Map ? MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, (Map)key, keyType, ignoreSet) : Conversions.coerce(keyType, key));
                            newMap.put(key, value);
                        }
                        list.set(index, newMap);
                    }
                    break block30;
                }
                if (item instanceof List && !Typ.isCollection(paramType) && !paramType.isEnum()) {
                    List listItem = null;
                    Object convertedItem = null;
                    try {
                        listItem = (List)item;
                        convertedItem = MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, listItem, paramType, ignoreSet);
                        list.set(index, convertedItem);
                    }
                    catch (Exception ex) {
                        Boon.error(ex, "PROBLEM WITH matchAndConvertArgs converting a list item into an object", "listItem", listItem, "convertedItem", convertedItem, "respectIgnore", respectIgnore, "view", view, "fieldsAccessor", fieldsAccessor, "list", list, "constructor", constructor, "parameters", parameterTypes, "index", index, "ignoreSet", ignoreSet);
                        ex.printStackTrace();
                    }
                    break block30;
                }
                if (Typ.isCollection(paramType) && item instanceof List) {
                    List itemList = (List)item;
                    if (itemList.size() > 0 && (itemList.get(0) instanceof List || itemList.get(0) instanceof ValueContainer)) {
                        java.lang.reflect.Type type = constructor.getGenericParameterTypes()[index];
                        if (type instanceof ParameterizedType) {
                            ParameterizedType pType = (ParameterizedType)type;
                            Class componentType = (Class)pType.getActualTypeArguments()[0];
                            Collection<Object> newList = Conversions.createCollection(paramType, itemList.size());
                            for (Object o : itemList) {
                                if (o instanceof ValueContainer) {
                                    o = ((ValueContainer)o).toValue();
                                }
                                List fromList = (List)o;
                                o = MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, fromList, componentType, ignoreSet);
                                newList.add(o);
                            }
                            list.set(index, newList);
                        }
                    } else {
                        java.lang.reflect.Type type = constructor.getGenericParameterTypes()[index];
                        if (type instanceof ParameterizedType) {
                            ParameterizedType pType = (ParameterizedType)type;
                            Class componentType = (Class)pType.getActualTypeArguments()[0];
                            Collection<Object> newList = Conversions.createCollection(paramType, itemList.size());
                            for (Object o : itemList) {
                                if (o instanceof ValueContainer) {
                                    o = ((ValueContainer)o).toValue();
                                }
                                if (o instanceof List) {
                                    List fromList = (List)o;
                                    o = MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, fromList, componentType, ignoreSet);
                                    newList.add(o);
                                    continue;
                                }
                                if (o instanceof Map) {
                                    Map fromMap = (Map)o;
                                    o = MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, fromMap, componentType, ignoreSet);
                                    newList.add(o);
                                    continue;
                                }
                                newList.add(Conversions.coerce(componentType, o));
                            }
                            list.set(index, newList);
                        }
                    }
                    break block30;
                }
                if (paramType == Typ.string && item instanceof CharSequence) {
                    list.set(index, item.toString());
                    break block30;
                }
                if (paramType.isEnum() && item instanceof CharSequence | item instanceof Number) {
                    list.set(index, Conversions.toEnum(paramType, item));
                    break block30;
                }
                if (paramType.isInstance(item)) {
                    return true;
                }
                Type type = Type.getType(paramType);
                if (type == Type.INSTANCE) {
                    list.set(index, Conversions.coerce(paramType, item));
                    break block30;
                }
                return false;
            }
            catch (Exception ex) {
                Boon.error(ex, "PROBLEM WITH matchAndConvertArgs", "respectIgnore", respectIgnore, "view", view, "fieldsAccessor", fieldsAccessor, "list", list, "constructor", constructor, "parameters", parameterTypes, "index", index, "ignoreSet", ignoreSet);
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> clazz) {
        return MapObjectConversion.fromMap(false, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(true), map, clazz, null);
    }

    public static List<Object> toList(Object object) {
        Type instanceType = Type.getInstanceType(object);
        switch (instanceType) {
            case NULL: {
                return Lists.list(new Object[]{null});
            }
            case ARRAY: {
                return Conversions.toList(object);
            }
            case INSTANCE: {
                if (!Reflection.respondsTo(object, "toList")) break;
                return (List)Reflection.invoke(object, "toList", new Object[0]);
            }
        }
        return Lists.list(object);
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> clazz, String ... excludeProperties) {
        Set<String> ignoreProps = excludeProperties.length > 0 ? Sets.set(excludeProperties) : null;
        return MapObjectConversion.fromMap(false, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(true), map, clazz, ignoreProps);
    }

    public static Object fromMap(Map<String, Object> map) {
        String clazz = (String)map.get("class");
        Class<?> cls = Reflection.loadClass(clazz);
        return MapObjectConversion.fromMap(false, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(true), map, cls, null);
    }

    public static <T> T fromMap(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Map<String, Object> map, Class<T> cls, Set<String> ignoreSet) {
        T toObject = Reflection.newInstance(cls);
        Map<String, FieldAccess> fields = fieldsAccessor.getFields(toObject.getClass());
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            FieldAccess field;
            String key = entry.getKey();
            if (ignoreSet != null && ignoreSet.contains(key) || (field = fields.get(key)) == null || view != null && !field.isViewActive(view) || respectIgnore && field.ignore()) continue;
            Object value = entry.getValue();
            if (value instanceof Value) {
                if (((Value)value).isContainer()) {
                    value = ((Value)value).toValue();
                } else {
                    field.setFromValue(toObject, (Value)value);
                    continue;
                }
            }
            if (value == null) {
                field.setObject(toObject, null);
                continue;
            }
            if (value.getClass() == field.type() || field.type() == Object.class) {
                field.setObject(toObject, value);
                continue;
            }
            if (Typ.isBasicType(value)) {
                field.setValue(toObject, value);
                continue;
            }
            if (value instanceof Value) {
                field.setValue(toObject, value);
                continue;
            }
            if (value instanceof Map) {
                MapObjectConversion.setFieldValueFromMap(respectIgnore, view, fieldsAccessor, ignoreSet, toObject, field, value);
                continue;
            }
            if (value instanceof Collection) {
                MapObjectConversion.processCollectionFromMapUsingFields(respectIgnore, view, fieldsAccessor, toObject, field, (Collection)value, ignoreSet);
                continue;
            }
            if (value instanceof Map[]) {
                MapObjectConversion.processArrayOfMaps(respectIgnore, view, fieldsAccessor, toObject, field, value, ignoreSet);
                continue;
            }
            field.setValue(toObject, value);
        }
        return toObject;
    }

    private static <T> void setFieldValueFromMap(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Set<String> ignoreSet, T toObject, FieldAccess field, Object value) {
        Class<?> clazz = field.type();
        Map mapInner = (Map)value;
        if (!Typ.isMap(clazz)) {
            String className;
            value = !clazz.isInterface() && !Typ.isAbstract(clazz) ? MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, mapInner, field.type(), ignoreSet) : ((className = (String)((Map)value).get("class")) != null ? MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, mapInner, Reflection.loadClass(className), ignoreSet) : null);
        } else if (Typ.isMap(clazz)) {
            Class keyType = (Class)field.getParameterizedType().getActualTypeArguments()[0];
            Class valueType = (Class)field.getParameterizedType().getActualTypeArguments()[1];
            Set set = mapInner.entrySet();
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry entry : set) {
                Object evalue = entry.getValue();
                Object key = entry.getKey();
                if (evalue instanceof ValueContainer) {
                    evalue = ((ValueContainer)evalue).toValue();
                }
                key = Conversions.coerce(keyType, key);
                evalue = Conversions.coerce(valueType, evalue);
                newMap.put(key, evalue);
            }
            value = newMap;
        }
        field.setObject(toObject, value);
    }

    private static Object fromValueMap(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Map<String, Value> map, Set<String> ignoreSet) {
        try {
            String className = map.get("class").toString();
            Class<?> cls = Reflection.loadClass(className);
            return MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, map, cls, ignoreSet);
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, Boon.sputs("fromValueMap", "map", map, "fieldAccessor", fieldsAccessor), ex);
        }
    }

    public static <T> T fromValueMap(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Map<String, Value> amap, Class<T> cls, Set<String> ignoreSet) {
        Map.Entry<String, Value>[] entries;
        int size;
        T newInstance = Reflection.newInstance(cls);
        ValueMap map = (ValueMap)amap;
        Map<String, FieldAccess> fields = fieldsAccessor.getFields(cls);
        if (!map.hydrated()) {
            size = map.len();
            entries = map.items();
        } else {
            size = map.size();
            entries = map.entrySet().toArray(new Map.Entry[size]);
        }
        if (size == 0 || entries == null) {
            return newInstance;
        }
        FieldAccess field = null;
        String fieldName = null;
        for (int index = 0; index < size; ++index) {
            Value value = null;
            try {
                Map.Entry<String, Value> entry = entries[index];
                fieldName = entry.getKey();
                if (ignoreSet != null && ignoreSet.contains(fieldName) || (field = fields.get(fieldName)) == null || view != null && !field.isViewActive(view) || respectIgnore && field.ignore()) continue;
                value = entry.getValue();
                if (value instanceof Value) {
                    MapObjectConversion.fromValueMapHandleValueCase(respectIgnore, view, fieldsAccessor, newInstance, field, value, ignoreSet);
                    continue;
                }
                MapObjectConversion.fromMapHandleNonValueCase(respectIgnore, view, fieldsAccessor, newInstance, field, value, ignoreSet);
                continue;
            }
            catch (Exception ex) {
                return (T)Exceptions.handle(Object.class, ex, "fieldName", fieldName, "of class", cls, "had issues for value", value, "for field", field);
            }
        }
        return newInstance;
    }

    private static <T> void fromMapHandleNonValueCase(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, T newInstance, FieldAccess field, Object ovalue, Set<String> ignoreSet) {
        try {
            if (ovalue instanceof Map) {
                Class<?> clazz = field.type();
                ovalue = !clazz.isInterface() && !Typ.isAbstract(clazz) ? MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, (Map)ovalue, field.type(), ignoreSet) : MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, (Map)ovalue, ignoreSet);
                field.setObject(newInstance, ovalue);
            } else if (ovalue instanceof Collection) {
                MapObjectConversion.handleCollectionOfValues(respectIgnore, view, fieldsAccessor, newInstance, field, (Collection)ovalue, ignoreSet);
            } else {
                field.setValue(newInstance, ovalue);
            }
        }
        catch (Exception ex) {
            Exceptions.handle(Boon.sputs("Problem handling non value case of fromValueMap", "field", field.name(), "fieldType", field.type().getName(), "object from map", ovalue), (Throwable)ex);
        }
    }

    private static <T> void fromValueMapHandleValueCase(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, T newInstance, FieldAccess field, Value value, Set<String> ignoreSet) {
        Object objValue = null;
        try {
            if (value.isContainer()) {
                objValue = value.toValue();
                if (objValue instanceof Map) {
                    Class<?> clazz = field.type();
                    if (!clazz.isInterface() && !Typ.isAbstract(clazz)) {
                        objValue = MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, (Map)objValue, field.type(), ignoreSet);
                    } else if (Typ.isMap(field.type())) {
                        Class keyType = (Class)field.getParameterizedType().getActualTypeArguments()[0];
                        Class valueType = (Class)field.getParameterizedType().getActualTypeArguments()[1];
                        Map mapInner = (Map)objValue;
                        Set set = mapInner.entrySet();
                        LinkedHashMap newMap = new LinkedHashMap();
                        for (Map.Entry entry : set) {
                            Object evalue = entry.getValue();
                            Object key = entry.getKey();
                            if (evalue instanceof ValueContainer) {
                                evalue = ((ValueContainer)evalue).toValue();
                            }
                            key = Conversions.coerce(keyType, key);
                            evalue = Conversions.coerce(valueType, evalue);
                            newMap.put(key, evalue);
                        }
                        objValue = newMap;
                    } else {
                        objValue = MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, (Map)objValue, ignoreSet);
                    }
                    field.setObject(newInstance, objValue);
                } else if (objValue instanceof Collection) {
                    MapObjectConversion.handleCollectionOfValues(respectIgnore, view, fieldsAccessor, newInstance, field, (Collection)objValue, ignoreSet);
                }
            } else {
                field.setFromValue(newInstance, value);
            }
        }
        catch (Exception ex) {
            Exceptions.handle(Boon.sputs("Problem handling non value case of fromValueMap", "field", field.name(), "fieldType", field.type().getName(), "object from map", "objValue", objValue, "value", value), (Throwable)ex);
        }
    }

    private static void processCollectionFromMapUsingFields(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Collection<?> collection, Set<String> ignoreSet) {
        Class<?> fieldComponentClass = field.getComponentClass();
        Class<?> valueComponentClass = Reflection.getComponentType(collection);
        if (Typ.isMap(valueComponentClass)) {
            MapObjectConversion.handleCollectionOfMaps(respectIgnore, view, fieldsAccessor, newInstance, field, collection, ignoreSet);
            return;
        }
        if (Typ.isValue(valueComponentClass)) {
            MapObjectConversion.handleCollectionOfValues(respectIgnore, view, fieldsAccessor, newInstance, field, collection, ignoreSet);
            return;
        }
        if (Typ.implementsInterface(collection.getClass(), field.type()) && fieldComponentClass != null && fieldComponentClass.isAssignableFrom(valueComponentClass)) {
            field.setValue(newInstance, collection);
            return;
        }
        if (!field.typeEnum().isCollection()) {
            if (collection instanceof List) {
                try {
                    Object value = MapObjectConversion.fromList(respectIgnore, view, fieldsAccessor, (List)collection, field.getComponentClass(), ignoreSet);
                    field.setObject(newInstance, value);
                }
                catch (Exception ex) {
                    field.setObject(newInstance, Conversions.coerce(field.typeEnum(), field.type(), collection));
                }
            } else {
                field.setObject(newInstance, Conversions.coerce(field.typeEnum(), field.type(), collection));
            }
            return;
        }
        Collection<Object> newCollection = Conversions.createCollection(field.type(), collection.size());
        if (fieldComponentClass == null || fieldComponentClass.isAssignableFrom(valueComponentClass)) {
            newCollection.addAll(collection);
            field.setValue(newInstance, newCollection);
            return;
        }
        for (Map<String, Object> itemValue : collection) {
            newCollection.add(Conversions.coerce(fieldComponentClass, itemValue));
            field.setValue(newInstance, newCollection);
        }
    }

    private static void processArrayOfMaps(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Object value, Set<String> ignoreSet) {
        Map[] maps = (Map[])value;
        List<Map<String, Object>> list = Lists.list(maps);
        MapObjectConversion.handleCollectionOfMaps(respectIgnore, view, fieldsAccessor, newInstance, field, list, ignoreSet);
    }

    private static void handleCollectionOfMaps(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Collection<Map<String, Object>> collectionOfMaps, Set<String> ignoreSet) {
        Collection<Object> newCollection = Conversions.createCollection(field.type(), collectionOfMaps.size());
        Class<?> componentClass = field.getComponentClass();
        if (componentClass != null) {
            for (Map<String, Object> mapComponent : collectionOfMaps) {
                newCollection.add(MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, mapComponent, componentClass, ignoreSet));
            }
            field.setObject(newInstance, newCollection);
        }
    }

    private static void handleCollectionOfValues(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Collection<Value> acollectionOfValues, Set<String> ignoreSet) {
        Collection<Value> collectionOfValues = acollectionOfValues;
        if (collectionOfValues instanceof ValueList) {
            collectionOfValues = ((ValueList)collectionOfValues).list();
        }
        Collection<Object> newCollection = Conversions.createCollection(field.type(), collectionOfValues.size());
        if (field.typeEnum().isCollection()) {
            Class<?> componentClass = field.getComponentClass();
            for (Value value : (List)collectionOfValues) {
                if (value.isContainer()) {
                    Object oValue = value.toValue();
                    if (!(oValue instanceof Map)) continue;
                    newCollection.add(MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, (Map)oValue, componentClass, ignoreSet));
                    continue;
                }
                newCollection.add(Conversions.coerce(componentClass, value.toValue()));
            }
            field.setObject(newInstance, newCollection);
        } else {
            if (field.typeEnum() == Type.ARRAY) {
                Class<?> componentClass = field.getComponentClass();
                Type componentType = Type.getType(componentClass);
                int index = 0;
                switch (componentType) {
                    case INT: {
                        int[] iarray = new int[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            iarray[index] = value.intValue();
                            ++index;
                        }
                        field.setObject(newInstance, iarray);
                        return;
                    }
                    case SHORT: {
                        short[] sarray = new short[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            sarray[index] = value.shortValue();
                            ++index;
                        }
                        field.setObject(newInstance, sarray);
                        return;
                    }
                    case DOUBLE: {
                        double[] darray = new double[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            darray[index] = value.doubleValue();
                            ++index;
                        }
                        field.setObject(newInstance, darray);
                        return;
                    }
                    case FLOAT: {
                        float[] farray = new float[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            farray[index] = value.floatValue();
                            ++index;
                        }
                        field.setObject(newInstance, farray);
                        return;
                    }
                    case LONG: {
                        long[] larray = new long[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            larray[index] = value.longValue();
                            ++index;
                        }
                        field.setObject(newInstance, larray);
                        return;
                    }
                    case BYTE: {
                        byte[] barray = new byte[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            barray[index] = value.byteValue();
                            ++index;
                        }
                        field.setObject(newInstance, barray);
                        return;
                    }
                    case CHAR: {
                        char[] chars = new char[collectionOfValues.size()];
                        for (Value value : (List)collectionOfValues) {
                            chars[index] = value.charValue();
                            ++index;
                        }
                        field.setObject(newInstance, chars);
                        return;
                    }
                }
                Object array = Array.newInstance(componentClass, collectionOfValues.size());
                for (Value value : (List)collectionOfValues) {
                    Object o;
                    if (value instanceof ValueContainer) {
                        o = value.toValue();
                        if (o instanceof List) {
                            if (!componentClass.isInstance(o = MapObjectConversion.fromList(fieldsAccessor, (List)o, componentClass))) break;
                            Array.set(array, index, o);
                        }
                    } else {
                        o = value.toValue();
                        if (componentClass.isInstance(o)) {
                            Array.set(array, index, o);
                        } else {
                            Array.set(array, index, Conversions.coerce(componentClass, o));
                        }
                    }
                    ++index;
                }
                field.setObject(newInstance, array);
                return;
            }
            field.setObject(newInstance, MapObjectConversion.fromList(fieldsAccessor, (List)acollectionOfValues, field.type()));
        }
    }

    public static Map<String, Object> toMap(Object object, String ... ignore) {
        return MapObjectConversion.toMap(object, Sets.set(ignore));
    }

    public static Map<String, Object> toMap(Object object, Set<String> ignore) {
        if (object == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map<String, FieldAccess> fieldMap = Reflection.getAllAccessorFields(object.getClass());
        ArrayList<FieldAccess> fields = new ArrayList<FieldAccess>(fieldMap.values());
        Collections.reverse(fields);
        List<Maps.Entry<String, Object>> entries = Conversions.mapFilterNulls(new FieldToEntryConverter(object), new ArrayList<FieldAccess>(fields));
        map.put("class", object.getClass().getName());
        for (Maps.Entry<String, Object> entry : entries) {
            Object value;
            String key = entry.key();
            if (ignore.contains(key) || (value = entry.value()) == null) continue;
            if (Typ.isBasicType(value)) {
                map.put(key, entry.value());
                continue;
            }
            if (Boon.isArray(value) && Typ.isBasicType(value.getClass().getComponentType())) {
                map.put(key, entry.value());
                continue;
            }
            if (Boon.isArray(value)) {
                int length = Arry.len(value);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(length);
                for (int index = 0; index < length; ++index) {
                    Object item = BeanUtils.idx(value, index);
                    list.add(MapObjectConversion.toMap(item, ignore));
                }
                map.put(key, list);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Class<?> componentType = Reflection.getComponentType(collection, fieldMap.get(entry.key()));
                if (Typ.isBasicType(componentType)) {
                    map.put(key, value);
                    continue;
                }
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(collection.size());
                for (Object item : collection) {
                    if (item == null) continue;
                    list.add(MapObjectConversion.toMap(item, ignore));
                }
                map.put(entry.key(), list);
                continue;
            }
            if (value instanceof Map) continue;
            map.put(entry.key(), MapObjectConversion.toMap(value, ignore));
        }
        return map;
    }

    public static Map<String, Object> toMap(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map<String, FieldAccess> fieldMap = Reflection.getAllAccessorFields(object.getClass());
        ArrayList<FieldAccess> fields = new ArrayList<FieldAccess>(fieldMap.values());
        Collections.reverse(fields);
        List<Maps.Entry<String, Object>> entries = Conversions.mapFilterNulls(new FieldToEntryConverter(object), new ArrayList<FieldAccess>(fields));
        map.put("class", object.getClass().getName());
        for (Maps.Entry<String, Object> entry : entries) {
            Object value = entry.value();
            if (value == null) continue;
            if (Typ.isBasicType(value)) {
                map.put(entry.key(), entry.value());
                continue;
            }
            if (Boon.isArray(value) && Typ.isBasicType(value.getClass().getComponentType())) {
                map.put(entry.key(), entry.value());
                continue;
            }
            if (Boon.isArray(value)) {
                int length = Arry.len(value);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(length);
                for (int index = 0; index < length; ++index) {
                    Object item = BeanUtils.idx(value, index);
                    list.add(MapObjectConversion.toMap(item));
                }
                map.put(entry.key(), list);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Class<?> componentType = Reflection.getComponentType(collection, fieldMap.get(entry.key()));
                if (Typ.isBasicType(componentType)) {
                    map.put(entry.key(), value);
                    continue;
                }
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(collection.size());
                for (Object item : collection) {
                    if (item == null) continue;
                    list.add(MapObjectConversion.toMap(item));
                }
                map.put(entry.key(), list);
                continue;
            }
            if (value instanceof Map) continue;
            map.put(entry.key(), MapObjectConversion.toMap(value));
        }
        return map;
    }

    public static <T> List<T> convertListOfMapsToObjects(boolean respectIgnore, String view, FieldsAccessor fieldsAccessor, Class<T> componentType, List<?> list, Set<String> ignoreProperties) {
        ArrayList<T> newList = new ArrayList<T>(list.size());
        for (Object obj : list) {
            if (obj instanceof Value) {
                obj = ((Value)obj).toValue();
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                if (map instanceof ValueMapImpl) {
                    newList.add(MapObjectConversion.fromValueMap(respectIgnore, view, fieldsAccessor, map, componentType, ignoreProperties));
                    continue;
                }
                newList.add(MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, map, componentType, ignoreProperties));
                continue;
            }
            newList.add(Conversions.coerce(componentType, obj));
        }
        return newList;
    }

    public static List<Map<String, Object>> toListOfMaps(Collection<?> collection) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Object o : collection) {
            list.add(MapObjectConversion.toMap(o));
        }
        return list;
    }

    public static class FieldToEntryConverter
    implements Function<FieldAccess, Maps.Entry<String, Object>> {
        final Object object;

        public FieldToEntryConverter(Object object) {
            this.object = object;
        }

        @Override
        public Maps.Entry<String, Object> apply(FieldAccess from) {
            if (from.isReadOnly()) {
                return null;
            }
            Maps.EntryImpl<String, Object> entry = new Maps.EntryImpl<String, Object>(from.name(), from.getValue(this.object));
            return entry;
        }
    }
}

