/*
 * Decompiled with CFR 0.152.
 */
package org.boon.cache;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.boon.cache.Cache;

public class ConcurrentLruCache<KEY, VALUE>
implements Cache<KEY, VALUE> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<KEY, VALUE> map = new ConcurrentHashMap<KEY, VALUE>();
    private final Deque<KEY> queue = new LinkedList<KEY>();
    private final int limit;

    public ConcurrentLruCache(int limit) {
        this.limit = limit;
    }

    @Override
    public void put(KEY key, VALUE value) {
        VALUE oldValue = this.map.put(key, value);
        if (oldValue != null) {
            this.removeThenAddKey(key);
        } else {
            this.addKey(key);
        }
        if (this.map.size() > this.limit) {
            this.map.remove(this.removeLast());
        }
    }

    @Override
    public VALUE get(KEY key) {
        this.removeThenAddKey(key);
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKey(KEY key) {
        this.lock.lock();
        try {
            this.queue.addFirst(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KEY removeLast() {
        this.lock.lock();
        try {
            KEY removedKey;
            KEY KEY = removedKey = this.queue.removeLast();
            return KEY;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeThenAddKey(KEY key) {
        this.lock.lock();
        try {
            this.queue.removeFirstOccurrence(key);
            this.queue.addFirst(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFirstOccurrence(KEY key) {
        this.lock.lock();
        try {
            this.queue.removeFirstOccurrence(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public VALUE getSilent(KEY key) {
        return this.map.get(key);
    }

    @Override
    public void remove(KEY key) {
        this.removeFirstOccurrence(key);
        this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }
}

